package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.Cesp;

import java.util.List;

/**
 * The persistence utility for the cesp service. This utility wraps {@link CespPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see CespPersistence
 * @see CespPersistenceImpl
 * @generated
 */
public class CespUtil {
    private static CespPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(Cesp cesp) {
        getPersistence().clearCache(cesp);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<Cesp> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<Cesp> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<Cesp> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static Cesp update(Cesp cesp) throws SystemException {
        return getPersistence().update(cesp);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static Cesp update(Cesp cesp, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(cesp, serviceContext);
    }

    /**
    * Returns all the cesps where callId = &#63;.
    *
    * @param callId the call ID
    * @return the matching cesps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Cesp> findByCallId(
        long callId) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByCallId(callId);
    }

    /**
    * Returns a range of all the cesps where callId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CespModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callId the call ID
    * @param start the lower bound of the range of cesps
    * @param end the upper bound of the range of cesps (not inclusive)
    * @return the range of matching cesps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Cesp> findByCallId(
        long callId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByCallId(callId, start, end);
    }

    /**
    * Returns an ordered range of all the cesps where callId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CespModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param callId the call ID
    * @param start the lower bound of the range of cesps
    * @param end the upper bound of the range of cesps (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching cesps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Cesp> findByCallId(
        long callId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByCallId(callId, start, end, orderByComparator);
    }

    /**
    * Returns the first cesp in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching cesp
    * @throws gov.va.caret.NoSuchCespException if a matching cesp could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Cesp findByCallId_First(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCespException {
        return getPersistence().findByCallId_First(callId, orderByComparator);
    }

    /**
    * Returns the first cesp in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching cesp, or <code>null</code> if a matching cesp could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Cesp fetchByCallId_First(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByCallId_First(callId, orderByComparator);
    }

    /**
    * Returns the last cesp in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching cesp
    * @throws gov.va.caret.NoSuchCespException if a matching cesp could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Cesp findByCallId_Last(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCespException {
        return getPersistence().findByCallId_Last(callId, orderByComparator);
    }

    /**
    * Returns the last cesp in the ordered set where callId = &#63;.
    *
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching cesp, or <code>null</code> if a matching cesp could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Cesp fetchByCallId_Last(long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByCallId_Last(callId, orderByComparator);
    }

    /**
    * Returns the cesps before and after the current cesp in the ordered set where callId = &#63;.
    *
    * @param cespId the primary key of the current cesp
    * @param callId the call ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next cesp
    * @throws gov.va.caret.NoSuchCespException if a cesp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Cesp[] findByCallId_PrevAndNext(
        long cespId, long callId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCespException {
        return getPersistence()
                   .findByCallId_PrevAndNext(cespId, callId, orderByComparator);
    }

    /**
    * Removes all the cesps where callId = &#63; from the database.
    *
    * @param callId the call ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByCallId(callId);
    }

    /**
    * Returns the number of cesps where callId = &#63;.
    *
    * @param callId the call ID
    * @return the number of matching cesps
    * @throws SystemException if a system exception occurred
    */
    public static int countByCallId(long callId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByCallId(callId);
    }

    /**
    * Caches the cesp in the entity cache if it is enabled.
    *
    * @param cesp the cesp
    */
    public static void cacheResult(gov.va.caret.model.Cesp cesp) {
        getPersistence().cacheResult(cesp);
    }

    /**
    * Caches the cesps in the entity cache if it is enabled.
    *
    * @param cesps the cesps
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.Cesp> cesps) {
        getPersistence().cacheResult(cesps);
    }

    /**
    * Creates a new cesp with the primary key. Does not add the cesp to the database.
    *
    * @param cespId the primary key for the new cesp
    * @return the new cesp
    */
    public static gov.va.caret.model.Cesp create(long cespId) {
        return getPersistence().create(cespId);
    }

    /**
    * Removes the cesp with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param cespId the primary key of the cesp
    * @return the cesp that was removed
    * @throws gov.va.caret.NoSuchCespException if a cesp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Cesp remove(long cespId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCespException {
        return getPersistence().remove(cespId);
    }

    public static gov.va.caret.model.Cesp updateImpl(
        gov.va.caret.model.Cesp cesp)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(cesp);
    }

    /**
    * Returns the cesp with the primary key or throws a {@link gov.va.caret.NoSuchCespException} if it could not be found.
    *
    * @param cespId the primary key of the cesp
    * @return the cesp
    * @throws gov.va.caret.NoSuchCespException if a cesp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Cesp findByPrimaryKey(long cespId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchCespException {
        return getPersistence().findByPrimaryKey(cespId);
    }

    /**
    * Returns the cesp with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param cespId the primary key of the cesp
    * @return the cesp, or <code>null</code> if a cesp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Cesp fetchByPrimaryKey(long cespId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(cespId);
    }

    /**
    * Returns all the cesps.
    *
    * @return the cesps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Cesp> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the cesps.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CespModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cesps
    * @param end the upper bound of the range of cesps (not inclusive)
    * @return the range of cesps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Cesp> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the cesps.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CespModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of cesps
    * @param end the upper bound of the range of cesps (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of cesps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Cesp> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the cesps from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of cesps.
    *
    * @return the number of cesps
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static CespPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (CespPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    CespPersistence.class.getName());

            ReferenceRegistry.registerReference(CespUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(CespPersistence persistence) {
    }
}
