package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.BoxGp;

import java.util.List;

/**
 * The persistence utility for the box gp service. This utility wraps {@link BoxGpPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BoxGpPersistence
 * @see BoxGpPersistenceImpl
 * @generated
 */
public class BoxGpUtil {
    private static BoxGpPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(BoxGp boxGp) {
        getPersistence().clearCache(boxGp);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<BoxGp> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<BoxGp> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<BoxGp> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static BoxGp update(BoxGp boxGp) throws SystemException {
        return getPersistence().update(boxGp);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static BoxGp update(BoxGp boxGp, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(boxGp, serviceContext);
    }

    /**
    * Returns all the box gps where boxGroup = &#63;.
    *
    * @param boxGroup the box group
    * @return the matching box gps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BoxGp> findByBoxGroup(
        java.lang.String boxGroup)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByBoxGroup(boxGroup);
    }

    /**
    * Returns a range of all the box gps where boxGroup = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param boxGroup the box group
    * @param start the lower bound of the range of box gps
    * @param end the upper bound of the range of box gps (not inclusive)
    * @return the range of matching box gps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BoxGp> findByBoxGroup(
        java.lang.String boxGroup, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByBoxGroup(boxGroup, start, end);
    }

    /**
    * Returns an ordered range of all the box gps where boxGroup = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param boxGroup the box group
    * @param start the lower bound of the range of box gps
    * @param end the upper bound of the range of box gps (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching box gps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BoxGp> findByBoxGroup(
        java.lang.String boxGroup, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByBoxGroup(boxGroup, start, end, orderByComparator);
    }

    /**
    * Returns the first box gp in the ordered set where boxGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BoxGp findByBoxGroup_First(
        java.lang.String boxGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException {
        return getPersistence().findByBoxGroup_First(boxGroup, orderByComparator);
    }

    /**
    * Returns the first box gp in the ordered set where boxGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching box gp, or <code>null</code> if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BoxGp fetchByBoxGroup_First(
        java.lang.String boxGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBoxGroup_First(boxGroup, orderByComparator);
    }

    /**
    * Returns the last box gp in the ordered set where boxGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BoxGp findByBoxGroup_Last(
        java.lang.String boxGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException {
        return getPersistence().findByBoxGroup_Last(boxGroup, orderByComparator);
    }

    /**
    * Returns the last box gp in the ordered set where boxGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching box gp, or <code>null</code> if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BoxGp fetchByBoxGroup_Last(
        java.lang.String boxGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByBoxGroup_Last(boxGroup, orderByComparator);
    }

    /**
    * Returns the box gps before and after the current box gp in the ordered set where boxGroup = &#63;.
    *
    * @param boxGpId the primary key of the current box gp
    * @param boxGroup the box group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BoxGp[] findByBoxGroup_PrevAndNext(
        long boxGpId, java.lang.String boxGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException {
        return getPersistence()
                   .findByBoxGroup_PrevAndNext(boxGpId, boxGroup,
            orderByComparator);
    }

    /**
    * Removes all the box gps where boxGroup = &#63; from the database.
    *
    * @param boxGroup the box group
    * @throws SystemException if a system exception occurred
    */
    public static void removeByBoxGroup(java.lang.String boxGroup)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByBoxGroup(boxGroup);
    }

    /**
    * Returns the number of box gps where boxGroup = &#63;.
    *
    * @param boxGroup the box group
    * @return the number of matching box gps
    * @throws SystemException if a system exception occurred
    */
    public static int countByBoxGroup(java.lang.String boxGroup)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByBoxGroup(boxGroup);
    }

    /**
    * Returns all the box gps where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @return the matching box gps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BoxGp> findByBoxSubGroup(
        java.lang.String boxGroup, java.lang.String boxSubGroup)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByBoxSubGroup(boxGroup, boxSubGroup);
    }

    /**
    * Returns a range of all the box gps where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param start the lower bound of the range of box gps
    * @param end the upper bound of the range of box gps (not inclusive)
    * @return the range of matching box gps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BoxGp> findByBoxSubGroup(
        java.lang.String boxGroup, java.lang.String boxSubGroup, int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByBoxSubGroup(boxGroup, boxSubGroup, start, end);
    }

    /**
    * Returns an ordered range of all the box gps where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param start the lower bound of the range of box gps
    * @param end the upper bound of the range of box gps (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching box gps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BoxGp> findByBoxSubGroup(
        java.lang.String boxGroup, java.lang.String boxSubGroup, int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .findByBoxSubGroup(boxGroup, boxSubGroup, start, end,
            orderByComparator);
    }

    /**
    * Returns the first box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BoxGp findByBoxSubGroup_First(
        java.lang.String boxGroup, java.lang.String boxSubGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException {
        return getPersistence()
                   .findByBoxSubGroup_First(boxGroup, boxSubGroup,
            orderByComparator);
    }

    /**
    * Returns the first box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching box gp, or <code>null</code> if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BoxGp fetchByBoxSubGroup_First(
        java.lang.String boxGroup, java.lang.String boxSubGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBoxSubGroup_First(boxGroup, boxSubGroup,
            orderByComparator);
    }

    /**
    * Returns the last box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BoxGp findByBoxSubGroup_Last(
        java.lang.String boxGroup, java.lang.String boxSubGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException {
        return getPersistence()
                   .findByBoxSubGroup_Last(boxGroup, boxSubGroup,
            orderByComparator);
    }

    /**
    * Returns the last box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching box gp, or <code>null</code> if a matching box gp could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BoxGp fetchByBoxSubGroup_Last(
        java.lang.String boxGroup, java.lang.String boxSubGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence()
                   .fetchByBoxSubGroup_Last(boxGroup, boxSubGroup,
            orderByComparator);
    }

    /**
    * Returns the box gps before and after the current box gp in the ordered set where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGpId the primary key of the current box gp
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BoxGp[] findByBoxSubGroup_PrevAndNext(
        long boxGpId, java.lang.String boxGroup, java.lang.String boxSubGroup,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException {
        return getPersistence()
                   .findByBoxSubGroup_PrevAndNext(boxGpId, boxGroup,
            boxSubGroup, orderByComparator);
    }

    /**
    * Removes all the box gps where boxGroup = &#63; and boxSubGroup = &#63; from the database.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @throws SystemException if a system exception occurred
    */
    public static void removeByBoxSubGroup(java.lang.String boxGroup,
        java.lang.String boxSubGroup)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByBoxSubGroup(boxGroup, boxSubGroup);
    }

    /**
    * Returns the number of box gps where boxGroup = &#63; and boxSubGroup = &#63;.
    *
    * @param boxGroup the box group
    * @param boxSubGroup the box sub group
    * @return the number of matching box gps
    * @throws SystemException if a system exception occurred
    */
    public static int countByBoxSubGroup(java.lang.String boxGroup,
        java.lang.String boxSubGroup)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByBoxSubGroup(boxGroup, boxSubGroup);
    }

    /**
    * Caches the box gp in the entity cache if it is enabled.
    *
    * @param boxGp the box gp
    */
    public static void cacheResult(gov.va.caret.model.BoxGp boxGp) {
        getPersistence().cacheResult(boxGp);
    }

    /**
    * Caches the box gps in the entity cache if it is enabled.
    *
    * @param boxGps the box gps
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.BoxGp> boxGps) {
        getPersistence().cacheResult(boxGps);
    }

    /**
    * Creates a new box gp with the primary key. Does not add the box gp to the database.
    *
    * @param boxGpId the primary key for the new box gp
    * @return the new box gp
    */
    public static gov.va.caret.model.BoxGp create(long boxGpId) {
        return getPersistence().create(boxGpId);
    }

    /**
    * Removes the box gp with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param boxGpId the primary key of the box gp
    * @return the box gp that was removed
    * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BoxGp remove(long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException {
        return getPersistence().remove(boxGpId);
    }

    public static gov.va.caret.model.BoxGp updateImpl(
        gov.va.caret.model.BoxGp boxGp)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(boxGp);
    }

    /**
    * Returns the box gp with the primary key or throws a {@link gov.va.caret.NoSuchBoxGpException} if it could not be found.
    *
    * @param boxGpId the primary key of the box gp
    * @return the box gp
    * @throws gov.va.caret.NoSuchBoxGpException if a box gp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BoxGp findByPrimaryKey(long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBoxGpException {
        return getPersistence().findByPrimaryKey(boxGpId);
    }

    /**
    * Returns the box gp with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param boxGpId the primary key of the box gp
    * @return the box gp, or <code>null</code> if a box gp with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.BoxGp fetchByPrimaryKey(long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(boxGpId);
    }

    /**
    * Returns all the box gps.
    *
    * @return the box gps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BoxGp> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the box gps.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of box gps
    * @param end the upper bound of the range of box gps (not inclusive)
    * @return the range of box gps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BoxGp> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the box gps.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BoxGpModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of box gps
    * @param end the upper bound of the range of box gps (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of box gps
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.BoxGp> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the box gps from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of box gps.
    *
    * @return the number of box gps
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static BoxGpPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (BoxGpPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    BoxGpPersistence.class.getName());

            ReferenceRegistry.registerReference(BoxGpUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(BoxGpPersistence persistence) {
    }
}
