package gov.va.caret.service.persistence;

import com.liferay.portal.service.persistence.BasePersistence;

import gov.va.caret.model.BgLae;

/**
 * The persistence interface for the bg lae service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see BgLaePersistenceImpl
 * @see BgLaeUtil
 * @generated
 */
public interface BgLaePersistence extends BasePersistence<BgLae> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. Always use {@link BgLaeUtil} to access the bg lae persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this interface.
     */

    /**
    * Returns all the bg laes where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @return the matching bg laes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgLae> findByBoxGroupCharAssociations(
        long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the bg laes where ownerId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgLaeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param start the lower bound of the range of bg laes
    * @param end the upper bound of the range of bg laes (not inclusive)
    * @return the range of matching bg laes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgLae> findByBoxGroupCharAssociations(
        long ownerId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the bg laes where ownerId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgLaeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param ownerId the owner ID
    * @param start the lower bound of the range of bg laes
    * @param end the upper bound of the range of bg laes (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching bg laes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgLae> findByBoxGroupCharAssociations(
        long ownerId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the first bg lae in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg lae
    * @throws gov.va.caret.NoSuchBgLaeException if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgLae findByBoxGroupCharAssociations_First(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException;

    /**
    * Returns the first bg lae in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching bg lae, or <code>null</code> if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgLae fetchByBoxGroupCharAssociations_First(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the last bg lae in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg lae
    * @throws gov.va.caret.NoSuchBgLaeException if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgLae findByBoxGroupCharAssociations_Last(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException;

    /**
    * Returns the last bg lae in the ordered set where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching bg lae, or <code>null</code> if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgLae fetchByBoxGroupCharAssociations_Last(
        long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bg laes before and after the current bg lae in the ordered set where ownerId = &#63;.
    *
    * @param bgLaeId the primary key of the current bg lae
    * @param ownerId the owner ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next bg lae
    * @throws gov.va.caret.NoSuchBgLaeException if a bg lae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgLae[] findByBoxGroupCharAssociations_PrevAndNext(
        long bgLaeId, long ownerId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException;

    /**
    * Removes all the bg laes where ownerId = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @throws SystemException if a system exception occurred
    */
    public void removeByBoxGroupCharAssociations(long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of bg laes where ownerId = &#63;.
    *
    * @param ownerId the owner ID
    * @return the number of matching bg laes
    * @throws SystemException if a system exception occurred
    */
    public int countByBoxGroupCharAssociations(long ownerId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bg lae where ownerId = &#63; and boxGpId = &#63; or throws a {@link gov.va.caret.NoSuchBgLaeException} if it could not be found.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the matching bg lae
    * @throws gov.va.caret.NoSuchBgLaeException if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgLae findByBgCharInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException;

    /**
    * Returns the bg lae where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the matching bg lae, or <code>null</code> if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgLae fetchByBgCharInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bg lae where ownerId = &#63; and boxGpId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @param retrieveFromCache whether to use the finder cache
    * @return the matching bg lae, or <code>null</code> if a matching bg lae could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgLae fetchByBgCharInst(long ownerId,
        long boxGpId, boolean retrieveFromCache)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes the bg lae where ownerId = &#63; and boxGpId = &#63; from the database.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the bg lae that was removed
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgLae removeByBgCharInst(long ownerId,
        long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException;

    /**
    * Returns the number of bg laes where ownerId = &#63; and boxGpId = &#63;.
    *
    * @param ownerId the owner ID
    * @param boxGpId the box gp ID
    * @return the number of matching bg laes
    * @throws SystemException if a system exception occurred
    */
    public int countByBgCharInst(long ownerId, long boxGpId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Caches the bg lae in the entity cache if it is enabled.
    *
    * @param bgLae the bg lae
    */
    public void cacheResult(gov.va.caret.model.BgLae bgLae);

    /**
    * Caches the bg laes in the entity cache if it is enabled.
    *
    * @param bgLaes the bg laes
    */
    public void cacheResult(java.util.List<gov.va.caret.model.BgLae> bgLaes);

    /**
    * Creates a new bg lae with the primary key. Does not add the bg lae to the database.
    *
    * @param bgLaeId the primary key for the new bg lae
    * @return the new bg lae
    */
    public gov.va.caret.model.BgLae create(long bgLaeId);

    /**
    * Removes the bg lae with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param bgLaeId the primary key of the bg lae
    * @return the bg lae that was removed
    * @throws gov.va.caret.NoSuchBgLaeException if a bg lae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgLae remove(long bgLaeId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException;

    public gov.va.caret.model.BgLae updateImpl(gov.va.caret.model.BgLae bgLae)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the bg lae with the primary key or throws a {@link gov.va.caret.NoSuchBgLaeException} if it could not be found.
    *
    * @param bgLaeId the primary key of the bg lae
    * @return the bg lae
    * @throws gov.va.caret.NoSuchBgLaeException if a bg lae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgLae findByPrimaryKey(long bgLaeId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchBgLaeException;

    /**
    * Returns the bg lae with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param bgLaeId the primary key of the bg lae
    * @return the bg lae, or <code>null</code> if a bg lae with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public gov.va.caret.model.BgLae fetchByPrimaryKey(long bgLaeId)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns all the bg laes.
    *
    * @return the bg laes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgLae> findAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns a range of all the bg laes.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgLaeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg laes
    * @param end the upper bound of the range of bg laes (not inclusive)
    * @return the range of bg laes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgLae> findAll(int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns an ordered range of all the bg laes.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgLaeModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of bg laes
    * @param end the upper bound of the range of bg laes (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of bg laes
    * @throws SystemException if a system exception occurred
    */
    public java.util.List<gov.va.caret.model.BgLae> findAll(int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Removes all the bg laes from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException;

    /**
    * Returns the number of bg laes.
    *
    * @return the number of bg laes
    * @throws SystemException if a system exception occurred
    */
    public int countAll()
        throws com.liferay.portal.kernel.exception.SystemException;
}
