package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.service.ServiceContext;

import gov.va.caret.model.Assmt;

import java.util.List;

/**
 * The persistence utility for the assmt service. This utility wraps {@link AssmtPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see AssmtPersistence
 * @see AssmtPersistenceImpl
 * @generated
 */
public class AssmtUtil {
    private static AssmtPersistence _persistence;

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache()
     */
    public static void clearCache() {
        getPersistence().clearCache();
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#clearCache(com.liferay.portal.model.BaseModel)
     */
    public static void clearCache(Assmt assmt) {
        getPersistence().clearCache(assmt);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
     */
    public static long countWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().countWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
     */
    public static List<Assmt> findWithDynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
     */
    public static List<Assmt> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end) throws SystemException {
        return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
     */
    public static List<Assmt> findWithDynamicQuery(DynamicQuery dynamicQuery,
        int start, int end, OrderByComparator orderByComparator)
        throws SystemException {
        return getPersistence()
                   .findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel)
     */
    public static Assmt update(Assmt assmt) throws SystemException {
        return getPersistence().update(assmt);
    }

    /**
     * @see com.liferay.portal.service.persistence.BasePersistence#update(com.liferay.portal.model.BaseModel, ServiceContext)
     */
    public static Assmt update(Assmt assmt, ServiceContext serviceContext)
        throws SystemException {
        return getPersistence().update(assmt, serviceContext);
    }

    /**
    * Returns all the assmts where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @return the matching assmts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Assmt> findByVcgId(
        long vcgId) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVcgId(vcgId);
    }

    /**
    * Returns a range of all the assmts where vcgId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vcgId the vcg ID
    * @param start the lower bound of the range of assmts
    * @param end the upper bound of the range of assmts (not inclusive)
    * @return the range of matching assmts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Assmt> findByVcgId(
        long vcgId, int start, int end)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVcgId(vcgId, start, end);
    }

    /**
    * Returns an ordered range of all the assmts where vcgId = &#63;.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param vcgId the vcg ID
    * @param start the lower bound of the range of assmts
    * @param end the upper bound of the range of assmts (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of matching assmts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Assmt> findByVcgId(
        long vcgId, int start, int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findByVcgId(vcgId, start, end, orderByComparator);
    }

    /**
    * Returns the first assmt in the ordered set where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching assmt
    * @throws gov.va.caret.NoSuchAssmtException if a matching assmt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Assmt findByVcgId_First(long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAssmtException {
        return getPersistence().findByVcgId_First(vcgId, orderByComparator);
    }

    /**
    * Returns the first assmt in the ordered set where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the first matching assmt, or <code>null</code> if a matching assmt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Assmt fetchByVcgId_First(long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByVcgId_First(vcgId, orderByComparator);
    }

    /**
    * Returns the last assmt in the ordered set where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching assmt
    * @throws gov.va.caret.NoSuchAssmtException if a matching assmt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Assmt findByVcgId_Last(long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAssmtException {
        return getPersistence().findByVcgId_Last(vcgId, orderByComparator);
    }

    /**
    * Returns the last assmt in the ordered set where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the last matching assmt, or <code>null</code> if a matching assmt could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Assmt fetchByVcgId_Last(long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByVcgId_Last(vcgId, orderByComparator);
    }

    /**
    * Returns the assmts before and after the current assmt in the ordered set where vcgId = &#63;.
    *
    * @param assmtId the primary key of the current assmt
    * @param vcgId the vcg ID
    * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
    * @return the previous, current, and next assmt
    * @throws gov.va.caret.NoSuchAssmtException if a assmt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Assmt[] findByVcgId_PrevAndNext(
        long assmtId, long vcgId,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAssmtException {
        return getPersistence()
                   .findByVcgId_PrevAndNext(assmtId, vcgId, orderByComparator);
    }

    /**
    * Removes all the assmts where vcgId = &#63; from the database.
    *
    * @param vcgId the vcg ID
    * @throws SystemException if a system exception occurred
    */
    public static void removeByVcgId(long vcgId)
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeByVcgId(vcgId);
    }

    /**
    * Returns the number of assmts where vcgId = &#63;.
    *
    * @param vcgId the vcg ID
    * @return the number of matching assmts
    * @throws SystemException if a system exception occurred
    */
    public static int countByVcgId(long vcgId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countByVcgId(vcgId);
    }

    /**
    * Caches the assmt in the entity cache if it is enabled.
    *
    * @param assmt the assmt
    */
    public static void cacheResult(gov.va.caret.model.Assmt assmt) {
        getPersistence().cacheResult(assmt);
    }

    /**
    * Caches the assmts in the entity cache if it is enabled.
    *
    * @param assmts the assmts
    */
    public static void cacheResult(
        java.util.List<gov.va.caret.model.Assmt> assmts) {
        getPersistence().cacheResult(assmts);
    }

    /**
    * Creates a new assmt with the primary key. Does not add the assmt to the database.
    *
    * @param assmtId the primary key for the new assmt
    * @return the new assmt
    */
    public static gov.va.caret.model.Assmt create(long assmtId) {
        return getPersistence().create(assmtId);
    }

    /**
    * Removes the assmt with the primary key from the database. Also notifies the appropriate model listeners.
    *
    * @param assmtId the primary key of the assmt
    * @return the assmt that was removed
    * @throws gov.va.caret.NoSuchAssmtException if a assmt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Assmt remove(long assmtId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAssmtException {
        return getPersistence().remove(assmtId);
    }

    public static gov.va.caret.model.Assmt updateImpl(
        gov.va.caret.model.Assmt assmt)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().updateImpl(assmt);
    }

    /**
    * Returns the assmt with the primary key or throws a {@link gov.va.caret.NoSuchAssmtException} if it could not be found.
    *
    * @param assmtId the primary key of the assmt
    * @return the assmt
    * @throws gov.va.caret.NoSuchAssmtException if a assmt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Assmt findByPrimaryKey(long assmtId)
        throws com.liferay.portal.kernel.exception.SystemException,
            gov.va.caret.NoSuchAssmtException {
        return getPersistence().findByPrimaryKey(assmtId);
    }

    /**
    * Returns the assmt with the primary key or returns <code>null</code> if it could not be found.
    *
    * @param assmtId the primary key of the assmt
    * @return the assmt, or <code>null</code> if a assmt with the primary key could not be found
    * @throws SystemException if a system exception occurred
    */
    public static gov.va.caret.model.Assmt fetchByPrimaryKey(long assmtId)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().fetchByPrimaryKey(assmtId);
    }

    /**
    * Returns all the assmts.
    *
    * @return the assmts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Assmt> findAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll();
    }

    /**
    * Returns a range of all the assmts.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of assmts
    * @param end the upper bound of the range of assmts (not inclusive)
    * @return the range of assmts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Assmt> findAll(int start,
        int end) throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end);
    }

    /**
    * Returns an ordered range of all the assmts.
    *
    * <p>
    * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.AssmtModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
    * </p>
    *
    * @param start the lower bound of the range of assmts
    * @param end the upper bound of the range of assmts (not inclusive)
    * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
    * @return the ordered range of assmts
    * @throws SystemException if a system exception occurred
    */
    public static java.util.List<gov.va.caret.model.Assmt> findAll(int start,
        int end,
        com.liferay.portal.kernel.util.OrderByComparator orderByComparator)
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().findAll(start, end, orderByComparator);
    }

    /**
    * Removes all the assmts from the database.
    *
    * @throws SystemException if a system exception occurred
    */
    public static void removeAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        getPersistence().removeAll();
    }

    /**
    * Returns the number of assmts.
    *
    * @return the number of assmts
    * @throws SystemException if a system exception occurred
    */
    public static int countAll()
        throws com.liferay.portal.kernel.exception.SystemException {
        return getPersistence().countAll();
    }

    public static AssmtPersistence getPersistence() {
        if (_persistence == null) {
            _persistence = (AssmtPersistence) PortletBeanLocatorUtil.locate(gov.va.caret.service.ClpSerializer.getServletContextName(),
                    AssmtPersistence.class.getName());

            ReferenceRegistry.registerReference(AssmtUtil.class, "_persistence");
        }

        return _persistence;
    }

    /**
     * @deprecated As of 6.2.0
     */
    public void setPersistence(AssmtPersistence persistence) {
    }
}
