package gov.va.caret.model;

import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the VetVr service. Represents a row in the &quot;CARET_VETERAN_VENDOR&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.VetVrModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.VetVrImpl}.
 * </p>
 *
 * @author caret
 * @see VetVr
 * @see gov.va.caret.model.impl.VetVrImpl
 * @see gov.va.caret.model.impl.VetVrModelImpl
 * @generated
 */
public interface VetVrModel extends BaseModel<VetVr> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a vet vr model instance should use the {@link VetVr} interface instead.
     */

    /**
     * Returns the primary key of this vet vr.
     *
     * @return the primary key of this vet vr
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this vet vr.
     *
     * @param primaryKey the primary key of this vet vr
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the vet vr ID of this vet vr.
     *
     * @return the vet vr ID of this vet vr
     */
    public long getVetVrId();

    /**
     * Sets the vet vr ID of this vet vr.
     *
     * @param vetVrId the vet vr ID of this vet vr
     */
    public void setVetVrId(long vetVrId);

    /**
     * Returns the vendr ID of this vet vr.
     *
     * @return the vendr ID of this vet vr
     */
    public long getVendrId();

    /**
     * Sets the vendr ID of this vet vr.
     *
     * @param vendrId the vendr ID of this vet vr
     */
    public void setVendrId(long vendrId);

    /**
     * Returns the cg ID of this vet vr.
     *
     * @return the cg ID of this vet vr
     */
    public long getCgId();

    /**
     * Sets the cg ID of this vet vr.
     *
     * @param cgId the cg ID of this vet vr
     */
    public void setCgId(long cgId);

    /**
     * Returns the veteran ID of this vet vr.
     *
     * @return the veteran ID of this vet vr
     */
    public long getVeteranId();

    /**
     * Sets the veteran ID of this vet vr.
     *
     * @param veteranId the veteran ID of this vet vr
     */
    public void setVeteranId(long veteranId);

    /**
     * Returns the group ID of this vet vr.
     *
     * @return the group ID of this vet vr
     */
    public long getGroupId();

    /**
     * Sets the group ID of this vet vr.
     *
     * @param groupId the group ID of this vet vr
     */
    public void setGroupId(long groupId);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.VetVr vetVr);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.VetVr> toCacheModel();

    @Override
    public gov.va.caret.model.VetVr toEscapedModel();

    @Override
    public gov.va.caret.model.VetVr toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
