package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

/**
 * The base model interface for the Vendr service. Represents a row in the &quot;CARET_VENDOR&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.VendrModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.VendrImpl}.
 * </p>
 *
 * @author caret
 * @see Vendr
 * @see gov.va.caret.model.impl.VendrImpl
 * @see gov.va.caret.model.impl.VendrModelImpl
 * @generated
 */
public interface VendrModel extends BaseModel<Vendr> {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this interface directly. All methods that expect a vendr model instance should use the {@link Vendr} interface instead.
     */

    /**
     * Returns the primary key of this vendr.
     *
     * @return the primary key of this vendr
     */
    public long getPrimaryKey();

    /**
     * Sets the primary key of this vendr.
     *
     * @param primaryKey the primary key of this vendr
     */
    public void setPrimaryKey(long primaryKey);

    /**
     * Returns the vendr ID of this vendr.
     *
     * @return the vendr ID of this vendr
     */
    public long getVendrId();

    /**
     * Sets the vendr ID of this vendr.
     *
     * @param vendrId the vendr ID of this vendr
     */
    public void setVendrId(long vendrId);

    /**
     * Returns the last name of this vendr.
     *
     * @return the last name of this vendr
     */
    @AutoEscape
    public String getLastName();

    /**
     * Sets the last name of this vendr.
     *
     * @param lastName the last name of this vendr
     */
    public void setLastName(String lastName);

    /**
     * Returns the first name of this vendr.
     *
     * @return the first name of this vendr
     */
    @AutoEscape
    public String getFirstName();

    /**
     * Sets the first name of this vendr.
     *
     * @param firstName the first name of this vendr
     */
    public void setFirstName(String firstName);

    /**
     * Returns the middle name of this vendr.
     *
     * @return the middle name of this vendr
     */
    @AutoEscape
    public String getMiddleName();

    /**
     * Sets the middle name of this vendr.
     *
     * @param middleName the middle name of this vendr
     */
    public void setMiddleName(String middleName);

    /**
     * Returns the fed tax ID of this vendr.
     *
     * @return the fed tax ID of this vendr
     */
    @AutoEscape
    public String getFedTaxId();

    /**
     * Sets the fed tax ID of this vendr.
     *
     * @param fedTaxId the fed tax ID of this vendr
     */
    public void setFedTaxId(String fedTaxId);

    /**
     * Returns the address of this vendr.
     *
     * @return the address of this vendr
     */
    @AutoEscape
    public String getAddress();

    /**
     * Sets the address of this vendr.
     *
     * @param address the address of this vendr
     */
    public void setAddress(String address);

    /**
     * Returns the address2 of this vendr.
     *
     * @return the address2 of this vendr
     */
    @AutoEscape
    public String getAddress2();

    /**
     * Sets the address2 of this vendr.
     *
     * @param address2 the address2 of this vendr
     */
    public void setAddress2(String address2);

    /**
     * Returns the city of this vendr.
     *
     * @return the city of this vendr
     */
    @AutoEscape
    public String getCity();

    /**
     * Sets the city of this vendr.
     *
     * @param city the city of this vendr
     */
    public void setCity(String city);

    /**
     * Returns the state of this vendr.
     *
     * @return the state of this vendr
     */
    @AutoEscape
    public String getState();

    /**
     * Sets the state of this vendr.
     *
     * @param state the state of this vendr
     */
    public void setState(String state);

    /**
     * Returns the zip of this vendr.
     *
     * @return the zip of this vendr
     */
    @AutoEscape
    public String getZip();

    /**
     * Sets the zip of this vendr.
     *
     * @param zip the zip of this vendr
     */
    public void setZip(String zip);

    /**
     * Returns the phone of this vendr.
     *
     * @return the phone of this vendr
     */
    @AutoEscape
    public String getPhone();

    /**
     * Sets the phone of this vendr.
     *
     * @param phone the phone of this vendr
     */
    public void setPhone(String phone);

    /**
     * Returns the phone2 of this vendr.
     *
     * @return the phone2 of this vendr
     */
    @AutoEscape
    public String getPhone2();

    /**
     * Sets the phone2 of this vendr.
     *
     * @param phone2 the phone2 of this vendr
     */
    public void setPhone2(String phone2);

    /**
     * Returns the grace period of this vendr.
     *
     * @return the grace period of this vendr
     */
    @AutoEscape
    public String getGracePeriod();

    /**
     * Sets the grace period of this vendr.
     *
     * @param gracePeriod the grace period of this vendr
     */
    public void setGracePeriod(String gracePeriod);

    /**
     * Returns the grace period duration of this vendr.
     *
     * @return the grace period duration of this vendr
     */
    @AutoEscape
    public String getGracePeriodDuration();

    /**
     * Sets the grace period duration of this vendr.
     *
     * @param gracePeriodDuration the grace period duration of this vendr
     */
    public void setGracePeriodDuration(String gracePeriodDuration);

    /**
     * Returns the direct deposit info of this vendr.
     *
     * @return the direct deposit info of this vendr
     */
    @AutoEscape
    public String getDirectDepositInfo();

    /**
     * Sets the direct deposit info of this vendr.
     *
     * @param directDepositInfo the direct deposit info of this vendr
     */
    public void setDirectDepositInfo(String directDepositInfo);

    /**
     * Returns the payment method of this vendr.
     *
     * @return the payment method of this vendr
     */
    @AutoEscape
    public String getPaymentMethod();

    /**
     * Sets the payment method of this vendr.
     *
     * @param paymentMethod the payment method of this vendr
     */
    public void setPaymentMethod(String paymentMethod);

    /**
     * Returns the crypto1 of this vendr.
     *
     * @return the crypto1 of this vendr
     */
    @AutoEscape
    public String getCrypto1();

    /**
     * Sets the crypto1 of this vendr.
     *
     * @param crypto1 the crypto1 of this vendr
     */
    public void setCrypto1(String crypto1);

    /**
     * Returns the group ID of this vendr.
     *
     * @return the group ID of this vendr
     */
    public long getGroupId();

    /**
     * Sets the group ID of this vendr.
     *
     * @param groupId the group ID of this vendr
     */
    public void setGroupId(long groupId);

    @Override
    public boolean isNew();

    @Override
    public void setNew(boolean n);

    @Override
    public boolean isCachedModel();

    @Override
    public void setCachedModel(boolean cachedModel);

    @Override
    public boolean isEscapedModel();

    @Override
    public Serializable getPrimaryKeyObj();

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj);

    @Override
    public ExpandoBridge getExpandoBridge();

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext);

    @Override
    public Object clone();

    @Override
    public int compareTo(gov.va.caret.model.Vendr vendr);

    @Override
    public int hashCode();

    @Override
    public CacheModel<gov.va.caret.model.Vendr> toCacheModel();

    @Override
    public gov.va.caret.model.Vendr toEscapedModel();

    @Override
    public gov.va.caret.model.Vendr toUnescapedModel();

    @Override
    public String toString();

    @Override
    public String toXmlString();
}
