package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class VcgAnSoap implements Serializable {
    private long _vcgAnId;
    private long _vcgId;
    private long _veteranId;
    private long _primaryId;
    private long _secondaryId;
    private long _secondaryTwoId;
    private String _status;
    private Date _receivedDate;
    private String _primaryRelationship;
    private String _secondaryRelationship;
    private String _secondaryTwoRelationship;
    private Date _primarySignDate;
    private Date _secondarySignDate;
    private Date _secondaryTwoSignDate;
    private boolean _vaHealthEnrolled;
    private boolean _mediEnrolled;
    private String _lastTreatmentPlace;
    private boolean _hospital;
    private boolean _clinic;
    private Date _submitDate;
    private Date _creationDate;
    private long _groupId;

    public VcgAnSoap() {
    }

    public static VcgAnSoap toSoapModel(VcgAn model) {
        VcgAnSoap soapModel = new VcgAnSoap();

        soapModel.setVcgAnId(model.getVcgAnId());
        soapModel.setVcgId(model.getVcgId());
        soapModel.setVeteranId(model.getVeteranId());
        soapModel.setPrimaryId(model.getPrimaryId());
        soapModel.setSecondaryId(model.getSecondaryId());
        soapModel.setSecondaryTwoId(model.getSecondaryTwoId());
        soapModel.setStatus(model.getStatus());
        soapModel.setReceivedDate(model.getReceivedDate());
        soapModel.setPrimaryRelationship(model.getPrimaryRelationship());
        soapModel.setSecondaryRelationship(model.getSecondaryRelationship());
        soapModel.setSecondaryTwoRelationship(model.getSecondaryTwoRelationship());
        soapModel.setPrimarySignDate(model.getPrimarySignDate());
        soapModel.setSecondarySignDate(model.getSecondarySignDate());
        soapModel.setSecondaryTwoSignDate(model.getSecondaryTwoSignDate());
        soapModel.setVaHealthEnrolled(model.getVaHealthEnrolled());
        soapModel.setMediEnrolled(model.getMediEnrolled());
        soapModel.setLastTreatmentPlace(model.getLastTreatmentPlace());
        soapModel.setHospital(model.getHospital());
        soapModel.setClinic(model.getClinic());
        soapModel.setSubmitDate(model.getSubmitDate());
        soapModel.setCreationDate(model.getCreationDate());
        soapModel.setGroupId(model.getGroupId());

        return soapModel;
    }

    public static VcgAnSoap[] toSoapModels(VcgAn[] models) {
        VcgAnSoap[] soapModels = new VcgAnSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static VcgAnSoap[][] toSoapModels(VcgAn[][] models) {
        VcgAnSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new VcgAnSoap[models.length][models[0].length];
        } else {
            soapModels = new VcgAnSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static VcgAnSoap[] toSoapModels(List<VcgAn> models) {
        List<VcgAnSoap> soapModels = new ArrayList<VcgAnSoap>(models.size());

        for (VcgAn model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new VcgAnSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _vcgAnId;
    }

    public void setPrimaryKey(long pk) {
        setVcgAnId(pk);
    }

    public long getVcgAnId() {
        return _vcgAnId;
    }

    public void setVcgAnId(long vcgAnId) {
        _vcgAnId = vcgAnId;
    }

    public long getVcgId() {
        return _vcgId;
    }

    public void setVcgId(long vcgId) {
        _vcgId = vcgId;
    }

    public long getVeteranId() {
        return _veteranId;
    }

    public void setVeteranId(long veteranId) {
        _veteranId = veteranId;
    }

    public long getPrimaryId() {
        return _primaryId;
    }

    public void setPrimaryId(long primaryId) {
        _primaryId = primaryId;
    }

    public long getSecondaryId() {
        return _secondaryId;
    }

    public void setSecondaryId(long secondaryId) {
        _secondaryId = secondaryId;
    }

    public long getSecondaryTwoId() {
        return _secondaryTwoId;
    }

    public void setSecondaryTwoId(long secondaryTwoId) {
        _secondaryTwoId = secondaryTwoId;
    }

    public String getStatus() {
        return _status;
    }

    public void setStatus(String status) {
        _status = status;
    }

    public Date getReceivedDate() {
        return _receivedDate;
    }

    public void setReceivedDate(Date receivedDate) {
        _receivedDate = receivedDate;
    }

    public String getPrimaryRelationship() {
        return _primaryRelationship;
    }

    public void setPrimaryRelationship(String primaryRelationship) {
        _primaryRelationship = primaryRelationship;
    }

    public String getSecondaryRelationship() {
        return _secondaryRelationship;
    }

    public void setSecondaryRelationship(String secondaryRelationship) {
        _secondaryRelationship = secondaryRelationship;
    }

    public String getSecondaryTwoRelationship() {
        return _secondaryTwoRelationship;
    }

    public void setSecondaryTwoRelationship(String secondaryTwoRelationship) {
        _secondaryTwoRelationship = secondaryTwoRelationship;
    }

    public Date getPrimarySignDate() {
        return _primarySignDate;
    }

    public void setPrimarySignDate(Date primarySignDate) {
        _primarySignDate = primarySignDate;
    }

    public Date getSecondarySignDate() {
        return _secondarySignDate;
    }

    public void setSecondarySignDate(Date secondarySignDate) {
        _secondarySignDate = secondarySignDate;
    }

    public Date getSecondaryTwoSignDate() {
        return _secondaryTwoSignDate;
    }

    public void setSecondaryTwoSignDate(Date secondaryTwoSignDate) {
        _secondaryTwoSignDate = secondaryTwoSignDate;
    }

    public boolean getVaHealthEnrolled() {
        return _vaHealthEnrolled;
    }

    public boolean isVaHealthEnrolled() {
        return _vaHealthEnrolled;
    }

    public void setVaHealthEnrolled(boolean vaHealthEnrolled) {
        _vaHealthEnrolled = vaHealthEnrolled;
    }

    public boolean getMediEnrolled() {
        return _mediEnrolled;
    }

    public boolean isMediEnrolled() {
        return _mediEnrolled;
    }

    public void setMediEnrolled(boolean mediEnrolled) {
        _mediEnrolled = mediEnrolled;
    }

    public String getLastTreatmentPlace() {
        return _lastTreatmentPlace;
    }

    public void setLastTreatmentPlace(String lastTreatmentPlace) {
        _lastTreatmentPlace = lastTreatmentPlace;
    }

    public boolean getHospital() {
        return _hospital;
    }

    public boolean isHospital() {
        return _hospital;
    }

    public void setHospital(boolean hospital) {
        _hospital = hospital;
    }

    public boolean getClinic() {
        return _clinic;
    }

    public boolean isClinic() {
        return _clinic;
    }

    public void setClinic(boolean clinic) {
        _clinic = clinic;
    }

    public Date getSubmitDate() {
        return _submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        _submitDate = submitDate;
    }

    public Date getCreationDate() {
        return _creationDate;
    }

    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    public long getGroupId() {
        return _groupId;
    }

    public void setGroupId(long groupId) {
        _groupId = groupId;
    }
}
