package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.StiPtLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class StiPtClp extends BaseModelImpl<StiPt> implements StiPt {
    private long _stiPtId;
    private long _stiRdId;
    private long _vendrId;
    private String _tier;
    private String _tierHours;
    private String _blsRateHourly;
    private String _dailyRate;
    private String _monthlyPayment;
    private String _stipendStatus;
    private Date _stipendApprovedDate;
    private Date _stipendStartDate;
    private long _groupId;
    private BaseModel<?> _stiPtRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public StiPtClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return StiPt.class;
    }

    @Override
    public String getModelClassName() {
        return StiPt.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _stiPtId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setStiPtId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _stiPtId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("stiPtId", getStiPtId());
        attributes.put("stiRdId", getStiRdId());
        attributes.put("vendrId", getVendrId());
        attributes.put("tier", getTier());
        attributes.put("tierHours", getTierHours());
        attributes.put("blsRateHourly", getBlsRateHourly());
        attributes.put("dailyRate", getDailyRate());
        attributes.put("monthlyPayment", getMonthlyPayment());
        attributes.put("stipendStatus", getStipendStatus());
        attributes.put("stipendApprovedDate", getStipendApprovedDate());
        attributes.put("stipendStartDate", getStipendStartDate());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long stiPtId = (Long) attributes.get("stiPtId");

        if (stiPtId != null) {
            setStiPtId(stiPtId);
        }

        Long stiRdId = (Long) attributes.get("stiRdId");

        if (stiRdId != null) {
            setStiRdId(stiRdId);
        }

        Long vendrId = (Long) attributes.get("vendrId");

        if (vendrId != null) {
            setVendrId(vendrId);
        }

        String tier = (String) attributes.get("tier");

        if (tier != null) {
            setTier(tier);
        }

        String tierHours = (String) attributes.get("tierHours");

        if (tierHours != null) {
            setTierHours(tierHours);
        }

        String blsRateHourly = (String) attributes.get("blsRateHourly");

        if (blsRateHourly != null) {
            setBlsRateHourly(blsRateHourly);
        }

        String dailyRate = (String) attributes.get("dailyRate");

        if (dailyRate != null) {
            setDailyRate(dailyRate);
        }

        String monthlyPayment = (String) attributes.get("monthlyPayment");

        if (monthlyPayment != null) {
            setMonthlyPayment(monthlyPayment);
        }

        String stipendStatus = (String) attributes.get("stipendStatus");

        if (stipendStatus != null) {
            setStipendStatus(stipendStatus);
        }

        Date stipendApprovedDate = (Date) attributes.get("stipendApprovedDate");

        if (stipendApprovedDate != null) {
            setStipendApprovedDate(stipendApprovedDate);
        }

        Date stipendStartDate = (Date) attributes.get("stipendStartDate");

        if (stipendStartDate != null) {
            setStipendStartDate(stipendStartDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getStiPtId() {
        return _stiPtId;
    }

    @Override
    public void setStiPtId(long stiPtId) {
        _stiPtId = stiPtId;

        if (_stiPtRemoteModel != null) {
            try {
                Class<?> clazz = _stiPtRemoteModel.getClass();

                Method method = clazz.getMethod("setStiPtId", long.class);

                method.invoke(_stiPtRemoteModel, stiPtId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getStiRdId() {
        return _stiRdId;
    }

    @Override
    public void setStiRdId(long stiRdId) {
        _stiRdId = stiRdId;

        if (_stiPtRemoteModel != null) {
            try {
                Class<?> clazz = _stiPtRemoteModel.getClass();

                Method method = clazz.getMethod("setStiRdId", long.class);

                method.invoke(_stiPtRemoteModel, stiRdId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getVendrId() {
        return _vendrId;
    }

    @Override
    public void setVendrId(long vendrId) {
        _vendrId = vendrId;

        if (_stiPtRemoteModel != null) {
            try {
                Class<?> clazz = _stiPtRemoteModel.getClass();

                Method method = clazz.getMethod("setVendrId", long.class);

                method.invoke(_stiPtRemoteModel, vendrId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getTier() {
        return _tier;
    }

    @Override
    public void setTier(String tier) {
        _tier = tier;

        if (_stiPtRemoteModel != null) {
            try {
                Class<?> clazz = _stiPtRemoteModel.getClass();

                Method method = clazz.getMethod("setTier", String.class);

                method.invoke(_stiPtRemoteModel, tier);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getTierHours() {
        return _tierHours;
    }

    @Override
    public void setTierHours(String tierHours) {
        _tierHours = tierHours;

        if (_stiPtRemoteModel != null) {
            try {
                Class<?> clazz = _stiPtRemoteModel.getClass();

                Method method = clazz.getMethod("setTierHours", String.class);

                method.invoke(_stiPtRemoteModel, tierHours);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getBlsRateHourly() {
        return _blsRateHourly;
    }

    @Override
    public void setBlsRateHourly(String blsRateHourly) {
        _blsRateHourly = blsRateHourly;

        if (_stiPtRemoteModel != null) {
            try {
                Class<?> clazz = _stiPtRemoteModel.getClass();

                Method method = clazz.getMethod("setBlsRateHourly", String.class);

                method.invoke(_stiPtRemoteModel, blsRateHourly);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getDailyRate() {
        return _dailyRate;
    }

    @Override
    public void setDailyRate(String dailyRate) {
        _dailyRate = dailyRate;

        if (_stiPtRemoteModel != null) {
            try {
                Class<?> clazz = _stiPtRemoteModel.getClass();

                Method method = clazz.getMethod("setDailyRate", String.class);

                method.invoke(_stiPtRemoteModel, dailyRate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getMonthlyPayment() {
        return _monthlyPayment;
    }

    @Override
    public void setMonthlyPayment(String monthlyPayment) {
        _monthlyPayment = monthlyPayment;

        if (_stiPtRemoteModel != null) {
            try {
                Class<?> clazz = _stiPtRemoteModel.getClass();

                Method method = clazz.getMethod("setMonthlyPayment",
                        String.class);

                method.invoke(_stiPtRemoteModel, monthlyPayment);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getStipendStatus() {
        return _stipendStatus;
    }

    @Override
    public void setStipendStatus(String stipendStatus) {
        _stipendStatus = stipendStatus;

        if (_stiPtRemoteModel != null) {
            try {
                Class<?> clazz = _stiPtRemoteModel.getClass();

                Method method = clazz.getMethod("setStipendStatus", String.class);

                method.invoke(_stiPtRemoteModel, stipendStatus);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getStipendApprovedDate() {
        return _stipendApprovedDate;
    }

    @Override
    public void setStipendApprovedDate(Date stipendApprovedDate) {
        _stipendApprovedDate = stipendApprovedDate;

        if (_stiPtRemoteModel != null) {
            try {
                Class<?> clazz = _stiPtRemoteModel.getClass();

                Method method = clazz.getMethod("setStipendApprovedDate",
                        Date.class);

                method.invoke(_stiPtRemoteModel, stipendApprovedDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getStipendStartDate() {
        return _stipendStartDate;
    }

    @Override
    public void setStipendStartDate(Date stipendStartDate) {
        _stipendStartDate = stipendStartDate;

        if (_stiPtRemoteModel != null) {
            try {
                Class<?> clazz = _stiPtRemoteModel.getClass();

                Method method = clazz.getMethod("setStipendStartDate",
                        Date.class);

                method.invoke(_stiPtRemoteModel, stipendStartDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;

        if (_stiPtRemoteModel != null) {
            try {
                Class<?> clazz = _stiPtRemoteModel.getClass();

                Method method = clazz.getMethod("setGroupId", long.class);

                method.invoke(_stiPtRemoteModel, groupId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getStiPtRemoteModel() {
        return _stiPtRemoteModel;
    }

    public void setStiPtRemoteModel(BaseModel<?> stiPtRemoteModel) {
        _stiPtRemoteModel = stiPtRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _stiPtRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_stiPtRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            StiPtLocalServiceUtil.addStiPt(this);
        } else {
            StiPtLocalServiceUtil.updateStiPt(this);
        }
    }

    @Override
    public StiPt toEscapedModel() {
        return (StiPt) ProxyUtil.newProxyInstance(StiPt.class.getClassLoader(),
            new Class[] { StiPt.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        StiPtClp clone = new StiPtClp();

        clone.setStiPtId(getStiPtId());
        clone.setStiRdId(getStiRdId());
        clone.setVendrId(getVendrId());
        clone.setTier(getTier());
        clone.setTierHours(getTierHours());
        clone.setBlsRateHourly(getBlsRateHourly());
        clone.setDailyRate(getDailyRate());
        clone.setMonthlyPayment(getMonthlyPayment());
        clone.setStipendStatus(getStipendStatus());
        clone.setStipendApprovedDate(getStipendApprovedDate());
        clone.setStipendStartDate(getStipendStartDate());
        clone.setGroupId(getGroupId());

        return clone;
    }

    @Override
    public int compareTo(StiPt stiPt) {
        long primaryKey = stiPt.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof StiPtClp)) {
            return false;
        }

        StiPtClp stiPt = (StiPtClp) obj;

        long primaryKey = stiPt.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(25);

        sb.append("{stiPtId=");
        sb.append(getStiPtId());
        sb.append(", stiRdId=");
        sb.append(getStiRdId());
        sb.append(", vendrId=");
        sb.append(getVendrId());
        sb.append(", tier=");
        sb.append(getTier());
        sb.append(", tierHours=");
        sb.append(getTierHours());
        sb.append(", blsRateHourly=");
        sb.append(getBlsRateHourly());
        sb.append(", dailyRate=");
        sb.append(getDailyRate());
        sb.append(", monthlyPayment=");
        sb.append(getMonthlyPayment());
        sb.append(", stipendStatus=");
        sb.append(getStipendStatus());
        sb.append(", stipendApprovedDate=");
        sb.append(getStipendApprovedDate());
        sb.append(", stipendStartDate=");
        sb.append(getStipendStartDate());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(40);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.StiPt");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>stiPtId</column-name><column-value><![CDATA[");
        sb.append(getStiPtId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>stiRdId</column-name><column-value><![CDATA[");
        sb.append(getStiRdId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vendrId</column-name><column-value><![CDATA[");
        sb.append(getVendrId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>tier</column-name><column-value><![CDATA[");
        sb.append(getTier());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>tierHours</column-name><column-value><![CDATA[");
        sb.append(getTierHours());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>blsRateHourly</column-name><column-value><![CDATA[");
        sb.append(getBlsRateHourly());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>dailyRate</column-name><column-value><![CDATA[");
        sb.append(getDailyRate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>monthlyPayment</column-name><column-value><![CDATA[");
        sb.append(getMonthlyPayment());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>stipendStatus</column-name><column-value><![CDATA[");
        sb.append(getStipendStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>stipendApprovedDate</column-name><column-value><![CDATA[");
        sb.append(getStipendApprovedDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>stipendStartDate</column-name><column-value><![CDATA[");
        sb.append(getStipendStartDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
