package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.PersnLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class PersnClp extends BaseModelImpl<Persn> implements Persn {
    private long _persnId;
    private long _persnUserId;
    private String _persnUserUuid;
    private String _lastName;
    private String _firstName;
    private String _middleName;
    private String _prefix;
    private String _suffix;
    private Date _birthDate;
    private Date _deceasedDate;
    private String _gender;
    private String _address;
    private String _address2;
    private String _city;
    private String _state;
    private String _country;
    private String _zip;
    private String _phone;
    private String _phone2;
    private String _email;
    private String _email2;
    private String _status;
    private String _source;
    private String _externalId;
    private String _otherHealthInsurance;
    private long _userId;
    private String _userUuid;
    private long _groupId;
    private BaseModel<?> _persnRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public PersnClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return Persn.class;
    }

    @Override
    public String getModelClassName() {
        return Persn.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _persnId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setPersnId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _persnId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("persnId", getPersnId());
        attributes.put("persnUserId", getPersnUserId());
        attributes.put("lastName", getLastName());
        attributes.put("firstName", getFirstName());
        attributes.put("middleName", getMiddleName());
        attributes.put("prefix", getPrefix());
        attributes.put("suffix", getSuffix());
        attributes.put("birthDate", getBirthDate());
        attributes.put("deceasedDate", getDeceasedDate());
        attributes.put("gender", getGender());
        attributes.put("address", getAddress());
        attributes.put("address2", getAddress2());
        attributes.put("city", getCity());
        attributes.put("state", getState());
        attributes.put("country", getCountry());
        attributes.put("zip", getZip());
        attributes.put("phone", getPhone());
        attributes.put("phone2", getPhone2());
        attributes.put("email", getEmail());
        attributes.put("email2", getEmail2());
        attributes.put("status", getStatus());
        attributes.put("source", getSource());
        attributes.put("externalId", getExternalId());
        attributes.put("otherHealthInsurance", getOtherHealthInsurance());
        attributes.put("userId", getUserId());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long persnId = (Long) attributes.get("persnId");

        if (persnId != null) {
            setPersnId(persnId);
        }

        Long persnUserId = (Long) attributes.get("persnUserId");

        if (persnUserId != null) {
            setPersnUserId(persnUserId);
        }

        String lastName = (String) attributes.get("lastName");

        if (lastName != null) {
            setLastName(lastName);
        }

        String firstName = (String) attributes.get("firstName");

        if (firstName != null) {
            setFirstName(firstName);
        }

        String middleName = (String) attributes.get("middleName");

        if (middleName != null) {
            setMiddleName(middleName);
        }

        String prefix = (String) attributes.get("prefix");

        if (prefix != null) {
            setPrefix(prefix);
        }

        String suffix = (String) attributes.get("suffix");

        if (suffix != null) {
            setSuffix(suffix);
        }

        Date birthDate = (Date) attributes.get("birthDate");

        if (birthDate != null) {
            setBirthDate(birthDate);
        }

        Date deceasedDate = (Date) attributes.get("deceasedDate");

        if (deceasedDate != null) {
            setDeceasedDate(deceasedDate);
        }

        String gender = (String) attributes.get("gender");

        if (gender != null) {
            setGender(gender);
        }

        String address = (String) attributes.get("address");

        if (address != null) {
            setAddress(address);
        }

        String address2 = (String) attributes.get("address2");

        if (address2 != null) {
            setAddress2(address2);
        }

        String city = (String) attributes.get("city");

        if (city != null) {
            setCity(city);
        }

        String state = (String) attributes.get("state");

        if (state != null) {
            setState(state);
        }

        String country = (String) attributes.get("country");

        if (country != null) {
            setCountry(country);
        }

        String zip = (String) attributes.get("zip");

        if (zip != null) {
            setZip(zip);
        }

        String phone = (String) attributes.get("phone");

        if (phone != null) {
            setPhone(phone);
        }

        String phone2 = (String) attributes.get("phone2");

        if (phone2 != null) {
            setPhone2(phone2);
        }

        String email = (String) attributes.get("email");

        if (email != null) {
            setEmail(email);
        }

        String email2 = (String) attributes.get("email2");

        if (email2 != null) {
            setEmail2(email2);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        String source = (String) attributes.get("source");

        if (source != null) {
            setSource(source);
        }

        String externalId = (String) attributes.get("externalId");

        if (externalId != null) {
            setExternalId(externalId);
        }

        String otherHealthInsurance = (String) attributes.get(
                "otherHealthInsurance");

        if (otherHealthInsurance != null) {
            setOtherHealthInsurance(otherHealthInsurance);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getPersnId() {
        return _persnId;
    }

    @Override
    public void setPersnId(long persnId) {
        _persnId = persnId;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setPersnId", long.class);

                method.invoke(_persnRemoteModel, persnId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getPersnUserId() {
        return _persnUserId;
    }

    @Override
    public void setPersnUserId(long persnUserId) {
        _persnUserId = persnUserId;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setPersnUserId", long.class);

                method.invoke(_persnRemoteModel, persnUserId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getPersnUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getPersnUserId(), "uuid", _persnUserUuid);
    }

    @Override
    public void setPersnUserUuid(String persnUserUuid) {
        _persnUserUuid = persnUserUuid;
    }

    @Override
    public String getLastName() {
        return _lastName;
    }

    @Override
    public void setLastName(String lastName) {
        _lastName = lastName;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setLastName", String.class);

                method.invoke(_persnRemoteModel, lastName);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getFirstName() {
        return _firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        _firstName = firstName;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setFirstName", String.class);

                method.invoke(_persnRemoteModel, firstName);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getMiddleName() {
        return _middleName;
    }

    @Override
    public void setMiddleName(String middleName) {
        _middleName = middleName;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setMiddleName", String.class);

                method.invoke(_persnRemoteModel, middleName);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getPrefix() {
        return _prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        _prefix = prefix;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setPrefix", String.class);

                method.invoke(_persnRemoteModel, prefix);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getSuffix() {
        return _suffix;
    }

    @Override
    public void setSuffix(String suffix) {
        _suffix = suffix;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setSuffix", String.class);

                method.invoke(_persnRemoteModel, suffix);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getBirthDate() {
        return _birthDate;
    }

    @Override
    public void setBirthDate(Date birthDate) {
        _birthDate = birthDate;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setBirthDate", Date.class);

                method.invoke(_persnRemoteModel, birthDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getDeceasedDate() {
        return _deceasedDate;
    }

    @Override
    public void setDeceasedDate(Date deceasedDate) {
        _deceasedDate = deceasedDate;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setDeceasedDate", Date.class);

                method.invoke(_persnRemoteModel, deceasedDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getGender() {
        return _gender;
    }

    @Override
    public void setGender(String gender) {
        _gender = gender;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setGender", String.class);

                method.invoke(_persnRemoteModel, gender);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getAddress() {
        return _address;
    }

    @Override
    public void setAddress(String address) {
        _address = address;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setAddress", String.class);

                method.invoke(_persnRemoteModel, address);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getAddress2() {
        return _address2;
    }

    @Override
    public void setAddress2(String address2) {
        _address2 = address2;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setAddress2", String.class);

                method.invoke(_persnRemoteModel, address2);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCity() {
        return _city;
    }

    @Override
    public void setCity(String city) {
        _city = city;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setCity", String.class);

                method.invoke(_persnRemoteModel, city);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getState() {
        return _state;
    }

    @Override
    public void setState(String state) {
        _state = state;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setState", String.class);

                method.invoke(_persnRemoteModel, state);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCountry() {
        return _country;
    }

    @Override
    public void setCountry(String country) {
        _country = country;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setCountry", String.class);

                method.invoke(_persnRemoteModel, country);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getZip() {
        return _zip;
    }

    @Override
    public void setZip(String zip) {
        _zip = zip;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setZip", String.class);

                method.invoke(_persnRemoteModel, zip);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getPhone() {
        return _phone;
    }

    @Override
    public void setPhone(String phone) {
        _phone = phone;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setPhone", String.class);

                method.invoke(_persnRemoteModel, phone);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getPhone2() {
        return _phone2;
    }

    @Override
    public void setPhone2(String phone2) {
        _phone2 = phone2;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setPhone2", String.class);

                method.invoke(_persnRemoteModel, phone2);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getEmail() {
        return _email;
    }

    @Override
    public void setEmail(String email) {
        _email = email;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setEmail", String.class);

                method.invoke(_persnRemoteModel, email);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getEmail2() {
        return _email2;
    }

    @Override
    public void setEmail2(String email2) {
        _email2 = email2;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setEmail2", String.class);

                method.invoke(_persnRemoteModel, email2);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getStatus() {
        return _status;
    }

    @Override
    public void setStatus(String status) {
        _status = status;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setStatus", String.class);

                method.invoke(_persnRemoteModel, status);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getSource() {
        return _source;
    }

    @Override
    public void setSource(String source) {
        _source = source;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setSource", String.class);

                method.invoke(_persnRemoteModel, source);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getExternalId() {
        return _externalId;
    }

    @Override
    public void setExternalId(String externalId) {
        _externalId = externalId;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setExternalId", String.class);

                method.invoke(_persnRemoteModel, externalId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getOtherHealthInsurance() {
        return _otherHealthInsurance;
    }

    @Override
    public void setOtherHealthInsurance(String otherHealthInsurance) {
        _otherHealthInsurance = otherHealthInsurance;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setOtherHealthInsurance",
                        String.class);

                method.invoke(_persnRemoteModel, otherHealthInsurance);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setUserId", long.class);

                method.invoke(_persnRemoteModel, userId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;

        if (_persnRemoteModel != null) {
            try {
                Class<?> clazz = _persnRemoteModel.getClass();

                Method method = clazz.getMethod("setGroupId", long.class);

                method.invoke(_persnRemoteModel, groupId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getPersnRemoteModel() {
        return _persnRemoteModel;
    }

    public void setPersnRemoteModel(BaseModel<?> persnRemoteModel) {
        _persnRemoteModel = persnRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _persnRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_persnRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            PersnLocalServiceUtil.addPersn(this);
        } else {
            PersnLocalServiceUtil.updatePersn(this);
        }
    }

    @Override
    public Persn toEscapedModel() {
        return (Persn) ProxyUtil.newProxyInstance(Persn.class.getClassLoader(),
            new Class[] { Persn.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        PersnClp clone = new PersnClp();

        clone.setPersnId(getPersnId());
        clone.setPersnUserId(getPersnUserId());
        clone.setLastName(getLastName());
        clone.setFirstName(getFirstName());
        clone.setMiddleName(getMiddleName());
        clone.setPrefix(getPrefix());
        clone.setSuffix(getSuffix());
        clone.setBirthDate(getBirthDate());
        clone.setDeceasedDate(getDeceasedDate());
        clone.setGender(getGender());
        clone.setAddress(getAddress());
        clone.setAddress2(getAddress2());
        clone.setCity(getCity());
        clone.setState(getState());
        clone.setCountry(getCountry());
        clone.setZip(getZip());
        clone.setPhone(getPhone());
        clone.setPhone2(getPhone2());
        clone.setEmail(getEmail());
        clone.setEmail2(getEmail2());
        clone.setStatus(getStatus());
        clone.setSource(getSource());
        clone.setExternalId(getExternalId());
        clone.setOtherHealthInsurance(getOtherHealthInsurance());
        clone.setUserId(getUserId());
        clone.setGroupId(getGroupId());

        return clone;
    }

    @Override
    public int compareTo(Persn persn) {
        long primaryKey = persn.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof PersnClp)) {
            return false;
        }

        PersnClp persn = (PersnClp) obj;

        long primaryKey = persn.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(53);

        sb.append("{persnId=");
        sb.append(getPersnId());
        sb.append(", persnUserId=");
        sb.append(getPersnUserId());
        sb.append(", lastName=");
        sb.append(getLastName());
        sb.append(", firstName=");
        sb.append(getFirstName());
        sb.append(", middleName=");
        sb.append(getMiddleName());
        sb.append(", prefix=");
        sb.append(getPrefix());
        sb.append(", suffix=");
        sb.append(getSuffix());
        sb.append(", birthDate=");
        sb.append(getBirthDate());
        sb.append(", deceasedDate=");
        sb.append(getDeceasedDate());
        sb.append(", gender=");
        sb.append(getGender());
        sb.append(", address=");
        sb.append(getAddress());
        sb.append(", address2=");
        sb.append(getAddress2());
        sb.append(", city=");
        sb.append(getCity());
        sb.append(", state=");
        sb.append(getState());
        sb.append(", country=");
        sb.append(getCountry());
        sb.append(", zip=");
        sb.append(getZip());
        sb.append(", phone=");
        sb.append(getPhone());
        sb.append(", phone2=");
        sb.append(getPhone2());
        sb.append(", email=");
        sb.append(getEmail());
        sb.append(", email2=");
        sb.append(getEmail2());
        sb.append(", status=");
        sb.append(getStatus());
        sb.append(", source=");
        sb.append(getSource());
        sb.append(", externalId=");
        sb.append(getExternalId());
        sb.append(", otherHealthInsurance=");
        sb.append(getOtherHealthInsurance());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(82);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Persn");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>persnId</column-name><column-value><![CDATA[");
        sb.append(getPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>persnUserId</column-name><column-value><![CDATA[");
        sb.append(getPersnUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>lastName</column-name><column-value><![CDATA[");
        sb.append(getLastName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>firstName</column-name><column-value><![CDATA[");
        sb.append(getFirstName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>middleName</column-name><column-value><![CDATA[");
        sb.append(getMiddleName());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>prefix</column-name><column-value><![CDATA[");
        sb.append(getPrefix());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>suffix</column-name><column-value><![CDATA[");
        sb.append(getSuffix());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>birthDate</column-name><column-value><![CDATA[");
        sb.append(getBirthDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>deceasedDate</column-name><column-value><![CDATA[");
        sb.append(getDeceasedDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>gender</column-name><column-value><![CDATA[");
        sb.append(getGender());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>address</column-name><column-value><![CDATA[");
        sb.append(getAddress());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>address2</column-name><column-value><![CDATA[");
        sb.append(getAddress2());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>city</column-name><column-value><![CDATA[");
        sb.append(getCity());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>state</column-name><column-value><![CDATA[");
        sb.append(getState());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>country</column-name><column-value><![CDATA[");
        sb.append(getCountry());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>zip</column-name><column-value><![CDATA[");
        sb.append(getZip());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>phone</column-name><column-value><![CDATA[");
        sb.append(getPhone());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>phone2</column-name><column-value><![CDATA[");
        sb.append(getPhone2());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>email</column-name><column-value><![CDATA[");
        sb.append(getEmail());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>email2</column-name><column-value><![CDATA[");
        sb.append(getEmail2());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>status</column-name><column-value><![CDATA[");
        sb.append(getStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>source</column-name><column-value><![CDATA[");
        sb.append(getSource());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>externalId</column-name><column-value><![CDATA[");
        sb.append(getExternalId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>otherHealthInsurance</column-name><column-value><![CDATA[");
        sb.append(getOtherHealthInsurance());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
