package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link PayLg}.
 * </p>
 *
 * @author caret
 * @see PayLg
 * @generated
 */
public class PayLgWrapper implements PayLg, ModelWrapper<PayLg> {
    private PayLg _payLg;

    public PayLgWrapper(PayLg payLg) {
        _payLg = payLg;
    }

    @Override
    public Class<?> getModelClass() {
        return PayLg.class;
    }

    @Override
    public String getModelClassName() {
        return PayLg.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("paymentLogId", getPaymentLogId());
        attributes.put("stiPtId", getStiPtId());
        attributes.put("amount", getAmount());
        attributes.put("paymentDate", getPaymentDate());
        attributes.put("status", getStatus());
        attributes.put("reason", getReason());
        attributes.put("creationDate", getCreationDate());
        attributes.put("userId", getUserId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long paymentLogId = (Long) attributes.get("paymentLogId");

        if (paymentLogId != null) {
            setPaymentLogId(paymentLogId);
        }

        Long stiPtId = (Long) attributes.get("stiPtId");

        if (stiPtId != null) {
            setStiPtId(stiPtId);
        }

        Double amount = (Double) attributes.get("amount");

        if (amount != null) {
            setAmount(amount);
        }

        Date paymentDate = (Date) attributes.get("paymentDate");

        if (paymentDate != null) {
            setPaymentDate(paymentDate);
        }

        String status = (String) attributes.get("status");

        if (status != null) {
            setStatus(status);
        }

        String reason = (String) attributes.get("reason");

        if (reason != null) {
            setReason(reason);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }
    }

    /**
    * Returns the primary key of this pay lg.
    *
    * @return the primary key of this pay lg
    */
    @Override
    public long getPrimaryKey() {
        return _payLg.getPrimaryKey();
    }

    /**
    * Sets the primary key of this pay lg.
    *
    * @param primaryKey the primary key of this pay lg
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _payLg.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the payment log ID of this pay lg.
    *
    * @return the payment log ID of this pay lg
    */
    @Override
    public long getPaymentLogId() {
        return _payLg.getPaymentLogId();
    }

    /**
    * Sets the payment log ID of this pay lg.
    *
    * @param paymentLogId the payment log ID of this pay lg
    */
    @Override
    public void setPaymentLogId(long paymentLogId) {
        _payLg.setPaymentLogId(paymentLogId);
    }

    /**
    * Returns the sti pt ID of this pay lg.
    *
    * @return the sti pt ID of this pay lg
    */
    @Override
    public long getStiPtId() {
        return _payLg.getStiPtId();
    }

    /**
    * Sets the sti pt ID of this pay lg.
    *
    * @param stiPtId the sti pt ID of this pay lg
    */
    @Override
    public void setStiPtId(long stiPtId) {
        _payLg.setStiPtId(stiPtId);
    }

    /**
    * Returns the amount of this pay lg.
    *
    * @return the amount of this pay lg
    */
    @Override
    public java.lang.Double getAmount() {
        return _payLg.getAmount();
    }

    /**
    * Sets the amount of this pay lg.
    *
    * @param amount the amount of this pay lg
    */
    @Override
    public void setAmount(java.lang.Double amount) {
        _payLg.setAmount(amount);
    }

    /**
    * Returns the payment date of this pay lg.
    *
    * @return the payment date of this pay lg
    */
    @Override
    public java.util.Date getPaymentDate() {
        return _payLg.getPaymentDate();
    }

    /**
    * Sets the payment date of this pay lg.
    *
    * @param paymentDate the payment date of this pay lg
    */
    @Override
    public void setPaymentDate(java.util.Date paymentDate) {
        _payLg.setPaymentDate(paymentDate);
    }

    /**
    * Returns the status of this pay lg.
    *
    * @return the status of this pay lg
    */
    @Override
    public java.lang.String getStatus() {
        return _payLg.getStatus();
    }

    /**
    * Sets the status of this pay lg.
    *
    * @param status the status of this pay lg
    */
    @Override
    public void setStatus(java.lang.String status) {
        _payLg.setStatus(status);
    }

    /**
    * Returns the reason of this pay lg.
    *
    * @return the reason of this pay lg
    */
    @Override
    public java.lang.String getReason() {
        return _payLg.getReason();
    }

    /**
    * Sets the reason of this pay lg.
    *
    * @param reason the reason of this pay lg
    */
    @Override
    public void setReason(java.lang.String reason) {
        _payLg.setReason(reason);
    }

    /**
    * Returns the creation date of this pay lg.
    *
    * @return the creation date of this pay lg
    */
    @Override
    public java.util.Date getCreationDate() {
        return _payLg.getCreationDate();
    }

    /**
    * Sets the creation date of this pay lg.
    *
    * @param creationDate the creation date of this pay lg
    */
    @Override
    public void setCreationDate(java.util.Date creationDate) {
        _payLg.setCreationDate(creationDate);
    }

    /**
    * Returns the user ID of this pay lg.
    *
    * @return the user ID of this pay lg
    */
    @Override
    public long getUserId() {
        return _payLg.getUserId();
    }

    /**
    * Sets the user ID of this pay lg.
    *
    * @param userId the user ID of this pay lg
    */
    @Override
    public void setUserId(long userId) {
        _payLg.setUserId(userId);
    }

    /**
    * Returns the user uuid of this pay lg.
    *
    * @return the user uuid of this pay lg
    * @throws SystemException if a system exception occurred
    */
    @Override
    public java.lang.String getUserUuid()
        throws com.liferay.portal.kernel.exception.SystemException {
        return _payLg.getUserUuid();
    }

    /**
    * Sets the user uuid of this pay lg.
    *
    * @param userUuid the user uuid of this pay lg
    */
    @Override
    public void setUserUuid(java.lang.String userUuid) {
        _payLg.setUserUuid(userUuid);
    }

    @Override
    public boolean isNew() {
        return _payLg.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _payLg.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _payLg.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _payLg.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _payLg.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _payLg.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _payLg.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _payLg.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _payLg.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _payLg.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _payLg.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new PayLgWrapper((PayLg) _payLg.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.PayLg payLg) {
        return _payLg.compareTo(payLg);
    }

    @Override
    public int hashCode() {
        return _payLg.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.PayLg> toCacheModel() {
        return _payLg.toCacheModel();
    }

    @Override
    public gov.va.caret.model.PayLg toEscapedModel() {
        return new PayLgWrapper(_payLg.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.PayLg toUnescapedModel() {
        return new PayLgWrapper(_payLg.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _payLg.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _payLg.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _payLg.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof PayLgWrapper)) {
            return false;
        }

        PayLgWrapper payLgWrapper = (PayLgWrapper) obj;

        if (Validator.equals(_payLg, payLgWrapper._payLg)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public PayLg getWrappedPayLg() {
        return _payLg;
    }

    @Override
    public PayLg getWrappedModel() {
        return _payLg;
    }

    @Override
    public void resetOriginalValues() {
        _payLg.resetOriginalValues();
    }
}
