/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link PMMessage}.
 * </p>
 *
 * @author caret
 * @see PMMessage
 * @generated
 */
public class PMMessageWrapper implements PMMessage, ModelWrapper<PMMessage> {
	public PMMessageWrapper(PMMessage pmMessage) {
		_pmMessage = pmMessage;
	}

	@Override
	public Class<?> getModelClass() {
		return PMMessage.class;
	}

	@Override
	public String getModelClassName() {
		return PMMessage.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("messageId", getMessageId());
		attributes.put("subject", getSubject());
		attributes.put("body", getBody());
		attributes.put("url", getUrl());
		attributes.put("parentMessageId", getParentMessageId());
		attributes.put("ownerId", getOwnerId());
		attributes.put("ownerName", getOwnerName());
		attributes.put("postedDate", getPostedDate());
		attributes.put("recepients", getRecepients());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long messageId = (Long)attributes.get("messageId");

		if (messageId != null) {
			setMessageId(messageId);
		}

		String subject = (String)attributes.get("subject");

		if (subject != null) {
			setSubject(subject);
		}

		String body = (String)attributes.get("body");

		if (body != null) {
			setBody(body);
		}

		String url = (String)attributes.get("url");

		if (url != null) {
			setUrl(url);
		}

		Long parentMessageId = (Long)attributes.get("parentMessageId");

		if (parentMessageId != null) {
			setParentMessageId(parentMessageId);
		}

		Long ownerId = (Long)attributes.get("ownerId");

		if (ownerId != null) {
			setOwnerId(ownerId);
		}

		String ownerName = (String)attributes.get("ownerName");

		if (ownerName != null) {
			setOwnerName(ownerName);
		}

		Date postedDate = (Date)attributes.get("postedDate");

		if (postedDate != null) {
			setPostedDate(postedDate);
		}

		String recepients = (String)attributes.get("recepients");

		if (recepients != null) {
			setRecepients(recepients);
		}
	}

	/**
	* Returns the primary key of this p m message.
	*
	* @return the primary key of this p m message
	*/
	@Override
	public long getPrimaryKey() {
		return _pmMessage.getPrimaryKey();
	}

	/**
	* Sets the primary key of this p m message.
	*
	* @param primaryKey the primary key of this p m message
	*/
	@Override
	public void setPrimaryKey(long primaryKey) {
		_pmMessage.setPrimaryKey(primaryKey);
	}

	/**
	* Returns the message ID of this p m message.
	*
	* @return the message ID of this p m message
	*/
	@Override
	public long getMessageId() {
		return _pmMessage.getMessageId();
	}

	/**
	* Sets the message ID of this p m message.
	*
	* @param messageId the message ID of this p m message
	*/
	@Override
	public void setMessageId(long messageId) {
		_pmMessage.setMessageId(messageId);
	}

	/**
	* Returns the subject of this p m message.
	*
	* @return the subject of this p m message
	*/
	@Override
	public java.lang.String getSubject() {
		return _pmMessage.getSubject();
	}

	/**
	* Sets the subject of this p m message.
	*
	* @param subject the subject of this p m message
	*/
	@Override
	public void setSubject(java.lang.String subject) {
		_pmMessage.setSubject(subject);
	}

	/**
	* Returns the body of this p m message.
	*
	* @return the body of this p m message
	*/
	@Override
	public java.lang.String getBody() {
		return _pmMessage.getBody();
	}

	/**
	* Sets the body of this p m message.
	*
	* @param body the body of this p m message
	*/
	@Override
	public void setBody(java.lang.String body) {
		_pmMessage.setBody(body);
	}

	/**
	* Returns the url of this p m message.
	*
	* @return the url of this p m message
	*/
	@Override
	public java.lang.String getUrl() {
		return _pmMessage.getUrl();
	}

	/**
	* Sets the url of this p m message.
	*
	* @param url the url of this p m message
	*/
	@Override
	public void setUrl(java.lang.String url) {
		_pmMessage.setUrl(url);
	}

	/**
	* Returns the parent message ID of this p m message.
	*
	* @return the parent message ID of this p m message
	*/
	@Override
	public long getParentMessageId() {
		return _pmMessage.getParentMessageId();
	}

	/**
	* Sets the parent message ID of this p m message.
	*
	* @param parentMessageId the parent message ID of this p m message
	*/
	@Override
	public void setParentMessageId(long parentMessageId) {
		_pmMessage.setParentMessageId(parentMessageId);
	}

	/**
	* Returns the owner ID of this p m message.
	*
	* @return the owner ID of this p m message
	*/
	@Override
	public long getOwnerId() {
		return _pmMessage.getOwnerId();
	}

	/**
	* Sets the owner ID of this p m message.
	*
	* @param ownerId the owner ID of this p m message
	*/
	@Override
	public void setOwnerId(long ownerId) {
		_pmMessage.setOwnerId(ownerId);
	}

	/**
	* Returns the owner name of this p m message.
	*
	* @return the owner name of this p m message
	*/
	@Override
	public java.lang.String getOwnerName() {
		return _pmMessage.getOwnerName();
	}

	/**
	* Sets the owner name of this p m message.
	*
	* @param ownerName the owner name of this p m message
	*/
	@Override
	public void setOwnerName(java.lang.String ownerName) {
		_pmMessage.setOwnerName(ownerName);
	}

	/**
	* Returns the posted date of this p m message.
	*
	* @return the posted date of this p m message
	*/
	@Override
	public java.util.Date getPostedDate() {
		return _pmMessage.getPostedDate();
	}

	/**
	* Sets the posted date of this p m message.
	*
	* @param postedDate the posted date of this p m message
	*/
	@Override
	public void setPostedDate(java.util.Date postedDate) {
		_pmMessage.setPostedDate(postedDate);
	}

	/**
	* Returns the recepients of this p m message.
	*
	* @return the recepients of this p m message
	*/
	@Override
	public java.lang.String getRecepients() {
		return _pmMessage.getRecepients();
	}

	/**
	* Sets the recepients of this p m message.
	*
	* @param recepients the recepients of this p m message
	*/
	@Override
	public void setRecepients(java.lang.String recepients) {
		_pmMessage.setRecepients(recepients);
	}

	@Override
	public boolean isNew() {
		return _pmMessage.isNew();
	}

	@Override
	public void setNew(boolean n) {
		_pmMessage.setNew(n);
	}

	@Override
	public boolean isCachedModel() {
		return _pmMessage.isCachedModel();
	}

	@Override
	public void setCachedModel(boolean cachedModel) {
		_pmMessage.setCachedModel(cachedModel);
	}

	@Override
	public boolean isEscapedModel() {
		return _pmMessage.isEscapedModel();
	}

	@Override
	public java.io.Serializable getPrimaryKeyObj() {
		return _pmMessage.getPrimaryKeyObj();
	}

	@Override
	public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
		_pmMessage.setPrimaryKeyObj(primaryKeyObj);
	}

	@Override
	public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
		return _pmMessage.getExpandoBridge();
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portal.model.BaseModel<?> baseModel) {
		_pmMessage.setExpandoBridgeAttributes(baseModel);
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
		_pmMessage.setExpandoBridgeAttributes(expandoBridge);
	}

	@Override
	public void setExpandoBridgeAttributes(
		com.liferay.portal.service.ServiceContext serviceContext) {
		_pmMessage.setExpandoBridgeAttributes(serviceContext);
	}

	@Override
	public java.lang.Object clone() {
		return new PMMessageWrapper((PMMessage)_pmMessage.clone());
	}

	@Override
	public int compareTo(gov.va.caret.model.PMMessage pmMessage) {
		return _pmMessage.compareTo(pmMessage);
	}

	@Override
	public int hashCode() {
		return _pmMessage.hashCode();
	}

	@Override
	public com.liferay.portal.model.CacheModel<gov.va.caret.model.PMMessage> toCacheModel() {
		return _pmMessage.toCacheModel();
	}

	@Override
	public gov.va.caret.model.PMMessage toEscapedModel() {
		return new PMMessageWrapper(_pmMessage.toEscapedModel());
	}

	@Override
	public gov.va.caret.model.PMMessage toUnescapedModel() {
		return new PMMessageWrapper(_pmMessage.toUnescapedModel());
	}

	@Override
	public java.lang.String toString() {
		return _pmMessage.toString();
	}

	@Override
	public java.lang.String toXmlString() {
		return _pmMessage.toXmlString();
	}

	@Override
	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		_pmMessage.persist();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof PMMessageWrapper)) {
			return false;
		}

		PMMessageWrapper pmMessageWrapper = (PMMessageWrapper)obj;

		if (Validator.equals(_pmMessage, pmMessageWrapper._pmMessage)) {
			return true;
		}

		return false;
	}

	/**
	 * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
	 */
	public PMMessage getWrappedPMMessage() {
		return _pmMessage;
	}

	@Override
	public PMMessage getWrappedModel() {
		return _pmMessage;
	}

	@Override
	public void resetOriginalValues() {
		_pmMessage.resetOriginalValues();
	}

	private PMMessage _pmMessage;
}