/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the PMMessage service. Represents a row in the &quot;private_message&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.PMMessageModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.PMMessageImpl}.
 * </p>
 *
 * @author caret
 * @see PMMessage
 * @see gov.va.caret.model.impl.PMMessageImpl
 * @see gov.va.caret.model.impl.PMMessageModelImpl
 * @generated
 */
public interface PMMessageModel extends BaseModel<PMMessage> {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a p m message model instance should use the {@link PMMessage} interface instead.
	 */

	/**
	 * Returns the primary key of this p m message.
	 *
	 * @return the primary key of this p m message
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this p m message.
	 *
	 * @param primaryKey the primary key of this p m message
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the message ID of this p m message.
	 *
	 * @return the message ID of this p m message
	 */
	public long getMessageId();

	/**
	 * Sets the message ID of this p m message.
	 *
	 * @param messageId the message ID of this p m message
	 */
	public void setMessageId(long messageId);

	/**
	 * Returns the subject of this p m message.
	 *
	 * @return the subject of this p m message
	 */
	@AutoEscape
	public String getSubject();

	/**
	 * Sets the subject of this p m message.
	 *
	 * @param subject the subject of this p m message
	 */
	public void setSubject(String subject);

	/**
	 * Returns the body of this p m message.
	 *
	 * @return the body of this p m message
	 */
	@AutoEscape
	public String getBody();

	/**
	 * Sets the body of this p m message.
	 *
	 * @param body the body of this p m message
	 */
	public void setBody(String body);

	/**
	 * Returns the url of this p m message.
	 *
	 * @return the url of this p m message
	 */
	@AutoEscape
	public String getUrl();

	/**
	 * Sets the url of this p m message.
	 *
	 * @param url the url of this p m message
	 */
	public void setUrl(String url);

	/**
	 * Returns the parent message ID of this p m message.
	 *
	 * @return the parent message ID of this p m message
	 */
	public long getParentMessageId();

	/**
	 * Sets the parent message ID of this p m message.
	 *
	 * @param parentMessageId the parent message ID of this p m message
	 */
	public void setParentMessageId(long parentMessageId);

	/**
	 * Returns the owner ID of this p m message.
	 *
	 * @return the owner ID of this p m message
	 */
	public long getOwnerId();

	/**
	 * Sets the owner ID of this p m message.
	 *
	 * @param ownerId the owner ID of this p m message
	 */
	public void setOwnerId(long ownerId);

	/**
	 * Returns the owner name of this p m message.
	 *
	 * @return the owner name of this p m message
	 */
	@AutoEscape
	public String getOwnerName();

	/**
	 * Sets the owner name of this p m message.
	 *
	 * @param ownerName the owner name of this p m message
	 */
	public void setOwnerName(String ownerName);

	/**
	 * Returns the posted date of this p m message.
	 *
	 * @return the posted date of this p m message
	 */
	public Date getPostedDate();

	/**
	 * Sets the posted date of this p m message.
	 *
	 * @param postedDate the posted date of this p m message
	 */
	public void setPostedDate(Date postedDate);

	/**
	 * Returns the recepients of this p m message.
	 *
	 * @return the recepients of this p m message
	 */
	@AutoEscape
	public String getRecepients();

	/**
	 * Sets the recepients of this p m message.
	 *
	 * @param recepients the recepients of this p m message
	 */
	public void setRecepients(String recepients);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(gov.va.caret.model.PMMessage pmMessage);

	@Override
	public int hashCode();

	@Override
	public CacheModel<gov.va.caret.model.PMMessage> toCacheModel();

	@Override
	public gov.va.caret.model.PMMessage toEscapedModel();

	@Override
	public gov.va.caret.model.PMMessage toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();
}