/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the PMDeletedMessage service. Represents a row in the &quot;deleted_message&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link gov.va.caret.model.impl.PMDeletedMessageModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link gov.va.caret.model.impl.PMDeletedMessageImpl}.
 * </p>
 *
 * @author caret
 * @see PMDeletedMessage
 * @see gov.va.caret.model.impl.PMDeletedMessageImpl
 * @see gov.va.caret.model.impl.PMDeletedMessageModelImpl
 * @generated
 */
public interface PMDeletedMessageModel extends BaseModel<PMDeletedMessage> {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a p m deleted message model instance should use the {@link PMDeletedMessage} interface instead.
	 */

	/**
	 * Returns the primary key of this p m deleted message.
	 *
	 * @return the primary key of this p m deleted message
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this p m deleted message.
	 *
	 * @param primaryKey the primary key of this p m deleted message
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the deleted message ID of this p m deleted message.
	 *
	 * @return the deleted message ID of this p m deleted message
	 */
	public long getDeletedMessageId();

	/**
	 * Sets the deleted message ID of this p m deleted message.
	 *
	 * @param deletedMessageId the deleted message ID of this p m deleted message
	 */
	public void setDeletedMessageId(long deletedMessageId);

	/**
	 * Returns the message ID of this p m deleted message.
	 *
	 * @return the message ID of this p m deleted message
	 */
	public long getMessageId();

	/**
	 * Sets the message ID of this p m deleted message.
	 *
	 * @param messageId the message ID of this p m deleted message
	 */
	public void setMessageId(long messageId);

	/**
	 * Returns the owner ID of this p m deleted message.
	 *
	 * @return the owner ID of this p m deleted message
	 */
	public long getOwnerId();

	/**
	 * Sets the owner ID of this p m deleted message.
	 *
	 * @param ownerId the owner ID of this p m deleted message
	 */
	public void setOwnerId(long ownerId);

	/**
	 * Returns the deleted date of this p m deleted message.
	 *
	 * @return the deleted date of this p m deleted message
	 */
	public Date getDeletedDate();

	/**
	 * Sets the deleted date of this p m deleted message.
	 *
	 * @param deletedDate the deleted date of this p m deleted message
	 */
	public void setDeletedDate(Date deletedDate);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(gov.va.caret.model.PMDeletedMessage pmDeletedMessage);

	@Override
	public int hashCode();

	@Override
	public CacheModel<gov.va.caret.model.PMDeletedMessage> toCacheModel();

	@Override
	public gov.va.caret.model.PMDeletedMessage toEscapedModel();

	@Override
	public gov.va.caret.model.PMDeletedMessage toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();
}