/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClpSerializer;
import gov.va.caret.service.PMDeletedMessageLocalServiceUtil;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author caret
 */
public class PMDeletedMessageClp extends BaseModelImpl<PMDeletedMessage>
	implements PMDeletedMessage {
	public PMDeletedMessageClp() {
	}

	@Override
	public Class<?> getModelClass() {
		return PMDeletedMessage.class;
	}

	@Override
	public String getModelClassName() {
		return PMDeletedMessage.class.getName();
	}

	@Override
	public long getPrimaryKey() {
		return _deletedMessageId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setDeletedMessageId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _deletedMessageId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("deletedMessageId", getDeletedMessageId());
		attributes.put("messageId", getMessageId());
		attributes.put("ownerId", getOwnerId());
		attributes.put("deletedDate", getDeletedDate());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long deletedMessageId = (Long)attributes.get("deletedMessageId");

		if (deletedMessageId != null) {
			setDeletedMessageId(deletedMessageId);
		}

		Long messageId = (Long)attributes.get("messageId");

		if (messageId != null) {
			setMessageId(messageId);
		}

		Long ownerId = (Long)attributes.get("ownerId");

		if (ownerId != null) {
			setOwnerId(ownerId);
		}

		Date deletedDate = (Date)attributes.get("deletedDate");

		if (deletedDate != null) {
			setDeletedDate(deletedDate);
		}
	}

	@Override
	public long getDeletedMessageId() {
		return _deletedMessageId;
	}

	@Override
	public void setDeletedMessageId(long deletedMessageId) {
		_deletedMessageId = deletedMessageId;

		if (_pmDeletedMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmDeletedMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setDeletedMessageId",
						long.class);

				method.invoke(_pmDeletedMessageRemoteModel, deletedMessageId);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public long getMessageId() {
		return _messageId;
	}

	@Override
	public void setMessageId(long messageId) {
		_messageId = messageId;

		if (_pmDeletedMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmDeletedMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setMessageId", long.class);

				method.invoke(_pmDeletedMessageRemoteModel, messageId);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public long getOwnerId() {
		return _ownerId;
	}

	@Override
	public void setOwnerId(long ownerId) {
		_ownerId = ownerId;

		if (_pmDeletedMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmDeletedMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setOwnerId", long.class);

				method.invoke(_pmDeletedMessageRemoteModel, ownerId);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	@Override
	public Date getDeletedDate() {
		return _deletedDate;
	}

	@Override
	public void setDeletedDate(Date deletedDate) {
		_deletedDate = deletedDate;

		if (_pmDeletedMessageRemoteModel != null) {
			try {
				Class<?> clazz = _pmDeletedMessageRemoteModel.getClass();

				Method method = clazz.getMethod("setDeletedDate", Date.class);

				method.invoke(_pmDeletedMessageRemoteModel, deletedDate);
			}
			catch (Exception e) {
				throw new UnsupportedOperationException(e);
			}
		}
	}

	public BaseModel<?> getPMDeletedMessageRemoteModel() {
		return _pmDeletedMessageRemoteModel;
	}

	public void setPMDeletedMessageRemoteModel(
		BaseModel<?> pmDeletedMessageRemoteModel) {
		_pmDeletedMessageRemoteModel = pmDeletedMessageRemoteModel;
	}

	public Object invokeOnRemoteModel(String methodName,
		Class<?>[] parameterTypes, Object[] parameterValues)
		throws Exception {
		Object[] remoteParameterValues = new Object[parameterValues.length];

		for (int i = 0; i < parameterValues.length; i++) {
			if (parameterValues[i] != null) {
				remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
			}
		}

		Class<?> remoteModelClass = _pmDeletedMessageRemoteModel.getClass();

		ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

		Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

		for (int i = 0; i < parameterTypes.length; i++) {
			if (parameterTypes[i].isPrimitive()) {
				remoteParameterTypes[i] = parameterTypes[i];
			}
			else {
				String parameterTypeName = parameterTypes[i].getName();

				remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
			}
		}

		Method method = remoteModelClass.getMethod(methodName,
				remoteParameterTypes);

		Object returnValue = method.invoke(_pmDeletedMessageRemoteModel,
				remoteParameterValues);

		if (returnValue != null) {
			returnValue = ClpSerializer.translateOutput(returnValue);
		}

		return returnValue;
	}

	@Override
	public void persist() throws SystemException {
		if (this.isNew()) {
			PMDeletedMessageLocalServiceUtil.addPMDeletedMessage(this);
		}
		else {
			PMDeletedMessageLocalServiceUtil.updatePMDeletedMessage(this);
		}
	}

	@Override
	public PMDeletedMessage toEscapedModel() {
		return (PMDeletedMessage)ProxyUtil.newProxyInstance(PMDeletedMessage.class.getClassLoader(),
			new Class[] { PMDeletedMessage.class },
			new AutoEscapeBeanHandler(this));
	}

	@Override
	public Object clone() {
		PMDeletedMessageClp clone = new PMDeletedMessageClp();

		clone.setDeletedMessageId(getDeletedMessageId());
		clone.setMessageId(getMessageId());
		clone.setOwnerId(getOwnerId());
		clone.setDeletedDate(getDeletedDate());

		return clone;
	}

	@Override
	public int compareTo(PMDeletedMessage pmDeletedMessage) {
		int value = 0;

		value = DateUtil.compareTo(getDeletedDate(),
				pmDeletedMessage.getDeletedDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof PMDeletedMessageClp)) {
			return false;
		}

		PMDeletedMessageClp pmDeletedMessage = (PMDeletedMessageClp)obj;

		long primaryKey = pmDeletedMessage.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	public Class<?> getClpSerializerClass() {
		return _clpSerializerClass;
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(9);

		sb.append("{deletedMessageId=");
		sb.append(getDeletedMessageId());
		sb.append(", messageId=");
		sb.append(getMessageId());
		sb.append(", ownerId=");
		sb.append(getOwnerId());
		sb.append(", deletedDate=");
		sb.append(getDeletedDate());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(16);

		sb.append("<model><model-name>");
		sb.append("gov.va.caret.model.PMDeletedMessage");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>deletedMessageId</column-name><column-value><![CDATA[");
		sb.append(getDeletedMessageId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>messageId</column-name><column-value><![CDATA[");
		sb.append(getMessageId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ownerId</column-name><column-value><![CDATA[");
		sb.append(getOwnerId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>deletedDate</column-name><column-value><![CDATA[");
		sb.append(getDeletedDate());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private long _deletedMessageId;
	private long _messageId;
	private long _ownerId;
	private Date _deletedDate;
	private BaseModel<?> _pmDeletedMessageRemoteModel;
	private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;
}