package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.sql.Blob;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link Docum}.
 * </p>
 *
 * @author caret
 * @see Docum
 * @generated
 */
public class DocumWrapper implements Docum, ModelWrapper<Docum> {
    private Docum _docum;

    public DocumWrapper(Docum docum) {
        _docum = docum;
    }

    @Override
    public Class<?> getModelClass() {
        return Docum.class;
    }

    @Override
    public String getModelClassName() {
        return Docum.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("documId", getDocumId());
        attributes.put("document", getDocument());
        attributes.put("classId", getClassId());
        attributes.put("classPk", getClassPk());
        attributes.put("name", getName());
        attributes.put("type", getType());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long documId = (Long) attributes.get("documId");

        if (documId != null) {
            setDocumId(documId);
        }

        Blob document = (Blob) attributes.get("document");

        if (document != null) {
            setDocument(document);
        }

        Long classId = (Long) attributes.get("classId");

        if (classId != null) {
            setClassId(classId);
        }

        Long classPk = (Long) attributes.get("classPk");

        if (classPk != null) {
            setClassPk(classPk);
        }

        String name = (String) attributes.get("name");

        if (name != null) {
            setName(name);
        }

        String type = (String) attributes.get("type");

        if (type != null) {
            setType(type);
        }
    }

    /**
    * Returns the primary key of this docum.
    *
    * @return the primary key of this docum
    */
    @Override
    public long getPrimaryKey() {
        return _docum.getPrimaryKey();
    }

    /**
    * Sets the primary key of this docum.
    *
    * @param primaryKey the primary key of this docum
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _docum.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the docum ID of this docum.
    *
    * @return the docum ID of this docum
    */
    @Override
    public long getDocumId() {
        return _docum.getDocumId();
    }

    /**
    * Sets the docum ID of this docum.
    *
    * @param documId the docum ID of this docum
    */
    @Override
    public void setDocumId(long documId) {
        _docum.setDocumId(documId);
    }

    /**
    * Returns the document of this docum.
    *
    * @return the document of this docum
    */
    @Override
    public java.sql.Blob getDocument() {
        return _docum.getDocument();
    }

    /**
    * Sets the document of this docum.
    *
    * @param document the document of this docum
    */
    @Override
    public void setDocument(java.sql.Blob document) {
        _docum.setDocument(document);
    }

    /**
    * Returns the class ID of this docum.
    *
    * @return the class ID of this docum
    */
    @Override
    public long getClassId() {
        return _docum.getClassId();
    }

    /**
    * Sets the class ID of this docum.
    *
    * @param classId the class ID of this docum
    */
    @Override
    public void setClassId(long classId) {
        _docum.setClassId(classId);
    }

    /**
    * Returns the class pk of this docum.
    *
    * @return the class pk of this docum
    */
    @Override
    public long getClassPk() {
        return _docum.getClassPk();
    }

    /**
    * Sets the class pk of this docum.
    *
    * @param classPk the class pk of this docum
    */
    @Override
    public void setClassPk(long classPk) {
        _docum.setClassPk(classPk);
    }

    /**
    * Returns the name of this docum.
    *
    * @return the name of this docum
    */
    @Override
    public java.lang.String getName() {
        return _docum.getName();
    }

    /**
    * Sets the name of this docum.
    *
    * @param name the name of this docum
    */
    @Override
    public void setName(java.lang.String name) {
        _docum.setName(name);
    }

    /**
    * Returns the type of this docum.
    *
    * @return the type of this docum
    */
    @Override
    public java.lang.String getType() {
        return _docum.getType();
    }

    /**
    * Sets the type of this docum.
    *
    * @param type the type of this docum
    */
    @Override
    public void setType(java.lang.String type) {
        _docum.setType(type);
    }

    @Override
    public boolean isNew() {
        return _docum.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _docum.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _docum.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _docum.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _docum.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _docum.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _docum.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _docum.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _docum.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _docum.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _docum.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new DocumWrapper((Docum) _docum.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.Docum docum) {
        return _docum.compareTo(docum);
    }

    @Override
    public int hashCode() {
        return _docum.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.Docum> toCacheModel() {
        return _docum.toCacheModel();
    }

    @Override
    public gov.va.caret.model.Docum toEscapedModel() {
        return new DocumWrapper(_docum.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.Docum toUnescapedModel() {
        return new DocumWrapper(_docum.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _docum.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _docum.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _docum.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof DocumWrapper)) {
            return false;
        }

        DocumWrapper documWrapper = (DocumWrapper) obj;

        if (Validator.equals(_docum, documWrapper._docum)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public Docum getWrappedDocum() {
        return _docum;
    }

    @Override
    public Docum getWrappedModel() {
        return _docum;
    }

    @Override
    public void resetOriginalValues() {
        _docum.resetOriginalValues();
    }
}
