package gov.va.caret.model;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.impl.BaseModelImpl;

import gov.va.caret.service.ClSocLocalServiceUtil;
import gov.va.caret.service.ClpSerializer;

import java.io.Serializable;

import java.lang.reflect.Method;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


public class ClSocClp extends BaseModelImpl<ClSoc> implements ClSoc {
    private long _clSocId;
    private long _callId;
    private long _persnId;
    private String _surveyStatus;
    private String _surveyComment;
    private Date _creationDate;
    private String _attemptNum;
    private String _callerAvailable;
    private String _requestedCallbackTime;
    private String _willingToAnsQues;
    private String _calledCsl;
    private String _cslKnowledgable;
    private String _cslSupportive;
    private String _localResSuggested;
    private String _localResContacted;
    private String _rsnLocalResNotContacted;
    private String _localResHelpful;
    private String _concernsAnswered;
    private String _understandNextSteps;
    private String _callCslAgain;
    private String _recommendCsl;
    private String _suggestions;
    private String _followupCall;
    private String _followupCallTime;
    private String _tresholdMet;
    private BaseModel<?> _clSocRemoteModel;
    private Class<?> _clpSerializerClass = gov.va.caret.service.ClpSerializer.class;

    public ClSocClp() {
    }

    @Override
    public Class<?> getModelClass() {
        return ClSoc.class;
    }

    @Override
    public String getModelClassName() {
        return ClSoc.class.getName();
    }

    @Override
    public long getPrimaryKey() {
        return _clSocId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setClSocId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _clSocId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("clSocId", getClSocId());
        attributes.put("callId", getCallId());
        attributes.put("persnId", getPersnId());
        attributes.put("surveyStatus", getSurveyStatus());
        attributes.put("surveyComment", getSurveyComment());
        attributes.put("creationDate", getCreationDate());
        attributes.put("attemptNum", getAttemptNum());
        attributes.put("callerAvailable", getCallerAvailable());
        attributes.put("requestedCallbackTime", getRequestedCallbackTime());
        attributes.put("willingToAnsQues", getWillingToAnsQues());
        attributes.put("calledCsl", getCalledCsl());
        attributes.put("cslKnowledgable", getCslKnowledgable());
        attributes.put("cslSupportive", getCslSupportive());
        attributes.put("localResSuggested", getLocalResSuggested());
        attributes.put("localResContacted", getLocalResContacted());
        attributes.put("rsnLocalResNotContacted", getRsnLocalResNotContacted());
        attributes.put("localResHelpful", getLocalResHelpful());
        attributes.put("concernsAnswered", getConcernsAnswered());
        attributes.put("understandNextSteps", getUnderstandNextSteps());
        attributes.put("callCslAgain", getCallCslAgain());
        attributes.put("recommendCsl", getRecommendCsl());
        attributes.put("suggestions", getSuggestions());
        attributes.put("followupCall", getFollowupCall());
        attributes.put("followupCallTime", getFollowupCallTime());
        attributes.put("tresholdMet", getTresholdMet());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long clSocId = (Long) attributes.get("clSocId");

        if (clSocId != null) {
            setClSocId(clSocId);
        }

        Long callId = (Long) attributes.get("callId");

        if (callId != null) {
            setCallId(callId);
        }

        Long persnId = (Long) attributes.get("persnId");

        if (persnId != null) {
            setPersnId(persnId);
        }

        String surveyStatus = (String) attributes.get("surveyStatus");

        if (surveyStatus != null) {
            setSurveyStatus(surveyStatus);
        }

        String surveyComment = (String) attributes.get("surveyComment");

        if (surveyComment != null) {
            setSurveyComment(surveyComment);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        String attemptNum = (String) attributes.get("attemptNum");

        if (attemptNum != null) {
            setAttemptNum(attemptNum);
        }

        String callerAvailable = (String) attributes.get("callerAvailable");

        if (callerAvailable != null) {
            setCallerAvailable(callerAvailable);
        }

        String requestedCallbackTime = (String) attributes.get(
                "requestedCallbackTime");

        if (requestedCallbackTime != null) {
            setRequestedCallbackTime(requestedCallbackTime);
        }

        String willingToAnsQues = (String) attributes.get("willingToAnsQues");

        if (willingToAnsQues != null) {
            setWillingToAnsQues(willingToAnsQues);
        }

        String calledCsl = (String) attributes.get("calledCsl");

        if (calledCsl != null) {
            setCalledCsl(calledCsl);
        }

        String cslKnowledgable = (String) attributes.get("cslKnowledgable");

        if (cslKnowledgable != null) {
            setCslKnowledgable(cslKnowledgable);
        }

        String cslSupportive = (String) attributes.get("cslSupportive");

        if (cslSupportive != null) {
            setCslSupportive(cslSupportive);
        }

        String localResSuggested = (String) attributes.get("localResSuggested");

        if (localResSuggested != null) {
            setLocalResSuggested(localResSuggested);
        }

        String localResContacted = (String) attributes.get("localResContacted");

        if (localResContacted != null) {
            setLocalResContacted(localResContacted);
        }

        String rsnLocalResNotContacted = (String) attributes.get(
                "rsnLocalResNotContacted");

        if (rsnLocalResNotContacted != null) {
            setRsnLocalResNotContacted(rsnLocalResNotContacted);
        }

        String localResHelpful = (String) attributes.get("localResHelpful");

        if (localResHelpful != null) {
            setLocalResHelpful(localResHelpful);
        }

        String concernsAnswered = (String) attributes.get("concernsAnswered");

        if (concernsAnswered != null) {
            setConcernsAnswered(concernsAnswered);
        }

        String understandNextSteps = (String) attributes.get(
                "understandNextSteps");

        if (understandNextSteps != null) {
            setUnderstandNextSteps(understandNextSteps);
        }

        String callCslAgain = (String) attributes.get("callCslAgain");

        if (callCslAgain != null) {
            setCallCslAgain(callCslAgain);
        }

        String recommendCsl = (String) attributes.get("recommendCsl");

        if (recommendCsl != null) {
            setRecommendCsl(recommendCsl);
        }

        String suggestions = (String) attributes.get("suggestions");

        if (suggestions != null) {
            setSuggestions(suggestions);
        }

        String followupCall = (String) attributes.get("followupCall");

        if (followupCall != null) {
            setFollowupCall(followupCall);
        }

        String followupCallTime = (String) attributes.get("followupCallTime");

        if (followupCallTime != null) {
            setFollowupCallTime(followupCallTime);
        }

        String tresholdMet = (String) attributes.get("tresholdMet");

        if (tresholdMet != null) {
            setTresholdMet(tresholdMet);
        }
    }

    @Override
    public long getClSocId() {
        return _clSocId;
    }

    @Override
    public void setClSocId(long clSocId) {
        _clSocId = clSocId;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setClSocId", long.class);

                method.invoke(_clSocRemoteModel, clSocId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getCallId() {
        return _callId;
    }

    @Override
    public void setCallId(long callId) {
        _callId = callId;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setCallId", long.class);

                method.invoke(_clSocRemoteModel, callId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public long getPersnId() {
        return _persnId;
    }

    @Override
    public void setPersnId(long persnId) {
        _persnId = persnId;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setPersnId", long.class);

                method.invoke(_clSocRemoteModel, persnId);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getSurveyStatus() {
        return _surveyStatus;
    }

    @Override
    public void setSurveyStatus(String surveyStatus) {
        _surveyStatus = surveyStatus;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setSurveyStatus", String.class);

                method.invoke(_clSocRemoteModel, surveyStatus);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getSurveyComment() {
        return _surveyComment;
    }

    @Override
    public void setSurveyComment(String surveyComment) {
        _surveyComment = surveyComment;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setSurveyComment", String.class);

                method.invoke(_clSocRemoteModel, surveyComment);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setCreationDate", Date.class);

                method.invoke(_clSocRemoteModel, creationDate);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getAttemptNum() {
        return _attemptNum;
    }

    @Override
    public void setAttemptNum(String attemptNum) {
        _attemptNum = attemptNum;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setAttemptNum", String.class);

                method.invoke(_clSocRemoteModel, attemptNum);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCallerAvailable() {
        return _callerAvailable;
    }

    @Override
    public void setCallerAvailable(String callerAvailable) {
        _callerAvailable = callerAvailable;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setCallerAvailable",
                        String.class);

                method.invoke(_clSocRemoteModel, callerAvailable);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getRequestedCallbackTime() {
        return _requestedCallbackTime;
    }

    @Override
    public void setRequestedCallbackTime(String requestedCallbackTime) {
        _requestedCallbackTime = requestedCallbackTime;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setRequestedCallbackTime",
                        String.class);

                method.invoke(_clSocRemoteModel, requestedCallbackTime);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getWillingToAnsQues() {
        return _willingToAnsQues;
    }

    @Override
    public void setWillingToAnsQues(String willingToAnsQues) {
        _willingToAnsQues = willingToAnsQues;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setWillingToAnsQues",
                        String.class);

                method.invoke(_clSocRemoteModel, willingToAnsQues);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCalledCsl() {
        return _calledCsl;
    }

    @Override
    public void setCalledCsl(String calledCsl) {
        _calledCsl = calledCsl;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setCalledCsl", String.class);

                method.invoke(_clSocRemoteModel, calledCsl);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCslKnowledgable() {
        return _cslKnowledgable;
    }

    @Override
    public void setCslKnowledgable(String cslKnowledgable) {
        _cslKnowledgable = cslKnowledgable;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setCslKnowledgable",
                        String.class);

                method.invoke(_clSocRemoteModel, cslKnowledgable);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCslSupportive() {
        return _cslSupportive;
    }

    @Override
    public void setCslSupportive(String cslSupportive) {
        _cslSupportive = cslSupportive;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setCslSupportive", String.class);

                method.invoke(_clSocRemoteModel, cslSupportive);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getLocalResSuggested() {
        return _localResSuggested;
    }

    @Override
    public void setLocalResSuggested(String localResSuggested) {
        _localResSuggested = localResSuggested;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setLocalResSuggested",
                        String.class);

                method.invoke(_clSocRemoteModel, localResSuggested);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getLocalResContacted() {
        return _localResContacted;
    }

    @Override
    public void setLocalResContacted(String localResContacted) {
        _localResContacted = localResContacted;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setLocalResContacted",
                        String.class);

                method.invoke(_clSocRemoteModel, localResContacted);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getRsnLocalResNotContacted() {
        return _rsnLocalResNotContacted;
    }

    @Override
    public void setRsnLocalResNotContacted(String rsnLocalResNotContacted) {
        _rsnLocalResNotContacted = rsnLocalResNotContacted;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setRsnLocalResNotContacted",
                        String.class);

                method.invoke(_clSocRemoteModel, rsnLocalResNotContacted);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getLocalResHelpful() {
        return _localResHelpful;
    }

    @Override
    public void setLocalResHelpful(String localResHelpful) {
        _localResHelpful = localResHelpful;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setLocalResHelpful",
                        String.class);

                method.invoke(_clSocRemoteModel, localResHelpful);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getConcernsAnswered() {
        return _concernsAnswered;
    }

    @Override
    public void setConcernsAnswered(String concernsAnswered) {
        _concernsAnswered = concernsAnswered;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setConcernsAnswered",
                        String.class);

                method.invoke(_clSocRemoteModel, concernsAnswered);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getUnderstandNextSteps() {
        return _understandNextSteps;
    }

    @Override
    public void setUnderstandNextSteps(String understandNextSteps) {
        _understandNextSteps = understandNextSteps;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setUnderstandNextSteps",
                        String.class);

                method.invoke(_clSocRemoteModel, understandNextSteps);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getCallCslAgain() {
        return _callCslAgain;
    }

    @Override
    public void setCallCslAgain(String callCslAgain) {
        _callCslAgain = callCslAgain;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setCallCslAgain", String.class);

                method.invoke(_clSocRemoteModel, callCslAgain);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getRecommendCsl() {
        return _recommendCsl;
    }

    @Override
    public void setRecommendCsl(String recommendCsl) {
        _recommendCsl = recommendCsl;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setRecommendCsl", String.class);

                method.invoke(_clSocRemoteModel, recommendCsl);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getSuggestions() {
        return _suggestions;
    }

    @Override
    public void setSuggestions(String suggestions) {
        _suggestions = suggestions;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setSuggestions", String.class);

                method.invoke(_clSocRemoteModel, suggestions);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getFollowupCall() {
        return _followupCall;
    }

    @Override
    public void setFollowupCall(String followupCall) {
        _followupCall = followupCall;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setFollowupCall", String.class);

                method.invoke(_clSocRemoteModel, followupCall);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getFollowupCallTime() {
        return _followupCallTime;
    }

    @Override
    public void setFollowupCallTime(String followupCallTime) {
        _followupCallTime = followupCallTime;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setFollowupCallTime",
                        String.class);

                method.invoke(_clSocRemoteModel, followupCallTime);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public String getTresholdMet() {
        return _tresholdMet;
    }

    @Override
    public void setTresholdMet(String tresholdMet) {
        _tresholdMet = tresholdMet;

        if (_clSocRemoteModel != null) {
            try {
                Class<?> clazz = _clSocRemoteModel.getClass();

                Method method = clazz.getMethod("setTresholdMet", String.class);

                method.invoke(_clSocRemoteModel, tresholdMet);
            } catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    public BaseModel<?> getClSocRemoteModel() {
        return _clSocRemoteModel;
    }

    public void setClSocRemoteModel(BaseModel<?> clSocRemoteModel) {
        _clSocRemoteModel = clSocRemoteModel;
    }

    public Object invokeOnRemoteModel(String methodName,
        Class<?>[] parameterTypes, Object[] parameterValues)
        throws Exception {
        Object[] remoteParameterValues = new Object[parameterValues.length];

        for (int i = 0; i < parameterValues.length; i++) {
            if (parameterValues[i] != null) {
                remoteParameterValues[i] = ClpSerializer.translateInput(parameterValues[i]);
            }
        }

        Class<?> remoteModelClass = _clSocRemoteModel.getClass();

        ClassLoader remoteModelClassLoader = remoteModelClass.getClassLoader();

        Class<?>[] remoteParameterTypes = new Class[parameterTypes.length];

        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].isPrimitive()) {
                remoteParameterTypes[i] = parameterTypes[i];
            } else {
                String parameterTypeName = parameterTypes[i].getName();

                remoteParameterTypes[i] = remoteModelClassLoader.loadClass(parameterTypeName);
            }
        }

        Method method = remoteModelClass.getMethod(methodName,
                remoteParameterTypes);

        Object returnValue = method.invoke(_clSocRemoteModel,
                remoteParameterValues);

        if (returnValue != null) {
            returnValue = ClpSerializer.translateOutput(returnValue);
        }

        return returnValue;
    }

    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            ClSocLocalServiceUtil.addClSoc(this);
        } else {
            ClSocLocalServiceUtil.updateClSoc(this);
        }
    }

    @Override
    public ClSoc toEscapedModel() {
        return (ClSoc) ProxyUtil.newProxyInstance(ClSoc.class.getClassLoader(),
            new Class[] { ClSoc.class }, new AutoEscapeBeanHandler(this));
    }

    @Override
    public Object clone() {
        ClSocClp clone = new ClSocClp();

        clone.setClSocId(getClSocId());
        clone.setCallId(getCallId());
        clone.setPersnId(getPersnId());
        clone.setSurveyStatus(getSurveyStatus());
        clone.setSurveyComment(getSurveyComment());
        clone.setCreationDate(getCreationDate());
        clone.setAttemptNum(getAttemptNum());
        clone.setCallerAvailable(getCallerAvailable());
        clone.setRequestedCallbackTime(getRequestedCallbackTime());
        clone.setWillingToAnsQues(getWillingToAnsQues());
        clone.setCalledCsl(getCalledCsl());
        clone.setCslKnowledgable(getCslKnowledgable());
        clone.setCslSupportive(getCslSupportive());
        clone.setLocalResSuggested(getLocalResSuggested());
        clone.setLocalResContacted(getLocalResContacted());
        clone.setRsnLocalResNotContacted(getRsnLocalResNotContacted());
        clone.setLocalResHelpful(getLocalResHelpful());
        clone.setConcernsAnswered(getConcernsAnswered());
        clone.setUnderstandNextSteps(getUnderstandNextSteps());
        clone.setCallCslAgain(getCallCslAgain());
        clone.setRecommendCsl(getRecommendCsl());
        clone.setSuggestions(getSuggestions());
        clone.setFollowupCall(getFollowupCall());
        clone.setFollowupCallTime(getFollowupCallTime());
        clone.setTresholdMet(getTresholdMet());

        return clone;
    }

    @Override
    public int compareTo(ClSoc clSoc) {
        long primaryKey = clSoc.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof ClSocClp)) {
            return false;
        }

        ClSocClp clSoc = (ClSocClp) obj;

        long primaryKey = clSoc.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    public Class<?> getClpSerializerClass() {
        return _clpSerializerClass;
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(51);

        sb.append("{clSocId=");
        sb.append(getClSocId());
        sb.append(", callId=");
        sb.append(getCallId());
        sb.append(", persnId=");
        sb.append(getPersnId());
        sb.append(", surveyStatus=");
        sb.append(getSurveyStatus());
        sb.append(", surveyComment=");
        sb.append(getSurveyComment());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", attemptNum=");
        sb.append(getAttemptNum());
        sb.append(", callerAvailable=");
        sb.append(getCallerAvailable());
        sb.append(", requestedCallbackTime=");
        sb.append(getRequestedCallbackTime());
        sb.append(", willingToAnsQues=");
        sb.append(getWillingToAnsQues());
        sb.append(", calledCsl=");
        sb.append(getCalledCsl());
        sb.append(", cslKnowledgable=");
        sb.append(getCslKnowledgable());
        sb.append(", cslSupportive=");
        sb.append(getCslSupportive());
        sb.append(", localResSuggested=");
        sb.append(getLocalResSuggested());
        sb.append(", localResContacted=");
        sb.append(getLocalResContacted());
        sb.append(", rsnLocalResNotContacted=");
        sb.append(getRsnLocalResNotContacted());
        sb.append(", localResHelpful=");
        sb.append(getLocalResHelpful());
        sb.append(", concernsAnswered=");
        sb.append(getConcernsAnswered());
        sb.append(", understandNextSteps=");
        sb.append(getUnderstandNextSteps());
        sb.append(", callCslAgain=");
        sb.append(getCallCslAgain());
        sb.append(", recommendCsl=");
        sb.append(getRecommendCsl());
        sb.append(", suggestions=");
        sb.append(getSuggestions());
        sb.append(", followupCall=");
        sb.append(getFollowupCall());
        sb.append(", followupCallTime=");
        sb.append(getFollowupCallTime());
        sb.append(", tresholdMet=");
        sb.append(getTresholdMet());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(79);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.ClSoc");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>clSocId</column-name><column-value><![CDATA[");
        sb.append(getClSocId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callId</column-name><column-value><![CDATA[");
        sb.append(getCallId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>persnId</column-name><column-value><![CDATA[");
        sb.append(getPersnId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>surveyStatus</column-name><column-value><![CDATA[");
        sb.append(getSurveyStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>surveyComment</column-name><column-value><![CDATA[");
        sb.append(getSurveyComment());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>attemptNum</column-name><column-value><![CDATA[");
        sb.append(getAttemptNum());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callerAvailable</column-name><column-value><![CDATA[");
        sb.append(getCallerAvailable());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>requestedCallbackTime</column-name><column-value><![CDATA[");
        sb.append(getRequestedCallbackTime());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>willingToAnsQues</column-name><column-value><![CDATA[");
        sb.append(getWillingToAnsQues());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>calledCsl</column-name><column-value><![CDATA[");
        sb.append(getCalledCsl());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cslKnowledgable</column-name><column-value><![CDATA[");
        sb.append(getCslKnowledgable());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>cslSupportive</column-name><column-value><![CDATA[");
        sb.append(getCslSupportive());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>localResSuggested</column-name><column-value><![CDATA[");
        sb.append(getLocalResSuggested());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>localResContacted</column-name><column-value><![CDATA[");
        sb.append(getLocalResContacted());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>rsnLocalResNotContacted</column-name><column-value><![CDATA[");
        sb.append(getRsnLocalResNotContacted());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>localResHelpful</column-name><column-value><![CDATA[");
        sb.append(getLocalResHelpful());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>concernsAnswered</column-name><column-value><![CDATA[");
        sb.append(getConcernsAnswered());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>understandNextSteps</column-name><column-value><![CDATA[");
        sb.append(getUnderstandNextSteps());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>callCslAgain</column-name><column-value><![CDATA[");
        sb.append(getCallCslAgain());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>recommendCsl</column-name><column-value><![CDATA[");
        sb.append(getRecommendCsl());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>suggestions</column-name><column-value><![CDATA[");
        sb.append(getSuggestions());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>followupCall</column-name><column-value><![CDATA[");
        sb.append(getFollowupCall());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>followupCallTime</column-name><column-value><![CDATA[");
        sb.append(getFollowupCallTime());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>tresholdMet</column-name><column-value><![CDATA[");
        sb.append(getTresholdMet());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
