package gov.va.caret.model;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelWrapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link Call}.
 * </p>
 *
 * @author caret
 * @see Call
 * @generated
 */
public class CallWrapper implements Call, ModelWrapper<Call> {
    private Call _call;

    public CallWrapper(Call call) {
        _call = call;
    }

    @Override
    public Class<?> getModelClass() {
        return Call.class;
    }

    @Override
    public String getModelClassName() {
        return Call.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("callId", getCallId());
        attributes.put("callType", getCallType());
        attributes.put("callerRelationship", getCallerRelationship());
        attributes.put("workPrimaryKey", getWorkPrimaryKey());
        attributes.put("callState", getCallState());
        attributes.put("callerPersnId", getCallerPersnId());
        attributes.put("callerTitle", getCallerTitle());
        attributes.put("callerLearnAbout", getCallerLearnAbout());
        attributes.put("veteranPersnId", getVeteranPersnId());
        attributes.put("message", getMessage());
        attributes.put("summary", getSummary());
        attributes.put("transferRemarks", getTransferRemarks());
        attributes.put("cespGoal", getCespGoal());
        attributes.put("cespOutcome", getCespOutcome());
        attributes.put("transferredTo", getTransferredTo());
        attributes.put("otherBenefits", getOtherBenefits());
        attributes.put("contactInfo", getContactInfo());
        attributes.put("eraService", getEraService());
        attributes.put("serviceBranch", getServiceBranch());
        attributes.put("serviceStatus", getServiceStatus());
        attributes.put("contactInfoProvided", getContactInfoProvided());
        attributes.put("referralAgreeable", getReferralAgreeable());
        attributes.put("withoutContact", getWithoutContact());
        attributes.put("hangUp", getHangUp());
        attributes.put("wrongNumber", getWrongNumber());
        attributes.put("sameAddress", getSameAddress());
        attributes.put("verified", getVerified());
        attributes.put("anonymous", getAnonymous());
        attributes.put("createGroupId", getCreateGroupId());
        attributes.put("userId", getUserId());
        attributes.put("creationDate", getCreationDate());
        attributes.put("callbackPref", getCallbackPref());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long callId = (Long) attributes.get("callId");

        if (callId != null) {
            setCallId(callId);
        }

        String callType = (String) attributes.get("callType");

        if (callType != null) {
            setCallType(callType);
        }

        String callerRelationship = (String) attributes.get(
                "callerRelationship");

        if (callerRelationship != null) {
            setCallerRelationship(callerRelationship);
        }

        Long workPrimaryKey = (Long) attributes.get("workPrimaryKey");

        if (workPrimaryKey != null) {
            setWorkPrimaryKey(workPrimaryKey);
        }

        String callState = (String) attributes.get("callState");

        if (callState != null) {
            setCallState(callState);
        }

        Long callerPersnId = (Long) attributes.get("callerPersnId");

        if (callerPersnId != null) {
            setCallerPersnId(callerPersnId);
        }

        String callerTitle = (String) attributes.get("callerTitle");

        if (callerTitle != null) {
            setCallerTitle(callerTitle);
        }

        String callerLearnAbout = (String) attributes.get("callerLearnAbout");

        if (callerLearnAbout != null) {
            setCallerLearnAbout(callerLearnAbout);
        }

        Long veteranPersnId = (Long) attributes.get("veteranPersnId");

        if (veteranPersnId != null) {
            setVeteranPersnId(veteranPersnId);
        }

        String message = (String) attributes.get("message");

        if (message != null) {
            setMessage(message);
        }

        String summary = (String) attributes.get("summary");

        if (summary != null) {
            setSummary(summary);
        }

        String transferRemarks = (String) attributes.get("transferRemarks");

        if (transferRemarks != null) {
            setTransferRemarks(transferRemarks);
        }

        String cespGoal = (String) attributes.get("cespGoal");

        if (cespGoal != null) {
            setCespGoal(cespGoal);
        }

        String cespOutcome = (String) attributes.get("cespOutcome");

        if (cespOutcome != null) {
            setCespOutcome(cespOutcome);
        }

        String transferredTo = (String) attributes.get("transferredTo");

        if (transferredTo != null) {
            setTransferredTo(transferredTo);
        }

        String otherBenefits = (String) attributes.get("otherBenefits");

        if (otherBenefits != null) {
            setOtherBenefits(otherBenefits);
        }

        String contactInfo = (String) attributes.get("contactInfo");

        if (contactInfo != null) {
            setContactInfo(contactInfo);
        }

        String eraService = (String) attributes.get("eraService");

        if (eraService != null) {
            setEraService(eraService);
        }

        String serviceBranch = (String) attributes.get("serviceBranch");

        if (serviceBranch != null) {
            setServiceBranch(serviceBranch);
        }

        String serviceStatus = (String) attributes.get("serviceStatus");

        if (serviceStatus != null) {
            setServiceStatus(serviceStatus);
        }

        Boolean contactInfoProvided = (Boolean) attributes.get(
                "contactInfoProvided");

        if (contactInfoProvided != null) {
            setContactInfoProvided(contactInfoProvided);
        }

        Boolean referralAgreeable = (Boolean) attributes.get(
                "referralAgreeable");

        if (referralAgreeable != null) {
            setReferralAgreeable(referralAgreeable);
        }

        Boolean withoutContact = (Boolean) attributes.get("withoutContact");

        if (withoutContact != null) {
            setWithoutContact(withoutContact);
        }

        Boolean hangUp = (Boolean) attributes.get("hangUp");

        if (hangUp != null) {
            setHangUp(hangUp);
        }

        Boolean wrongNumber = (Boolean) attributes.get("wrongNumber");

        if (wrongNumber != null) {
            setWrongNumber(wrongNumber);
        }

        Boolean sameAddress = (Boolean) attributes.get("sameAddress");

        if (sameAddress != null) {
            setSameAddress(sameAddress);
        }

        Boolean verified = (Boolean) attributes.get("verified");

        if (verified != null) {
            setVerified(verified);
        }

        Boolean anonymous = (Boolean) attributes.get("anonymous");

        if (anonymous != null) {
            setAnonymous(anonymous);
        }

        Long createGroupId = (Long) attributes.get("createGroupId");

        if (createGroupId != null) {
            setCreateGroupId(createGroupId);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        String callbackPref = (String) attributes.get("callbackPref");

        if (callbackPref != null) {
            setCallbackPref(callbackPref);
        }
    }

    /**
    * Returns the primary key of this call.
    *
    * @return the primary key of this call
    */
    @Override
    public long getPrimaryKey() {
        return _call.getPrimaryKey();
    }

    /**
    * Sets the primary key of this call.
    *
    * @param primaryKey the primary key of this call
    */
    @Override
    public void setPrimaryKey(long primaryKey) {
        _call.setPrimaryKey(primaryKey);
    }

    /**
    * Returns the call ID of this call.
    *
    * @return the call ID of this call
    */
    @Override
    public long getCallId() {
        return _call.getCallId();
    }

    /**
    * Sets the call ID of this call.
    *
    * @param callId the call ID of this call
    */
    @Override
    public void setCallId(long callId) {
        _call.setCallId(callId);
    }

    /**
    * Returns the call type of this call.
    *
    * @return the call type of this call
    */
    @Override
    public java.lang.String getCallType() {
        return _call.getCallType();
    }

    /**
    * Sets the call type of this call.
    *
    * @param callType the call type of this call
    */
    @Override
    public void setCallType(java.lang.String callType) {
        _call.setCallType(callType);
    }

    /**
    * Returns the caller relationship of this call.
    *
    * @return the caller relationship of this call
    */
    @Override
    public java.lang.String getCallerRelationship() {
        return _call.getCallerRelationship();
    }

    /**
    * Sets the caller relationship of this call.
    *
    * @param callerRelationship the caller relationship of this call
    */
    @Override
    public void setCallerRelationship(java.lang.String callerRelationship) {
        _call.setCallerRelationship(callerRelationship);
    }

    /**
    * Returns the work primary key of this call.
    *
    * @return the work primary key of this call
    */
    @Override
    public long getWorkPrimaryKey() {
        return _call.getWorkPrimaryKey();
    }

    /**
    * Sets the work primary key of this call.
    *
    * @param workPrimaryKey the work primary key of this call
    */
    @Override
    public void setWorkPrimaryKey(long workPrimaryKey) {
        _call.setWorkPrimaryKey(workPrimaryKey);
    }

    /**
    * Returns the call state of this call.
    *
    * @return the call state of this call
    */
    @Override
    public java.lang.String getCallState() {
        return _call.getCallState();
    }

    /**
    * Sets the call state of this call.
    *
    * @param callState the call state of this call
    */
    @Override
    public void setCallState(java.lang.String callState) {
        _call.setCallState(callState);
    }

    /**
    * Returns the caller persn ID of this call.
    *
    * @return the caller persn ID of this call
    */
    @Override
    public long getCallerPersnId() {
        return _call.getCallerPersnId();
    }

    /**
    * Sets the caller persn ID of this call.
    *
    * @param callerPersnId the caller persn ID of this call
    */
    @Override
    public void setCallerPersnId(long callerPersnId) {
        _call.setCallerPersnId(callerPersnId);
    }

    /**
    * Returns the caller title of this call.
    *
    * @return the caller title of this call
    */
    @Override
    public java.lang.String getCallerTitle() {
        return _call.getCallerTitle();
    }

    /**
    * Sets the caller title of this call.
    *
    * @param callerTitle the caller title of this call
    */
    @Override
    public void setCallerTitle(java.lang.String callerTitle) {
        _call.setCallerTitle(callerTitle);
    }

    /**
    * Returns the caller learn about of this call.
    *
    * @return the caller learn about of this call
    */
    @Override
    public java.lang.String getCallerLearnAbout() {
        return _call.getCallerLearnAbout();
    }

    /**
    * Sets the caller learn about of this call.
    *
    * @param callerLearnAbout the caller learn about of this call
    */
    @Override
    public void setCallerLearnAbout(java.lang.String callerLearnAbout) {
        _call.setCallerLearnAbout(callerLearnAbout);
    }

    /**
    * Returns the veteran persn ID of this call.
    *
    * @return the veteran persn ID of this call
    */
    @Override
    public long getVeteranPersnId() {
        return _call.getVeteranPersnId();
    }

    /**
    * Sets the veteran persn ID of this call.
    *
    * @param veteranPersnId the veteran persn ID of this call
    */
    @Override
    public void setVeteranPersnId(long veteranPersnId) {
        _call.setVeteranPersnId(veteranPersnId);
    }

    /**
    * Returns the message of this call.
    *
    * @return the message of this call
    */
    @Override
    public java.lang.String getMessage() {
        return _call.getMessage();
    }

    /**
    * Sets the message of this call.
    *
    * @param message the message of this call
    */
    @Override
    public void setMessage(java.lang.String message) {
        _call.setMessage(message);
    }

    /**
    * Returns the summary of this call.
    *
    * @return the summary of this call
    */
    @Override
    public java.lang.String getSummary() {
        return _call.getSummary();
    }

    /**
    * Sets the summary of this call.
    *
    * @param summary the summary of this call
    */
    @Override
    public void setSummary(java.lang.String summary) {
        _call.setSummary(summary);
    }

    /**
    * Returns the transfer remarks of this call.
    *
    * @return the transfer remarks of this call
    */
    @Override
    public java.lang.String getTransferRemarks() {
        return _call.getTransferRemarks();
    }

    /**
    * Sets the transfer remarks of this call.
    *
    * @param transferRemarks the transfer remarks of this call
    */
    @Override
    public void setTransferRemarks(java.lang.String transferRemarks) {
        _call.setTransferRemarks(transferRemarks);
    }

    /**
    * Returns the cesp goal of this call.
    *
    * @return the cesp goal of this call
    */
    @Override
    public java.lang.String getCespGoal() {
        return _call.getCespGoal();
    }

    /**
    * Sets the cesp goal of this call.
    *
    * @param cespGoal the cesp goal of this call
    */
    @Override
    public void setCespGoal(java.lang.String cespGoal) {
        _call.setCespGoal(cespGoal);
    }

    /**
    * Returns the cesp outcome of this call.
    *
    * @return the cesp outcome of this call
    */
    @Override
    public java.lang.String getCespOutcome() {
        return _call.getCespOutcome();
    }

    /**
    * Sets the cesp outcome of this call.
    *
    * @param cespOutcome the cesp outcome of this call
    */
    @Override
    public void setCespOutcome(java.lang.String cespOutcome) {
        _call.setCespOutcome(cespOutcome);
    }

    /**
    * Returns the transferred to of this call.
    *
    * @return the transferred to of this call
    */
    @Override
    public java.lang.String getTransferredTo() {
        return _call.getTransferredTo();
    }

    /**
    * Sets the transferred to of this call.
    *
    * @param transferredTo the transferred to of this call
    */
    @Override
    public void setTransferredTo(java.lang.String transferredTo) {
        _call.setTransferredTo(transferredTo);
    }

    /**
    * Returns the other benefits of this call.
    *
    * @return the other benefits of this call
    */
    @Override
    public java.lang.String getOtherBenefits() {
        return _call.getOtherBenefits();
    }

    /**
    * Sets the other benefits of this call.
    *
    * @param otherBenefits the other benefits of this call
    */
    @Override
    public void setOtherBenefits(java.lang.String otherBenefits) {
        _call.setOtherBenefits(otherBenefits);
    }

    /**
    * Returns the contact info of this call.
    *
    * @return the contact info of this call
    */
    @Override
    public java.lang.String getContactInfo() {
        return _call.getContactInfo();
    }

    /**
    * Sets the contact info of this call.
    *
    * @param contactInfo the contact info of this call
    */
    @Override
    public void setContactInfo(java.lang.String contactInfo) {
        _call.setContactInfo(contactInfo);
    }

    /**
    * Returns the era service of this call.
    *
    * @return the era service of this call
    */
    @Override
    public java.lang.String getEraService() {
        return _call.getEraService();
    }

    /**
    * Sets the era service of this call.
    *
    * @param eraService the era service of this call
    */
    @Override
    public void setEraService(java.lang.String eraService) {
        _call.setEraService(eraService);
    }

    /**
    * Returns the service branch of this call.
    *
    * @return the service branch of this call
    */
    @Override
    public java.lang.String getServiceBranch() {
        return _call.getServiceBranch();
    }

    /**
    * Sets the service branch of this call.
    *
    * @param serviceBranch the service branch of this call
    */
    @Override
    public void setServiceBranch(java.lang.String serviceBranch) {
        _call.setServiceBranch(serviceBranch);
    }

    /**
    * Returns the service status of this call.
    *
    * @return the service status of this call
    */
    @Override
    public java.lang.String getServiceStatus() {
        return _call.getServiceStatus();
    }

    /**
    * Sets the service status of this call.
    *
    * @param serviceStatus the service status of this call
    */
    @Override
    public void setServiceStatus(java.lang.String serviceStatus) {
        _call.setServiceStatus(serviceStatus);
    }

    /**
    * Returns the contact info provided of this call.
    *
    * @return the contact info provided of this call
    */
    @Override
    public boolean getContactInfoProvided() {
        return _call.getContactInfoProvided();
    }

    /**
    * Returns <code>true</code> if this call is contact info provided.
    *
    * @return <code>true</code> if this call is contact info provided; <code>false</code> otherwise
    */
    @Override
    public boolean isContactInfoProvided() {
        return _call.isContactInfoProvided();
    }

    /**
    * Sets whether this call is contact info provided.
    *
    * @param contactInfoProvided the contact info provided of this call
    */
    @Override
    public void setContactInfoProvided(boolean contactInfoProvided) {
        _call.setContactInfoProvided(contactInfoProvided);
    }

    /**
    * Returns the referral agreeable of this call.
    *
    * @return the referral agreeable of this call
    */
    @Override
    public boolean getReferralAgreeable() {
        return _call.getReferralAgreeable();
    }

    /**
    * Returns <code>true</code> if this call is referral agreeable.
    *
    * @return <code>true</code> if this call is referral agreeable; <code>false</code> otherwise
    */
    @Override
    public boolean isReferralAgreeable() {
        return _call.isReferralAgreeable();
    }

    /**
    * Sets whether this call is referral agreeable.
    *
    * @param referralAgreeable the referral agreeable of this call
    */
    @Override
    public void setReferralAgreeable(boolean referralAgreeable) {
        _call.setReferralAgreeable(referralAgreeable);
    }

    /**
    * Returns the without contact of this call.
    *
    * @return the without contact of this call
    */
    @Override
    public boolean getWithoutContact() {
        return _call.getWithoutContact();
    }

    /**
    * Returns <code>true</code> if this call is without contact.
    *
    * @return <code>true</code> if this call is without contact; <code>false</code> otherwise
    */
    @Override
    public boolean isWithoutContact() {
        return _call.isWithoutContact();
    }

    /**
    * Sets whether this call is without contact.
    *
    * @param withoutContact the without contact of this call
    */
    @Override
    public void setWithoutContact(boolean withoutContact) {
        _call.setWithoutContact(withoutContact);
    }

    /**
    * Returns the hang up of this call.
    *
    * @return the hang up of this call
    */
    @Override
    public boolean getHangUp() {
        return _call.getHangUp();
    }

    /**
    * Returns <code>true</code> if this call is hang up.
    *
    * @return <code>true</code> if this call is hang up; <code>false</code> otherwise
    */
    @Override
    public boolean isHangUp() {
        return _call.isHangUp();
    }

    /**
    * Sets whether this call is hang up.
    *
    * @param hangUp the hang up of this call
    */
    @Override
    public void setHangUp(boolean hangUp) {
        _call.setHangUp(hangUp);
    }

    /**
    * Returns the wrong number of this call.
    *
    * @return the wrong number of this call
    */
    @Override
    public boolean getWrongNumber() {
        return _call.getWrongNumber();
    }

    /**
    * Returns <code>true</code> if this call is wrong number.
    *
    * @return <code>true</code> if this call is wrong number; <code>false</code> otherwise
    */
    @Override
    public boolean isWrongNumber() {
        return _call.isWrongNumber();
    }

    /**
    * Sets whether this call is wrong number.
    *
    * @param wrongNumber the wrong number of this call
    */
    @Override
    public void setWrongNumber(boolean wrongNumber) {
        _call.setWrongNumber(wrongNumber);
    }

    /**
    * Returns the same address of this call.
    *
    * @return the same address of this call
    */
    @Override
    public boolean getSameAddress() {
        return _call.getSameAddress();
    }

    /**
    * Returns <code>true</code> if this call is same address.
    *
    * @return <code>true</code> if this call is same address; <code>false</code> otherwise
    */
    @Override
    public boolean isSameAddress() {
        return _call.isSameAddress();
    }

    /**
    * Sets whether this call is same address.
    *
    * @param sameAddress the same address of this call
    */
    @Override
    public void setSameAddress(boolean sameAddress) {
        _call.setSameAddress(sameAddress);
    }

    /**
    * Returns the verified of this call.
    *
    * @return the verified of this call
    */
    @Override
    public boolean getVerified() {
        return _call.getVerified();
    }

    /**
    * Returns <code>true</code> if this call is verified.
    *
    * @return <code>true</code> if this call is verified; <code>false</code> otherwise
    */
    @Override
    public boolean isVerified() {
        return _call.isVerified();
    }

    /**
    * Sets whether this call is verified.
    *
    * @param verified the verified of this call
    */
    @Override
    public void setVerified(boolean verified) {
        _call.setVerified(verified);
    }

    /**
    * Returns the anonymous of this call.
    *
    * @return the anonymous of this call
    */
    @Override
    public boolean getAnonymous() {
        return _call.getAnonymous();
    }

    /**
    * Returns <code>true</code> if this call is anonymous.
    *
    * @return <code>true</code> if this call is anonymous; <code>false</code> otherwise
    */
    @Override
    public boolean isAnonymous() {
        return _call.isAnonymous();
    }

    /**
    * Sets whether this call is anonymous.
    *
    * @param anonymous the anonymous of this call
    */
    @Override
    public void setAnonymous(boolean anonymous) {
        _call.setAnonymous(anonymous);
    }

    /**
    * Returns the create group ID of this call.
    *
    * @return the create group ID of this call
    */
    @Override
    public long getCreateGroupId() {
        return _call.getCreateGroupId();
    }

    /**
    * Sets the create group ID of this call.
    *
    * @param createGroupId the create group ID of this call
    */
    @Override
    public void setCreateGroupId(long createGroupId) {
        _call.setCreateGroupId(createGroupId);
    }

    /**
    * Returns the user ID of this call.
    *
    * @return the user ID of this call
    */
    @Override
    public long getUserId() {
        return _call.getUserId();
    }

    /**
    * Sets the user ID of this call.
    *
    * @param userId the user ID of this call
    */
    @Override
    public void setUserId(long userId) {
        _call.setUserId(userId);
    }

    /**
    * Returns the user uuid of this call.
    *
    * @return the user uuid of this call
    * @throws SystemException if a system exception occurred
    */
    @Override
    public java.lang.String getUserUuid()
        throws com.liferay.portal.kernel.exception.SystemException {
        return _call.getUserUuid();
    }

    /**
    * Sets the user uuid of this call.
    *
    * @param userUuid the user uuid of this call
    */
    @Override
    public void setUserUuid(java.lang.String userUuid) {
        _call.setUserUuid(userUuid);
    }

    /**
    * Returns the creation date of this call.
    *
    * @return the creation date of this call
    */
    @Override
    public java.util.Date getCreationDate() {
        return _call.getCreationDate();
    }

    /**
    * Sets the creation date of this call.
    *
    * @param creationDate the creation date of this call
    */
    @Override
    public void setCreationDate(java.util.Date creationDate) {
        _call.setCreationDate(creationDate);
    }

    /**
    * Returns the callback pref of this call.
    *
    * @return the callback pref of this call
    */
    @Override
    public java.lang.String getCallbackPref() {
        return _call.getCallbackPref();
    }

    /**
    * Sets the callback pref of this call.
    *
    * @param callbackPref the callback pref of this call
    */
    @Override
    public void setCallbackPref(java.lang.String callbackPref) {
        _call.setCallbackPref(callbackPref);
    }

    @Override
    public boolean isNew() {
        return _call.isNew();
    }

    @Override
    public void setNew(boolean n) {
        _call.setNew(n);
    }

    @Override
    public boolean isCachedModel() {
        return _call.isCachedModel();
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        _call.setCachedModel(cachedModel);
    }

    @Override
    public boolean isEscapedModel() {
        return _call.isEscapedModel();
    }

    @Override
    public java.io.Serializable getPrimaryKeyObj() {
        return _call.getPrimaryKeyObj();
    }

    @Override
    public void setPrimaryKeyObj(java.io.Serializable primaryKeyObj) {
        _call.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public com.liferay.portlet.expando.model.ExpandoBridge getExpandoBridge() {
        return _call.getExpandoBridge();
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.model.BaseModel<?> baseModel) {
        _call.setExpandoBridgeAttributes(baseModel);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portlet.expando.model.ExpandoBridge expandoBridge) {
        _call.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(
        com.liferay.portal.service.ServiceContext serviceContext) {
        _call.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public java.lang.Object clone() {
        return new CallWrapper((Call) _call.clone());
    }

    @Override
    public int compareTo(gov.va.caret.model.Call call) {
        return _call.compareTo(call);
    }

    @Override
    public int hashCode() {
        return _call.hashCode();
    }

    @Override
    public com.liferay.portal.model.CacheModel<gov.va.caret.model.Call> toCacheModel() {
        return _call.toCacheModel();
    }

    @Override
    public gov.va.caret.model.Call toEscapedModel() {
        return new CallWrapper(_call.toEscapedModel());
    }

    @Override
    public gov.va.caret.model.Call toUnescapedModel() {
        return new CallWrapper(_call.toUnescapedModel());
    }

    @Override
    public java.lang.String toString() {
        return _call.toString();
    }

    @Override
    public java.lang.String toXmlString() {
        return _call.toXmlString();
    }

    @Override
    public void persist()
        throws com.liferay.portal.kernel.exception.SystemException {
        _call.persist();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof CallWrapper)) {
            return false;
        }

        CallWrapper callWrapper = (CallWrapper) obj;

        if (Validator.equals(_call, callWrapper._call)) {
            return true;
        }

        return false;
    }

    /**
     * @deprecated As of 6.1.0, replaced by {@link #getWrappedModel}
     */
    public Call getWrappedCall() {
        return _call;
    }

    @Override
    public Call getWrappedModel() {
        return _call;
    }

    @Override
    public void resetOriginalValues() {
        _call.resetOriginalValues();
    }
}
