package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class BoxGpSoap implements Serializable {
    private long _boxGpId;
    private String _boxGroup;
    private String _boxSubGroup;
    private String _label;
    private int _viewSequence;

    public BoxGpSoap() {
    }

    public static BoxGpSoap toSoapModel(BoxGp model) {
        BoxGpSoap soapModel = new BoxGpSoap();

        soapModel.setBoxGpId(model.getBoxGpId());
        soapModel.setBoxGroup(model.getBoxGroup());
        soapModel.setBoxSubGroup(model.getBoxSubGroup());
        soapModel.setLabel(model.getLabel());
        soapModel.setViewSequence(model.getViewSequence());

        return soapModel;
    }

    public static BoxGpSoap[] toSoapModels(BoxGp[] models) {
        BoxGpSoap[] soapModels = new BoxGpSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static BoxGpSoap[][] toSoapModels(BoxGp[][] models) {
        BoxGpSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new BoxGpSoap[models.length][models[0].length];
        } else {
            soapModels = new BoxGpSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static BoxGpSoap[] toSoapModels(List<BoxGp> models) {
        List<BoxGpSoap> soapModels = new ArrayList<BoxGpSoap>(models.size());

        for (BoxGp model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new BoxGpSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _boxGpId;
    }

    public void setPrimaryKey(long pk) {
        setBoxGpId(pk);
    }

    public long getBoxGpId() {
        return _boxGpId;
    }

    public void setBoxGpId(long boxGpId) {
        _boxGpId = boxGpId;
    }

    public String getBoxGroup() {
        return _boxGroup;
    }

    public void setBoxGroup(String boxGroup) {
        _boxGroup = boxGroup;
    }

    public String getBoxSubGroup() {
        return _boxSubGroup;
    }

    public void setBoxSubGroup(String boxSubGroup) {
        _boxSubGroup = boxSubGroup;
    }

    public String getLabel() {
        return _label;
    }

    public void setLabel(String label) {
        _label = label;
    }

    public int getViewSequence() {
        return _viewSequence;
    }

    public void setViewSequence(int viewSequence) {
        _viewSequence = viewSequence;
    }
}
