package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class BlsAeSoap implements Serializable {
    private long _blsAeId;
    private String _areaName;
    private int _areaNumber;

    public BlsAeSoap() {
    }

    public static BlsAeSoap toSoapModel(BlsAe model) {
        BlsAeSoap soapModel = new BlsAeSoap();

        soapModel.setBlsAeId(model.getBlsAeId());
        soapModel.setAreaName(model.getAreaName());
        soapModel.setAreaNumber(model.getAreaNumber());

        return soapModel;
    }

    public static BlsAeSoap[] toSoapModels(BlsAe[] models) {
        BlsAeSoap[] soapModels = new BlsAeSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static BlsAeSoap[][] toSoapModels(BlsAe[][] models) {
        BlsAeSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new BlsAeSoap[models.length][models[0].length];
        } else {
            soapModels = new BlsAeSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static BlsAeSoap[] toSoapModels(List<BlsAe> models) {
        List<BlsAeSoap> soapModels = new ArrayList<BlsAeSoap>(models.size());

        for (BlsAe model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new BlsAeSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _blsAeId;
    }

    public void setPrimaryKey(long pk) {
        setBlsAeId(pk);
    }

    public long getBlsAeId() {
        return _blsAeId;
    }

    public void setBlsAeId(long blsAeId) {
        _blsAeId = blsAeId;
    }

    public String getAreaName() {
        return _areaName;
    }

    public void setAreaName(String areaName) {
        _areaName = areaName;
    }

    public int getAreaNumber() {
        return _areaNumber;
    }

    public void setAreaNumber(int areaNumber) {
        _areaNumber = areaNumber;
    }
}
