package gov.va.caret.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author caret
 * @generated
 */
public class BgNumSoap implements Serializable {
    private long _bgNumId;
    private long _ownerId;
    private long _boxGpId;
    private double _value;

    public BgNumSoap() {
    }

    public static BgNumSoap toSoapModel(BgNum model) {
        BgNumSoap soapModel = new BgNumSoap();

        soapModel.setBgNumId(model.getBgNumId());
        soapModel.setOwnerId(model.getOwnerId());
        soapModel.setBoxGpId(model.getBoxGpId());
        soapModel.setValue(model.getValue());

        return soapModel;
    }

    public static BgNumSoap[] toSoapModels(BgNum[] models) {
        BgNumSoap[] soapModels = new BgNumSoap[models.length];

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModel(models[i]);
        }

        return soapModels;
    }

    public static BgNumSoap[][] toSoapModels(BgNum[][] models) {
        BgNumSoap[][] soapModels = null;

        if (models.length > 0) {
            soapModels = new BgNumSoap[models.length][models[0].length];
        } else {
            soapModels = new BgNumSoap[0][0];
        }

        for (int i = 0; i < models.length; i++) {
            soapModels[i] = toSoapModels(models[i]);
        }

        return soapModels;
    }

    public static BgNumSoap[] toSoapModels(List<BgNum> models) {
        List<BgNumSoap> soapModels = new ArrayList<BgNumSoap>(models.size());

        for (BgNum model : models) {
            soapModels.add(toSoapModel(model));
        }

        return soapModels.toArray(new BgNumSoap[soapModels.size()]);
    }

    public long getPrimaryKey() {
        return _bgNumId;
    }

    public void setPrimaryKey(long pk) {
        setBgNumId(pk);
    }

    public long getBgNumId() {
        return _bgNumId;
    }

    public void setBgNumId(long bgNumId) {
        _bgNumId = bgNumId;
    }

    public long getOwnerId() {
        return _ownerId;
    }

    public void setOwnerId(long ownerId) {
        _ownerId = ownerId;
    }

    public long getBoxGpId() {
        return _boxGpId;
    }

    public void setBoxGpId(long boxGpId) {
        _boxGpId = boxGpId;
    }

    public double getValue() {
        return _value;
    }

    public void setValue(double value) {
        _value = value;
    }
}
