<%@ include file="/jsp/init.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<c:set var="type" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx2']}" />
<c:set var="worImId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx1']}" />
<c:set var="primaryKey" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx10']}" />
<c:set var="veteranId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx11']}" />

<portlet:actionURL var="loadDispositionWork">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadDispositionWork" />
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="type" value="${type}"/>
</portlet:actionURL>

<portlet:actionURL var="createAppfromCall">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="callId" value="${primaryKey}"/>
	<portlet:param name="veteranId" value="${veteranId}"/>
	<portlet:param name="entry" value="CREATE_APPLICATIONS"/>
</portlet:actionURL>

<portlet:actionURL var="openReferral">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="openReferral" />
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="callId" value="${primaryKey}"/>
	<portlet:param name="type" value="${type}"/>
</portlet:actionURL>

<liferay-ui:icon-menu>
	<liferay-ui:icon image="post" message="transfer-to-facility" url="javascript:transfer(${worImId});"  />
	<liferay-ui:icon image="assign" message="assign-ownership" url="javascript:assignTo(${SEARCH_CONTAINER_RESULT_ROW.object['ndx1']});" />
	<c:choose>
		<c:when test="${fn:contains(type, 'REFERRAL')}">
			<liferay-ui:icon image="preview" message="view-referral" url="${openReferral}" />
			<liferay-ui:icon image="add" message="start-application"  url="${createAppfromCall}" />
		</c:when>
		<c:otherwise>
			<liferay-ui:icon image="clip" message="create-waiver" url="${loadDispositionWork}" />
		</c:otherwise>
	</c:choose>
</liferay-ui:icon-menu>