<%@ include file="/jsp/init.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<c:set var="type" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx2']}" />
<c:set var="worImId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx1']}" />
<c:set var="primaryKey" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx10']}" />
<c:set var="veteranId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx11']}" />
<c:set var="vcgAnId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx12']}" />
<c:set var="daysPassed" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx13']}" />
<c:set var="receivedDate" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx14']}" />


<portlet:actionURL var="loadDispositionWork">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadDispositionWork" />
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="primaryKey" value="${primaryKey}"/>
	<portlet:param name="type" value="${type}"/>
</portlet:actionURL>

<portlet:actionURL var="cscWaiver">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="cscWaiver" />
	<portlet:param name="workItemId" value="${worImId}"/>
	<portlet:param name="vcgAnId" value="${vcgAnId}"/>
	<portlet:param name="daysPassed" value="${daysPassed}"/>
	<portlet:param name="receivedDate" value="${receivedDate}"/>
</portlet:actionURL>

<c:set var="isReferral" value="${fn:contains(type, 'REFERRAL')}" />

<liferay-ui:icon-menu>
	<liferay-ui:icon image="post" message="transfer-to-facility" url="javascript:transfer(${worImId});"  />
	<c:choose>
		<c:when test="${isReferral}">
			<portlet:actionURL var="openReferral">
				<portlet:param name="javax.portlet.action" value="doAction" />
				<portlet:param name="action" value="openReferral" />
				<portlet:param name="worImId" value="${worImId}"/>
				<portlet:param name="callId" value="${primaryKey}"/>
				<portlet:param name="type" value="${type}"/>
			</portlet:actionURL>
			
			<portlet:actionURL var="createApplication">
				<portlet:param name="javax.portlet.action" value="doAction" />
				<portlet:param name="action" value="loadEntry" />
				<portlet:param name="worImId" value="${worImId}"/>
				<portlet:param name="entry" value="CREATE_APPLICATIONS"/>
				<portlet:param name="veteranId" value="${veteranId}"/>
			</portlet:actionURL>

			<liferay-ui:icon image="preview" message="follow-up-referral" url="${openReferral}" />
			<liferay-ui:icon image="add" message="start-application"  url="${createApplication}" />
			<liferay-ui:icon image="close" message="mark-closed-completed" url="javascript:markClosed(${worImId});" />
		</c:when>
		<c:otherwise>	
			<c:choose>
				<c:when test="${daysPassed ge 46 and daysPassed le 90}">
			        <liferay-ui:icon image="submit" message="csc-waiver" url="${cscWaiver}"/>
			    </c:when>    
			    <c:otherwise>
			        <liferay-ui:icon image="submit" message="process-application" url="${loadDispositionWork}" />
			    </c:otherwise>		
			</c:choose>
		</c:otherwise>
	</c:choose>
</liferay-ui:icon-menu>