
<%@ include file="/jsp/init.jsp" %>

<c:if test="${!empty CARET_MENU}">
	
	<c:if test="${!empty CARET_MENU['createActions']}">
		<portlet:actionURL var="createEntry">
			<portlet:param name="javax.portlet.action" value="doAction"/>
			<portlet:param name="action" value="loadEntry"/>
		</portlet:actionURL>
		
		<form name="createEntry" method="post" action="${createEntry}" >
			<input type="hidden" id="<portlet:namespace/>entry" name="entry" >
			<input type="hidden" name="TRACKER" value="${TRACKER}" >
		</form>
			
		<aui:script use="node" >
			A.all('.caret-action').on(
		      'click',
		      function(e) {	
		    	  var id = e.currentTarget.attr('id');
		       		id = id.substring( id.indexOf('<portlet:namespace/>') + '<portlet:namespace/>'.length );
		       		A.one ('#<portlet:namespace/>entry').val( id );
		       		document.forms["createEntry"].submit();
		      }
		    );
		</aui:script>
	</c:if>
	
	<aui:nav cssClass="caret-menu">
		<c:if test="${!empty CARET_MENU['createActions']}">
		     <aui:nav-item dropdown="true" iconCssClass="icon-plus" label="create" >
		    	<c:forEach items="${CARET_MENU['createActions']}" var="action" >
		    		<aui:nav-item href="javascript:"  cssClass="caret-action" id="${action.key}" label="${action.value}" />
		    	</c:forEach>
		    </aui:nav-item>
	    </c:if>
	    
	    <c:if test="${!empty CARET_MENU['toolsActions']}">
	    	<c:set var="toolsActions" value="${CARET_MENU['toolsActions']}" />
	    	<aui:nav-item dropdown="true" iconCssClass="icon-wrench" label="tools" >
		    	<c:forEach items="${toolsActions}" var="action" >
		    		<aui:nav-item href="javascript:" cssClass="tool-action" id="${action.key}" label="${action.value}" />
		    	</c:forEach>
		    </aui:nav-item>
		</c:if>
		
		<c:if test="${!empty CARET_MENU['helpActions']}">
	    	<c:set var="helpActions" value="${CARET_MENU['helpActions']}" />
	    	<aui:nav-item dropdown="true" iconCssClass="icon-info-sign" label="help" >
		    	<c:forEach items="${helpActions}" var="action" >
		    		<aui:nav-item href="javascript:" cssClass="help-action" id="${action.key}" label="${action.value}" />
		    	</c:forEach>
		    </aui:nav-item>
		</c:if>
	</aui:nav>
	
   	<c:if test="${! empty toolsActions['STIPEND_CALCULATOR']}"  >
		<%@include file="/jsp/tools/stipendCalculator.jsp" %>
   	</c:if>
   	
   	<c:if test="${! empty toolsActions['IDENTITY_MATCHING']}"  >
   	</c:if>
   	
   	<c:if test="${! empty toolsActions['USPS_LINK']}"  >
   	</c:if>


   	<c:if test="${! empty helpActions['CSP_HELP']}"  >
   	</c:if>
   	
   	<c:if test="${! empty helpActions['ABOUT_CARET']}"  >
   	</c:if>
	
</c:if>	
