<%@ include file="/jsp/init.jsp" %>

<style>
.lfr-dynamic-uploader {
    display: block;
    float: left;
    margin-top: -10px;
    margin-right: 15em;;
}
.lfr-dynamic-uploader.manage-layout {
    width: 427px;
}
.lfr-upload-container .upload-target {
    border: thin solid #2aaae6;
    margin-bottom: 1em;   
    min-height: 60px;
    padding: 15px 0;
}
.float-right{
	float: right;
}
fieldset hr{margin:20px 0;border:0;border-top:1px solid red;border-bottom:1px solid white}

</style>

<portlet:actionURL var="saveEntry">
	<portlet:param name="javax.portlet.action" value="doAction"/>
</portlet:actionURL>




<form name="saveEntry" method="post" action="${saveEntry}" >
	<input type="hidden" name="action" value="saveEntry"/>
	<input type="hidden" id="entry" name="entry" value="CREATE_REFERRAL" >
	<input type="hidden" name="TRACKER" value="${TRACKER}" >
	<c:set var="cssClass" value="${form_['required']}" />
	
	<c:set var="form_" value="${caretMap_['form_']}" />
	<c:set var="call" value="${form_['call']}" />
	<c:set var="boxGrp_" value="${form_['boxGrp_']}" />
	<c:set var="bgAsn_" value="${form_['bgAsn_']}" />
	
	<legend class="header" id="headerElem">
		<c:choose>
			<c:when test="${isDisabled}">
				<liferay-ui:message key="view-referral" /> (${role})
			</c:when>
			<c:when test="${!empty call and call.primaryKey gt 0}">
				<liferay-ui:message key="edit-referral" /> (${role})
			</c:when>
			<c:otherwise>
				<liferay-ui:message key="create-referral" /> (${role})
			</c:otherwise>
		</c:choose>
	</legend>
	
	
	<fieldset id="sectionCollapse">
	
		<div class="next-section-label section-header toggler-header-expanded">
			<div class="icon-user show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
				<liferay-ui:message key="veteran-information" />
			</div>
		</div>
		<hr/>
	
		<div class="content toggler-content-expanded" >
			
			<c:set var="ndx" value="veteranPersn" />
	
			<c:set var="person" value="${form_['veteranPersn']}" />
			<input type="hidden" name="${ndx}_primaryKey" value="${person.primaryKey}" id="<portlet:namespace/>use_${ndx}_" />
			<input type="hidden" name="call_primaryKey" value="${call.primaryKey }" />
			
			<c:set var="searchCss" value="search-person-action icon-search" />
			
			<%@include file="/jsp/internal/person.jsp" %>
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['email']}"  >
				<aui:input disabled="${isDisabled}" label="email" name="${ndx}_email" type="text" size="25" id="${ndx}_email" value="${person.email}" />
			</aui:field-wrapper>

			<c:set var="includeFacility" value="${true}" />
			<%@include file="/jsp/internal/editAddress.jsp" %>
	
			<div class="veteran-supplemental-info">
				
				<div class="supplemental-row">
					<div class="supplemental-question-veteran">
						<liferay-ui:message key="veteran-enrolled-in-va-health" />
					</div>
					<div class="supplemental-answer">
							<aui:input disabled="${isDisabled}" label="yes" name="call_enrolled"  value="true" type="radio" checked="${call.enrolled}" />
							<aui:input disabled="${isDisabled}" label="no" name="call_enrolled"  value="false" type="radio" checked="${!call.enrolled}" />
						
					</div>
				</div>
				<div class="supplemental-row">
					<div class="supplemental-question-veteran">
						<liferay-ui:message key="discharged-after-911" />
					</div>
					<div class="supplemental-answer">
						<aui:input disabled="${isDisabled}"  label="yes" name="call_dutyDischargeAfter911"  value="true" type="radio" checked="${call.dutyDischargeAfter911}" />
						<aui:input disabled="${isDisabled}" label="no" name="call_dutyDischargeAfter911"  value="false" type="radio" checked="${!call.dutyDischargeAfter911}" />
						
					
						
					</div>
				</div>
				<div class="supplemental-row">
					<div class="supplemental-question-veteran">
						<liferay-ui:message key="veteran-has-sc-condition" />
					</div>
					<div class="supplemental-answer">
						
						<aui:input disabled="${isDisabled}" label="yes" name="call_scCondition" value="true" type="radio" checked="${call.scCondition}" />
						<aui:input disabled="${isDisabled}" label="no" name="call_scCondition" value="false" type="radio" checked="${!call.scCondition}" />
					</div>
				</div>
				<div class="supplemental-row">
					<div class="supplemental-question-veteran">
						<liferay-ui:message key="prescreen-meets-pcafc" />
					</div>
					<div class="supplemental-answer">
						<aui:input disabled="${isDisabled}" label="yes" name="call_pcafcQaulified" type="radio" checked="${call.pcafcQaulified}" />
						<aui:input disabled="${isDisabled}" label="no" name="call_pcafcQaulified" type="radio" checked="${!call.pcafcQaulified}" />
						
					</div>
				</div>
				
				<aui:field-wrapper inlineField="true" cssClass="supplemental-row ${cssClass['serviceStatus']}" inlineLabel="left" first="false" last="false" >
					<aui:select disabled="${isDisabled}" cssClass="supplemental-answer" label="current-service-status" name="call_serviceStatus" id="call_serviceStatus" >
						<aui:option label="select" value=""  />
						<c:forEach var="servStat" items="${serviceStatus}">
							<aui:option value="${servStat}" label="${servStat}" selected="${call.serviceStatus eq servStat}" />
						</c:forEach>
					</aui:select>
				</aui:field-wrapper>
			</div>

			
			<c:if test="${!empty boxGrp_['hec-questionaire']}">
				<div class="hec-questions manage-layout-wide">
					<div class="hec-title"><liferay-ui:message key="lod-aggravated-injury" /></div>
					<div class="hec-only">
						<c:forEach var="boxGrp" items="${boxGrp_['hec-questionaire']}" begin="0" varStatus="ndx">
							<aui:input cssClass="hec-checkbox" label="${boxGrp.label}" name="boxGrp_${boxGrp.boxGpId}" type="checkbox"  value="${bgAsn_[boxGrp.primaryKey]}" />
						</c:forEach>
					</div>
				</div>
			</c:if>
			
		</div>
		
		<div class="next-section-label section-header">
			<div class="icon-user show-tooltip" title='<liferay-ui:message key="click-to-toggle-pane" />' > 
				<liferay-ui:message key="caller-info" />
			</div>
		</div>
		<hr/>
		
	    <div class="content toggler-content-expanded" >
	      	
			<input type="hidden" name="call_callType" value="Referral" />
			<c:set var="ndx" value="callerPersn" />
			<c:set var="person" value="${form_['callerPersn']}" />
			<input type="hidden" name="call_primaryKey" value="${call.primaryKey }" />
			
			<input type="hidden" name="${ndx}_primaryKey" value="${person.primaryKey}" id="<portlet:namespace/>use_${ndx}_" />
			<%@include file="/jsp/internal/editCaller.jsp" %>	
			
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['callerRelationship']}"   >
				<aui:select disabled="${isDisabled}" label="caller-relationship" name="call_callerRelationship" id="call_callerRelationship" >
					<aui:option label="select-relationship" value=""  />
					<aui:option label="family" cssClass="section" disabled="true" />
					<c:forEach var="relationship" items="${caretMap_['relationship-family']}">
						<aui:option cssClass="relationship" value="${relationship}" label="${relationship}" selected="${call.callerRelationship eq relationship}" />
					</c:forEach>
					<aui:option label="not-family" cssClass="section" disabled="true" />
					<c:forEach var="relationship" items="${caretMap_['relationship-not-family']}">
						<aui:option cssClass="relationship" value="${relationship}" label="${relationship}" selected="${call.callerRelationship eq relationship}" />
					</c:forEach>
				</aui:select>
			</aui:field-wrapper>
			
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['callerEmail']}"  >
				<aui:input disabled="${isDisabled}" label="email" name="${ndx}_email" type="text" size="25" id="${ndx}_email" value="${person.email}" />
			</aui:field-wrapper>
		
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout2"  >
				<aui:input disabled="${isDisabled}" label="same-address-as-veteran" name="call_sameAddress" type="checkbox" id="sameAddress" value="${ true eq form_['sameAddress'] }" />
			</aui:field-wrapper>
				
			<c:set var="addrGroup" value="${ndx}" />
			<c:set var="first" value="${ndx}" />
			<c:set var="includeFacility" value="${false}" />
			<%@include file="/jsp/internal/editAddress.jsp" %>
			
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="form-textarea manage-layout-wide-input ${cssClass['message']}"  >
				<aui:input disabled="${isDisabled}" label="remarks" name="call_message" size="50" cssClass="caller-message" type="textarea" id="call_message" value="${call.message}" />
			</aui:field-wrapper>
			
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide ${cssClass['callerLearnAbout']}"   >
				<aui:select disabled="${isDisabled}" label="how-learned-of-program" name="call_callerLearnAbout" id="call_callerLearnAbout" >
					<aui:option label="select" value=""  />
					<c:forEach var="entry" items="${callerLearnAbout}" >
						<aui:option value="${entry}" label="${entry}" selected="${call.callerLearnAbout eq entry}" />
					</c:forEach>
				</aui:select>
			</aui:field-wrapper>
		</div>
	</fieldset>


	<c:if test="${role eq 'HEC'}">
		<portlet:actionURL var="uploadFileURL1010cg">
			<portlet:param name="javax.portlet.action" value="doAction"/>
			<portlet:param name="action" value="uploadFile"/>
			<portlet:param name="type" value="1010cg"/>
		</portlet:actionURL>
		
		<portlet:actionURL var="uploadFileURLpoa">
			<portlet:param name="javax.portlet.action" value="doAction"/>
			<portlet:param name="action" value="uploadFile"/>
			<portlet:param name="type" value="poa"/>
		</portlet:actionURL>
	
		<div class="icon-list-alt next-section-label section-header"> 
			<liferay-ui:message key="supporting-docs" />
		</div>
		<hr/>
		
	    <div class="content toggler-content-expanded" >		
			<div class="clear-both" id="<portlet:namespace/>supportDocs" >
				<c:forEach var="doc" items="${form_['supportDocs']}">
					<portlet:resourceURL var="getDocum">
						<portlet:param name="action" value="getDocum"/>
						<portlet:param name="documId" value="${doc.documId}"/>
					</portlet:resourceURL>
					
					<div class="poa-docum manage-layout" >
						<a href="${getDocum}" target="_blank" ><i class="close-window btn btn-primary icon-download" >&nbsp; ${doc.name}</i></a>
					</div>		
				</c:forEach>
			</div>
					
			<div class="lfr-dynamic-uploader manage-layout">
			   <div class="lfr-upload-container fileUpload" id="<portlet:namespace />fileUpload">
			        &nbsp;
			    </div>
			</div>			
			
			<div class="lfr-dynamic-uploader manage-layout">
			   <div class="lfr-upload-container fileUploadPOA" id="<portlet:namespace />fileUploadPOA">
			        &nbsp;
			    </div>
			<br/>
			</div>			
		</div>
	
		<aui:script  use="liferay-upload">
		
		var liferayUpload = new Liferay.Upload({
	         allowedFileTypes: "${form_['extensions']}",
	         container: '#<portlet:namespace />fileUpload',
	         maxFileSize: 0,
	         namespace:'<portlet:namespace />',
	         uploadFile: '${uploadFileURL1010cg}',        
	         tempFileRemoved: function(){},
	         'strings.dropFilesText': '<liferay-ui:message key="drag-and-drop-1010-file" />',
	         'strings.dropFileText': '<liferay-ui:message key="drag-and-drop-1010-file" />',
	         'strings.selectFileText': '<liferay-ui:message key="select-1010-file" />',
	         'strings.selectFilesText': '<liferay-ui:message key="select-1010-file" />',
	         'strings.fileCannotBeSavedText': 'File cannot be saved',
	         'strings.pendingFileText': 'Upload of file pending',
	         'strings.uploadsCompleteText': 'Upload completed, save to attach to Application',
	         multipleFiles: false

	     });
		 
		 var liferayUploadPOA = new Liferay.Upload({
	         allowedFileTypes: "${form_['extensions']}",
	         container: '#<portlet:namespace />fileUploadPOA',
	         maxFileSize: 0,
	         namespace:'<portlet:namespace />',
	         uploadFile: '${uploadFileURLpoa}',        
	         tempFileRemoved: function(){},
	         'strings.dropFilesText': '<liferay-ui:message key="drag-and-drop-poa-file" />',
	         'strings.dropFileText': '<liferay-ui:message key="drag-and-drop-poa-file" />',
	         'strings.selectFileText': '<liferay-ui:message key="select-poa-file" />',
	         'strings.selectFilesText': '<liferay-ui:message key="select-poa-file" />',
	         'strings.fileCannotBeSavedText': 'File cannot be saved',
	         'strings.pendingFileText': 'Upload of file pending',
	         'strings.uploadsCompleteText': 'Upload completed, save to attach to Application',
	         multipleFiles: false

	     });

	     A.on('domready', function( event ) {
		     	try {
		         	A.one('.component.liferayupload').appendTo("#<portlet:namespace />fileUploadPOA");
		         	A.one('.component.liferayupload').appendTo("#<portlet:namespace />fileUpload");
		     	} catch (e){
		     		// console.log('appendTo... failed');
		     	}
		  });	
	     
		</aui:script>	
	</c:if>			
			
<c:choose>
	<c:when test="${empty worImId}">
		<div class="clear-both">
			<a href="<portlet:actionURL/>" class="btn btn-primary" >
					<liferay-ui:message key="cancel" />
			</a>
			<a href="javascript:" id="submitForm" class="referral-submitter btn btn-primary" >
				<liferay-ui:message key="submit-referral" />
			</a>
		</div>
	
	</c:when>
	<c:otherwise>
	
		
		<div class="save-info-bottom">
				
			<aui:field-wrapper inlineField="true" cssClass="manage-layout ${cssClass['callState']}" inlineLabel="left" first="false" last="false" >
				<aui:select disabled="${isDisabled}" label="call-disposition" name="call_callState" id="callState" cssClass="small-legend" >
					<aui:option value="" label="select"  />
					<aui:option value="complete" label="completed"  />
					<aui:option value="completed-without-contact" label="completed-without-contact"  />
				</aui:select>
			</aui:field-wrapper>
					
			<div class="clear-both">
				<a href="<portlet:actionURL/>" class="btn btn-primary" >
					<liferay-ui:message key="cancel" />
				</a>
				<a href="javascript:" id="submitForm" class="referral-submitter btn btn-primary" >
					<liferay-ui:message key="submit" />
				</a>
			</div>
		</div>
	</c:otherwise>
</c:choose>
	
	
	
	
	
</form>

<%@include file="/jsp/internal/searchPerson.jsp" %>


<aui:script use="aui-tooltip,aui-toggler,liferay-upload">
	
	new A.TooltipDelegate( { trigger: '.show-tooltip' } );
	
		new A.TogglerDelegate(
			      {
			        animated: true,
			        closeAllOnExpand: false,
			        container: '#sectionCollapse',
			        content: '.content',
			        expanded: true,
			        header: '.section-header',
			        transition: {
			          duration: 0.2,
			          easing: 'cubic-bezier(0, 0.1, 0, 1)'
			        }
			      }
			    );
		
		A.one('#<portlet:namespace/>sameAddressCheckbox').on('click',
			function( event ) {
			if ( this.attr('checked') ){
				A.all('.${first}').hide();
			} else {
				A.all('.${first}').show();
			}
		});
		
		
		A.all('.referral-submitter').on('click', function ( event ) {
			if ( true == validateFields() ){
				document.forms['saveEntry'].submit();
			}
		});
		
		var validateFields = function(e){
			var count = 0;
			  var inputNodes = A.all('.required-input input, .required-input select');
			  var fields = "";
			  for ( var i = 0; i < inputNodes.size() ; i++ ){
				  var node = A.one(inputNodes._nodes[i]);
				  if (node == undefined  || node.attr('disabled') == true ) continue;
					if ( 'select-one' == node.attr('type') ){
		    			if ( node.val() == "" || node.val() == "0" ){
		    				 node.addClass( 'missing-required-input' );
		    				 fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
		    				 count++;
		    			} else {
		    				if ( node.hasClass('missing-required-input') ){
		    					node.removeClass( 'missing-required-input' );
		    				}
		    			}
		    		}
					if ( 'text' == node.attr('type') ){
						if ( node.val() == ""  
							|| ( node.hasClass('date-field') && node.val() == 'MM/DD/YYYY' )
							|| ( node.hasClass('ssn-field') && node.val() == '###-##-####' )
							|| ( node.hasClass('phone-field') && node.val() == '(###) ###-####' ) ){
		   					node.addClass( 'missing-required-input' );
		   					fields = fields + "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
		   					count++;
			   			} else {
			   				if ( node.hasClass('missing-required-input') ){
			   					node.removeClass( 'missing-required-input' );
			   				}
						}
			    	}
			    }
			  
			  if ( count > 0 ){
    				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + fields +"</ul></div>";
    				A.one ('#validationResult').html(msg);
		    		modalDataValidation.render();
		    		modalDataValidation.show();
		    		return false;	
		    	}
			  return true;
		}
		
		var modalDataValidation = new A.Modal({
		    headerContent: '<h4><liferay-ui:message key="data-validation-header" /></h4>',
		    bodyContent: A.one("#validationDiv"),
		    centered: true,
		    destroyOnHide: false,
		    modal: true,
		    render: '#validationModal',
		    resizable: {
		      handles: 'b, r'
		    },
		    visible: false,
		    width: 500
		});
		
		

		
	
</aui:script>

<div class="yui3-skin-sam">
<div id="validationModal"></div>
</div>

<div id="validationDiv" class="yui3-skin-sam">
<div id="validationResult"></div>
</div>


<%@include file="/jsp/version.jsp" %>
	
	