
<%@ include file="/jsp/init.jsp" %>
		<c:set var="tempNdx" value="${ndx}" />
		<c:set var="ndx" value="${tempNdx}u" />
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="usps-service manage-layout ${addrGroup} ${cssClass['address']}"  >
			<aui:input label="address" disabled="${isDisabled}" name="${tempNdx}_address" type="text" size="25" value="${person.address}"  />
		</aui:field-wrapper>
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="usps-service manage-layout ${addrGroup} ${cssClass['state']}"  >
			<aui:select inlineField="true" disabled="${isDisabled}" label="state" name="${tempNdx}_state" id="${ndx}_state" cssClass="persn-resource-state" >
				<aui:option value="" label="select-state" />
				<c:forEach var="state" items="${caretMap_['states']}">
					<aui:option value="${state.regionCode}" label="${state.name}" selected="${state.regionCode eq person.state}" />
				</c:forEach>
			</aui:select>
		</aui:field-wrapper>
		
		<c:set var="key" value="${ndx}_blsCities" />
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="usps-service manage-layout ${addrGroup} ${cssClass['city']}"  >
			<aui:select disabled="${isDisabled}" label="city" name="${tempNdx}_city" id="${ndx}_city"  cssClass="persn-resource-city"  >
				<aui:option value="" label="select-city" />
				<c:forEach var="city" items="${caretMap_[key]}">
					<aui:option value="${city['ndx0']}" label="${city['ndx0']}" selected="${city['ndx0'] eq person.city}" />
				</c:forEach>
			</aui:select>
		</aui:field-wrapper>
		
		<c:set var="key" value="${ndx}_blsZips" />
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="usps-service manage-layout ${addrGroup} ${cssClass['zip']}"  >
			<aui:select disabled="${isDisabled}" label="zip" name="${tempNdx}_zip" id="${ndx}_zip" >
				<aui:option value="" label="select-zip" />
				<c:forEach var="zip" items="${caretMap_[key]}">
					<aui:option value="${zip}" label="${zip}" selected="${zip eq person.zip}" />
				</c:forEach>
			</aui:select>
			<!-- "zip-service" cssClass was with field-wrapper
			<a id="usps_${ndx}_" class="btn-link usps-zip-action btn-primary icon-envelope" title="<liferay-ui:message key='usps-zip-tooltip'/>"></a>
			 -->
		</aui:field-wrapper>
		
	
<aui:script use="aui-tooltip">
	A.all('.persn-resource-state').on( 
		      'change',
		      function( event ) {
		    	  	var eventId = event.currentTarget.attr('id');
		    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="getCities" /></portlet:resourceURL>', 'json', 
							{ state: A.one('#'+ eventId).val() },
							function( data ){
						    	 var citesNode = A.one ( '#' + eventId.substring(0, eventId.length-5) + 'city');
						    	 var options = "<option>Select City</option>";
								if ( data.size > 0 ){
							    	 for ( var i = 0; i < data.size; i++  ){
							    		 options = options + '<option value="' + data.cities[i].city + '">'+ data.cities[i].city + '</option>';
							    	 }
								}
						    	 citesNode.html( options );
							} 
					);
		     }
		 );

	A.all('.persn-resource-city').on(
	      'change',
	      function( event ) {
	    	  	var eventId = event.currentTarget.attr('id');
	    	  	
	    	  	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="getZips" /></portlet:resourceURL>', 'json', 
						{ city: A.one('#'+ eventId).val() },
						function( data ){
							var zipsNode = A.one ('#' + eventId.substring(0, eventId.length-4) + 'zip');
					    	 var options = "<option value='0' >Select Zip</option>";
							if ( data.size > 0 ){
						    	 for ( var i = 0; i < data.size; i++  ){
						    		 options = options + '<option value="' + data.zips[i].zip + '">'+ data.zips[i].zip + '</option>';
						    	 }
					    	 }
						     zipsNode.html( options );
						} 
				);
	     }
	 );
</aui:script>



<c:if test="${true eq includeFacility}">

	
	<div id="<portlet:namespace/>zipFaciliities" ></div>
	<div id="<portlet:namespace/>vaFacilities" ></div>

	
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass['groupId']}"   >
		<aui:select disabled="${isDisabled}" label="preferred-facility" name="${tempNdx}_groupId" id="${tempNdx}_groupId" >
			<aui:option value="0" label="select-facility" />
			<c:forEach var="district" items="${caretMap_['vhaSystem']}">
				<aui:option value="${district.key}" label="${district.key}" cssClass="district" disabled="true" selected="false" />
				<c:forEach var="visn" items="${district.value}">
					<aui:option value="${visn.key}" label="${visn.key}" cssClass="visn" disabled="true" selected="false" />
					<c:forEach var="facility" items="${visn.value}">
						<aui:option value="${facility.value}" label="${facility.key}" cssClass="facility" selected="${facility.value eq person.groupId}" />
					</c:forEach>
				</c:forEach>
			</c:forEach>
		</aui:select>
		<a class="btn-link short-facility-list btn-primary icon-filter facil-magnet" id="<portlet:namespace/>${ndx}_facility" title="<liferay-ui:message key="narrow-facilities-to-zip" />" ></a>
	</aui:field-wrapper>


<aui:script use="aui-tooltip">

	
	A.one("#<portlet:namespace/>vaFacilities").hide();
	A.one("#<portlet:namespace/>zipFaciliities").hide();
	var ttip =  new A.TooltipDelegate( { trigger: '.next-section-label a, .facil-magnet' } );
	
	A.one('#<portlet:namespace/>${ndx}_facility').on( 'click',
    	function (e){
			if ( ${isDisabled ne true} ){
	    		var zip = A.one('#<portlet:namespace/>${ndx}_zip' ).val();
	    		if ( zip == ''){
	    			return;
	    		}
	    		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="getFacils" /></portlet:resourceURL>', 'json',
						{ zip: zip },
						function( data ){
							var facilNode;
	  				    	 
	  				    	if ( A.one('#<portlet:namespace/>vaFacilities').html() == "" ){
	  				    		facilNode = A.one ( '#<portlet:namespace/>zipFaciliities');
	  			    		} else {
	  			    			facilNode = A.one('#<portlet:namespace/>${tempNdx}_groupId');
	  				    	}
	  				    	
	  				    	var options = "<option>Select Facility</option>";
	  						if ( data.size > 0 ){
	  					    	 for ( var i = 0; i < data.size; i++  ){
	  					    		 options = options + '<option value="' + data.facilities[i].groupId + '">'+ data.facilities[i].facility + '</option>';
	  					    	 }
	  						}
	  					    facilNode.html( options );
						} 
				);
	    		
	    		
	    		var zipFaciliities = A.one('#<portlet:namespace/>zipFaciliities');
	    		var vaFacilities = A.one('#<portlet:namespace/>vaFacilities');
	    		var facilitySelect = A.one('#<portlet:namespace/>${tempNdx}_groupId');
	    		
	    		if ( vaFacilities.html() == "" ){
		    		vaFacilities.html( facilitySelect.html() );
	    			facilitySelect.html( zipFaciliities.html() );
	    			zipFaciliities.html('');
	    		} else {
	    			zipFaciliities.html( facilitySelect.html() );
	    			facilitySelect.html( vaFacilities.html() );
	    			vaFacilities.html('');
	    		}
			}
    });

</aui:script>

</c:if>





	<c:set var="ndx" value="${tempNdx}" /><!-- "u" on prefix is for USA vs "g" for global  -->