<%@ include file="/jsp/init.jsp" %>

	<c:set var="ndx" value="secondaryTwoPerson" />	
	<c:set var="searchCss" value="search-person-action icon-search" />
	<c:set var="cssClass" value="${form_['secondaryTwoRequired']}" />
	
	<c:set var="isDisabled" value="${false}" />	
	<%@include file="/jsp/internal/person.jsp" %>

	<c:set var="includeFacility" value="${false}" />
	<c:set var="isDisabled" value="${false}" />	
	<%@include file="/jsp/common/editAddress.jsp" %>
	
	<br>

	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['phone']}"  >
		<aui:input label="phone1" cssClass="phone-field" name="${ndx}_phone" type="text" size="25" value="${person.phone}" />
	</aui:field-wrapper>
	
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
		<aui:input label="phone2" cssClass="phone-field" name="${ndx}_phone2" type="text" size="25" value="${person.phone2}" />
	</aui:field-wrapper>
			
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
		<aui:input label="email" name="${ndx}_email" id="${ndx}_email" max="75" type="text" size="25" value="${person.email}"  />
	</aui:field-wrapper>

	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['secondaryTwoRelationship']}"   >
		<aui:select disabled="${isDisabled}" label="online-cg-relationship" name="vcgAn_secondaryTwoRelationship" id="vcgAn_secondaryTwoRelationship" >
			<aui:option label="select-relationship" value=""  selected="true"/>
			<aui:option label="family" cssClass="section" disabled="true" />
			<c:forEach var="relationship" items="${caretMap_['relationship-family']}">
				<aui:option cssClass="family relationship" value="${relationship}" label="${relationship}" selected="${form_['vcgAn'].secondaryTwoRelationship eq relationship}" />
			</c:forEach>
			<aui:option label="not-family" cssClass="section" disabled="true" />
			<c:forEach var="relationship" items="${caretMap_['relationship-not-family']}">
				<aui:option cssClass="not-family relationship" value="${relationship}" label="${relationship}" selected="${form_['vcgAn'].secondaryTwoRelationship eq relationship}" />
			</c:forEach>
		</aui:select>
	</aui:field-wrapper>
	
	<div class="certify-that float-left" >
		<aui:input label="" cssClass="float-left ${cssClass['relationshipToVeteran']}" id="relationshipSecondaryTwo" name="certify-that" type="checkbox" />
		<div id="secondaryTwoFamily" class="hidden-msg" >
			<liferay-ui:message key="caregiver-certify-as-family" />
		</div>
		<div id="secondartTwoNotFamily" class="hidden-msg" >
			<liferay-ui:message key="caregiver-certify-not-as-family" />
		</div>
		<div>
			<p><liferay-ui:message key="secondary-perform-services-to-veteran" /></p>
		</div>		
	</div>
	
	<div class="clear-both"></div>

<aui:script use="aui-base">
	
	 A.one('#<portlet:namespace/>vcgAn_secondaryTwoRelationship').on('change',function( event ) {
   	    var eventId = event.currentTarget.attr('id');
   	  	var str = this._node.options[this._node.selectedIndex].getAttribute('class');
   	  	
   	  	if ( str.indexOf('not-family') > -1 ){ 		    	  		
			if ( A.one ('#secondartTwoNotFamily').hasClass('hidden-msg') ){
				A.one ('#secondartTwoNotFamily').removeClass('hidden-msg');
			}
   	  		if ( ! A.one ('#secondaryTwoFamily').hasClass('hidden-msg') ){
				A.one ('#secondaryTwoFamily').addClass('hidden-msg');
			}
		} else {		    	  		
   	  		if ( A.one ('#secondaryTwoFamily').hasClass('hidden-msg') ){
				A.one ('#secondaryTwoFamily').removeClass('hidden-msg');
			}
   	  		if ( ! A.one ('#secondartTwoNotFamily').hasClass('hidden-msg') ){
				A.one ('#secondartTwoNotFamily').addClass('hidden-msg');
			}
		}		    	  	
	});

	window.validateSecondaryTwoFields = function( validateOtherCallback ){
		var submit = true;
		if(A.one('#<portlet:namespace/>${ndx}_primaryKey')!=null ){ 

			validateFields( function( message ){
				
				/*
				if(A.one('#<portlet:namespace/>vcgAn_secondaryTwoRelationship')==null || A.one('#<portlet:namespace/>vcgAn_secondaryTwoRelationship').val()=='' ){
					message = message + "<li>Secondary Two Caregiver relationship to Veteran is required</li>";
					A.one('#<portlet:namespace/>vcgAn_secondaryTwoRelationship').addClass( 'missing-required-input' );
				}else{
					if ( A.one('#<portlet:namespace/>vcgAn_secondaryTwoRelationship').hasClass('missing-required-input') ){
						A.one('#<portlet:namespace/>vcgAn_secondaryTwoRelationship').removeClass( 'missing-required-input' );
					}
				}
				*/
				
				if ( message.length > 0 ){
					modalDataValidation.render();
					modalDataValidation.show();
										
					var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields-secondaryTwo' /><ul>" + message +"</ul></div>";
					A.one ('#secondaryTwoValidationResult').html(msg);
					submit = false;
				}else{
					A.one ('#secondaryTwoValidationResult').html('');
				}			
				validateOtherCallback( submit );
			});
		}else{
			A.one ('#secondaryTwoValidationResult').html('');
			validateOtherCallback( submit );			
		}
	}

	<%@include file="/jsp/internal/cscValidation.jsp" %>

</aui:script>

