<%@ include file="/jsp/init.jsp" %>

<style>
.certify-that input[type="checkbox"] {
    margin-right: 5px;
    margin-top: 13px;
}

.lfr-dynamic-uploader {
    display: block;
    float: right;
     margin-top: -20px;
}
.lfr-dynamic-uploader.manage-layout {
    width: 427px;
}
.lfr-upload-container .upload-target {
    border: thin solid #2aaae6;
    margin-bottom: 1em;
    min-height: 60px;
    padding: 15px 0;
}
.manage-layout-wide-input select {
    width: auto;
}
.manage-layout-wide-input input[type="text"] {
    width: 65%;
}
.sectionHeading{
    border: thin solid #d9d9d9;
    background-color: #f0efef;
	font-weight: bold;
	margin: 15px 0;
	padding: 3px;
	width: 99%;
	float: left;
}
.required-input .control-label::before {
    content: "*" !important;
}
.missing-required-input {
	background-color: #ffffcc !important;
}
</style>


<legend class="header">10-10CG Form</legend>

<portlet:actionURL var="saveEntry">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="saveEntry"/>
	<portlet:param name="entry" value="vcgAn"/>
</portlet:actionURL>

<portlet:actionURL var="uploadFileURL1010cg">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="uploadFile"/>
	<portlet:param name="type" value="1010cg"/>
</portlet:actionURL>

<portlet:actionURL var="uploadFileURLpoa">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="uploadFile"/>
	<portlet:param name="type" value="poa"/>
</portlet:actionURL>



<form name="saveEntry" method="post" action="${saveEntry}" >
	<input type="hidden" name="TRACKER" value="${TRACKER}" >
	<c:set var="form_" value="${caretMap_['form_']}" />
	<c:set var="cssClass" value="${form_['required']}" />
	
	<div id="app1010Tab">
	   	<ul class="nav nav-tabs">
		    <li><a href="#tab-4-1">Veteran</a></li>
		    <li><a href="#tab-4-2">Primary Caregiver</a></li>
		    <li><a href="#tab-4-3">Secondary Caregiver</a></li>
		    <li><a href="#tab-4-4">Secondary Two Caregiver</a></li>
		</ul>	
	
		<div class="tab-content">
			<div id="tab-4-1" class="tab-pane">				
				<c:set var="title" value="Veteran" />
		    	<%@include file="/jsp/internal/cscVeteranInfo.jsp" %>
		    </div>
		    
		    <div id="tab-4-2" class="tab-pane">
				<c:set var="title" value="Primary" />
		   		<%@include file="/jsp/internal/cscPrimaryInfo.jsp" %>
		    </div>
	
			<div id="tab-4-3" class="tab-pane">				
				<c:set var="title" value="Secondary" />
		    	<%@include file="/jsp/internal/cscSecondaryInfo.jsp" %>
		    </div>
		    
		    <div id="tab-4-4" class="tab-pane">
				<c:set var="title" value="SecondaryTwo" />
		   		<%@include file="/jsp/internal/cscSecondaryTwoInfo.jsp" %>
		    </div>	    
		</div>
	</div>

	
	<div class="clear-both">
		<button type="button" id="submitForm" class="btn btn-primary " >Save</button>
		
		<a href="<portlet:actionURL/>" class="btn btn-primary" >
			<liferay-ui:message key="cancel" />
		</a>
	</div>

</form>

<div id="<portlet:namespace/>fallback"></div>
<div id="submitState"></div>
 

<aui:script use="aui-tabview,aui-modal,aui-tooltip,liferay-upload,aui-base">

	var modalCaregiver = new A.Modal({
	    headerContent: '<h4><liferay-ui:message key="caregiver-modal-header" /> </h4>',
	    bodyContent: A.one("#caregiverDiv"),
	    centered: true,
	    destroyOnHide: false,
	    modal: true,
	    render: '#caregiverModal',
	    toolbars: false,
	    resizable: {
	      handles: 'b, r'
	    },
	    visible: false,
	    width: 600
	});

	modalCaregiver.render();
	modalCaregiver.show();


    A.all('#submitCGSelection').on('click', function() { 

    	var primary = A.one('#<portlet:namespace/>primaryCG').val();
    	var secondary= A.one('#<portlet:namespace/>secondaryCG').val();
    	var secondaryTwo = A.one('#<portlet:namespace/>secondaryTwoCG').val();
    	
    	if((null==primary || 'false'==primary)
    			&& (null==secondary || 'false'==secondary)
    			&& (null==secondaryTwo || 'false'==secondaryTwo))
    	{
			var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-select-caregiver' /></div>";
			A.one ('#cgErrorSection').html(msg);
    	}else{
    		A.one ('#cgErrorSection').html('');    		
    		modalCaregiver.hide();
    		
    		if(null==primary || 'false'==primary){
    			var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='primary-not-selected' /></div>";
    			A.one ('#tab-4-2').html(msg);
    		}
    		if(null==secondary || 'false'==secondary){
       			var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='secondary-not-selected' /></div>";
    			A.one ('#tab-4-3').html(msg);
    		}
    		if(null==secondaryTwo || 'false'==secondaryTwo){
       			var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='secondary-two-not-selected' /></div>";
    			A.one ('#tab-4-4').html(msg);
    		}
   		}
    });
    

	var app1010Tab = new A.TabView({
	    srcNode: '#app1010Tab',
	    type: 'pills'
	  }
	);
	app1010Tab.render();
	
	new A.TooltipDelegate( { trigger: '.search-person-action' } );
	
	 var liferayUpload = new Liferay.Upload({
         allowedFileTypes: "${form_['extensions']}",
         container: '#<portlet:namespace />fileUpload',
         maxFileSize: 0,
         namespace:'<portlet:namespace />',
         uploadFile: '${uploadFileURL1010cg}',        
         tempFileRemoved: function(){},
         'strings.dropFilesText': '<liferay-ui:message key="drag-and-drop-1010-file" />',
         'strings.dropFileText': '<liferay-ui:message key="drag-and-drop-1010-file" />',
         'strings.selectFileText': '<liferay-ui:message key="select-1010-file" />',
         'strings.selectFilesText': '<liferay-ui:message key="select-1010-file" />',
         'strings.fileCannotBeSavedText': 'File cannot be saved',
         'strings.pendingFileText': 'Upload of file pending',
         'strings.uploadsCompleteText': 'Upload completed, save to attach to Application',
         multipleFiles: false

     });
	 
	 var liferayUploadPOA = new Liferay.Upload({
         allowedFileTypes: "${form_['extensions']}",
         container: '#<portlet:namespace />fileUploadPOA',
         maxFileSize: 0,
         namespace:'<portlet:namespace />',
         uploadFile: '${uploadFileURLpoa}',        
         tempFileRemoved: function(){},
         'strings.dropFilesText': '<liferay-ui:message key="drag-and-drop-poa-file" />',
         'strings.dropFileText': '<liferay-ui:message key="drag-and-drop-poa-file" />',
         'strings.selectFileText': '<liferay-ui:message key="select-poa-file" />',
         'strings.selectFilesText': '<liferay-ui:message key="select-poa-file" />',
         'strings.fileCannotBeSavedText': 'File cannot be saved',
         'strings.pendingFileText': 'Upload of file pending',
         'strings.uploadsCompleteText': 'Upload completed, save to attach to Application',
         multipleFiles: false

     });


     A.on('domready', function( event ) {
     	try {
         	A.one('.component.liferayupload').appendTo("#<portlet:namespace />fileUploadPOA");
         	A.one('.component.liferayupload').appendTo("#<portlet:namespace />fileUpload");
     	} catch (e){
     		// console.log('appendTo... failed');
     	}
     });	
     
          
     A.all('#submitForm').on('click', function() { 
    	 
    	 var veteran = false;
    	 var primary = false;
    	 var secondary = false;
    	 var secondaryTwo = false;

 //   	 /*
	   	 validateVeteranFields(function ( validationStatus ){
    		 veteran = validationStatus;    		
    		 
    		 validatePrimaryFields(function ( validationStatus ){
        		 primary = validationStatus;    
        		 
        		 validateSecondaryFields(function ( validationStatus ){
            		 secondary = validationStatus; 
            		 
            		 validateSecondaryTwoFields(function ( validationStatus ){
                		 secondaryTwo = validationStatus;                  		 
                		 
                	   	 //console.log("veteran is : "+veteran);
                    	 //console.log("primary is : "+primary);
                    	 //console.log("secondary is : "+secondary);
                		 //console.log("secondary two is : "+secondaryTwo);
                    	 
                    	 if(veteran && primary && secondary && secondaryTwo){
                    		 //console.log("good for submit");
                    		 document.forms['saveEntry'].submit();
                    	 }else{
                    		 //console.log("validation errors");
                    	 }    	
                	 });
            	 });            	
        	 });        	 
    	 });
//    	 */

    	 /*
    	 validateAll(function(veteran, primary, secondary, secondaryTwo){
    	   	 console.log("veteran is : "+veteran);
        	 console.log("primary is : "+primary);
        	 console.log("secondary is : "+secondary);
    		 console.log("secondary two is : "+secondaryTwo);
        	 
        	 if(veteran && primary && secondary && secondaryTwo){
        		 console.log("good for submit");
        		 document.forms['saveEntry'].submit();
        	 }else{
        		 console.log("validation errors");
        	 }    	    		 
    			 
    	 }); 
    	 */
     });
     
 
     /*
     var validateAll = function(validateAllCallback){

       	 var veteran = false;
    	 var primary = false;
    	 var secondary = false;
    	 var secondaryTwo = false;
   	 
    	 validateVeteranFields(function ( validationStatus ){
    		veteran = validationStatus;    		
    	});
    		 
		validatePrimaryFields(function ( validationStatus ){
			primary = validationStatus;    
		});
		  		 
		validateSecondaryFields(function ( validationStatus ){
			secondary = validationStatus; 
		});
		      		 
		validateSecondaryTwoFields(function ( validationStatus ){
			secondaryTwo = validationStatus;    		 
		});
   	 
    	validateAllCallback(veteran, primary, secondary, secondaryTwo); 
     }
     */

     
	 window.modalDataValidation = new A.Modal({
		    headerContent: '<h4><liferay-ui:message key="data-validation-header" /> </h4>',
		    bodyContent: A.one("#validationDiv"),
		    centered: true,
		    destroyOnHide: false,
		    modal: true,
		    render: '#validationModal',
		    resizable: {
		      handles: 'b, r'
		    },
		    visible: false,
		    width: 600
	});

</aui:script>
		  
<div class="yui3-skin-sam">
<div id="caregiverModal"></div>
</div>

<div id="caregiverDiv" class="yui3-skin-sam">
	<div id="caregiverResult">

	<div id="cgErrorSection" ></div>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass=" ${cssClass}"  >
			<aui:input label="primary-cg" name="primaryCG" type="checkbox" value="false" /><br/>
			<aui:input label="secondary-cg" name="secondaryCG" type="checkbox" value="false" /><br>
			<aui:input label="secondary-two-cg" name="secondaryTwoCG" type="checkbox" value="false" />
		</aui:field-wrapper>

		<div class="clear-both">
			<button type="button" id="submitCGSelection" class="btn btn-primary" >Ok</button>
		</div>	
	</div>
</div>


<div class="yui3-skin-sam">
	<div id="validationModal"></div>
</div>

<div id="validationDiv" class="yui3-skin-sam">	
	<div id="veteranValidationResult"></div>
	<div id="primaryValidationResult"></div>
	<div id="secondaryValidationResult"></div>
	<div id="secondaryTwoValidationResult"></div>
</div>


<c:set var="isDisabled" value="${false}" />	
<%@include file="/jsp/internal/searchPerson.jsp" %>
<c:set var="isDisabled" value="${true}" />	

<%@include file="/jsp/version.jsp" %>

	