<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>

<%@include file="/jsp/init.jsp" %>

<!-- %@include file="/jsp/online/console.jsp" % -->

<div class="yui3-skin-sam">
    <div id="modal"></div>
</div>

<%@include file="/jsp/internal/menu.jsp" %>



<div id="mainTab">
  <ul class="nav nav-tabs">
    <li class="active"><a href="#tab-1">${role} Dashboard<!-- ${facilityNumber} --></a></li>
    <li id="vcgs"><a href="#tab-2">Search</a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-1" class="tab-pane">
      	<div class="dashboard-top">
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse1">
			      	<legend class="header toggler-header-expanded">My Work</legend>
			      	<div class="content toggler-header-expanded window-overwrite" >
						<%@include file="/jsp/internal/myApplicationWork.jsp" %>
					</div>
				</fieldset>
      		</div>
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse2">
		      		<legend class="header toggler-header-expanded">Messaging</legend>
		      		<div class="content toggler-header-expanded window-overwrite" >
	      				<%@include file="/jsp/internal/myMessages.jsp" %>
	      			</div>
      			</fieldset>
      		</div>
      	</div>
      	
      	<fieldset id="sectionCollapse3" class="clear-both">
			<legend class="header toggler-header-expanded">${facilityName}</legend>
			   <div id="midTabs" class="content toggler-header-expanded" >
					<ul class="nav nav-tabs">
					
					    <li class="lazy-load" ><a href="#unassignedWork">Unassigned (<c:if test="${ ! empty FILTERED['unassignedWork']}">*</c:if><span id='total_unassignedWork'>${total_['unassignedWork']}</span>)</a></li>
					    <li class="lazy-load" ><a href="#overdueApps">Unassigned Overdue (<span id='total_overdueApps'>${total_['overdueApps']}</span>)</a></li>
					    <li class="lazy-load" ><a href="#inProcess">In Process (<span id='total_inProcess'>${total_['inProcess']}</span>)</a></li>
					    <li class="lazy-load" ><a href="#dueTodayWork">Due Today (<span id='total_dueTodayWork'>${total_['dueTodayWork']}</span>)</a></li>
					    <li class="lazy-load" ><a href="#overdueInProcess">Overdue (<c:if test="${ ! empty FILTERED['overdueInProcess']}">*</c:if><span id='total_overdueInProcess'>${total_['overdueInProcess']}</span>)</a></li>
					    <li class="lazy-load" ><a href="#newApplications">New (<span id='total_newApplications'>${total_['newApplications']}</span>)</a></li>
					    <li class="lazy-load" ><a href="#transferred">Transferred (<span id='total_transferred'>${total_['transferred']}</span>)</a></li>
						<li class="lazy-load" ><a href="#referrals">Referrals (<span id='total_referrals'>${total_['referrals']}</span>)</a></li>
					    <li class="lazy-load" ><a href="#homeVisit">Home Visit Due (<span id='total_homeVisit'>${total_['homeVisit']}</span>)</a></li>
					    <li class="lazy-load" ><a href="#deathNotice">Death Notice (<span id='total_deathNotice'>${total_['deathNotice']}</span>)</a></li>
					    <li class="lazy-load" ><a href="#vcgNotifications">VCG Notifications (<span id='total_vcgNotifications'>${total_['vcgNotifications']}</span>)</a></li>
					    <li class="lazy-load" ><a href="#tiuNoteRewrite">TUI Rewrite (<span id='total_tiuNoteRewrite'>${total_['tiuNoteRewrite']}</span>)</a></li>
					
					</ul>
					<div class="tab-content">
						<div id="unassignedWork" class="tab-pane"></div>
						<div id="overdueApps" class="tab-pane"></div>
						<div id="inProcess" class="tab-pane"></div>
						<div id="dueTodayWork" class="tab-pane"></div>
						<div id="overdueInProcess" class="tab-pane"></div>
						<div id="newApplications" class="tab-pane"></div>
						<div id="transferred" class="tab-pane"></div>
						<div id="referrals" class="tab-pane"></div>
						<div id="homeVisit" class="tab-pane"></div>
						<div id="deathNotice" class="tab-pane"></div>
						<div id="vcgNotifications" class="tab-pane"></div>
						<div id="tiuNoteRewrite" class="tab-pane"></div>
						
					</div>
				</div>
		  </fieldset>
		  
	
		  
	  	<fieldset  id="sectionCollapse4" class="clear-both">
			<legend class="header toggler-header-expanded">My CBOPC Work Items</legend>
			<div id="informationChange" class="tab-pane loaded-pane window-overwrite">
			  	<%@include file="/jsp/internal/informationChange.jsp" %>
			</div>
		</fieldset>
    </div>

    <div id="tab-2" class="tab-pane">
		<%@include file="/jsp/internal/filter.jsp" %>
	</div>
  </div>

</div>


<aui:script use="aui-tabview,aui-modal,aui-dropdown,aui-toggler,node-event-simulate">
	
	for ( i = 1 ; i < 5; i++ ){
	    new A.TogglerDelegate(
	      {
	        animated: true,
	        container: '#sectionCollapse' + i ,
	        content: '.content',
	        expanded: true,
	        header: '.header',
	        transition: {
	          duration: 0.2,
	          easing: 'cubic-bezier(0, 0.1, 0, 1)'
	        }
	      }
	    );
	}

	A.all('.close-window').on(
	 'click',
	  function() {
		modal.hide();	    	  
	  }
	);
	    
    A.all('.view-application').on(
      'click',
      function(e) {	
			modal.render();
        	modal.show();
        	// A.one ('#<portlet:namespace/>placeHolder').val( e.currentTarget.attr('id') );
      }
    );
    
    window.bottomTabs = new A.TabView({
        srcNode: '#bottomTabs',
        type: 'pills'
      }
    );
    window.bottomTabs.render();
    
    
    window.midTabs = new A.TabView({
        srcNode: '#midTabs',
        type: 'pills',
        on: {
            click: function(e) {
            	var href = e.currentTarget.getActiveTab().one('a').attr('href')
     	    	var page = href.substring(href.indexOf('#'));
      			var node = A.one( page );
     	    	if (node.hasClass('loaded-pane')){
     	    		return false;
     	    	}
	
      			window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /></portlet:resourceURL>', 'html', 
      				{ page: page },
      				function( data ){
      					overwrite( node, data );
      				} 
      			);
            }
          }
       
      }      
    );
    window.midTabs.render();
    
    

  window.careTmainTab = new A.TabView({
      srcNode: '#mainTab',
      type: 'pills'
    }
  );
  window.careTmainTab.render();
  
  A.on('domready', function( event ) {
   	try {
   		A.one('#unassignedWork').simulate('click');
   	} catch (e){}
   });
  
</aui:script>

<%@include file="/jsp/internal/actionsSupport.jsp" %>