package gov.va.caret.view;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.ParamUtil;

import gov.va.caret.model.AudLg;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.impl.AudLgImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.impl.VcgImpl;
import gov.va.caret.model.support.AuditLogSupport;
import gov.va.caret.service.AudLgLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.portlet.PortletRequest;

public class CachedReport extends GenericReport {

	public CachedReport(String reportName) {
		super(reportName);
	}
	
	
	//TODO: make this flexible for any search
	public void run ( PortletRequest request, boolean loadFromParams, int start, int end ){
		
		List report ;
		if ( "vcgs".equals( getName( )) ){
			report = getVcgList ( request, start, end );
		} else if ( "persnAudit".equals( getName() ) ){
			report = getPersnAudit ( request, start, end );
		} else {
			report = Collections.emptyList();
		}
		 
	 	ResultMap.getResultListMap( request ).put( getName(), report );
		ResultMap.getResultTotalMap( request ).put( getName(), report.size() );

		ResultMap.getResultOrderDeltaMap( request ).put(getName(), end == 0 ? SearchContainer.DEFAULT_DELTA : start-end );
//		ResultMap.getResultOrderColumnMap( request ).put( getName(), orderByCol );
//		ResultMap.getResultOrderTypeMap( request ).put( getName(), isDesc? "desc": "asc" );
		ResultMap.getResultFilteredMap( request ).put( getName(), getFiltered() );
		 
		 
	}
	
	private List getPersnAudit(PortletRequest request, int start, int end) {
		DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( AudLgImpl.class, PortletClassLoaderUtil.getClassLoader() );
		dynamicQuery.add( PropertyFactoryUtil.forName( "classPk" ).eq( ParamUtil.getLong(request, CaretStrPool.PERSN_ID ) ) )
//					.add( PropertyFactoryUtil.forName("oldValue").ne( CaretStrPool.EMPTY_ASSET ) );
		.addOrder( OrderFactoryUtil.desc("modifiedDate") );
		List report = new ArrayList();
		try {
			List<AudLg> list = (List<AudLg>) AudLgLocalServiceUtil.dynamicQuery( dynamicQuery );
			for ( AudLg audLg:  list ){
				report.add( new AuditLogSupport(audLg) );
			}
		} catch (SystemException e) {
			e.printStackTrace();
		}
		return report;
	}


	public List getVcgList ( PortletRequest request, int start, int end ) {
		
		String firstName = request.getParameter("firstName");
		String lastName = request.getParameter("lastName");
		String ssn = request.getParameter("ssn");
		String birthDate = request.getParameter("birthDate");
		String groupId = request.getParameter("userOrgIds");
		String zip = request.getParameter("zip");//[userOrgIds, lastName, zip, page, primaryKey, ssn, action, birthDate, firstName, fromParameter]
		String roleName = request.getParameter("roleName");
		if ( roleName == null && request.getParameter("roleId") != null ){
			int roleId = ParamUtil.getInteger(request, "roleId", 0);
			switch(roleId){
			case 1: roleName = "veteran"; break;
			case 2: roleName = "primary"; break;
			case 3: roleName = "secondary"; break;
			case 4: roleName = "secondaryTwo"; break;
			default:				
			}
		}
		String primaryKey = request.getParameter("primaryKey");
		
		boolean persnSet = false;
		
		 DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( PersnImpl.class, PortletClassLoaderUtil.getClassLoader() );
		 if ( ! firstName.isEmpty() ){
			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.FIRSTNAME).eq(firstName) );
			 persnSet = true;
		 }
		 
		 if ( ! lastName.isEmpty() ){
			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.LASTNAME).eq(lastName) );
			 persnSet = true;
		 }
		 
//		 if ( ! ssn.isEmpty() ){
//			 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.SSN).eq(ssn) );
//			 persnSet = true;
//		 }

		 Collection inList = Collections.emptyList();
		 
		 if ( persnSet ){
			 dynamicQuery.add( PropertyFactoryUtil.forName("status").eq(CaretStrPool.ACTIVE_VCG) );
			 dynamicQuery.setProjection( PropertyFactoryUtil.forName("persnId") );
			 try {
				inList = PersnLocalServiceUtil.dynamicQuery(dynamicQuery);
			} catch (SystemException e) {
				e.printStackTrace();
			}
		 }
		 
		 if ( ! inList.isEmpty() ){
			 List report = new ArrayList();
			 DynamicQuery dq = DynamicQueryFactoryUtil.forClass( VcgImpl.class, PortletClassLoaderUtil.getClassLoader() );
			 try {
				for ( Vcg vcg : (List<Vcg>)VcgLocalServiceUtil.dynamicQuery( dq.add(PropertyFactoryUtil.forName(roleName + "Id").in( inList) ) ) ){
					report.add( new gov.va.caret.model.support.VcgSupport(vcg) );
				}
				return report;
			} catch (SystemException e) {
				e.printStackTrace();
			}
		 }
		 return Collections.emptyList(); 
	}

	@Override
	public boolean isLazy(){
		return true;
	}
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

}
