package gov.va.caret.util;

import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class DateFormatMetadataThreadLocal<T> extends ThreadLocal<T> {

	private final SimpleDateFormat dateTimeFormat = new SimpleDateFormat(Toolbox.CARET_DATETIME_METADATA_FORMAT);
	
	{
		dateTimeFormat.setTimeZone(TimeZone.getTimeZone("America/New_York"));
	}
	
	protected T initialValue() {
        @SuppressWarnings("unchecked")
		T dateTimeFormat2 = (T) dateTimeFormat;
		return dateTimeFormat2;
    }

}
