package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchStiRdException;
import gov.va.caret.model.StiRd;
import gov.va.caret.model.impl.StiRdImpl;
import gov.va.caret.model.impl.StiRdModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the sti rd service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see StiRdPersistence
 * @see StiRdUtil
 * @generated
 */
public class StiRdPersistenceImpl extends BasePersistenceImpl<StiRd>
    implements StiRdPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link StiRdUtil} to access the sti rd persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = StiRdImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(StiRdModelImpl.ENTITY_CACHE_ENABLED,
            StiRdModelImpl.FINDER_CACHE_ENABLED, StiRdImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(StiRdModelImpl.ENTITY_CACHE_ENABLED,
            StiRdModelImpl.FINDER_CACHE_ENABLED, StiRdImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(StiRdModelImpl.ENTITY_CACHE_ENABLED,
            StiRdModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_VCGANID = new FinderPath(StiRdModelImpl.ENTITY_CACHE_ENABLED,
            StiRdModelImpl.FINDER_CACHE_ENABLED, StiRdImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByVcgAnId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGANID =
        new FinderPath(StiRdModelImpl.ENTITY_CACHE_ENABLED,
            StiRdModelImpl.FINDER_CACHE_ENABLED, StiRdImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByVcgAnId",
            new String[] { Long.class.getName() },
            StiRdModelImpl.VCGANID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_VCGANID = new FinderPath(StiRdModelImpl.ENTITY_CACHE_ENABLED,
            StiRdModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByVcgAnId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_VCGANID_VCGANID_2 = "stiRd.vcgAnId = ?";
    private static final String _SQL_SELECT_STIRD = "SELECT stiRd FROM StiRd stiRd";
    private static final String _SQL_SELECT_STIRD_WHERE = "SELECT stiRd FROM StiRd stiRd WHERE ";
    private static final String _SQL_COUNT_STIRD = "SELECT COUNT(stiRd) FROM StiRd stiRd";
    private static final String _SQL_COUNT_STIRD_WHERE = "SELECT COUNT(stiRd) FROM StiRd stiRd WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "stiRd.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No StiRd exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No StiRd exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(StiRdPersistenceImpl.class);
    private static StiRd _nullStiRd = new StiRdImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<StiRd> toCacheModel() {
                return _nullStiRdCacheModel;
            }
        };

    private static CacheModel<StiRd> _nullStiRdCacheModel = new CacheModel<StiRd>() {
            @Override
            public StiRd toEntityModel() {
                return _nullStiRd;
            }
        };

    public StiRdPersistenceImpl() {
        setModelClass(StiRd.class);
    }

    /**
     * Returns all the sti rds where vcgAnId = &#63;.
     *
     * @param vcgAnId the vcg an ID
     * @return the matching sti rds
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiRd> findByVcgAnId(long vcgAnId) throws SystemException {
        return findByVcgAnId(vcgAnId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the sti rds where vcgAnId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiRdModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param vcgAnId the vcg an ID
     * @param start the lower bound of the range of sti rds
     * @param end the upper bound of the range of sti rds (not inclusive)
     * @return the range of matching sti rds
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiRd> findByVcgAnId(long vcgAnId, int start, int end)
        throws SystemException {
        return findByVcgAnId(vcgAnId, start, end, null);
    }

    /**
     * Returns an ordered range of all the sti rds where vcgAnId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiRdModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param vcgAnId the vcg an ID
     * @param start the lower bound of the range of sti rds
     * @param end the upper bound of the range of sti rds (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching sti rds
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiRd> findByVcgAnId(long vcgAnId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGANID;
            finderArgs = new Object[] { vcgAnId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_VCGANID;
            finderArgs = new Object[] { vcgAnId, start, end, orderByComparator };
        }

        List<StiRd> list = (List<StiRd>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (StiRd stiRd : list) {
                if ((vcgAnId != stiRd.getVcgAnId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_STIRD_WHERE);

            query.append(_FINDER_COLUMN_VCGANID_VCGANID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(StiRdModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(vcgAnId);

                if (!pagination) {
                    list = (List<StiRd>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<StiRd>(list);
                } else {
                    list = (List<StiRd>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first sti rd in the ordered set where vcgAnId = &#63;.
     *
     * @param vcgAnId the vcg an ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching sti rd
     * @throws gov.va.caret.NoSuchStiRdException if a matching sti rd could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiRd findByVcgAnId_First(long vcgAnId,
        OrderByComparator orderByComparator)
        throws NoSuchStiRdException, SystemException {
        StiRd stiRd = fetchByVcgAnId_First(vcgAnId, orderByComparator);

        if (stiRd != null) {
            return stiRd;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("vcgAnId=");
        msg.append(vcgAnId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchStiRdException(msg.toString());
    }

    /**
     * Returns the first sti rd in the ordered set where vcgAnId = &#63;.
     *
     * @param vcgAnId the vcg an ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching sti rd, or <code>null</code> if a matching sti rd could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiRd fetchByVcgAnId_First(long vcgAnId,
        OrderByComparator orderByComparator) throws SystemException {
        List<StiRd> list = findByVcgAnId(vcgAnId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last sti rd in the ordered set where vcgAnId = &#63;.
     *
     * @param vcgAnId the vcg an ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching sti rd
     * @throws gov.va.caret.NoSuchStiRdException if a matching sti rd could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiRd findByVcgAnId_Last(long vcgAnId,
        OrderByComparator orderByComparator)
        throws NoSuchStiRdException, SystemException {
        StiRd stiRd = fetchByVcgAnId_Last(vcgAnId, orderByComparator);

        if (stiRd != null) {
            return stiRd;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("vcgAnId=");
        msg.append(vcgAnId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchStiRdException(msg.toString());
    }

    /**
     * Returns the last sti rd in the ordered set where vcgAnId = &#63;.
     *
     * @param vcgAnId the vcg an ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching sti rd, or <code>null</code> if a matching sti rd could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiRd fetchByVcgAnId_Last(long vcgAnId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByVcgAnId(vcgAnId);

        if (count == 0) {
            return null;
        }

        List<StiRd> list = findByVcgAnId(vcgAnId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the sti rds before and after the current sti rd in the ordered set where vcgAnId = &#63;.
     *
     * @param stiRdId the primary key of the current sti rd
     * @param vcgAnId the vcg an ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next sti rd
     * @throws gov.va.caret.NoSuchStiRdException if a sti rd with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiRd[] findByVcgAnId_PrevAndNext(long stiRdId, long vcgAnId,
        OrderByComparator orderByComparator)
        throws NoSuchStiRdException, SystemException {
        StiRd stiRd = findByPrimaryKey(stiRdId);

        Session session = null;

        try {
            session = openSession();

            StiRd[] array = new StiRdImpl[3];

            array[0] = getByVcgAnId_PrevAndNext(session, stiRd, vcgAnId,
                    orderByComparator, true);

            array[1] = stiRd;

            array[2] = getByVcgAnId_PrevAndNext(session, stiRd, vcgAnId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected StiRd getByVcgAnId_PrevAndNext(Session session, StiRd stiRd,
        long vcgAnId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_STIRD_WHERE);

        query.append(_FINDER_COLUMN_VCGANID_VCGANID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(StiRdModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(vcgAnId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(stiRd);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<StiRd> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the sti rds where vcgAnId = &#63; from the database.
     *
     * @param vcgAnId the vcg an ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByVcgAnId(long vcgAnId) throws SystemException {
        for (StiRd stiRd : findByVcgAnId(vcgAnId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(stiRd);
        }
    }

    /**
     * Returns the number of sti rds where vcgAnId = &#63;.
     *
     * @param vcgAnId the vcg an ID
     * @return the number of matching sti rds
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByVcgAnId(long vcgAnId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_VCGANID;

        Object[] finderArgs = new Object[] { vcgAnId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_STIRD_WHERE);

            query.append(_FINDER_COLUMN_VCGANID_VCGANID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(vcgAnId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the sti rd in the entity cache if it is enabled.
     *
     * @param stiRd the sti rd
     */
    @Override
    public void cacheResult(StiRd stiRd) {
        EntityCacheUtil.putResult(StiRdModelImpl.ENTITY_CACHE_ENABLED,
            StiRdImpl.class, stiRd.getPrimaryKey(), stiRd);

        stiRd.resetOriginalValues();
    }

    /**
     * Caches the sti rds in the entity cache if it is enabled.
     *
     * @param stiRds the sti rds
     */
    @Override
    public void cacheResult(List<StiRd> stiRds) {
        for (StiRd stiRd : stiRds) {
            if (EntityCacheUtil.getResult(StiRdModelImpl.ENTITY_CACHE_ENABLED,
                        StiRdImpl.class, stiRd.getPrimaryKey()) == null) {
                cacheResult(stiRd);
            } else {
                stiRd.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all sti rds.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(StiRdImpl.class.getName());
        }

        EntityCacheUtil.clearCache(StiRdImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the sti rd.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(StiRd stiRd) {
        EntityCacheUtil.removeResult(StiRdModelImpl.ENTITY_CACHE_ENABLED,
            StiRdImpl.class, stiRd.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<StiRd> stiRds) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (StiRd stiRd : stiRds) {
            EntityCacheUtil.removeResult(StiRdModelImpl.ENTITY_CACHE_ENABLED,
                StiRdImpl.class, stiRd.getPrimaryKey());
        }
    }

    /**
     * Creates a new sti rd with the primary key. Does not add the sti rd to the database.
     *
     * @param stiRdId the primary key for the new sti rd
     * @return the new sti rd
     */
    @Override
    public StiRd create(long stiRdId) {
        StiRd stiRd = new StiRdImpl();

        stiRd.setNew(true);
        stiRd.setPrimaryKey(stiRdId);

        return stiRd;
    }

    /**
     * Removes the sti rd with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param stiRdId the primary key of the sti rd
     * @return the sti rd that was removed
     * @throws gov.va.caret.NoSuchStiRdException if a sti rd with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiRd remove(long stiRdId)
        throws NoSuchStiRdException, SystemException {
        return remove((Serializable) stiRdId);
    }

    /**
     * Removes the sti rd with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the sti rd
     * @return the sti rd that was removed
     * @throws gov.va.caret.NoSuchStiRdException if a sti rd with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiRd remove(Serializable primaryKey)
        throws NoSuchStiRdException, SystemException {
        Session session = null;

        try {
            session = openSession();

            StiRd stiRd = (StiRd) session.get(StiRdImpl.class, primaryKey);

            if (stiRd == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchStiRdException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(stiRd);
        } catch (NoSuchStiRdException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected StiRd removeImpl(StiRd stiRd) throws SystemException {
        stiRd = toUnwrappedModel(stiRd);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(stiRd)) {
                stiRd = (StiRd) session.get(StiRdImpl.class,
                        stiRd.getPrimaryKeyObj());
            }

            if (stiRd != null) {
                session.delete(stiRd);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (stiRd != null) {
            clearCache(stiRd);
        }

        return stiRd;
    }

    @Override
    public StiRd updateImpl(gov.va.caret.model.StiRd stiRd)
        throws SystemException {
        stiRd = toUnwrappedModel(stiRd);

        boolean isNew = stiRd.isNew();

        StiRdModelImpl stiRdModelImpl = (StiRdModelImpl) stiRd;

        Session session = null;

        try {
            session = openSession();

            if (stiRd.isNew()) {
                session.save(stiRd);

                stiRd.setNew(false);
            } else {
                session.merge(stiRd);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !StiRdModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((stiRdModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGANID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { stiRdModelImpl.getOriginalVcgAnId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VCGANID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGANID,
                    args);

                args = new Object[] { stiRdModelImpl.getVcgAnId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VCGANID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VCGANID,
                    args);
            }
        }

        EntityCacheUtil.putResult(StiRdModelImpl.ENTITY_CACHE_ENABLED,
            StiRdImpl.class, stiRd.getPrimaryKey(), stiRd);

        return stiRd;
    }

    protected StiRd toUnwrappedModel(StiRd stiRd) {
        if (stiRd instanceof StiRdImpl) {
            return stiRd;
        }

        StiRdImpl stiRdImpl = new StiRdImpl();

        stiRdImpl.setNew(stiRd.isNew());
        stiRdImpl.setPrimaryKey(stiRd.getPrimaryKey());

        stiRdImpl.setStiRdId(stiRd.getStiRdId());
        stiRdImpl.setVcgAnId(stiRd.getVcgAnId());
        stiRdImpl.setCscStatus(stiRd.getCscStatus());
        stiRdImpl.setCscStatusDate(stiRd.getCscStatusDate());
        stiRdImpl.setCbopcStatus(stiRd.getCbopcStatus());
        stiRdImpl.setCbopcStatusDate(stiRd.getCbopcStatusDate());
        stiRdImpl.setCreationDate(stiRd.getCreationDate());
        stiRdImpl.setUserId(stiRd.getUserId());
        stiRdImpl.setGroupId(stiRd.getGroupId());

        return stiRdImpl;
    }

    /**
     * Returns the sti rd with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the sti rd
     * @return the sti rd
     * @throws gov.va.caret.NoSuchStiRdException if a sti rd with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiRd findByPrimaryKey(Serializable primaryKey)
        throws NoSuchStiRdException, SystemException {
        StiRd stiRd = fetchByPrimaryKey(primaryKey);

        if (stiRd == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchStiRdException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return stiRd;
    }

    /**
     * Returns the sti rd with the primary key or throws a {@link gov.va.caret.NoSuchStiRdException} if it could not be found.
     *
     * @param stiRdId the primary key of the sti rd
     * @return the sti rd
     * @throws gov.va.caret.NoSuchStiRdException if a sti rd with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiRd findByPrimaryKey(long stiRdId)
        throws NoSuchStiRdException, SystemException {
        return findByPrimaryKey((Serializable) stiRdId);
    }

    /**
     * Returns the sti rd with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the sti rd
     * @return the sti rd, or <code>null</code> if a sti rd with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiRd fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        StiRd stiRd = (StiRd) EntityCacheUtil.getResult(StiRdModelImpl.ENTITY_CACHE_ENABLED,
                StiRdImpl.class, primaryKey);

        if (stiRd == _nullStiRd) {
            return null;
        }

        if (stiRd == null) {
            Session session = null;

            try {
                session = openSession();

                stiRd = (StiRd) session.get(StiRdImpl.class, primaryKey);

                if (stiRd != null) {
                    cacheResult(stiRd);
                } else {
                    EntityCacheUtil.putResult(StiRdModelImpl.ENTITY_CACHE_ENABLED,
                        StiRdImpl.class, primaryKey, _nullStiRd);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(StiRdModelImpl.ENTITY_CACHE_ENABLED,
                    StiRdImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return stiRd;
    }

    /**
     * Returns the sti rd with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param stiRdId the primary key of the sti rd
     * @return the sti rd, or <code>null</code> if a sti rd with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public StiRd fetchByPrimaryKey(long stiRdId) throws SystemException {
        return fetchByPrimaryKey((Serializable) stiRdId);
    }

    /**
     * Returns all the sti rds.
     *
     * @return the sti rds
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiRd> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the sti rds.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiRdModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of sti rds
     * @param end the upper bound of the range of sti rds (not inclusive)
     * @return the range of sti rds
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiRd> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the sti rds.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.StiRdModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of sti rds
     * @param end the upper bound of the range of sti rds (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of sti rds
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<StiRd> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<StiRd> list = (List<StiRd>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_STIRD);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_STIRD;

                if (pagination) {
                    sql = sql.concat(StiRdModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<StiRd>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<StiRd>(list);
                } else {
                    list = (List<StiRd>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the sti rds from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (StiRd stiRd : findAll()) {
            remove(stiRd);
        }
    }

    /**
     * Returns the number of sti rds.
     *
     * @return the number of sti rds
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_STIRD);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the sti rd persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.StiRd")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<StiRd>> listenersList = new ArrayList<ModelListener<StiRd>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<StiRd>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(StiRdImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
