package gov.va.caret.service.persistence;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsKeys;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;

import gov.va.caret.NoSuchCallException;
import gov.va.caret.model.Call;
import gov.va.caret.model.impl.CallImpl;
import gov.va.caret.model.impl.CallModelImpl;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * The persistence implementation for the call service.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author caret
 * @see CallPersistence
 * @see CallUtil
 * @generated
 */
public class CallPersistenceImpl extends BasePersistenceImpl<Call>
    implements CallPersistence {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link CallUtil} to access the call persistence. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
     */
    public static final String FINDER_CLASS_NAME_ENTITY = CallImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY +
        ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, CallImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, CallImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_CREATEGROUPID =
        new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, CallImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCreateGroupId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CREATEGROUPID =
        new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, CallImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCreateGroupId",
            new String[] { Long.class.getName() },
            CallModelImpl.CREATEGROUPID_COLUMN_BITMASK |
            CallModelImpl.CREATIONDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_CREATEGROUPID = new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCreateGroupId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_CREATEGROUPID_CREATEGROUPID_2 = "call.createGroupId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_CALLERPERSNID =
        new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, CallImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCallerPersnId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLERPERSNID =
        new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, CallImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCallerPersnId",
            new String[] { Long.class.getName() },
            CallModelImpl.CALLERPERSNID_COLUMN_BITMASK |
            CallModelImpl.CREATIONDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_CALLERPERSNID = new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCallerPersnId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_CALLERPERSNID_CALLERPERSNID_2 = "call.callerPersnId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_VETERANPERSNID =
        new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, CallImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByVeteranPersnId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VETERANPERSNID =
        new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, CallImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByVeteranPersnId",
            new String[] { Long.class.getName() },
            CallModelImpl.VETERANPERSNID_COLUMN_BITMASK |
            CallModelImpl.CREATIONDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_VETERANPERSNID = new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByVeteranPersnId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_VETERANPERSNID_VETERANPERSNID_2 = "call.veteranPersnId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_USERID = new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, CallImpl.class,
            FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId",
            new String[] {
                Long.class.getName(),
                
            Integer.class.getName(), Integer.class.getName(),
                OrderByComparator.class.getName()
            });
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID =
        new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, CallImpl.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId",
            new String[] { Long.class.getName() },
            CallModelImpl.USERID_COLUMN_BITMASK |
            CallModelImpl.CREATIONDATE_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_USERID = new FinderPath(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallModelImpl.FINDER_CACHE_ENABLED, Long.class,
            FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId",
            new String[] { Long.class.getName() });
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "call.userId = ?";
    private static final String _SQL_SELECT_CALL = "SELECT call FROM Call call";
    private static final String _SQL_SELECT_CALL_WHERE = "SELECT call FROM Call call WHERE ";
    private static final String _SQL_COUNT_CALL = "SELECT COUNT(call) FROM Call call";
    private static final String _SQL_COUNT_CALL_WHERE = "SELECT COUNT(call) FROM Call call WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "call.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Call exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Call exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = GetterUtil.getBoolean(PropsUtil.get(
                PropsKeys.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE));
    private static Log _log = LogFactoryUtil.getLog(CallPersistenceImpl.class);
    private static Call _nullCall = new CallImpl() {
            @Override
            public Object clone() {
                return this;
            }

            @Override
            public CacheModel<Call> toCacheModel() {
                return _nullCallCacheModel;
            }
        };

    private static CacheModel<Call> _nullCallCacheModel = new CacheModel<Call>() {
            @Override
            public Call toEntityModel() {
                return _nullCall;
            }
        };

    public CallPersistenceImpl() {
        setModelClass(Call.class);
    }

    /**
     * Returns all the calls where createGroupId = &#63;.
     *
     * @param createGroupId the create group ID
     * @return the matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findByCreateGroupId(long createGroupId)
        throws SystemException {
        return findByCreateGroupId(createGroupId, QueryUtil.ALL_POS,
            QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the calls where createGroupId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param createGroupId the create group ID
     * @param start the lower bound of the range of calls
     * @param end the upper bound of the range of calls (not inclusive)
     * @return the range of matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findByCreateGroupId(long createGroupId, int start, int end)
        throws SystemException {
        return findByCreateGroupId(createGroupId, start, end, null);
    }

    /**
     * Returns an ordered range of all the calls where createGroupId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param createGroupId the create group ID
     * @param start the lower bound of the range of calls
     * @param end the upper bound of the range of calls (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findByCreateGroupId(long createGroupId, int start,
        int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CREATEGROUPID;
            finderArgs = new Object[] { createGroupId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_CREATEGROUPID;
            finderArgs = new Object[] {
                    createGroupId,
                    
                    start, end, orderByComparator
                };
        }

        List<Call> list = (List<Call>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Call call : list) {
                if ((createGroupId != call.getCreateGroupId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_CALL_WHERE);

            query.append(_FINDER_COLUMN_CREATEGROUPID_CREATEGROUPID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(CallModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(createGroupId);

                if (!pagination) {
                    list = (List<Call>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Call>(list);
                } else {
                    list = (List<Call>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first call in the ordered set where createGroupId = &#63;.
     *
     * @param createGroupId the create group ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching call
     * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call findByCreateGroupId_First(long createGroupId,
        OrderByComparator orderByComparator)
        throws NoSuchCallException, SystemException {
        Call call = fetchByCreateGroupId_First(createGroupId, orderByComparator);

        if (call != null) {
            return call;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("createGroupId=");
        msg.append(createGroupId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchCallException(msg.toString());
    }

    /**
     * Returns the first call in the ordered set where createGroupId = &#63;.
     *
     * @param createGroupId the create group ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching call, or <code>null</code> if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call fetchByCreateGroupId_First(long createGroupId,
        OrderByComparator orderByComparator) throws SystemException {
        List<Call> list = findByCreateGroupId(createGroupId, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last call in the ordered set where createGroupId = &#63;.
     *
     * @param createGroupId the create group ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching call
     * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call findByCreateGroupId_Last(long createGroupId,
        OrderByComparator orderByComparator)
        throws NoSuchCallException, SystemException {
        Call call = fetchByCreateGroupId_Last(createGroupId, orderByComparator);

        if (call != null) {
            return call;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("createGroupId=");
        msg.append(createGroupId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchCallException(msg.toString());
    }

    /**
     * Returns the last call in the ordered set where createGroupId = &#63;.
     *
     * @param createGroupId the create group ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching call, or <code>null</code> if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call fetchByCreateGroupId_Last(long createGroupId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByCreateGroupId(createGroupId);

        if (count == 0) {
            return null;
        }

        List<Call> list = findByCreateGroupId(createGroupId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the calls before and after the current call in the ordered set where createGroupId = &#63;.
     *
     * @param callId the primary key of the current call
     * @param createGroupId the create group ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next call
     * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call[] findByCreateGroupId_PrevAndNext(long callId,
        long createGroupId, OrderByComparator orderByComparator)
        throws NoSuchCallException, SystemException {
        Call call = findByPrimaryKey(callId);

        Session session = null;

        try {
            session = openSession();

            Call[] array = new CallImpl[3];

            array[0] = getByCreateGroupId_PrevAndNext(session, call,
                    createGroupId, orderByComparator, true);

            array[1] = call;

            array[2] = getByCreateGroupId_PrevAndNext(session, call,
                    createGroupId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Call getByCreateGroupId_PrevAndNext(Session session, Call call,
        long createGroupId, OrderByComparator orderByComparator,
        boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_CALL_WHERE);

        query.append(_FINDER_COLUMN_CREATEGROUPID_CREATEGROUPID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(CallModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(createGroupId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(call);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Call> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the calls where createGroupId = &#63; from the database.
     *
     * @param createGroupId the create group ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByCreateGroupId(long createGroupId)
        throws SystemException {
        for (Call call : findByCreateGroupId(createGroupId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(call);
        }
    }

    /**
     * Returns the number of calls where createGroupId = &#63;.
     *
     * @param createGroupId the create group ID
     * @return the number of matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByCreateGroupId(long createGroupId)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_CREATEGROUPID;

        Object[] finderArgs = new Object[] { createGroupId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_CALL_WHERE);

            query.append(_FINDER_COLUMN_CREATEGROUPID_CREATEGROUPID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(createGroupId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the calls where callerPersnId = &#63;.
     *
     * @param callerPersnId the caller persn ID
     * @return the matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findByCallerPersnId(long callerPersnId)
        throws SystemException {
        return findByCallerPersnId(callerPersnId, QueryUtil.ALL_POS,
            QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the calls where callerPersnId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param callerPersnId the caller persn ID
     * @param start the lower bound of the range of calls
     * @param end the upper bound of the range of calls (not inclusive)
     * @return the range of matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findByCallerPersnId(long callerPersnId, int start, int end)
        throws SystemException {
        return findByCallerPersnId(callerPersnId, start, end, null);
    }

    /**
     * Returns an ordered range of all the calls where callerPersnId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param callerPersnId the caller persn ID
     * @param start the lower bound of the range of calls
     * @param end the upper bound of the range of calls (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findByCallerPersnId(long callerPersnId, int start,
        int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLERPERSNID;
            finderArgs = new Object[] { callerPersnId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_CALLERPERSNID;
            finderArgs = new Object[] {
                    callerPersnId,
                    
                    start, end, orderByComparator
                };
        }

        List<Call> list = (List<Call>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Call call : list) {
                if ((callerPersnId != call.getCallerPersnId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_CALL_WHERE);

            query.append(_FINDER_COLUMN_CALLERPERSNID_CALLERPERSNID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(CallModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(callerPersnId);

                if (!pagination) {
                    list = (List<Call>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Call>(list);
                } else {
                    list = (List<Call>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first call in the ordered set where callerPersnId = &#63;.
     *
     * @param callerPersnId the caller persn ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching call
     * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call findByCallerPersnId_First(long callerPersnId,
        OrderByComparator orderByComparator)
        throws NoSuchCallException, SystemException {
        Call call = fetchByCallerPersnId_First(callerPersnId, orderByComparator);

        if (call != null) {
            return call;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("callerPersnId=");
        msg.append(callerPersnId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchCallException(msg.toString());
    }

    /**
     * Returns the first call in the ordered set where callerPersnId = &#63;.
     *
     * @param callerPersnId the caller persn ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching call, or <code>null</code> if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call fetchByCallerPersnId_First(long callerPersnId,
        OrderByComparator orderByComparator) throws SystemException {
        List<Call> list = findByCallerPersnId(callerPersnId, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last call in the ordered set where callerPersnId = &#63;.
     *
     * @param callerPersnId the caller persn ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching call
     * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call findByCallerPersnId_Last(long callerPersnId,
        OrderByComparator orderByComparator)
        throws NoSuchCallException, SystemException {
        Call call = fetchByCallerPersnId_Last(callerPersnId, orderByComparator);

        if (call != null) {
            return call;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("callerPersnId=");
        msg.append(callerPersnId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchCallException(msg.toString());
    }

    /**
     * Returns the last call in the ordered set where callerPersnId = &#63;.
     *
     * @param callerPersnId the caller persn ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching call, or <code>null</code> if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call fetchByCallerPersnId_Last(long callerPersnId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByCallerPersnId(callerPersnId);

        if (count == 0) {
            return null;
        }

        List<Call> list = findByCallerPersnId(callerPersnId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the calls before and after the current call in the ordered set where callerPersnId = &#63;.
     *
     * @param callId the primary key of the current call
     * @param callerPersnId the caller persn ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next call
     * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call[] findByCallerPersnId_PrevAndNext(long callId,
        long callerPersnId, OrderByComparator orderByComparator)
        throws NoSuchCallException, SystemException {
        Call call = findByPrimaryKey(callId);

        Session session = null;

        try {
            session = openSession();

            Call[] array = new CallImpl[3];

            array[0] = getByCallerPersnId_PrevAndNext(session, call,
                    callerPersnId, orderByComparator, true);

            array[1] = call;

            array[2] = getByCallerPersnId_PrevAndNext(session, call,
                    callerPersnId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Call getByCallerPersnId_PrevAndNext(Session session, Call call,
        long callerPersnId, OrderByComparator orderByComparator,
        boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_CALL_WHERE);

        query.append(_FINDER_COLUMN_CALLERPERSNID_CALLERPERSNID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(CallModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(callerPersnId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(call);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Call> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the calls where callerPersnId = &#63; from the database.
     *
     * @param callerPersnId the caller persn ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByCallerPersnId(long callerPersnId)
        throws SystemException {
        for (Call call : findByCallerPersnId(callerPersnId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(call);
        }
    }

    /**
     * Returns the number of calls where callerPersnId = &#63;.
     *
     * @param callerPersnId the caller persn ID
     * @return the number of matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByCallerPersnId(long callerPersnId)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_CALLERPERSNID;

        Object[] finderArgs = new Object[] { callerPersnId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_CALL_WHERE);

            query.append(_FINDER_COLUMN_CALLERPERSNID_CALLERPERSNID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(callerPersnId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the calls where veteranPersnId = &#63;.
     *
     * @param veteranPersnId the veteran persn ID
     * @return the matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findByVeteranPersnId(long veteranPersnId)
        throws SystemException {
        return findByVeteranPersnId(veteranPersnId, QueryUtil.ALL_POS,
            QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the calls where veteranPersnId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param veteranPersnId the veteran persn ID
     * @param start the lower bound of the range of calls
     * @param end the upper bound of the range of calls (not inclusive)
     * @return the range of matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findByVeteranPersnId(long veteranPersnId, int start,
        int end) throws SystemException {
        return findByVeteranPersnId(veteranPersnId, start, end, null);
    }

    /**
     * Returns an ordered range of all the calls where veteranPersnId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param veteranPersnId the veteran persn ID
     * @param start the lower bound of the range of calls
     * @param end the upper bound of the range of calls (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findByVeteranPersnId(long veteranPersnId, int start,
        int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VETERANPERSNID;
            finderArgs = new Object[] { veteranPersnId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_VETERANPERSNID;
            finderArgs = new Object[] {
                    veteranPersnId,
                    
                    start, end, orderByComparator
                };
        }

        List<Call> list = (List<Call>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Call call : list) {
                if ((veteranPersnId != call.getVeteranPersnId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_CALL_WHERE);

            query.append(_FINDER_COLUMN_VETERANPERSNID_VETERANPERSNID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(CallModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(veteranPersnId);

                if (!pagination) {
                    list = (List<Call>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Call>(list);
                } else {
                    list = (List<Call>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first call in the ordered set where veteranPersnId = &#63;.
     *
     * @param veteranPersnId the veteran persn ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching call
     * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call findByVeteranPersnId_First(long veteranPersnId,
        OrderByComparator orderByComparator)
        throws NoSuchCallException, SystemException {
        Call call = fetchByVeteranPersnId_First(veteranPersnId,
                orderByComparator);

        if (call != null) {
            return call;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("veteranPersnId=");
        msg.append(veteranPersnId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchCallException(msg.toString());
    }

    /**
     * Returns the first call in the ordered set where veteranPersnId = &#63;.
     *
     * @param veteranPersnId the veteran persn ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching call, or <code>null</code> if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call fetchByVeteranPersnId_First(long veteranPersnId,
        OrderByComparator orderByComparator) throws SystemException {
        List<Call> list = findByVeteranPersnId(veteranPersnId, 0, 1,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last call in the ordered set where veteranPersnId = &#63;.
     *
     * @param veteranPersnId the veteran persn ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching call
     * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call findByVeteranPersnId_Last(long veteranPersnId,
        OrderByComparator orderByComparator)
        throws NoSuchCallException, SystemException {
        Call call = fetchByVeteranPersnId_Last(veteranPersnId, orderByComparator);

        if (call != null) {
            return call;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("veteranPersnId=");
        msg.append(veteranPersnId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchCallException(msg.toString());
    }

    /**
     * Returns the last call in the ordered set where veteranPersnId = &#63;.
     *
     * @param veteranPersnId the veteran persn ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching call, or <code>null</code> if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call fetchByVeteranPersnId_Last(long veteranPersnId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByVeteranPersnId(veteranPersnId);

        if (count == 0) {
            return null;
        }

        List<Call> list = findByVeteranPersnId(veteranPersnId, count - 1,
                count, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the calls before and after the current call in the ordered set where veteranPersnId = &#63;.
     *
     * @param callId the primary key of the current call
     * @param veteranPersnId the veteran persn ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next call
     * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call[] findByVeteranPersnId_PrevAndNext(long callId,
        long veteranPersnId, OrderByComparator orderByComparator)
        throws NoSuchCallException, SystemException {
        Call call = findByPrimaryKey(callId);

        Session session = null;

        try {
            session = openSession();

            Call[] array = new CallImpl[3];

            array[0] = getByVeteranPersnId_PrevAndNext(session, call,
                    veteranPersnId, orderByComparator, true);

            array[1] = call;

            array[2] = getByVeteranPersnId_PrevAndNext(session, call,
                    veteranPersnId, orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Call getByVeteranPersnId_PrevAndNext(Session session, Call call,
        long veteranPersnId, OrderByComparator orderByComparator,
        boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_CALL_WHERE);

        query.append(_FINDER_COLUMN_VETERANPERSNID_VETERANPERSNID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(CallModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(veteranPersnId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(call);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Call> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the calls where veteranPersnId = &#63; from the database.
     *
     * @param veteranPersnId the veteran persn ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByVeteranPersnId(long veteranPersnId)
        throws SystemException {
        for (Call call : findByVeteranPersnId(veteranPersnId,
                QueryUtil.ALL_POS, QueryUtil.ALL_POS, null)) {
            remove(call);
        }
    }

    /**
     * Returns the number of calls where veteranPersnId = &#63;.
     *
     * @param veteranPersnId the veteran persn ID
     * @return the number of matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByVeteranPersnId(long veteranPersnId)
        throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_VETERANPERSNID;

        Object[] finderArgs = new Object[] { veteranPersnId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_CALL_WHERE);

            query.append(_FINDER_COLUMN_VETERANPERSNID_VETERANPERSNID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(veteranPersnId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Returns all the calls where userId = &#63;.
     *
     * @param userId the user ID
     * @return the matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findByUserId(long userId) throws SystemException {
        return findByUserId(userId, QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the calls where userId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param userId the user ID
     * @param start the lower bound of the range of calls
     * @param end the upper bound of the range of calls (not inclusive)
     * @return the range of matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findByUserId(long userId, int start, int end)
        throws SystemException {
        return findByUserId(userId, start, end, null);
    }

    /**
     * Returns an ordered range of all the calls where userId = &#63;.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param userId the user ID
     * @param start the lower bound of the range of calls
     * @param end the upper bound of the range of calls (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findByUserId(long userId, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID;
            finderArgs = new Object[] { userId };
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_USERID;
            finderArgs = new Object[] { userId, start, end, orderByComparator };
        }

        List<Call> list = (List<Call>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if ((list != null) && !list.isEmpty()) {
            for (Call call : list) {
                if ((userId != call.getUserId())) {
                    list = null;

                    break;
                }
            }
        }

        if (list == null) {
            StringBundler query = null;

            if (orderByComparator != null) {
                query = new StringBundler(3 +
                        (orderByComparator.getOrderByFields().length * 3));
            } else {
                query = new StringBundler(3);
            }

            query.append(_SQL_SELECT_CALL_WHERE);

            query.append(_FINDER_COLUMN_USERID_USERID_2);

            if (orderByComparator != null) {
                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);
            } else
             if (pagination) {
                query.append(CallModelImpl.ORDER_BY_JPQL);
            }

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(userId);

                if (!pagination) {
                    list = (List<Call>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Call>(list);
                } else {
                    list = (List<Call>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Returns the first call in the ordered set where userId = &#63;.
     *
     * @param userId the user ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching call
     * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call findByUserId_First(long userId,
        OrderByComparator orderByComparator)
        throws NoSuchCallException, SystemException {
        Call call = fetchByUserId_First(userId, orderByComparator);

        if (call != null) {
            return call;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("userId=");
        msg.append(userId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchCallException(msg.toString());
    }

    /**
     * Returns the first call in the ordered set where userId = &#63;.
     *
     * @param userId the user ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the first matching call, or <code>null</code> if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call fetchByUserId_First(long userId,
        OrderByComparator orderByComparator) throws SystemException {
        List<Call> list = findByUserId(userId, 0, 1, orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the last call in the ordered set where userId = &#63;.
     *
     * @param userId the user ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching call
     * @throws gov.va.caret.NoSuchCallException if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call findByUserId_Last(long userId,
        OrderByComparator orderByComparator)
        throws NoSuchCallException, SystemException {
        Call call = fetchByUserId_Last(userId, orderByComparator);

        if (call != null) {
            return call;
        }

        StringBundler msg = new StringBundler(4);

        msg.append(_NO_SUCH_ENTITY_WITH_KEY);

        msg.append("userId=");
        msg.append(userId);

        msg.append(StringPool.CLOSE_CURLY_BRACE);

        throw new NoSuchCallException(msg.toString());
    }

    /**
     * Returns the last call in the ordered set where userId = &#63;.
     *
     * @param userId the user ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the last matching call, or <code>null</code> if a matching call could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call fetchByUserId_Last(long userId,
        OrderByComparator orderByComparator) throws SystemException {
        int count = countByUserId(userId);

        if (count == 0) {
            return null;
        }

        List<Call> list = findByUserId(userId, count - 1, count,
                orderByComparator);

        if (!list.isEmpty()) {
            return list.get(0);
        }

        return null;
    }

    /**
     * Returns the calls before and after the current call in the ordered set where userId = &#63;.
     *
     * @param callId the primary key of the current call
     * @param userId the user ID
     * @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
     * @return the previous, current, and next call
     * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call[] findByUserId_PrevAndNext(long callId, long userId,
        OrderByComparator orderByComparator)
        throws NoSuchCallException, SystemException {
        Call call = findByPrimaryKey(callId);

        Session session = null;

        try {
            session = openSession();

            Call[] array = new CallImpl[3];

            array[0] = getByUserId_PrevAndNext(session, call, userId,
                    orderByComparator, true);

            array[1] = call;

            array[2] = getByUserId_PrevAndNext(session, call, userId,
                    orderByComparator, false);

            return array;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    protected Call getByUserId_PrevAndNext(Session session, Call call,
        long userId, OrderByComparator orderByComparator, boolean previous) {
        StringBundler query = null;

        if (orderByComparator != null) {
            query = new StringBundler(6 +
                    (orderByComparator.getOrderByFields().length * 6));
        } else {
            query = new StringBundler(3);
        }

        query.append(_SQL_SELECT_CALL_WHERE);

        query.append(_FINDER_COLUMN_USERID_USERID_2);

        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();

            if (orderByConditionFields.length > 0) {
                query.append(WHERE_AND);
            }

            for (int i = 0; i < orderByConditionFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);

                if ((i + 1) < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN_HAS_NEXT);
                    } else {
                        query.append(WHERE_LESSER_THAN_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(WHERE_GREATER_THAN);
                    } else {
                        query.append(WHERE_LESSER_THAN);
                    }
                }
            }

            query.append(ORDER_BY_CLAUSE);

            String[] orderByFields = orderByComparator.getOrderByFields();

            for (int i = 0; i < orderByFields.length; i++) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);

                if ((i + 1) < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC_HAS_NEXT);
                    } else {
                        query.append(ORDER_BY_DESC_HAS_NEXT);
                    }
                } else {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(ORDER_BY_ASC);
                    } else {
                        query.append(ORDER_BY_DESC);
                    }
                }
            }
        } else {
            query.append(CallModelImpl.ORDER_BY_JPQL);
        }

        String sql = query.toString();

        Query q = session.createQuery(sql);

        q.setFirstResult(0);
        q.setMaxResults(2);

        QueryPos qPos = QueryPos.getInstance(q);

        qPos.add(userId);

        if (orderByComparator != null) {
            Object[] values = orderByComparator.getOrderByConditionValues(call);

            for (Object value : values) {
                qPos.add(value);
            }
        }

        List<Call> list = q.list();

        if (list.size() == 2) {
            return list.get(1);
        } else {
            return null;
        }
    }

    /**
     * Removes all the calls where userId = &#63; from the database.
     *
     * @param userId the user ID
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeByUserId(long userId) throws SystemException {
        for (Call call : findByUserId(userId, QueryUtil.ALL_POS,
                QueryUtil.ALL_POS, null)) {
            remove(call);
        }
    }

    /**
     * Returns the number of calls where userId = &#63;.
     *
     * @param userId the user ID
     * @return the number of matching calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countByUserId(long userId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_USERID;

        Object[] finderArgs = new Object[] { userId };

        Long count = (Long) FinderCacheUtil.getResult(finderPath, finderArgs,
                this);

        if (count == null) {
            StringBundler query = new StringBundler(2);

            query.append(_SQL_COUNT_CALL_WHERE);

            query.append(_FINDER_COLUMN_USERID_USERID_2);

            String sql = query.toString();

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                QueryPos qPos = QueryPos.getInstance(q);

                qPos.add(userId);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Caches the call in the entity cache if it is enabled.
     *
     * @param call the call
     */
    @Override
    public void cacheResult(Call call) {
        EntityCacheUtil.putResult(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallImpl.class, call.getPrimaryKey(), call);

        call.resetOriginalValues();
    }

    /**
     * Caches the calls in the entity cache if it is enabled.
     *
     * @param calls the calls
     */
    @Override
    public void cacheResult(List<Call> calls) {
        for (Call call : calls) {
            if (EntityCacheUtil.getResult(CallModelImpl.ENTITY_CACHE_ENABLED,
                        CallImpl.class, call.getPrimaryKey()) == null) {
                cacheResult(call);
            } else {
                call.resetOriginalValues();
            }
        }
    }

    /**
     * Clears the cache for all calls.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear(CallImpl.class.getName());
        }

        EntityCacheUtil.clearCache(CallImpl.class.getName());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    /**
     * Clears the cache for the call.
     *
     * <p>
     * The {@link com.liferay.portal.kernel.dao.orm.EntityCache} and {@link com.liferay.portal.kernel.dao.orm.FinderCache} are both cleared by this method.
     * </p>
     */
    @Override
    public void clearCache(Call call) {
        EntityCacheUtil.removeResult(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallImpl.class, call.getPrimaryKey());

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<Call> calls) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);

        for (Call call : calls) {
            EntityCacheUtil.removeResult(CallModelImpl.ENTITY_CACHE_ENABLED,
                CallImpl.class, call.getPrimaryKey());
        }
    }

    /**
     * Creates a new call with the primary key. Does not add the call to the database.
     *
     * @param callId the primary key for the new call
     * @return the new call
     */
    @Override
    public Call create(long callId) {
        Call call = new CallImpl();

        call.setNew(true);
        call.setPrimaryKey(callId);

        return call;
    }

    /**
     * Removes the call with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param callId the primary key of the call
     * @return the call that was removed
     * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call remove(long callId) throws NoSuchCallException, SystemException {
        return remove((Serializable) callId);
    }

    /**
     * Removes the call with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param primaryKey the primary key of the call
     * @return the call that was removed
     * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call remove(Serializable primaryKey)
        throws NoSuchCallException, SystemException {
        Session session = null;

        try {
            session = openSession();

            Call call = (Call) session.get(CallImpl.class, primaryKey);

            if (call == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }

                throw new NoSuchCallException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                    primaryKey);
            }

            return remove(call);
        } catch (NoSuchCallException nsee) {
            throw nsee;
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }
    }

    @Override
    protected Call removeImpl(Call call) throws SystemException {
        call = toUnwrappedModel(call);

        Session session = null;

        try {
            session = openSession();

            if (!session.contains(call)) {
                call = (Call) session.get(CallImpl.class,
                        call.getPrimaryKeyObj());
            }

            if (call != null) {
                session.delete(call);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        if (call != null) {
            clearCache(call);
        }

        return call;
    }

    @Override
    public Call updateImpl(gov.va.caret.model.Call call)
        throws SystemException {
        call = toUnwrappedModel(call);

        boolean isNew = call.isNew();

        CallModelImpl callModelImpl = (CallModelImpl) call;

        Session session = null;

        try {
            session = openSession();

            if (call.isNew()) {
                session.save(call);

                call.setNew(false);
            } else {
                session.merge(call);
            }
        } catch (Exception e) {
            throw processException(e);
        } finally {
            closeSession(session);
        }

        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);

        if (isNew || !CallModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        }
        else {
            if ((callModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CREATEGROUPID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        callModelImpl.getOriginalCreateGroupId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CREATEGROUPID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CREATEGROUPID,
                    args);

                args = new Object[] { callModelImpl.getCreateGroupId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CREATEGROUPID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CREATEGROUPID,
                    args);
            }

            if ((callModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLERPERSNID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        callModelImpl.getOriginalCallerPersnId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CALLERPERSNID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLERPERSNID,
                    args);

                args = new Object[] { callModelImpl.getCallerPersnId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_CALLERPERSNID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CALLERPERSNID,
                    args);
            }

            if ((callModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VETERANPERSNID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] {
                        callModelImpl.getOriginalVeteranPersnId()
                    };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VETERANPERSNID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VETERANPERSNID,
                    args);

                args = new Object[] { callModelImpl.getVeteranPersnId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_VETERANPERSNID,
                    args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_VETERANPERSNID,
                    args);
            }

            if ((callModelImpl.getColumnBitmask() &
                    FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID.getColumnBitmask()) != 0) {
                Object[] args = new Object[] { callModelImpl.getOriginalUserId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_USERID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID,
                    args);

                args = new Object[] { callModelImpl.getUserId() };

                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_BY_USERID, args);
                FinderCacheUtil.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID,
                    args);
            }
        }

        EntityCacheUtil.putResult(CallModelImpl.ENTITY_CACHE_ENABLED,
            CallImpl.class, call.getPrimaryKey(), call);

        return call;
    }

    protected Call toUnwrappedModel(Call call) {
        if (call instanceof CallImpl) {
            return call;
        }

        CallImpl callImpl = new CallImpl();

        callImpl.setNew(call.isNew());
        callImpl.setPrimaryKey(call.getPrimaryKey());

        callImpl.setCallId(call.getCallId());
        callImpl.setCallType(call.getCallType());
        callImpl.setCallerRelationship(call.getCallerRelationship());
        callImpl.setWorkPrimaryKey(call.getWorkPrimaryKey());
        callImpl.setCallState(call.getCallState());
        callImpl.setCallerPersnId(call.getCallerPersnId());
        callImpl.setCallerTitle(call.getCallerTitle());
        callImpl.setCallerLearnAbout(call.getCallerLearnAbout());
        callImpl.setVeteranPersnId(call.getVeteranPersnId());
        callImpl.setMessage(call.getMessage());
        callImpl.setSummary(call.getSummary());
        callImpl.setTransferRemarks(call.getTransferRemarks());
        callImpl.setCespGoal(call.getCespGoal());
        callImpl.setCespOutcome(call.getCespOutcome());
        callImpl.setTransferredTo(call.getTransferredTo());
        callImpl.setOtherBenefits(call.getOtherBenefits());
        callImpl.setContactInfo(call.getContactInfo());
        callImpl.setEraService(call.getEraService());
        callImpl.setServiceBranch(call.getServiceBranch());
        callImpl.setServiceStatus(call.getServiceStatus());
        callImpl.setContactInfoProvided(call.isContactInfoProvided());
        callImpl.setReferralAgreeable(call.isReferralAgreeable());
        callImpl.setWithoutContact(call.isWithoutContact());
        callImpl.setHangUp(call.isHangUp());
        callImpl.setWrongNumber(call.isWrongNumber());
        callImpl.setSameAddress(call.isSameAddress());
        callImpl.setEnrolled(call.isEnrolled());
        callImpl.setDutyDischargeAfter911(call.isDutyDischargeAfter911());
        callImpl.setScCondition(call.isScCondition());
        callImpl.setPcafcQaulified(call.isPcafcQaulified());
        callImpl.setVerified(call.isVerified());
        callImpl.setAnonymous(call.isAnonymous());
        callImpl.setCreateGroupId(call.getCreateGroupId());
        callImpl.setUserId(call.getUserId());
        callImpl.setCreationDate(call.getCreationDate());
        callImpl.setCallbackPref(call.getCallbackPref());

        return callImpl;
    }

    /**
     * Returns the call with the primary key or throws a {@link com.liferay.portal.NoSuchModelException} if it could not be found.
     *
     * @param primaryKey the primary key of the call
     * @return the call
     * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call findByPrimaryKey(Serializable primaryKey)
        throws NoSuchCallException, SystemException {
        Call call = fetchByPrimaryKey(primaryKey);

        if (call == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }

            throw new NoSuchCallException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY +
                primaryKey);
        }

        return call;
    }

    /**
     * Returns the call with the primary key or throws a {@link gov.va.caret.NoSuchCallException} if it could not be found.
     *
     * @param callId the primary key of the call
     * @return the call
     * @throws gov.va.caret.NoSuchCallException if a call with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call findByPrimaryKey(long callId)
        throws NoSuchCallException, SystemException {
        return findByPrimaryKey((Serializable) callId);
    }

    /**
     * Returns the call with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param primaryKey the primary key of the call
     * @return the call, or <code>null</code> if a call with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call fetchByPrimaryKey(Serializable primaryKey)
        throws SystemException {
        Call call = (Call) EntityCacheUtil.getResult(CallModelImpl.ENTITY_CACHE_ENABLED,
                CallImpl.class, primaryKey);

        if (call == _nullCall) {
            return null;
        }

        if (call == null) {
            Session session = null;

            try {
                session = openSession();

                call = (Call) session.get(CallImpl.class, primaryKey);

                if (call != null) {
                    cacheResult(call);
                } else {
                    EntityCacheUtil.putResult(CallModelImpl.ENTITY_CACHE_ENABLED,
                        CallImpl.class, primaryKey, _nullCall);
                }
            } catch (Exception e) {
                EntityCacheUtil.removeResult(CallModelImpl.ENTITY_CACHE_ENABLED,
                    CallImpl.class, primaryKey);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return call;
    }

    /**
     * Returns the call with the primary key or returns <code>null</code> if it could not be found.
     *
     * @param callId the primary key of the call
     * @return the call, or <code>null</code> if a call with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public Call fetchByPrimaryKey(long callId) throws SystemException {
        return fetchByPrimaryKey((Serializable) callId);
    }

    /**
     * Returns all the calls.
     *
     * @return the calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findAll() throws SystemException {
        return findAll(QueryUtil.ALL_POS, QueryUtil.ALL_POS, null);
    }

    /**
     * Returns a range of all the calls.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of calls
     * @param end the upper bound of the range of calls (not inclusive)
     * @return the range of calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findAll(int start, int end) throws SystemException {
        return findAll(start, end, null);
    }

    /**
     * Returns an ordered range of all the calls.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.CallModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of calls
     * @param end the upper bound of the range of calls (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<Call> findAll(int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;

        if ((start == QueryUtil.ALL_POS) && (end == QueryUtil.ALL_POS) &&
                (orderByComparator == null)) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[] { start, end, orderByComparator };
        }

        List<Call> list = (List<Call>) FinderCacheUtil.getResult(finderPath,
                finderArgs, this);

        if (list == null) {
            StringBundler query = null;
            String sql = null;

            if (orderByComparator != null) {
                query = new StringBundler(2 +
                        (orderByComparator.getOrderByFields().length * 3));

                query.append(_SQL_SELECT_CALL);

                appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS,
                    orderByComparator);

                sql = query.toString();
            } else {
                sql = _SQL_SELECT_CALL;

                if (pagination) {
                    sql = sql.concat(CallModelImpl.ORDER_BY_JPQL);
                }
            }

            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(sql);

                if (!pagination) {
                    list = (List<Call>) QueryUtil.list(q, getDialect(), start,
                            end, false);

                    Collections.sort(list);

                    list = new UnmodifiableList<Call>(list);
                } else {
                    list = (List<Call>) QueryUtil.list(q, getDialect(), start,
                            end);
                }

                cacheResult(list);

                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return list;
    }

    /**
     * Removes all the calls from the database.
     *
     * @throws SystemException if a system exception occurred
     */
    @Override
    public void removeAll() throws SystemException {
        for (Call call : findAll()) {
            remove(call);
        }
    }

    /**
     * Returns the number of calls.
     *
     * @return the number of calls
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int countAll() throws SystemException {
        Long count = (Long) FinderCacheUtil.getResult(FINDER_PATH_COUNT_ALL,
                FINDER_ARGS_EMPTY, this);

        if (count == null) {
            Session session = null;

            try {
                session = openSession();

                Query q = session.createQuery(_SQL_COUNT_CALL);

                count = (Long) q.uniqueResult();

                FinderCacheUtil.putResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY, count);
            } catch (Exception e) {
                FinderCacheUtil.removeResult(FINDER_PATH_COUNT_ALL,
                    FINDER_ARGS_EMPTY);

                throw processException(e);
            } finally {
                closeSession(session);
            }
        }

        return count.intValue();
    }

    /**
     * Initializes the call persistence.
     */
    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split(GetterUtil.getString(
                    com.liferay.util.service.ServiceProps.get(
                        "value.object.listener.gov.va.caret.model.Call")));

        if (listenerClassNames.length > 0) {
            try {
                List<ModelListener<Call>> listenersList = new ArrayList<ModelListener<Call>>();

                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener<Call>) InstanceFactory.newInstance(
                            getClassLoader(), listenerClassName));
                }

                listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            } catch (Exception e) {
                _log.error(e);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache(CallImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}
