/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.kernel.exception.SystemException;

import java.util.List;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.NoSuchVcgException;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.service.base.VcgLocalServiceBaseImpl;

/**
 * The implementation of the vcg local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.VcgLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.VcgLocalServiceBaseImpl
 * @see gov.va.caret.service.VcgLocalServiceUtil
 */
public class VcgLocalServiceImpl extends VcgLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.VcgLocalServiceUtil} to access the vcg local service.
	 */
	
	public Vcg getVeteranVcg ( long persnId ) throws ApplicationWorkFlowException {
		try{
			return vcgPersistence.findByVeteran( persnId );
		} catch (NoSuchVcgException e) {
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
		return null;
	}
	
	public List<VcgAn> getVcgApps ( long vcgId ) throws ApplicationWorkFlowException {
		try {
			return vcgAnPersistence.findByVcgId(vcgId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	
}