/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.NoSuchVcgAnException;
import gov.va.caret.model.VcgAn;
import gov.va.caret.service.base.VcgAnLocalServiceBaseImpl;

import java.util.List;

/**
 * The implementation of the vcg an local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.VcgAnLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.VcgAnLocalServiceBaseImpl
 * @see gov.va.caret.service.VcgAnLocalServiceUtil
 */
public class VcgAnLocalServiceImpl extends VcgAnLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.VcgAnLocalServiceUtil} to access the vcg an local service.
	 */
	public List<VcgAn> getByPersn ( long userId ) throws ApplicationWorkFlowException {
		try {
			return vcgAnPersistence.findByVeteranId(userId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<VcgAn> getByVcg ( long vcgId ) throws ApplicationWorkFlowException {
		try {
			return vcgAnPersistence.findByVcgId(vcgId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public VcgAn getRecent ( long vcgId ) throws ApplicationWorkFlowException {
		try {
			return vcgAnPersistence.findByVcgId_First(vcgId, null);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		} catch (NoSuchVcgAnException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public int getByPersnCount ( long userId ) throws ApplicationWorkFlowException {
		try {
			return vcgAnPersistence.countByVeteranId(userId);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
}