/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.NoSuchBlsAeException;
import gov.va.caret.model.BlsAe;
import gov.va.caret.model.BlsRe;
import gov.va.caret.service.base.BlsAeLocalServiceBaseImpl;

import java.util.List;

/**
 * The implementation of the bls ae local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.BlsAeLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.BlsAeLocalServiceBaseImpl
 * @see gov.va.caret.service.BlsAeLocalServiceUtil
 */
public class BlsAeLocalServiceImpl extends BlsAeLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.BlsAeLocalServiceUtil} to access the bls ae local service.
	 */
	
	public BlsAe findByAreaNumber ( int areaNumber ) throws ApplicationWorkFlowException {
		try {
			return getBlsAePersistence().findByNumber(areaNumber);
		} catch (NoSuchBlsAeException e) {
			return null;
		} catch (SystemException e) {
			e.printStackTrace();
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<BlsRe> findCities ( String state ) throws ApplicationWorkFlowException {
		try {
			return blsRePersistence.findByState(state);
		} catch (SystemException e) {
			e.printStackTrace();
			throw new ApplicationWorkFlowException(e);
		}
	}
}