package gov.va.caret.service.ctssh;

import static java.nio.charset.StandardCharsets.ISO_8859_1;
import static java.nio.charset.StandardCharsets.UTF_8;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.caret.portlet.CaretPortlet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CTSSHandler {

	//the actual values of these are meaningless as long as they are unique
	private static final String TEMPLATE_REQ_URL_XPATHKEY 				= "XKEY01";
	private static final String TEMPLATE_REQ_METHOD_XPATHKEY 			= "XKEY02";
	private static final String TEMPLATE_REQ_HEADERS_XPATHKEY 			= "XKEY03";
	private static final String TEMPLATE_RESP_PROPERTIES_XPATHKEY 		= "XKEY04";
	private static final String TEMPLATE_REQ_PARAMETERS_XPATHKEY 		= "XKEY05";
	private static final String TEMPLATE_REQ_BODY_XPATHKEY 				= "XKEY06";
	private static final String TEMPLATE_RECORD_XPATHKEY 				= "XKEY07";
	private static final String TEMPLATE_FIELD_GROUPS_XPATHKEY 			= "XKEY08";
	private static final String TEMPLATE_FIELDS_XPATHKEY 				= "XKEY09";
	private static final String TEMPLATE_CALL_TYPE_XPATHKEY				= "XKEY19";
	private static final String GENERIC_XPATH_ATTRIBUTE_XPATHKEY 		= "XKEY10";
	private static final String GENERIC_DEFAULT_ATTRIBUTE_XPATHKEY 		= "XKEY11";
	private static final String GENERIC_NAME_ATTRIBUTE_XPATHKEY 		= "XKEY12";
	private static final String GENERIC_TOKEN_ATTRIBUTE_XPATHKEY		= "XKEY13";
	private static final String GENERIC_TAG_ATTRIBUTE_XPATHKEY 			= "XKEY14";
	private static final String GENERIC_VALUE_ATTRIBUTE_XPATHKEY		= "XKEY15";
	private static final String GENERIC_USE_ATTRIBUTE_XPATHKEY			= "XKEY16";
	private static final String GENERIC_DELIMETER_ATTRIBUTE_XPATHKEY	= "XKEY17";
	private static final String GENERIC_LISTKEY_ATTRIBUTE_XPATHKEY		= "XKEY18";
	
	private static volatile CTSSHandler SNGLETON = null;
	//removed these - not safe for concurrent executions
	//they will be created and cached PER execution.
	/*
	private DocumentBuilderFactory doc_builder_factory;
	private DocumentBuilder doc_builder;
	*/
	
	//the only things we put in the sngleton are thread safe and reuseable;
	private XPath xpath;
	private HashMap<String, Document> template_cache;
	private HashMap<String,String> raw_template_cache;
	private HashMap<String, XPathExpression> xpath_expression_cache;
	private String path_to_templates;

	private static Log _log = LogFactoryUtil.getLog(CTSSHandler.class);
	
	public static void init(String path_to_templates) throws CTSSHException {
		if (SNGLETON == null)
			SNGLETON = new CTSSHandler(path_to_templates);
		else
			throw new CTSSHException("CTSSHandler has already been initialized");
	}	
	
	public static void init(String path_to_templates, boolean reset) throws CTSSHException {
		
		if(reset)
		{
			SNGLETON = null;
		}
		
		if (SNGLETON == null)
			SNGLETON = new CTSSHandler(path_to_templates);
		else
			throw new CTSSHException("CTSSHandler has already been initialized");
	}	

	private CTSSHandler(String path_to_templates) throws CTSSHException {
		_log.info("new instance with :" + path_to_templates );
		if (new File(path_to_templates).exists() == false)
			throw new CTSSHException("Path to templates does not exist");

		this.path_to_templates = path_to_templates;
		this.template_cache = new HashMap<String, Document>();
		this.raw_template_cache = new HashMap<String, String>();

		try {

		
			// there are certain xpath expressions that will be reused on all
			// templates.
			// init them here to save time later
			xpath = XPathFactory.newInstance().newXPath();
			xpath_expression_cache = new HashMap<String, XPathExpression>();
			// these are used to get common attributes
			cacheExpression(GENERIC_XPATH_ATTRIBUTE_XPATHKEY, "@xpath");
			cacheExpression(GENERIC_LISTKEY_ATTRIBUTE_XPATHKEY,"@list_key");
			cacheExpression(GENERIC_DEFAULT_ATTRIBUTE_XPATHKEY, "@default");
			cacheExpression(GENERIC_NAME_ATTRIBUTE_XPATHKEY, "@name");
			cacheExpression(GENERIC_TOKEN_ATTRIBUTE_XPATHKEY, "@token");
			cacheExpression(GENERIC_TAG_ATTRIBUTE_XPATHKEY, "@tag");
			cacheExpression(GENERIC_VALUE_ATTRIBUTE_XPATHKEY, "@value");
			cacheExpression(GENERIC_DELIMETER_ATTRIBUTE_XPATHKEY, "@delimeter");
			cacheExpression(GENERIC_USE_ATTRIBUTE_XPATHKEY, "@use");
			cacheExpression(TEMPLATE_REQ_URL_XPATHKEY, "//*/request/url");
			cacheExpression(TEMPLATE_REQ_METHOD_XPATHKEY, "//*/request/http_request_method");
			cacheExpression(TEMPLATE_REQ_HEADERS_XPATHKEY, "//*/request/http_headers/header");
			cacheExpression(TEMPLATE_RESP_PROPERTIES_XPATHKEY, "//*/result_property");
			cacheExpression(TEMPLATE_REQ_PARAMETERS_XPATHKEY, "//*/parameter");
			cacheExpression(TEMPLATE_REQ_BODY_XPATHKEY, "//*/body");
			cacheExpression(TEMPLATE_RECORD_XPATHKEY, "//*/record");
			cacheExpression(TEMPLATE_FIELD_GROUPS_XPATHKEY, "field_group");
			cacheExpression(TEMPLATE_FIELDS_XPATHKEY, "field");
			cacheExpression(TEMPLATE_CALL_TYPE_XPATHKEY, "//*/CTSSH_call_type");
			
			
			xpath.reset();// just a little cleanup

		} catch (Exception e) {
			throw new CTSSHException(e.getMessage());
		}
	}

	private XPathExpression getCachedExpression(String x_path_or_key) throws XPathExpressionException
	{
		//this is just a little helper function
		//check the cache for the expression.  if it's not there, build it
		if(!xpath_expression_cache.containsKey(x_path_or_key))		
			cacheExpression(x_path_or_key,x_path_or_key);//the x_path_or_key has dual use, as key as well as path
		
		return xpath_expression_cache.get(x_path_or_key);
		
	}
	
	private synchronized void  cacheExpression(String key, String x_path) throws XPathExpressionException
	{
    	xpath_expression_cache.put(key, xpath.compile(x_path));
    	xpath.reset();
	}

	private void build_soap_request(CTSSHResponse response, CTSSHRequest request, Document template_meta) throws CTSSHException, XPathExpressionException {

		response.log("building soap message");
		
		
		response.raw_template = raw_template_cache.get(request.interfaceKey());
		response.setStartTime(".SOAP_BUILD");
		response.setStartTime(".SOAP_BUILD.GET_TEMPLATE");
		String template_body = (String) getCachedExpression(TEMPLATE_REQ_BODY_XPATHKEY).evaluate(template_meta, XPathConstants.STRING);
		response.setEndTime(".SOAP_BUILD.GET_TEMPLATE");
		NodeList nlParameters = (NodeList) getCachedExpression(TEMPLATE_REQ_PARAMETERS_XPATHKEY).evaluate(template_meta,XPathConstants.NODESET);

		String parameter_name;
		String parameter_token;
		String parameter_default;
		//String parameter_tag;
		String parameter_value;
		// String remove_exp_e;
		// String remove_exp_a;
		Node parameter;

		// we can't use the standard for loop because nodelist isn't a real
		// collection
		response.setStartTime(".SOAP_BUILD.SET_PARAMETERS");
		for (int pc = 0; pc < nlParameters.getLength(); pc++) {
			parameter = nlParameters.item(pc);
			parameter_name = (String) getCachedExpression(GENERIC_NAME_ATTRIBUTE_XPATHKEY).evaluate(parameter, XPathConstants.STRING);
			parameter_token = (String) getCachedExpression(GENERIC_TOKEN_ATTRIBUTE_XPATHKEY).evaluate(parameter, XPathConstants.STRING);
			//parameter_tag = (String) getCachedExpression(GENERIC_TAG_XPATHKEY).evaluate(parameter, XPathConstants.STRING);
			
			
			
			if(parameter_token.intern() != "##DUMMY.TOKEN##")
			{
				if (request.getParameter(parameter_name) != null) {
					response.log("Parameter " + parameter_name + " found in request : " + request.getParameter(parameter_name));
					parameter_value = request.getParameter(parameter_name);
					try{
						template_body = template_body.replace(parameter_token, parameter_value);
					}catch(Exception oops)
					{
						throw new CTSSHException(oops);
					}
					
				} else {
					
					parameter_default = (String) getCachedExpression(GENERIC_DEFAULT_ATTRIBUTE_XPATHKEY).evaluate(parameter, XPathConstants.STRING);
					response.log("Parameter " + parameter_name + " NOT found in request : using default :" + parameter_default);
					if (parameter_default.intern() == "[error]") {
						response.log("Parameter " + parameter_name + " default is [ERROR], throwing Exception");
						throw new CTSSHException("Parameter " + parameter_name + " is required for " + request.interfaceKey());
					} else if (parameter_default.intern() == "[remove]") {
						
						response.log("Parameter " + parameter_name + " default is [remove], removing element (this not implemented, just setting value to empty)");
						template_body = template_body.replaceAll(parameter_token, "");
						// this is a bug. I need to figure out the regexp for early
						// terminated tags
						// template_body =
						// template_body.replaceFirst(remove_exp_e,"");
	
					} else {
						template_body = template_body.replaceAll(parameter_token, parameter_default);
					}
				}
			}
		}
		response.setEndTime(".SOAP_BUILD.SET_PARAMETERS");
		response.soap_request = new String(template_body.getBytes(ISO_8859_1), UTF_8);
		response.setEndTime(".SOAP_BUILD");
		response.log("done building soap request. Check response.soap_request for content");
		
	}

	private Document getTemplate(String key, CTSSHResponse response) throws CTSSHException
	{
		response.log("Getting template : " + key);
		if (!template_cache.containsKey(key)) {
			response.log("Template " + key + " not in cache.  Loading from filesystem");
			
			String path = path_to_templates + key + ".xml";
			response.log("Loading template " + path);
			File temp = new File(path);

			if (temp.exists() == false)
			{
				response.log("Template " + path + " not found.  Throwing exception");	
				throw new CTSSHException("Template not found" + path);
			}

			if (temp.canRead() == false){
				throw new CTSSHException("Template not found" + path );
			}
			
			try {

				response.doc_builder.reset();
				Document doc = response.doc_builder.parse(temp);
				template_cache.put(key, doc);
				raw_template_cache.put(key, CTSSHUtil.getPrettyPrintXML(doc));
				
				response.log("Template " + key + " loaded from filesystem");
			} catch (Exception e) {
				response.log(e);
				throw new CTSSHException(e.getMessage());
			}
		}		
		
		response.log("Returning template " + key);
		return template_cache.get(key);
	}
	
	@SuppressWarnings("unchecked")
	private void process_response(CTSSHResponse response, Document template_meta) throws Exception
	{
		response.log("processing response");
		response.setStartTime(".PROCESS_RESPONSE_DATA");
		response.column_names = new ArrayList<String>();
		response.result_set = new ArrayList<HashMap<String,Object>>();  
		response.response_properties = new Properties();
		
		//convert the buffer to a dom so we can execute our xpaths on it
		
		
		response.doc_builder.reset();
		InputSource source = new InputSource(new StringReader(response.http_response_body));
		Document resp_doc = response.doc_builder.parse(source);
		resp_doc.getDocumentElement().normalize();
	    xpath.reset();

	    response.response_properties = new Properties();
	    NodeList nlProperties = (NodeList) getCachedExpression(TEMPLATE_RESP_PROPERTIES_XPATHKEY).evaluate(template_meta,XPathConstants.NODESET);
	    for(int pc = 0; pc < nlProperties.getLength();pc++)
	    {
	    	String prop_key = (String) getCachedExpression(GENERIC_NAME_ATTRIBUTE_XPATHKEY).evaluate(nlProperties.item(pc), XPathConstants.STRING);
	    	String prop_path = (String) getCachedExpression(GENERIC_XPATH_ATTRIBUTE_XPATHKEY).evaluate(nlProperties.item(pc), XPathConstants.STRING);
	    	String value = (String) getCachedExpression(prop_path).evaluate(resp_doc, XPathConstants.STRING);
	    	response.response_properties.put(prop_key, value);
	    }
	    
	    
	    
	    //some quick pre-setup
	    Node nTemplateRecord = (Node)getCachedExpression(TEMPLATE_RECORD_XPATHKEY).evaluate(template_meta,XPathConstants.NODE);
	    if(nTemplateRecord != null)
	    {
		    NodeList nlTemplateFieldGroups = (NodeList)getCachedExpression(TEMPLATE_FIELD_GROUPS_XPATHKEY).evaluate(nTemplateRecord, XPathConstants.NODESET);
		    String resp_record_path = (String)getCachedExpression(GENERIC_XPATH_ATTRIBUTE_XPATHKEY).evaluate(nTemplateRecord,XPathConstants.STRING);
		    //these are the actual records that were returned from the soap call
		    NodeList nlResultRecords = (NodeList) getCachedExpression(resp_record_path).evaluate(resp_doc,XPathConstants.NODESET);
	    	for(int rc = 0; rc < nlResultRecords.getLength(); rc++)
		    {
		    	Node current_result_record = nlResultRecords.item(rc);
		    	
		    	//this will be added to the main array list.
		    	HashMap<String,Object> this_return_record = new HashMap<String,Object>();
		    	//add the new row to the resultset
		    	response.result_set.add(this_return_record);
	
		    	for(int gc = 0; gc < nlTemplateFieldGroups.getLength(); gc++)
			    {
	
			    	String group_name = (String)getCachedExpression(GENERIC_NAME_ATTRIBUTE_XPATHKEY).evaluate(nlTemplateFieldGroups.item(gc),XPathConstants.STRING);
			   
			    	if(response.column_names.contains(group_name) == false)
			    		response.column_names.add(group_name);
			    	
			    	response.log("processing field_group " + group_name);
			    	
			    	
			    	String list_key = (String)getCachedExpression(GENERIC_LISTKEY_ATTRIBUTE_XPATHKEY).evaluate(nlTemplateFieldGroups.item(gc),XPathConstants.STRING);
			    	String list_key_xpath="";
			    	String list_key_delimiter="";
			    	int list_key_index = -1;
			    	
			    	if(list_key.startsWith("parse"))
			    	{
			    		String[] parts = list_key.split("!");
			    		list_key_xpath = parts[1];
			    		list_key_delimiter = parts[2];
			    		list_key_index = Integer.parseInt(parts[3]);
			    		
			    		
			    	}else
			    		list_key_xpath=list_key;
			    	
			    	//the group name is actually the column name in the row.
			    	//it will hold a hashmap of hashmaps.  Trust me, this is a very cool way of doing this.
			    	HashMap<String,HashMap<String,Object>>group_map = null;
			    	if(this_return_record.containsKey(group_name))
			    		group_map = (HashMap<String, HashMap<String,Object>>)this_return_record.get(group_name);
			    	else
			    	{
			    		group_map = new HashMap<String,HashMap<String,Object>>();
			    		this_return_record.put(group_name, group_map);
			    	}
			    			    	
			    
			    	
			    	
			    	String result_field_group_xpath = (String)getCachedExpression(GENERIC_XPATH_ATTRIBUTE_XPATHKEY).evaluate(nlTemplateFieldGroups.item(gc),XPathConstants.STRING);
			    	NodeList nlTemplateGroupFields = (NodeList)getCachedExpression(TEMPLATE_FIELDS_XPATHKEY).evaluate(nlTemplateFieldGroups.item(gc), XPathConstants.NODESET);
			    	NodeList current_record_current_field_groupings = (NodeList)getCachedExpression(result_field_group_xpath).evaluate(current_result_record,XPathConstants.NODESET);
			    	if(current_record_current_field_groupings != null)
			    	{
			    		//HashMap<String,String> this_grouping_fields = new HashMap<String,String>();
			    		
				    	for(int crcfg = 0; crcfg < current_record_current_field_groupings.getLength(); crcfg++)
			    		{
				    		//get the key value to use to add this grouping map back to the column map
				    		String group_list_key = (String)getCachedExpression(list_key_xpath).evaluate(current_record_current_field_groupings.item(crcfg),XPathConstants.STRING);
				    		if(list_key_index > -1)
				    		{
				    			String[] parts = group_list_key.split(list_key_delimiter);
				    			group_list_key = parts[list_key_index];
				    		}
				    		
				    		HashMap<String, Object> this_group_set = new HashMap<String,Object>();
				    		group_map.put(group_list_key, this_group_set);
				    		
				    		
					    	for(int x=0; x < nlTemplateGroupFields.getLength(); x++)
					    	{
					    		String field_xpath = (String)getCachedExpression(GENERIC_XPATH_ATTRIBUTE_XPATHKEY).evaluate(nlTemplateGroupFields.item(x),XPathConstants.STRING);
						    	String field_delimiter="";
						    	int field_index = -1;
						    	
						    	if(field_xpath.startsWith("parse"))
						    	{
						    		String[] field_parts = field_xpath.split("!");
						    		field_xpath = field_parts[1];
						    		field_delimiter = field_parts[2];
						    		field_index = Integer.parseInt(field_parts[3]);
						    	}
					    		
					    		String field_name = (String)getCachedExpression(GENERIC_NAME_ATTRIBUTE_XPATHKEY).evaluate(nlTemplateGroupFields.item(x),XPathConstants.STRING);
					    		String field_default = (String)getCachedExpression(GENERIC_DEFAULT_ATTRIBUTE_XPATHKEY).evaluate(nlTemplateGroupFields.item(x),XPathConstants.STRING);
					    		String field_value = (String)getCachedExpression(field_xpath).evaluate(current_record_current_field_groupings.item(crcfg),XPathConstants.STRING);
	
					    		if(field_value.length() == 0)
							    {
							    	if(field_default.intern() != "[null]")
							    		this_group_set.put(field_name, field_default);
							    	else
							    		this_group_set.put(field_name, "");
							    	
							    }else
							    {
						    		if(field_index > -1)
						    		{
						    			String[] parts = field_value.split(field_delimiter);
						    			if((parts.length - 1) >= field_index)
						    				field_value = parts[field_index];
							    	}
	
						    		this_group_set.put(field_name, field_value);
							    }
					    	}
			    		}
			    	}
			    		
			    }		
		    	
		    	//now that the groupings are done - do the standard fields
		    	NodeList nlTemplateFields = (NodeList)getCachedExpression(TEMPLATE_FIELDS_XPATHKEY).evaluate(nTemplateRecord, XPathConstants.NODESET);
		    	
		    	response.log("processing standard fields");
		    	for(int sfc = 0; sfc < nlTemplateFields.getLength(); sfc++)
		    	{
		    		String field_xpath = (String)getCachedExpression(GENERIC_XPATH_ATTRIBUTE_XPATHKEY).evaluate(nlTemplateFields.item(sfc),XPathConstants.STRING);
				    String field_value = (String)getCachedExpression(field_xpath).evaluate(current_result_record,XPathConstants.STRING);
				    String field_default = (String)getCachedExpression(GENERIC_DEFAULT_ATTRIBUTE_XPATHKEY).evaluate(nlTemplateFields.item(sfc),XPathConstants.STRING);
				    String field_name = (String)getCachedExpression(GENERIC_NAME_ATTRIBUTE_XPATHKEY).evaluate(nlTemplateFields.item(sfc),XPathConstants.STRING);			    
				    response.log("processing field " + field_name);   
				    if(field_value.length() > 0)
				    {
			    		if(response.column_names.contains(field_name) == false)
			    			response.column_names.add(field_name);
	
			    		this_return_record.put(field_name, field_value);
			    		
				    }else
				    if(field_default.length() == 0 && field_default.intern() != "[null]")			    	
				    {
			    		if(response.column_names.contains(field_name) == false)
			    			response.column_names.add(field_name);
				    	
			    		this_return_record.put(field_name, field_default);
				    }
		    	}//end stantard fields
		    }//end record looping
    	
		}//end nodelist record not null check
    	response.set();
    	response.setEndTime(".PROCESS_RESPONSE_DATA");
    	
    	response.log("done processing response");
		
	}
	
	private void execute_request(CTSSHResponse return_response, CTSSHRequest request, Document template_meta) throws CTSSHException {



		return_response.log("executing request");		
			
		try {
			String call_type = (String) getCachedExpression(TEMPLATE_CALL_TYPE_XPATHKEY).evaluate(template_meta, XPathConstants.STRING);
			//NOTE - this should be converted to a Factory method
			if(call_type.intern() == "chain")
			{
				execute_chain_request(return_response, request, template_meta);
			}else
			{
				execute_simple_request(return_response, request, template_meta);
			}
			
		} catch (Exception e) {
			return_response.setException(e);
			return_response.log(e);
			//e.printStackTrace();
			throw new CTSSHException(e.getMessage());
		}
		return_response.log("request execution complete");
	}
	
	private void execute_simple_request(CTSSHResponse return_response, CTSSHRequest request, Document template_meta) throws CTSSHException {

		
		StringBuilder return_data = null;
		BufferedWriter data_out = null;
		BufferedReader data_in = null;

		return_response.log("executing request");		
			
		try {
			
			build_soap_request(return_response, request,template_meta);
			
			return_response.setStartTime(".EXECUTE_REQUEST");
			// set up the connection and set the headers
			String url_string = (String) getCachedExpression(TEMPLATE_REQ_URL_XPATHKEY).evaluate(template_meta, XPathConstants.STRING);
			return_response.log("WebService URL : " + url_string);

			_log.info("---------------------------------------------------");
			_log.info("---------------------------------------------------");
			_log.info("-----------------url_string------------------------");
			_log.info( url_string );
			_log.info("---------------------------------------------------");
			_log.info("---------------------------------------------------");
			
			java.net.HttpURLConnection mvicon = (java.net.HttpURLConnection)CTSSHUtil.getServiceConnection(url_string);
//			HttpURLConnection mvicon = (HttpURLConnection)CTSSHUtil.getServiceConnection(url_string);
			mvicon.setDoOutput(true);
			mvicon.setRequestMethod((String) getCachedExpression(TEMPLATE_REQ_METHOD_XPATHKEY).evaluate(template_meta, XPathConstants.STRING));
			NodeList nlHeaders = (NodeList) getCachedExpression(TEMPLATE_REQ_HEADERS_XPATHKEY).evaluate(template_meta,XPathConstants.NODESET);
			
			for (int pc = 0; pc < nlHeaders.getLength(); pc++) {
				Node header = nlHeaders.item(pc);
				mvicon.setRequestProperty((String) getCachedExpression(GENERIC_NAME_ATTRIBUTE_XPATHKEY).evaluate(header, XPathConstants.STRING),(String) getCachedExpression(GENERIC_VALUE_ATTRIBUTE_XPATHKEY).evaluate(header, XPathConstants.STRING));
			}
			
			mvicon.setRequestProperty("Content-Length", String.valueOf(return_response.soap_request.getBytes().length));

			return_response.setStartTime(".WRITE_DATA");
			// push the request
			data_out = new BufferedWriter(new OutputStreamWriter(new DataOutputStream(mvicon.getOutputStream()), "UTF-8"));
			data_out.write("\r\n");
			data_out.write(return_response.soap_request);
			data_out.write("\r\n");
			data_out.flush();
			data_out.close();
			return_response.log("request written, buffers flushed and closed");
			return_response.setEndTime(".WRITE_DATA");
			
			return_response.setStartTime(".READ_DATA");
			return_response.log("reading data");
			String data_line;
			return_data = new StringBuilder();

			if (mvicon.getResponseCode() == 500)
				data_in = new BufferedReader(
						new InputStreamReader(new DataInputStream(mvicon.getErrorStream()), "UTF-8"));
			else
				data_in = new BufferedReader(
						new InputStreamReader(new DataInputStream(mvicon.getInputStream()), "UTF-8"));

			
			while ((data_line = data_in.readLine()) != null) {
				return_data.append(data_line);
			}
			
			data_in.close();
			return_response.setEndTime(".READ_DATA");
			return_response.log("data read (" + return_data.toString().length() + " bytes)");
			//we have data, but we need to check the response code to see if we got 500 or something else.
			if (mvicon.getResponseCode() == 500)
				throw new CTSSHException(return_data.toString());//the return data will have the error in it

			//create the response with all the codes.
			
			return_response.HTTP_RESP_CODE = mvicon.getResponseCode(); 
			return_response.HTTP_CONTENT_LENGTH = mvicon.getContentLength();
			return_response.HTTP_CONTENT_TYPE = mvicon.getContentType();
			return_response.HTTP_RESPONSE_MESSAGE =mvicon.getResponseMessage();
			return_response.http_response_body =return_data.toString(); 
			
			if(return_response.HTTP_RESP_CODE != 500)
			{
				process_response(return_response, template_meta);
			}
			
		} catch (Exception e) {
			
			_log.error(e);
			return_response.setException(e);
			return_response.log(e);
			e.printStackTrace();
			throw new CTSSHException(e.getMessage());
		}finally
		{
			return_response.setEndTime(".EXECUTE_REQUEST");
		}

		return_response.log("request execution complete");
	}
		
	private void execute_chain_request(CTSSHResponse return_response, CTSSHRequest request, Document template_meta) throws CTSSHException {


		return_response.log("executing request");		
		return_response.setStartTime(".EXECUTE_REQUEST");	
		try {
			
			//first thing to do is make sure the required parameters are on the chain request.
			NodeList nl_required_parameters = (NodeList)getCachedExpression("/CTSSH_Template_Root/required_parameters/parameter").evaluate(template_meta, XPathConstants.NODESET);
			boolean error = false;
			StringBuilder err = null;
		    for(int pc = 0; pc < nl_required_parameters.getLength();pc++)
		    {
		    	
		    	String prop_key = (String) getCachedExpression(GENERIC_NAME_ATTRIBUTE_XPATHKEY).evaluate(nl_required_parameters.item(pc), XPathConstants.STRING);
		    	if(request.getParameter(prop_key) == null || request.getParameter(prop_key).length() < 1)
		    	{
		    		error = true;
		    		if(err == null)
		    			err = new StringBuilder();
		    		
		    		err.append("Parameter " + prop_key + " is required but wasn't found.\n");
		    	}
		    	
		    }			
		
		    if(error)
		    	throw new CTSSHException(err.toString());
			
			
			//when doing a chain for requests, just aggregate all return results and then return everything
		    
			int step_count = Integer.parseInt((String) getCachedExpression("/CTSSH_Template_Root/call_steps/@count").evaluate(template_meta, XPathConstants.STRING));
	
			for(int step_counter = 1; step_counter <= step_count; step_counter++)
			{
				String template_id = (String) getCachedExpression("/CTSSH_Template_Root/call_steps/step[@sequence='" + step_counter + "']/@template_id").evaluate(template_meta, XPathConstants.STRING);
				String fail_message = (String) getCachedExpression("/CTSSH_Template_Root/call_steps/step[@sequence='" + step_counter + "']/@fail_message").evaluate(template_meta, XPathConstants.STRING);
				return_response.setStartTime(".EXECUTE_STEP_" + step_counter + "REQUEST");

				Node template = (Node)getCachedExpression("/CTSSH_Template_Root/CTSSH_Template[@template_id='" + template_id + "']").evaluate(template_meta, XPathConstants.NODE);
				
				
				String run_key =  UUID.randomUUID().toString();//this is the unique identifier for this run
				CTSSHResponse chain_response = new CTSSHResponse(return_response.run_key + run_key);
				chain_response.setStartTime(".EXECUTE");
				return_response.doc_builder.reset();
				InputSource source = new InputSource(new StringReader(CTSSHUtil.getPrettyPrintXML(template)));
				Document template_doc = return_response.doc_builder.parse(source);
				template_doc.getDocumentElement().normalize();			
				execute_simple_request(chain_response, request, template_doc);
				
				chain_response.setEndTime(".EXECUTE");
				return_response.setEndTime(".EXECUTE_STEP_" + step_counter + "REQUEST");

				if(chain_response.HTTP_RESP_CODE != 200 || Integer.parseInt(chain_response.response_properties.getProperty("ERROR")) > 0)
				{
					StringBuilder fmsg = new StringBuilder();
					fmsg.append(fail_message + "\n");
					fmsg.append(chain_response.response_properties.getProperty("ERROR_MESSAGE") + "\n");
					//fmsg.append(chain_response.getLog() + "\n");
					throw new CTSSHException(fmsg.toString());
				}
				
				//append the chain response to the main response.
				return_response.absorb(chain_response);
				
				//now merge the last response with the original request so we can use it again
				request.absorb(chain_response);
			}
				
			
		} catch (Exception e) {
			return_response.setException(e);
			return_response.log(e);
			//e.printStackTrace();
			throw new CTSSHException(e.getMessage());
		}finally
		{
			return_response.setEndTime(".EXECUTE_REQUEST");
		}

		return_response.log("request execution complete");
	}
	
	public CTSSHResponse execute(CTSSHRequest request) throws CTSSHException, XPathExpressionException, IOException, ParserConfigurationException {

		String run_key =  UUID.randomUUID().toString();//this is the unique identifier for this run
		CTSSHResponse response = new CTSSHResponse(run_key);
		response.setStartTime(".EXECUTE");
		execute_request(response, request, getTemplate(request.interfaceKey(), response));
		response.setEndTime(".EXECUTE");

		
		return response;

	}

	public static CTSSHandler instance() throws CTSSHException {

		if (SNGLETON == null)
			throw new CTSSHException("CTSSHandler has not been initialized");

		return SNGLETON;

	}

	

	
	
}
