package gov.va.caret.service.ctssh;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;



import javax.net.ssl.SSLSession;
//import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;


public class CTSSHUtil {

	//this has to be a sngleton because I am tracking the run times
	

//	private static SimpleDateFormat df = new SimpleDateFormat("mm:ss:SSS");
	
	private static Log _log = LogFactoryUtil.getLog(CTSSHUtil.class);
	

	public static void log(String message)
	{
		//replace this with liferay logging
		System.out.println(message);
		
	}
	
	
	
	public static java.net.URLConnection getServiceConnection(String urlstring) throws Exception
    {
           
           java.net.URLConnection return_connection = null;
           
           if(urlstring.toLowerCase().startsWith("https:"))
           {
               
                        javax.net.ssl.SSLContext ctx = javax.net.ssl.SSLContext.getInstance("TLS");//.getInstance("SSL");
                   ctx.init(new javax.net.ssl.KeyManager[0], new javax.net.ssl.TrustManager[] {new DefaultTrustManager()}, new SecureRandom());
                   javax.net.ssl.SSLContext.setDefault(ctx);
                   
                   java.net.URL url = new URL(null,urlstring ,new sun.net.www.protocol.https.Handler());
                   
                   javax.net.ssl.HttpsURLConnection conn = (javax.net.ssl.HttpsURLConnection) url.openConnection();
                   conn.setHostnameVerifier(new javax.net.ssl.HostnameVerifier() {
                       @Override
                       public boolean verify(String arg0, SSLSession arg1) {
                           return true;
                       }
                   });
                   
                   return_connection = conn;
                   
                                      
           }
           else
           if(urlstring.toLowerCase().startsWith("http:"))
           {
                  return_connection = (java.net.HttpURLConnection)  new URL(urlstring).openConnection();                    
           }
           else
                  throw new Exception("Protocol unsupported");
           
           
           
           return return_connection;
    }      

	
	
	
	
	
	public static String getPrettyPrintXML(String xml) {
        
		//this just formats the incomming xml so it's readable. 
		String rval ="";
		int indentation = 4;
		
		try {

        	Document document =  DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indentation);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
            transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
            transformer.setOutputProperty(OutputKeys.INDENT, "yes");

            // Return pretty print xml string
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            rval = stringWriter.toString();
            
            
            
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
		
		return rval;
    }

	public static String getPrettyPrintXML(Document doc) {
        
		//this just formats the incomming xml so it's readable. 
		String rval ="";
		int indentation = 4;
		
		try {

        	
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indentation);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
            transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
            transformer.setOutputProperty(OutputKeys.INDENT, "yes");

            // Return pretty print xml string
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(stringWriter));
            rval = stringWriter.toString();
            
            
            
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
		
		return rval;
    }
	public static String getPrettyPrintXML(Node n) {
        
		//this just formats the incomming xml so it's readable. 
		String rval ="";
		int indentation = 4;
		
		try {

        	
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indentation);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
            transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
            transformer.setOutputProperty(OutputKeys.INDENT, "yes");

            // Return pretty print xml string
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(n), new StreamResult(stringWriter));
            rval = stringWriter.toString();
            
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
		
		return rval;
    }
	public static String getTimeText(long time)
	{

		long secondsInMilli = 1000;
		long minutesInMilli = secondsInMilli * 60;
		
		StringBuilder sb = new StringBuilder();
		if(time > minutesInMilli)
		{
			
			sb.append("MIN : " + (time / minutesInMilli));
			time = time - ((time / minutesInMilli) * minutesInMilli);
		}else
			sb.append("MIN : 00");
		
		if(time > secondsInMilli)
		{
			
			sb.append("SEC : " + (time / secondsInMilli));
			time = time - ((time / secondsInMilli) * secondsInMilli);
		}else
			sb.append("SEC : 00");
		
		
		if(time > 0)
		{
			
			sb.append("MS : " + time);
		}else
			sb.append("MS : 00");
		
		
		return sb.toString();
		
	}	

	public static void log(Exception e)
	{
		//replace this with liferay logging
		e.printStackTrace();
		
	}
	
	public static String make_string(String string, int size)
	{
		StringBuilder sb = new StringBuilder();
		
		for(int x = 0; x < size; x++)
			sb.append(string);
		
		return sb.toString();
		
	}
	
	public static String make_string_size(String string, int size)
	{
	
		if(string == null)
			return make_string(" ", size);
		
		
		if(string.length() >= size)
			return string;
		else
			return string + String.format("%1$" + (size - string.length()) + "s", " ");
		
	}

	public static String make_string_size(Long value, int size) {
		
		String v = value.toString();
		if(v.length() >= size)
		{
			return v;
		}else
			return v + String.format("%1$" + (size - v.length()) + "s", " ");
		
	}
	
	
	
	
}
