package gov.va.caret.service.ctssh;

import java.util.UUID;

public class CTSSHTestMain {

	private static String template_path = CTSSHTestMain.class.getResource(".").getPath();
	
	public static String make_string_size(String string, int size)
	{
		return string + String.format("%1$" + (size - string.length()) + "s", " ");
		
	}	
	public static void main(String[] args) {

		//new CTSSHTestMain().test_mvi_unattended_search();
		//new CTSSHTestMain().test_mvi_attended_search();
		//new CTSSHTestMain().test_ee_summary_report();
		new CTSSHTestMain().test_tiu_notes(args);
		
		
	}

	
	
	private void test_tiu_notes(String[] args)
	{
		if (args.length < 1){
			System.err.print("pass your username and password...");
			return;
		}
		try{
			
			CTSSHandler.init(template_path, true);
			CTSSHRequest request = new CTSSHRequest(CTSSHConstants.VIA_WRITE_TIU_NOTE);

			//THESE ARE THE REQUIRED PARAMETERS TO WRITE A TIU NOTE
			request.setParameter(CTSSHConstants.FLD_VISTA_ACCESS_CODE, args[0]);//this is my vista id, don't share		
			request.setParameter(CTSSHConstants.FLD_VISTA_VERIFY_CODE, args[1]);//this is my vista pwd.  don't share
			request.setParameter(CTSSHConstants.FLD_VISTA_TARGET, "101126");// I don't know what this is - so I just left it
			request.setParameter(CTSSHConstants.FLD_VISTA_REQUESTING_APP, "VIA!Tester");//leave this
			request.setParameter(CTSSHConstants.FLD_VISTA_CONSUMINGAPPTOKEN, "VIA#Tester_ID");//leave this
			request.setParameter(CTSSHConstants.FLD_VISTA_CONSUMINGAPPPASSWORD, "iU6rW8xj1g");//leave this
			request.setParameter(CTSSHConstants.FLD_VISTA_SITE_CODE, "608");//I don't know if this ever changes - leave it for now
			request.setParameter(CTSSHConstants.FLD_VISTA_NOTE_TITLE_EIN, "1330");//we have to pass the EIN for a title for the note.  
			request.setParameter(CTSSHConstants.FLD_VISTA_NOTE_TEXT, "THIS IS A UUID JUST TO SHOW UNIQUENESS : " + UUID.randomUUID().toString());//this is the note body
			request.setParameter(CTSSHConstants.FLD_VISTA_PATIENT_ID, "7171870");//this is the patient id
			request.setParameter(CTSSHConstants.FLD_VISTA_PATIENT_SITE_ID, "608");//this is the patient site id
			
			CTSSHResponse response = CTSSHandler.instance().execute(request);

			
			
			//the response will have eveyrthing you need.  you don't have to access any records for TIU note.
			//these are all the things that will come back.  You can get each one with a "getString([fieldname])".
			//System.out.println(response.getString("RESULT_TEXT"));
			//if there is any kind of error on any call - an error will be thrown with the correct message and information.
			/*
			PAGE_COUNT                          : 1
			EIN                                 : 106
			DUZ                                 : KBafSHqYmZ1vFspgVhFzye9CW9brjRrmAh3eAvuxyWc=
			LAST_PAGE                           : 1
			ERROR                               : 0
			GREETING                            : Good morning ADAY,RONALD JOHN
			VISTADUZ                            : 101131
			SSN                                 : 999999800
			SITEID                              : 608
			RESULT_TEXT                         :  LOCAL TITLE: CARE COORDINATION HOME TELEHEALTH SUBSEQUENT EVAL NDATE OF NOTE: JUL 15, 2016@09:49:06  ENTRY DATE: JUL 15, 2016@09:49:07            AUTHOR: ADAY,RONALD JOHN     EXP COSIGNER:                                URGENCY:                            STATUS: UNSIGNED                      THIS IS A UUID JUST TO SHOW UNIQUENESS : 570c18aa-8c2d-4966-b38b-2d222361e695 
			NAME                                : ADAY,RONALD JOHN
			ERROR_MESSAGE                       : 			
			*/
			
			System.out.println(response.getRunReport());
			
			//if you are just dieing to see what all the calls did, run this.
			/*
			String delim = CTSSHUtil.make_string("=", 80);
			
			if(response.isResponseChain)
			{
				for(CTSSHResponse resp:response.responseChain)
				{
					System.out.println(resp.getReport());
					System.out.println(delim);
					System.out.println("REQUEST SOAP DATA");
					System.out.println(delim);
					System.out.println(resp.getRequestData());

					System.out.println(delim);
					System.out.println("RESPONSE RETURNED DATA");
					System.out.println(delim);
					System.out.println(resp.getResponseData());
					
				}
			}
			*/

		}catch(Exception e)
		{
			System.out.println(e.getMessage());
		}
				
		
	}
	
	private void test_ee_summary_report() {

	try{
		
			
			CTSSHandler.init(template_path, true);
			CTSSHRequest request = new CTSSHRequest(CTSSHConstants.EE_GET_SUMMARY);
			request.setParameter(CTSSHConstants.FLD_EE_KEY, "0000001008596039V736719000000");
			request.setParameter(CTSSHConstants.FLD_EE_KEY_TYPE, "VPID");
			request.setParameter(CTSSHConstants.FLD_EE_REQUEST_NAME, "CaregiverData");
			System.out.println(request.getReport());
			CTSSHResponse response = CTSSHandler.instance().execute(request);
			System.out.println(response.getReport());


		}catch(Exception e)
		{
			e.printStackTrace();
		}
				
		
		
	}
	
	private void test_mvi_attended_search()
	{
		
		try{
			

			
			CTSSHandler.init(template_path, true);
			CTSSHRequest request = new CTSSHRequest(CTSSHConstants.MVI_1305_ATTENDED_SEARCH);
			request.setParameter(CTSSHConstants.FLD_MVI_FIRSTNAME, "FRANKLEN");
			request.setParameter(CTSSHConstants.FLD_MVI_LASTNAME, "CASTLE");
			request.setParameter(CTSSHConstants.FLD_MVI_NAMETYPE, "L");
			request.setParameter(CTSSHConstants.FLD_MVI_DOB, "19780212");
			request.setParameter(CTSSHConstants.FLD_MVI_SSN, "201401001");
			
			request.setParameter(CTSSHConstants.FLD_MVI_SENDER_OID, "2.16.840.1.113883.4.349");
			request.setParameter(CTSSHConstants.FLD_MVI_SENDER_ID, "bfuser008");
			
			CTSSHResponse response = CTSSHandler.instance().execute(request);
			
			String delim = CTSSHUtil.make_string("=", 80);
			System.out.println(request.getReport());

			System.out.println(response.getReport());

			System.out.println(delim);
			System.out.println("REQUEST SOAP DATA");
			System.out.println(delim);
			System.out.println(response.getRequestData());

			System.out.println(delim);
			System.out.println("RESPONSE RETURNED DATA");
			System.out.println(delim);
			System.out.println(response.getResponseData());

			System.out.println(delim);
			System.out.println("RAW TEMPLATE DATA");
			System.out.println(delim);
			System.out.println(response.getTemplateData());

			System.out.println(delim);
			System.out.println("RUN LOG");
			System.out.println(delim);
			System.out.println(response.getLog());


		}catch(Exception e)
		{
			e.printStackTrace();
		}
				
		
	}

	private void test_mvi_unattended_search()
	{
		
		try{
		
			
			CTSSHandler.init(template_path, true);
			CTSSHRequest request = new CTSSHRequest(CTSSHConstants.MVI_1305_UNATTENDED_SEARCH);
			request.setParameter(CTSSHConstants.FLD_MVI_SENDER_OID, "2.16.840.1.113883.4.349");
			request.setParameter(CTSSHConstants.FLD_MVI_SENDER_ID, "bfuser008");
			request.setParameter(CTSSHConstants.FLD_MVI_SENDER_FIRSTNAME, "Frederick");
			request.setParameter(CTSSHConstants.FLD_MVI_SENDER_LASTNAME, "Krueger");
			request.setParameter(CTSSHConstants.FLD_MVI_GENDER, "M");
			request.setParameter(CTSSHConstants.FLD_MVI_DOB, "19810101");
			request.setParameter(CTSSHConstants.FLD_MVI_SSN, "666611111");
			request.setParameter(CTSSHConstants.FLD_MVI_FIRSTNAME, "NWHINZZZTESTPATIENT");
			request.setParameter(CTSSHConstants.FLD_MVI_LASTNAME, "NWHINONE");
			request.setParameter(CTSSHConstants.FLD_MVI_NAMETYPE, "L");
			request.setParameter(CTSSHConstants.FLD_MVI_ADDRESSTYPE, "PHYS");
			request.setParameter(CTSSHConstants.FLD_MVI_STREETADDRESS1, "2465 Cumberbatch Rd");
			request.setParameter(CTSSHConstants.FLD_MVI_CITY, "San Marino");
			request.setParameter(CTSSHConstants.FLD_MVI_STATE, "CA");
			request.setParameter(CTSSHConstants.FLD_MVI_POSTALCODE, "91033");
			request.setParameter(CTSSHConstants.FLD_MVI_COUNTRY, "USA");
			request.setParameter(CTSSHConstants.FLD_MVI_PATIENT_TELEPHONE, "tel:+1-626-626-6262");
			
			System.out.println(request.getReport());
			CTSSHResponse response = CTSSHandler.instance().execute(request);
			System.out.println(response.getReport());
		

		}catch(Exception e)
		{
			e.printStackTrace();
		}
				
		
	}
	
	
}
