package gov.va.caret.service.ctssh;

import java.util.Properties;
import java.util.Set;

public class CTSSHRequest {

	private String interface_key = null;
	
	protected Properties parameters;
	
	public CTSSHRequest(String interface_key)
	{
		this.interface_key = interface_key;
		this.parameters = new Properties();
	}	
	
	protected String interfaceKey()
	{
		return interface_key;
	}
	
	protected String getParameter(String key)
	{
		return parameters.getProperty(key);
	}
	
	public boolean safeSetParameter(String fldKey, String value )
	{
		if ( value != null && !value.isEmpty() ){
			setParameter( fldKey, value );
			return true;
		}
		return false;
	}
	
	public void setParameter(String key, String value)
	{
		parameters.setProperty(key, value);
	}
	
	public void setParameter(String key, int value)
	{
		parameters.setProperty(key, String.valueOf(value));
	}
	
	public void setParameter(String key, long value)
	{
		parameters.setProperty(key, String.valueOf(value));
	}
	
	public void setParameter(String key, double value)
	{
		parameters.setProperty(key, String.valueOf(value));
	}

	public String getReport() {

		

		
		StringBuilder sb = new StringBuilder();
		sb.append("\n");
		sb.append("===========================================\n");
		sb.append("CARE-T SOAP SERVICE HANDLER REQUEST REPORT\n");
		sb.append("===========================================\n");
		sb.append("REQUEST TYPE : " + interface_key + "\n");
		sb.append("PARAMETERS\n");
		sb.append("------------------------------------------------------\n");
		if(parameters == null || parameters.size() == 0)
			sb.append("-->  NO PARAMETERS SET <--\n");
		else
		{
			 Set<Object> keys = this.parameters.keySet();
   	         for(Object k:keys){
		          String key = (String)k;
		          sb.append(CTSSHUtil.make_string_size(key,20) + " : " + parameters.getProperty(key) + "\n");
	        }
		}
		
		sb.append("\n");

		return sb.toString();		
	}

	public void absorb(CTSSHResponse chain_response) {

		parameters.putAll(chain_response.response_properties);

		
	}
	
	
}
