package gov.va.caret.service.base;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.bean.IdentifiableBean;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.PersistedModel;
import com.liferay.portal.service.BaseLocalServiceImpl;
import com.liferay.portal.service.PersistedModelLocalServiceRegistryUtil;
import com.liferay.portal.service.persistence.UserPersistence;

import gov.va.caret.model.BgAsn;
import gov.va.caret.service.BgAsnLocalService;
import gov.va.caret.service.persistence.AssmtPersistence;
import gov.va.caret.service.persistence.AudLgPersistence;
import gov.va.caret.service.persistence.BgAsnPersistence;
import gov.va.caret.service.persistence.BgLaePersistence;
import gov.va.caret.service.persistence.BgNumPersistence;
import gov.va.caret.service.persistence.BlsAePersistence;
import gov.va.caret.service.persistence.BlsRePersistence;
import gov.va.caret.service.persistence.BoxGpPersistence;
import gov.va.caret.service.persistence.CalEtPersistence;
import gov.va.caret.service.persistence.CallPersistence;
import gov.va.caret.service.persistence.CaretFinder;
import gov.va.caret.service.persistence.CespPersistence;
import gov.va.caret.service.persistence.ClSocPersistence;
import gov.va.caret.service.persistence.CryptoPersistence;
import gov.va.caret.service.persistence.DocumPersistence;
import gov.va.caret.service.persistence.FacilPersistence;
import gov.va.caret.service.persistence.NotePersistence;
import gov.va.caret.service.persistence.NotifPersistence;
import gov.va.caret.service.persistence.PayLgPersistence;
import gov.va.caret.service.persistence.PersnPersistence;
import gov.va.caret.service.persistence.StiPtPersistence;
import gov.va.caret.service.persistence.StiRdPersistence;
import gov.va.caret.service.persistence.VcgAnPersistence;
import gov.va.caret.service.persistence.VcgPersistence;
import gov.va.caret.service.persistence.VendrPersistence;
import gov.va.caret.service.persistence.VetVrPersistence;
import gov.va.caret.service.persistence.WaivrPersistence;
import gov.va.caret.service.persistence.WorImPersistence;
import gov.va.caret.service.persistence.ZipFyPersistence;

import java.io.Serializable;

import java.util.List;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the bg asn local service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link gov.va.caret.service.impl.BgAsnLocalServiceImpl}.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.impl.BgAsnLocalServiceImpl
 * @see gov.va.caret.service.BgAsnLocalServiceUtil
 * @generated
 */
public abstract class BgAsnLocalServiceBaseImpl extends BaseLocalServiceImpl
    implements BgAsnLocalService, IdentifiableBean {
    @BeanReference(type = gov.va.caret.service.AssmtLocalService.class)
    protected gov.va.caret.service.AssmtLocalService assmtLocalService;
    @BeanReference(type = AssmtPersistence.class)
    protected AssmtPersistence assmtPersistence;
    @BeanReference(type = gov.va.caret.service.AudLgLocalService.class)
    protected gov.va.caret.service.AudLgLocalService audLgLocalService;
    @BeanReference(type = AudLgPersistence.class)
    protected AudLgPersistence audLgPersistence;
    @BeanReference(type = gov.va.caret.service.BgAsnLocalService.class)
    protected gov.va.caret.service.BgAsnLocalService bgAsnLocalService;
    @BeanReference(type = BgAsnPersistence.class)
    protected BgAsnPersistence bgAsnPersistence;
    @BeanReference(type = gov.va.caret.service.BgLaeLocalService.class)
    protected gov.va.caret.service.BgLaeLocalService bgLaeLocalService;
    @BeanReference(type = BgLaePersistence.class)
    protected BgLaePersistence bgLaePersistence;
    @BeanReference(type = gov.va.caret.service.BgNumLocalService.class)
    protected gov.va.caret.service.BgNumLocalService bgNumLocalService;
    @BeanReference(type = BgNumPersistence.class)
    protected BgNumPersistence bgNumPersistence;
    @BeanReference(type = gov.va.caret.service.BlsAeLocalService.class)
    protected gov.va.caret.service.BlsAeLocalService blsAeLocalService;
    @BeanReference(type = BlsAePersistence.class)
    protected BlsAePersistence blsAePersistence;
    @BeanReference(type = gov.va.caret.service.BlsReLocalService.class)
    protected gov.va.caret.service.BlsReLocalService blsReLocalService;
    @BeanReference(type = BlsRePersistence.class)
    protected BlsRePersistence blsRePersistence;
    @BeanReference(type = gov.va.caret.service.BoxGpLocalService.class)
    protected gov.va.caret.service.BoxGpLocalService boxGpLocalService;
    @BeanReference(type = BoxGpPersistence.class)
    protected BoxGpPersistence boxGpPersistence;
    @BeanReference(type = gov.va.caret.service.CalEtLocalService.class)
    protected gov.va.caret.service.CalEtLocalService calEtLocalService;
    @BeanReference(type = CalEtPersistence.class)
    protected CalEtPersistence calEtPersistence;
    @BeanReference(type = gov.va.caret.service.CallLocalService.class)
    protected gov.va.caret.service.CallLocalService callLocalService;
    @BeanReference(type = CallPersistence.class)
    protected CallPersistence callPersistence;
    @BeanReference(type = gov.va.caret.service.CaretLocalService.class)
    protected gov.va.caret.service.CaretLocalService caretLocalService;
    @BeanReference(type = CaretFinder.class)
    protected CaretFinder caretFinder;
    @BeanReference(type = gov.va.caret.service.CespLocalService.class)
    protected gov.va.caret.service.CespLocalService cespLocalService;
    @BeanReference(type = CespPersistence.class)
    protected CespPersistence cespPersistence;
    @BeanReference(type = gov.va.caret.service.ClSocLocalService.class)
    protected gov.va.caret.service.ClSocLocalService clSocLocalService;
    @BeanReference(type = ClSocPersistence.class)
    protected ClSocPersistence clSocPersistence;
    @BeanReference(type = gov.va.caret.service.CryptoLocalService.class)
    protected gov.va.caret.service.CryptoLocalService cryptoLocalService;
    @BeanReference(type = CryptoPersistence.class)
    protected CryptoPersistence cryptoPersistence;
    @BeanReference(type = gov.va.caret.service.DocumLocalService.class)
    protected gov.va.caret.service.DocumLocalService documLocalService;
    @BeanReference(type = DocumPersistence.class)
    protected DocumPersistence documPersistence;
    @BeanReference(type = gov.va.caret.service.FacilLocalService.class)
    protected gov.va.caret.service.FacilLocalService facilLocalService;
    @BeanReference(type = FacilPersistence.class)
    protected FacilPersistence facilPersistence;
    @BeanReference(type = gov.va.caret.service.NoteLocalService.class)
    protected gov.va.caret.service.NoteLocalService noteLocalService;
    @BeanReference(type = NotePersistence.class)
    protected NotePersistence notePersistence;
    @BeanReference(type = gov.va.caret.service.NotifLocalService.class)
    protected gov.va.caret.service.NotifLocalService notifLocalService;
    @BeanReference(type = NotifPersistence.class)
    protected NotifPersistence notifPersistence;
    @BeanReference(type = gov.va.caret.service.PayLgLocalService.class)
    protected gov.va.caret.service.PayLgLocalService payLgLocalService;
    @BeanReference(type = PayLgPersistence.class)
    protected PayLgPersistence payLgPersistence;
    @BeanReference(type = gov.va.caret.service.PersnLocalService.class)
    protected gov.va.caret.service.PersnLocalService persnLocalService;
    @BeanReference(type = PersnPersistence.class)
    protected PersnPersistence persnPersistence;
    @BeanReference(type = gov.va.caret.service.StiPtLocalService.class)
    protected gov.va.caret.service.StiPtLocalService stiPtLocalService;
    @BeanReference(type = StiPtPersistence.class)
    protected StiPtPersistence stiPtPersistence;
    @BeanReference(type = gov.va.caret.service.StiRdLocalService.class)
    protected gov.va.caret.service.StiRdLocalService stiRdLocalService;
    @BeanReference(type = StiRdPersistence.class)
    protected StiRdPersistence stiRdPersistence;
    @BeanReference(type = gov.va.caret.service.VcgLocalService.class)
    protected gov.va.caret.service.VcgLocalService vcgLocalService;
    @BeanReference(type = VcgPersistence.class)
    protected VcgPersistence vcgPersistence;
    @BeanReference(type = gov.va.caret.service.VcgAnLocalService.class)
    protected gov.va.caret.service.VcgAnLocalService vcgAnLocalService;
    @BeanReference(type = VcgAnPersistence.class)
    protected VcgAnPersistence vcgAnPersistence;
    @BeanReference(type = gov.va.caret.service.VendrLocalService.class)
    protected gov.va.caret.service.VendrLocalService vendrLocalService;
    @BeanReference(type = VendrPersistence.class)
    protected VendrPersistence vendrPersistence;
    @BeanReference(type = gov.va.caret.service.VetVrLocalService.class)
    protected gov.va.caret.service.VetVrLocalService vetVrLocalService;
    @BeanReference(type = VetVrPersistence.class)
    protected VetVrPersistence vetVrPersistence;
    @BeanReference(type = gov.va.caret.service.WaivrLocalService.class)
    protected gov.va.caret.service.WaivrLocalService waivrLocalService;
    @BeanReference(type = WaivrPersistence.class)
    protected WaivrPersistence waivrPersistence;
    @BeanReference(type = gov.va.caret.service.WorImLocalService.class)
    protected gov.va.caret.service.WorImLocalService worImLocalService;
    @BeanReference(type = WorImPersistence.class)
    protected WorImPersistence worImPersistence;
    @BeanReference(type = gov.va.caret.service.ZipFyLocalService.class)
    protected gov.va.caret.service.ZipFyLocalService zipFyLocalService;
    @BeanReference(type = ZipFyPersistence.class)
    protected ZipFyPersistence zipFyPersistence;
    @BeanReference(type = com.liferay.counter.service.CounterLocalService.class)
    protected com.liferay.counter.service.CounterLocalService counterLocalService;
    @BeanReference(type = com.liferay.portal.service.ResourceLocalService.class)
    protected com.liferay.portal.service.ResourceLocalService resourceLocalService;
    @BeanReference(type = com.liferay.portal.service.UserLocalService.class)
    protected com.liferay.portal.service.UserLocalService userLocalService;
    @BeanReference(type = com.liferay.portal.service.UserService.class)
    protected com.liferay.portal.service.UserService userService;
    @BeanReference(type = UserPersistence.class)
    protected UserPersistence userPersistence;
    private String _beanIdentifier;
    private ClassLoader _classLoader;
    private BgAsnLocalServiceClpInvoker _clpInvoker = new BgAsnLocalServiceClpInvoker();

    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. Always use {@link gov.va.caret.service.BgAsnLocalServiceUtil} to access the bg asn local service.
     */

    /**
     * Adds the bg asn to the database. Also notifies the appropriate model listeners.
     *
     * @param bgAsn the bg asn
     * @return the bg asn that was added
     * @throws SystemException if a system exception occurred
     */
    @Indexable(type = IndexableType.REINDEX)
    @Override
    public BgAsn addBgAsn(BgAsn bgAsn) throws SystemException {
        bgAsn.setNew(true);

        return bgAsnPersistence.update(bgAsn);
    }

    /**
     * Creates a new bg asn with the primary key. Does not add the bg asn to the database.
     *
     * @param bgAsnId the primary key for the new bg asn
     * @return the new bg asn
     */
    @Override
    public BgAsn createBgAsn(long bgAsnId) {
        return bgAsnPersistence.create(bgAsnId);
    }

    /**
     * Deletes the bg asn with the primary key from the database. Also notifies the appropriate model listeners.
     *
     * @param bgAsnId the primary key of the bg asn
     * @return the bg asn that was removed
     * @throws PortalException if a bg asn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Indexable(type = IndexableType.DELETE)
    @Override
    public BgAsn deleteBgAsn(long bgAsnId)
        throws PortalException, SystemException {
        return bgAsnPersistence.remove(bgAsnId);
    }

    /**
     * Deletes the bg asn from the database. Also notifies the appropriate model listeners.
     *
     * @param bgAsn the bg asn
     * @return the bg asn that was removed
     * @throws SystemException if a system exception occurred
     */
    @Indexable(type = IndexableType.DELETE)
    @Override
    public BgAsn deleteBgAsn(BgAsn bgAsn) throws SystemException {
        return bgAsnPersistence.remove(bgAsn);
    }

    @Override
    public DynamicQuery dynamicQuery() {
        Class<?> clazz = getClass();

        return DynamicQueryFactoryUtil.forClass(BgAsn.class,
            clazz.getClassLoader());
    }

    /**
     * Performs a dynamic query on the database and returns the matching rows.
     *
     * @param dynamicQuery the dynamic query
     * @return the matching rows
     * @throws SystemException if a system exception occurred
     */
    @Override
    @SuppressWarnings("rawtypes")
    public List dynamicQuery(DynamicQuery dynamicQuery)
        throws SystemException {
        return bgAsnPersistence.findWithDynamicQuery(dynamicQuery);
    }

    /**
     * Performs a dynamic query on the database and returns a range of the matching rows.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param dynamicQuery the dynamic query
     * @param start the lower bound of the range of model instances
     * @param end the upper bound of the range of model instances (not inclusive)
     * @return the range of matching rows
     * @throws SystemException if a system exception occurred
     */
    @Override
    @SuppressWarnings("rawtypes")
    public List dynamicQuery(DynamicQuery dynamicQuery, int start, int end)
        throws SystemException {
        return bgAsnPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    /**
     * Performs a dynamic query on the database and returns an ordered range of the matching rows.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param dynamicQuery the dynamic query
     * @param start the lower bound of the range of model instances
     * @param end the upper bound of the range of model instances (not inclusive)
     * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
     * @return the ordered range of matching rows
     * @throws SystemException if a system exception occurred
     */
    @Override
    @SuppressWarnings("rawtypes")
    public List dynamicQuery(DynamicQuery dynamicQuery, int start, int end,
        OrderByComparator orderByComparator) throws SystemException {
        return bgAsnPersistence.findWithDynamicQuery(dynamicQuery, start, end,
            orderByComparator);
    }

    /**
     * Returns the number of rows that match the dynamic query.
     *
     * @param dynamicQuery the dynamic query
     * @return the number of rows that match the dynamic query
     * @throws SystemException if a system exception occurred
     */
    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery)
        throws SystemException {
        return bgAsnPersistence.countWithDynamicQuery(dynamicQuery);
    }

    /**
     * Returns the number of rows that match the dynamic query.
     *
     * @param dynamicQuery the dynamic query
     * @param projection the projection to apply to the query
     * @return the number of rows that match the dynamic query
     * @throws SystemException if a system exception occurred
     */
    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery,
        Projection projection) throws SystemException {
        return bgAsnPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    @Override
    public BgAsn fetchBgAsn(long bgAsnId) throws SystemException {
        return bgAsnPersistence.fetchByPrimaryKey(bgAsnId);
    }

    /**
     * Returns the bg asn with the primary key.
     *
     * @param bgAsnId the primary key of the bg asn
     * @return the bg asn
     * @throws PortalException if a bg asn with the primary key could not be found
     * @throws SystemException if a system exception occurred
     */
    @Override
    public BgAsn getBgAsn(long bgAsnId) throws PortalException, SystemException {
        return bgAsnPersistence.findByPrimaryKey(bgAsnId);
    }

    @Override
    public PersistedModel getPersistedModel(Serializable primaryKeyObj)
        throws PortalException, SystemException {
        return bgAsnPersistence.findByPrimaryKey(primaryKeyObj);
    }

    /**
     * Returns a range of all the bg asns.
     *
     * <p>
     * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link gov.va.caret.model.impl.BgAsnModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
     * </p>
     *
     * @param start the lower bound of the range of bg asns
     * @param end the upper bound of the range of bg asns (not inclusive)
     * @return the range of bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public List<BgAsn> getBgAsns(int start, int end) throws SystemException {
        return bgAsnPersistence.findAll(start, end);
    }

    /**
     * Returns the number of bg asns.
     *
     * @return the number of bg asns
     * @throws SystemException if a system exception occurred
     */
    @Override
    public int getBgAsnsCount() throws SystemException {
        return bgAsnPersistence.countAll();
    }

    /**
     * Updates the bg asn in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
     *
     * @param bgAsn the bg asn
     * @return the bg asn that was updated
     * @throws SystemException if a system exception occurred
     */
    @Indexable(type = IndexableType.REINDEX)
    @Override
    public BgAsn updateBgAsn(BgAsn bgAsn) throws SystemException {
        return bgAsnPersistence.update(bgAsn);
    }

    /**
     * Returns the assmt local service.
     *
     * @return the assmt local service
     */
    public gov.va.caret.service.AssmtLocalService getAssmtLocalService() {
        return assmtLocalService;
    }

    /**
     * Sets the assmt local service.
     *
     * @param assmtLocalService the assmt local service
     */
    public void setAssmtLocalService(
        gov.va.caret.service.AssmtLocalService assmtLocalService) {
        this.assmtLocalService = assmtLocalService;
    }

    /**
     * Returns the assmt persistence.
     *
     * @return the assmt persistence
     */
    public AssmtPersistence getAssmtPersistence() {
        return assmtPersistence;
    }

    /**
     * Sets the assmt persistence.
     *
     * @param assmtPersistence the assmt persistence
     */
    public void setAssmtPersistence(AssmtPersistence assmtPersistence) {
        this.assmtPersistence = assmtPersistence;
    }

    /**
     * Returns the aud lg local service.
     *
     * @return the aud lg local service
     */
    public gov.va.caret.service.AudLgLocalService getAudLgLocalService() {
        return audLgLocalService;
    }

    /**
     * Sets the aud lg local service.
     *
     * @param audLgLocalService the aud lg local service
     */
    public void setAudLgLocalService(
        gov.va.caret.service.AudLgLocalService audLgLocalService) {
        this.audLgLocalService = audLgLocalService;
    }

    /**
     * Returns the aud lg persistence.
     *
     * @return the aud lg persistence
     */
    public AudLgPersistence getAudLgPersistence() {
        return audLgPersistence;
    }

    /**
     * Sets the aud lg persistence.
     *
     * @param audLgPersistence the aud lg persistence
     */
    public void setAudLgPersistence(AudLgPersistence audLgPersistence) {
        this.audLgPersistence = audLgPersistence;
    }

    /**
     * Returns the bg asn local service.
     *
     * @return the bg asn local service
     */
    public gov.va.caret.service.BgAsnLocalService getBgAsnLocalService() {
        return bgAsnLocalService;
    }

    /**
     * Sets the bg asn local service.
     *
     * @param bgAsnLocalService the bg asn local service
     */
    public void setBgAsnLocalService(
        gov.va.caret.service.BgAsnLocalService bgAsnLocalService) {
        this.bgAsnLocalService = bgAsnLocalService;
    }

    /**
     * Returns the bg asn persistence.
     *
     * @return the bg asn persistence
     */
    public BgAsnPersistence getBgAsnPersistence() {
        return bgAsnPersistence;
    }

    /**
     * Sets the bg asn persistence.
     *
     * @param bgAsnPersistence the bg asn persistence
     */
    public void setBgAsnPersistence(BgAsnPersistence bgAsnPersistence) {
        this.bgAsnPersistence = bgAsnPersistence;
    }

    /**
     * Returns the bg lae local service.
     *
     * @return the bg lae local service
     */
    public gov.va.caret.service.BgLaeLocalService getBgLaeLocalService() {
        return bgLaeLocalService;
    }

    /**
     * Sets the bg lae local service.
     *
     * @param bgLaeLocalService the bg lae local service
     */
    public void setBgLaeLocalService(
        gov.va.caret.service.BgLaeLocalService bgLaeLocalService) {
        this.bgLaeLocalService = bgLaeLocalService;
    }

    /**
     * Returns the bg lae persistence.
     *
     * @return the bg lae persistence
     */
    public BgLaePersistence getBgLaePersistence() {
        return bgLaePersistence;
    }

    /**
     * Sets the bg lae persistence.
     *
     * @param bgLaePersistence the bg lae persistence
     */
    public void setBgLaePersistence(BgLaePersistence bgLaePersistence) {
        this.bgLaePersistence = bgLaePersistence;
    }

    /**
     * Returns the bg num local service.
     *
     * @return the bg num local service
     */
    public gov.va.caret.service.BgNumLocalService getBgNumLocalService() {
        return bgNumLocalService;
    }

    /**
     * Sets the bg num local service.
     *
     * @param bgNumLocalService the bg num local service
     */
    public void setBgNumLocalService(
        gov.va.caret.service.BgNumLocalService bgNumLocalService) {
        this.bgNumLocalService = bgNumLocalService;
    }

    /**
     * Returns the bg num persistence.
     *
     * @return the bg num persistence
     */
    public BgNumPersistence getBgNumPersistence() {
        return bgNumPersistence;
    }

    /**
     * Sets the bg num persistence.
     *
     * @param bgNumPersistence the bg num persistence
     */
    public void setBgNumPersistence(BgNumPersistence bgNumPersistence) {
        this.bgNumPersistence = bgNumPersistence;
    }

    /**
     * Returns the bls ae local service.
     *
     * @return the bls ae local service
     */
    public gov.va.caret.service.BlsAeLocalService getBlsAeLocalService() {
        return blsAeLocalService;
    }

    /**
     * Sets the bls ae local service.
     *
     * @param blsAeLocalService the bls ae local service
     */
    public void setBlsAeLocalService(
        gov.va.caret.service.BlsAeLocalService blsAeLocalService) {
        this.blsAeLocalService = blsAeLocalService;
    }

    /**
     * Returns the bls ae persistence.
     *
     * @return the bls ae persistence
     */
    public BlsAePersistence getBlsAePersistence() {
        return blsAePersistence;
    }

    /**
     * Sets the bls ae persistence.
     *
     * @param blsAePersistence the bls ae persistence
     */
    public void setBlsAePersistence(BlsAePersistence blsAePersistence) {
        this.blsAePersistence = blsAePersistence;
    }

    /**
     * Returns the bls re local service.
     *
     * @return the bls re local service
     */
    public gov.va.caret.service.BlsReLocalService getBlsReLocalService() {
        return blsReLocalService;
    }

    /**
     * Sets the bls re local service.
     *
     * @param blsReLocalService the bls re local service
     */
    public void setBlsReLocalService(
        gov.va.caret.service.BlsReLocalService blsReLocalService) {
        this.blsReLocalService = blsReLocalService;
    }

    /**
     * Returns the bls re persistence.
     *
     * @return the bls re persistence
     */
    public BlsRePersistence getBlsRePersistence() {
        return blsRePersistence;
    }

    /**
     * Sets the bls re persistence.
     *
     * @param blsRePersistence the bls re persistence
     */
    public void setBlsRePersistence(BlsRePersistence blsRePersistence) {
        this.blsRePersistence = blsRePersistence;
    }

    /**
     * Returns the box gp local service.
     *
     * @return the box gp local service
     */
    public gov.va.caret.service.BoxGpLocalService getBoxGpLocalService() {
        return boxGpLocalService;
    }

    /**
     * Sets the box gp local service.
     *
     * @param boxGpLocalService the box gp local service
     */
    public void setBoxGpLocalService(
        gov.va.caret.service.BoxGpLocalService boxGpLocalService) {
        this.boxGpLocalService = boxGpLocalService;
    }

    /**
     * Returns the box gp persistence.
     *
     * @return the box gp persistence
     */
    public BoxGpPersistence getBoxGpPersistence() {
        return boxGpPersistence;
    }

    /**
     * Sets the box gp persistence.
     *
     * @param boxGpPersistence the box gp persistence
     */
    public void setBoxGpPersistence(BoxGpPersistence boxGpPersistence) {
        this.boxGpPersistence = boxGpPersistence;
    }

    /**
     * Returns the cal et local service.
     *
     * @return the cal et local service
     */
    public gov.va.caret.service.CalEtLocalService getCalEtLocalService() {
        return calEtLocalService;
    }

    /**
     * Sets the cal et local service.
     *
     * @param calEtLocalService the cal et local service
     */
    public void setCalEtLocalService(
        gov.va.caret.service.CalEtLocalService calEtLocalService) {
        this.calEtLocalService = calEtLocalService;
    }

    /**
     * Returns the cal et persistence.
     *
     * @return the cal et persistence
     */
    public CalEtPersistence getCalEtPersistence() {
        return calEtPersistence;
    }

    /**
     * Sets the cal et persistence.
     *
     * @param calEtPersistence the cal et persistence
     */
    public void setCalEtPersistence(CalEtPersistence calEtPersistence) {
        this.calEtPersistence = calEtPersistence;
    }

    /**
     * Returns the call local service.
     *
     * @return the call local service
     */
    public gov.va.caret.service.CallLocalService getCallLocalService() {
        return callLocalService;
    }

    /**
     * Sets the call local service.
     *
     * @param callLocalService the call local service
     */
    public void setCallLocalService(
        gov.va.caret.service.CallLocalService callLocalService) {
        this.callLocalService = callLocalService;
    }

    /**
     * Returns the call persistence.
     *
     * @return the call persistence
     */
    public CallPersistence getCallPersistence() {
        return callPersistence;
    }

    /**
     * Sets the call persistence.
     *
     * @param callPersistence the call persistence
     */
    public void setCallPersistence(CallPersistence callPersistence) {
        this.callPersistence = callPersistence;
    }

    /**
     * Returns the caret local service.
     *
     * @return the caret local service
     */
    public gov.va.caret.service.CaretLocalService getCaretLocalService() {
        return caretLocalService;
    }

    /**
     * Sets the caret local service.
     *
     * @param caretLocalService the caret local service
     */
    public void setCaretLocalService(
        gov.va.caret.service.CaretLocalService caretLocalService) {
        this.caretLocalService = caretLocalService;
    }

    /**
     * Returns the caret finder.
     *
     * @return the caret finder
     */
    public CaretFinder getCaretFinder() {
        return caretFinder;
    }

    /**
     * Sets the caret finder.
     *
     * @param caretFinder the caret finder
     */
    public void setCaretFinder(CaretFinder caretFinder) {
        this.caretFinder = caretFinder;
    }

    /**
     * Returns the cesp local service.
     *
     * @return the cesp local service
     */
    public gov.va.caret.service.CespLocalService getCespLocalService() {
        return cespLocalService;
    }

    /**
     * Sets the cesp local service.
     *
     * @param cespLocalService the cesp local service
     */
    public void setCespLocalService(
        gov.va.caret.service.CespLocalService cespLocalService) {
        this.cespLocalService = cespLocalService;
    }

    /**
     * Returns the cesp persistence.
     *
     * @return the cesp persistence
     */
    public CespPersistence getCespPersistence() {
        return cespPersistence;
    }

    /**
     * Sets the cesp persistence.
     *
     * @param cespPersistence the cesp persistence
     */
    public void setCespPersistence(CespPersistence cespPersistence) {
        this.cespPersistence = cespPersistence;
    }

    /**
     * Returns the cl soc local service.
     *
     * @return the cl soc local service
     */
    public gov.va.caret.service.ClSocLocalService getClSocLocalService() {
        return clSocLocalService;
    }

    /**
     * Sets the cl soc local service.
     *
     * @param clSocLocalService the cl soc local service
     */
    public void setClSocLocalService(
        gov.va.caret.service.ClSocLocalService clSocLocalService) {
        this.clSocLocalService = clSocLocalService;
    }

    /**
     * Returns the cl soc persistence.
     *
     * @return the cl soc persistence
     */
    public ClSocPersistence getClSocPersistence() {
        return clSocPersistence;
    }

    /**
     * Sets the cl soc persistence.
     *
     * @param clSocPersistence the cl soc persistence
     */
    public void setClSocPersistence(ClSocPersistence clSocPersistence) {
        this.clSocPersistence = clSocPersistence;
    }

    /**
     * Returns the crypto local service.
     *
     * @return the crypto local service
     */
    public gov.va.caret.service.CryptoLocalService getCryptoLocalService() {
        return cryptoLocalService;
    }

    /**
     * Sets the crypto local service.
     *
     * @param cryptoLocalService the crypto local service
     */
    public void setCryptoLocalService(
        gov.va.caret.service.CryptoLocalService cryptoLocalService) {
        this.cryptoLocalService = cryptoLocalService;
    }

    /**
     * Returns the crypto persistence.
     *
     * @return the crypto persistence
     */
    public CryptoPersistence getCryptoPersistence() {
        return cryptoPersistence;
    }

    /**
     * Sets the crypto persistence.
     *
     * @param cryptoPersistence the crypto persistence
     */
    public void setCryptoPersistence(CryptoPersistence cryptoPersistence) {
        this.cryptoPersistence = cryptoPersistence;
    }

    /**
     * Returns the docum local service.
     *
     * @return the docum local service
     */
    public gov.va.caret.service.DocumLocalService getDocumLocalService() {
        return documLocalService;
    }

    /**
     * Sets the docum local service.
     *
     * @param documLocalService the docum local service
     */
    public void setDocumLocalService(
        gov.va.caret.service.DocumLocalService documLocalService) {
        this.documLocalService = documLocalService;
    }

    /**
     * Returns the docum persistence.
     *
     * @return the docum persistence
     */
    public DocumPersistence getDocumPersistence() {
        return documPersistence;
    }

    /**
     * Sets the docum persistence.
     *
     * @param documPersistence the docum persistence
     */
    public void setDocumPersistence(DocumPersistence documPersistence) {
        this.documPersistence = documPersistence;
    }

    /**
     * Returns the facil local service.
     *
     * @return the facil local service
     */
    public gov.va.caret.service.FacilLocalService getFacilLocalService() {
        return facilLocalService;
    }

    /**
     * Sets the facil local service.
     *
     * @param facilLocalService the facil local service
     */
    public void setFacilLocalService(
        gov.va.caret.service.FacilLocalService facilLocalService) {
        this.facilLocalService = facilLocalService;
    }

    /**
     * Returns the facil persistence.
     *
     * @return the facil persistence
     */
    public FacilPersistence getFacilPersistence() {
        return facilPersistence;
    }

    /**
     * Sets the facil persistence.
     *
     * @param facilPersistence the facil persistence
     */
    public void setFacilPersistence(FacilPersistence facilPersistence) {
        this.facilPersistence = facilPersistence;
    }

    /**
     * Returns the note local service.
     *
     * @return the note local service
     */
    public gov.va.caret.service.NoteLocalService getNoteLocalService() {
        return noteLocalService;
    }

    /**
     * Sets the note local service.
     *
     * @param noteLocalService the note local service
     */
    public void setNoteLocalService(
        gov.va.caret.service.NoteLocalService noteLocalService) {
        this.noteLocalService = noteLocalService;
    }

    /**
     * Returns the note persistence.
     *
     * @return the note persistence
     */
    public NotePersistence getNotePersistence() {
        return notePersistence;
    }

    /**
     * Sets the note persistence.
     *
     * @param notePersistence the note persistence
     */
    public void setNotePersistence(NotePersistence notePersistence) {
        this.notePersistence = notePersistence;
    }

    /**
     * Returns the notif local service.
     *
     * @return the notif local service
     */
    public gov.va.caret.service.NotifLocalService getNotifLocalService() {
        return notifLocalService;
    }

    /**
     * Sets the notif local service.
     *
     * @param notifLocalService the notif local service
     */
    public void setNotifLocalService(
        gov.va.caret.service.NotifLocalService notifLocalService) {
        this.notifLocalService = notifLocalService;
    }

    /**
     * Returns the notif persistence.
     *
     * @return the notif persistence
     */
    public NotifPersistence getNotifPersistence() {
        return notifPersistence;
    }

    /**
     * Sets the notif persistence.
     *
     * @param notifPersistence the notif persistence
     */
    public void setNotifPersistence(NotifPersistence notifPersistence) {
        this.notifPersistence = notifPersistence;
    }

    /**
     * Returns the pay lg local service.
     *
     * @return the pay lg local service
     */
    public gov.va.caret.service.PayLgLocalService getPayLgLocalService() {
        return payLgLocalService;
    }

    /**
     * Sets the pay lg local service.
     *
     * @param payLgLocalService the pay lg local service
     */
    public void setPayLgLocalService(
        gov.va.caret.service.PayLgLocalService payLgLocalService) {
        this.payLgLocalService = payLgLocalService;
    }

    /**
     * Returns the pay lg persistence.
     *
     * @return the pay lg persistence
     */
    public PayLgPersistence getPayLgPersistence() {
        return payLgPersistence;
    }

    /**
     * Sets the pay lg persistence.
     *
     * @param payLgPersistence the pay lg persistence
     */
    public void setPayLgPersistence(PayLgPersistence payLgPersistence) {
        this.payLgPersistence = payLgPersistence;
    }

    /**
     * Returns the persn local service.
     *
     * @return the persn local service
     */
    public gov.va.caret.service.PersnLocalService getPersnLocalService() {
        return persnLocalService;
    }

    /**
     * Sets the persn local service.
     *
     * @param persnLocalService the persn local service
     */
    public void setPersnLocalService(
        gov.va.caret.service.PersnLocalService persnLocalService) {
        this.persnLocalService = persnLocalService;
    }

    /**
     * Returns the persn persistence.
     *
     * @return the persn persistence
     */
    public PersnPersistence getPersnPersistence() {
        return persnPersistence;
    }

    /**
     * Sets the persn persistence.
     *
     * @param persnPersistence the persn persistence
     */
    public void setPersnPersistence(PersnPersistence persnPersistence) {
        this.persnPersistence = persnPersistence;
    }

    /**
     * Returns the sti pt local service.
     *
     * @return the sti pt local service
     */
    public gov.va.caret.service.StiPtLocalService getStiPtLocalService() {
        return stiPtLocalService;
    }

    /**
     * Sets the sti pt local service.
     *
     * @param stiPtLocalService the sti pt local service
     */
    public void setStiPtLocalService(
        gov.va.caret.service.StiPtLocalService stiPtLocalService) {
        this.stiPtLocalService = stiPtLocalService;
    }

    /**
     * Returns the sti pt persistence.
     *
     * @return the sti pt persistence
     */
    public StiPtPersistence getStiPtPersistence() {
        return stiPtPersistence;
    }

    /**
     * Sets the sti pt persistence.
     *
     * @param stiPtPersistence the sti pt persistence
     */
    public void setStiPtPersistence(StiPtPersistence stiPtPersistence) {
        this.stiPtPersistence = stiPtPersistence;
    }

    /**
     * Returns the sti rd local service.
     *
     * @return the sti rd local service
     */
    public gov.va.caret.service.StiRdLocalService getStiRdLocalService() {
        return stiRdLocalService;
    }

    /**
     * Sets the sti rd local service.
     *
     * @param stiRdLocalService the sti rd local service
     */
    public void setStiRdLocalService(
        gov.va.caret.service.StiRdLocalService stiRdLocalService) {
        this.stiRdLocalService = stiRdLocalService;
    }

    /**
     * Returns the sti rd persistence.
     *
     * @return the sti rd persistence
     */
    public StiRdPersistence getStiRdPersistence() {
        return stiRdPersistence;
    }

    /**
     * Sets the sti rd persistence.
     *
     * @param stiRdPersistence the sti rd persistence
     */
    public void setStiRdPersistence(StiRdPersistence stiRdPersistence) {
        this.stiRdPersistence = stiRdPersistence;
    }

    /**
     * Returns the vcg local service.
     *
     * @return the vcg local service
     */
    public gov.va.caret.service.VcgLocalService getVcgLocalService() {
        return vcgLocalService;
    }

    /**
     * Sets the vcg local service.
     *
     * @param vcgLocalService the vcg local service
     */
    public void setVcgLocalService(
        gov.va.caret.service.VcgLocalService vcgLocalService) {
        this.vcgLocalService = vcgLocalService;
    }

    /**
     * Returns the vcg persistence.
     *
     * @return the vcg persistence
     */
    public VcgPersistence getVcgPersistence() {
        return vcgPersistence;
    }

    /**
     * Sets the vcg persistence.
     *
     * @param vcgPersistence the vcg persistence
     */
    public void setVcgPersistence(VcgPersistence vcgPersistence) {
        this.vcgPersistence = vcgPersistence;
    }

    /**
     * Returns the vcg an local service.
     *
     * @return the vcg an local service
     */
    public gov.va.caret.service.VcgAnLocalService getVcgAnLocalService() {
        return vcgAnLocalService;
    }

    /**
     * Sets the vcg an local service.
     *
     * @param vcgAnLocalService the vcg an local service
     */
    public void setVcgAnLocalService(
        gov.va.caret.service.VcgAnLocalService vcgAnLocalService) {
        this.vcgAnLocalService = vcgAnLocalService;
    }

    /**
     * Returns the vcg an persistence.
     *
     * @return the vcg an persistence
     */
    public VcgAnPersistence getVcgAnPersistence() {
        return vcgAnPersistence;
    }

    /**
     * Sets the vcg an persistence.
     *
     * @param vcgAnPersistence the vcg an persistence
     */
    public void setVcgAnPersistence(VcgAnPersistence vcgAnPersistence) {
        this.vcgAnPersistence = vcgAnPersistence;
    }

    /**
     * Returns the vendr local service.
     *
     * @return the vendr local service
     */
    public gov.va.caret.service.VendrLocalService getVendrLocalService() {
        return vendrLocalService;
    }

    /**
     * Sets the vendr local service.
     *
     * @param vendrLocalService the vendr local service
     */
    public void setVendrLocalService(
        gov.va.caret.service.VendrLocalService vendrLocalService) {
        this.vendrLocalService = vendrLocalService;
    }

    /**
     * Returns the vendr persistence.
     *
     * @return the vendr persistence
     */
    public VendrPersistence getVendrPersistence() {
        return vendrPersistence;
    }

    /**
     * Sets the vendr persistence.
     *
     * @param vendrPersistence the vendr persistence
     */
    public void setVendrPersistence(VendrPersistence vendrPersistence) {
        this.vendrPersistence = vendrPersistence;
    }

    /**
     * Returns the vet vr local service.
     *
     * @return the vet vr local service
     */
    public gov.va.caret.service.VetVrLocalService getVetVrLocalService() {
        return vetVrLocalService;
    }

    /**
     * Sets the vet vr local service.
     *
     * @param vetVrLocalService the vet vr local service
     */
    public void setVetVrLocalService(
        gov.va.caret.service.VetVrLocalService vetVrLocalService) {
        this.vetVrLocalService = vetVrLocalService;
    }

    /**
     * Returns the vet vr persistence.
     *
     * @return the vet vr persistence
     */
    public VetVrPersistence getVetVrPersistence() {
        return vetVrPersistence;
    }

    /**
     * Sets the vet vr persistence.
     *
     * @param vetVrPersistence the vet vr persistence
     */
    public void setVetVrPersistence(VetVrPersistence vetVrPersistence) {
        this.vetVrPersistence = vetVrPersistence;
    }

    /**
     * Returns the waivr local service.
     *
     * @return the waivr local service
     */
    public gov.va.caret.service.WaivrLocalService getWaivrLocalService() {
        return waivrLocalService;
    }

    /**
     * Sets the waivr local service.
     *
     * @param waivrLocalService the waivr local service
     */
    public void setWaivrLocalService(
        gov.va.caret.service.WaivrLocalService waivrLocalService) {
        this.waivrLocalService = waivrLocalService;
    }

    /**
     * Returns the waivr persistence.
     *
     * @return the waivr persistence
     */
    public WaivrPersistence getWaivrPersistence() {
        return waivrPersistence;
    }

    /**
     * Sets the waivr persistence.
     *
     * @param waivrPersistence the waivr persistence
     */
    public void setWaivrPersistence(WaivrPersistence waivrPersistence) {
        this.waivrPersistence = waivrPersistence;
    }

    /**
     * Returns the wor im local service.
     *
     * @return the wor im local service
     */
    public gov.va.caret.service.WorImLocalService getWorImLocalService() {
        return worImLocalService;
    }

    /**
     * Sets the wor im local service.
     *
     * @param worImLocalService the wor im local service
     */
    public void setWorImLocalService(
        gov.va.caret.service.WorImLocalService worImLocalService) {
        this.worImLocalService = worImLocalService;
    }

    /**
     * Returns the wor im persistence.
     *
     * @return the wor im persistence
     */
    public WorImPersistence getWorImPersistence() {
        return worImPersistence;
    }

    /**
     * Sets the wor im persistence.
     *
     * @param worImPersistence the wor im persistence
     */
    public void setWorImPersistence(WorImPersistence worImPersistence) {
        this.worImPersistence = worImPersistence;
    }

    /**
     * Returns the zip fy local service.
     *
     * @return the zip fy local service
     */
    public gov.va.caret.service.ZipFyLocalService getZipFyLocalService() {
        return zipFyLocalService;
    }

    /**
     * Sets the zip fy local service.
     *
     * @param zipFyLocalService the zip fy local service
     */
    public void setZipFyLocalService(
        gov.va.caret.service.ZipFyLocalService zipFyLocalService) {
        this.zipFyLocalService = zipFyLocalService;
    }

    /**
     * Returns the zip fy persistence.
     *
     * @return the zip fy persistence
     */
    public ZipFyPersistence getZipFyPersistence() {
        return zipFyPersistence;
    }

    /**
     * Sets the zip fy persistence.
     *
     * @param zipFyPersistence the zip fy persistence
     */
    public void setZipFyPersistence(ZipFyPersistence zipFyPersistence) {
        this.zipFyPersistence = zipFyPersistence;
    }

    /**
     * Returns the counter local service.
     *
     * @return the counter local service
     */
    public com.liferay.counter.service.CounterLocalService getCounterLocalService() {
        return counterLocalService;
    }

    /**
     * Sets the counter local service.
     *
     * @param counterLocalService the counter local service
     */
    public void setCounterLocalService(
        com.liferay.counter.service.CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    /**
     * Returns the resource local service.
     *
     * @return the resource local service
     */
    public com.liferay.portal.service.ResourceLocalService getResourceLocalService() {
        return resourceLocalService;
    }

    /**
     * Sets the resource local service.
     *
     * @param resourceLocalService the resource local service
     */
    public void setResourceLocalService(
        com.liferay.portal.service.ResourceLocalService resourceLocalService) {
        this.resourceLocalService = resourceLocalService;
    }

    /**
     * Returns the user local service.
     *
     * @return the user local service
     */
    public com.liferay.portal.service.UserLocalService getUserLocalService() {
        return userLocalService;
    }

    /**
     * Sets the user local service.
     *
     * @param userLocalService the user local service
     */
    public void setUserLocalService(
        com.liferay.portal.service.UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    /**
     * Returns the user remote service.
     *
     * @return the user remote service
     */
    public com.liferay.portal.service.UserService getUserService() {
        return userService;
    }

    /**
     * Sets the user remote service.
     *
     * @param userService the user remote service
     */
    public void setUserService(
        com.liferay.portal.service.UserService userService) {
        this.userService = userService;
    }

    /**
     * Returns the user persistence.
     *
     * @return the user persistence
     */
    public UserPersistence getUserPersistence() {
        return userPersistence;
    }

    /**
     * Sets the user persistence.
     *
     * @param userPersistence the user persistence
     */
    public void setUserPersistence(UserPersistence userPersistence) {
        this.userPersistence = userPersistence;
    }

    public void afterPropertiesSet() {
        Class<?> clazz = getClass();

        _classLoader = clazz.getClassLoader();

        PersistedModelLocalServiceRegistryUtil.register("gov.va.caret.model.BgAsn",
            bgAsnLocalService);
    }

    public void destroy() {
        PersistedModelLocalServiceRegistryUtil.unregister(
            "gov.va.caret.model.BgAsn");
    }

    /**
     * Returns the Spring bean ID for this bean.
     *
     * @return the Spring bean ID for this bean
     */
    @Override
    public String getBeanIdentifier() {
        return _beanIdentifier;
    }

    /**
     * Sets the Spring bean ID for this bean.
     *
     * @param beanIdentifier the Spring bean ID for this bean
     */
    @Override
    public void setBeanIdentifier(String beanIdentifier) {
        _beanIdentifier = beanIdentifier;
    }

    @Override
    public Object invokeMethod(String name, String[] parameterTypes,
        Object[] arguments) throws Throwable {
        Thread currentThread = Thread.currentThread();

        ClassLoader contextClassLoader = currentThread.getContextClassLoader();

        if (contextClassLoader != _classLoader) {
            currentThread.setContextClassLoader(_classLoader);
        }

        try {
            return _clpInvoker.invokeMethod(name, parameterTypes, arguments);
        } finally {
            if (contextClassLoader != _classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    protected Class<?> getModelClass() {
        return BgAsn.class;
    }

    protected String getModelClassName() {
        return BgAsn.class.getName();
    }

    /**
     * Performs an SQL query.
     *
     * @param sql the sql query
     */
    protected void runSQL(String sql) throws SystemException {
        try {
            DataSource dataSource = bgAsnPersistence.getDataSource();

            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource,
                    sql, new int[0]);

            sqlUpdate.update();
        } catch (Exception e) {
            throw new SystemException(e);
        }
    }
}
