package gov.va.caret.portlet.resource;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Junction;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CountryConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.service.RegionServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.CaretBaseViewController;
import gov.va.caret.controller.CaretViewController;
import gov.va.caret.controller.dashboard.config.DashboardConfig;
import gov.va.caret.model.Assmt;
import gov.va.caret.model.BlsAe;
import gov.va.caret.model.BlsRe;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.ClSoc;
import gov.va.caret.model.Persn;
import gov.va.caret.model.StiPt;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.Vendr;
import gov.va.caret.model.VetVr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.AssmtImpl;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.impl.StiPtImpl;
import gov.va.caret.model.impl.VendrImpl;
import gov.va.caret.model.impl.VetVrImpl;
import gov.va.caret.model.support.ModelConfig;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.service.AssmtLocalServiceUtil;
import gov.va.caret.service.BlsAeLocalServiceUtil;
import gov.va.caret.service.BlsReLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.ClSocLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.StiPtLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;
import gov.va.caret.service.VendrLocalServiceUtil;
import gov.va.caret.service.VetVrLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.service.ctssh.CTSSHConstants;
import gov.va.caret.service.ctssh.CTSSHFacade;
import gov.va.caret.util.CaretMap;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;

import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;

public class CaretResourceCommand extends ResourceCommand implements Serializable {

	private static final long serialVersionUID = 1L;
	
	public String getCities ( ResourceRequest request, ResourceResponse response ){
		return super.getCities(request, response);
	}
	public String getZips ( ResourceRequest request, ResourceResponse response ){
		return super.getZips(request, response);
	}
	public void getUSPSZips ( ResourceRequest request, ResourceResponse response ){
		super.getUSPSZips(request, response);
	}
	public String getFacils ( ResourceRequest request, ResourceResponse response ){
		return super.getFacils(request, response);
	}
	
	public void getUserList ( ResourceRequest request, ResourceResponse response ) throws ApplicationWorkFlowException{
		super.getUserList(request, response);
	}
	
	public boolean canImpersonate( PortletRequest request ){
		if ( CAction.canDoCaret(request, CAction.CaretCan.IMPERSONATE_ROLE.name() ) ){
			String impersonationMode = request.getParameter("impersonationMode");
			if ( impersonationMode != null && !impersonationMode.isEmpty() ) {
				request.getPortletSession().setAttribute(CaretStrPool.IMPERSONATE, impersonationMode);
				request.getPortletSession().setAttribute(CaretStrPool.IMPERSONATE_ID, ParamUtil.getLong( request, ReportParameter.userId.name() ) );
				request.getPortletSession().setAttribute(CaretStrPool.IMPERSONATE_ROLE_ID, ParamUtil.getLong( request, ReportParameter.roleId.name() ) );
			}
			return true;
		}
		_log.info("IMP=false");
		return false;
	}
		
	public String impersonate ( ResourceRequest request, ResourceResponse response ) throws ApplicationWorkFlowException{
		return writeJson ( response, JSONFactoryUtil.createJSONObject().put( CaretStrPool.FORM, canImpersonate(request) ) );
	}
		
	public String getRoleUsers ( ResourceRequest request, ResourceResponse response ) throws ApplicationWorkFlowException{
		JSONObject jsonUser, json = JSONFactoryUtil.createJSONObject();
		Long roleId = ParamUtil.getLong(request, "roleId");
		if ( roleId > 0 ) try {
			List<User> users = UserLocalServiceUtil.getRoleUsers(roleId);
			if ( !users.isEmpty() ){
				JSONArray jsonUsers = JSONFactoryUtil.createJSONArray();
				json.put("size", users.size());
				for ( User cont : users ){
					jsonUser = JSONFactoryUtil.createJSONObject();
					jsonUser.put( "userId", cont.getUserId() );
					jsonUser.put("fullName", cont.getFullName() );
					jsonUsers.put(jsonUser);
				}
				json.put("users", jsonUsers);
			} else {
				json.put("size", 0 );
			}
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
		return writeJson ( response, json );
	}
	
	public String searchMvi ( ResourceRequest request, ResourceResponse response ){
		
		 
		JSONObject vcg, json = JSONFactoryUtil.createJSONObject();
		JSONArray vcgs = JSONFactoryUtil.createJSONArray();
		
		Map<String, String> map = getMviMap( request );
		boolean skipSearch = Toolbox.isEmpty( map.get( CTSSHConstants.FLD_MVI_LASTNAME ) ) || 
				Toolbox.isEmpty( map.get( CTSSHConstants.FLD_MVI_FIRSTNAME ) );
		List<Person> list = null;
		int size = 0;
		if ( !skipSearch ){
			list = CTSSHFacade.getInstance().searchAttended( map, request );
			size = list.size();
			_log.info("user size vcgs.. " + size );
			json.put("size", size );
		}
			
		if ( skipSearch || list.size() == 0 ){
				vcg = JSONFactoryUtil.createJSONObject();
				vcg.put(CaretStrPool.PRIMARY_KEY, 0 );
				ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
				String noPersonsFound = LanguageUtil.get(themeDisplay.getLocale(), "no-persons-found", "No Persons found" );
				vcg.put("fullName", noPersonsFound );
				vcgs.put(vcg);
			} else {
				for ( Person p : list ){
					vcg = JSONFactoryUtil.createJSONObject();
					
					vcg.put("fullName", p.getFirstName() + " " + p.getMiddleName() + " " +  p.getLastName() );
					vcg.put( CaretStrPool.PRIMARY_KEY, p.getPrimaryKey() );
					vcg.put(CaretStrPool.SSN, p.getSsn() );
					vcg.put(CaretStrPool.BIRTHDATE, Toolbox.nullSafe( Toolbox.formatDateCprs( p.getBirthDate() ) ) );
					vcg.put(CaretStrPool.LASTNAME, p.getLastName() );
					vcg.put(CaretStrPool.FIRSTNAME, p.getFirstName() );
					vcg.put("middleName", Toolbox.nullSafe( p.getMiddleName() ) );
					vcg.put("suffix", Toolbox.nullSafe((p.getSuffix() )) );
					vcg.put("phone", Toolbox.nullSafe( p.getPhone() ));
//					vcg.put("phone2", Toolbox.nullSafe(p.getPhone2() ));
					vcg.put("email", Toolbox.nullSafe( p.getEmail() ) );
					vcg.put(CaretStrPool.ADDRESS, Toolbox.nullSafe( p.getAddress() ) );
					vcg.put(CaretStrPool.CITY, Toolbox.nullSafe( p.getCity() ) );
					vcg.put(CaretStrPool.ZIP, Toolbox.nullSafe( Toolbox.formatZip( p.getZip() ) ) );
					vcg.put(CaretStrPool.GENDER, Toolbox.nullSafe( p.getGender() ) );
					vcg.put(CaretStrPool.STATE, Toolbox.nullSafe(p.getState()) );
					vcg.put(CaretStrPool.GROUP_ID, p.getGroupId() );
					vcgs.put(vcg);
				}
			}
			
			json.put("vcgs", vcgs);
			
        
        
        return writeJson ( response, json );
	}
	
	public String searchVcg ( ResourceRequest request, ResourceResponse response ){
		if ( StringPool.TRUE.equals( PortletProps.get( "search.mvi.attended.enabled" ) ) ){
			return searchMvi(request, response);
		} else {
			return searchPerson(request, response, ParamUtil.getBoolean(request, "mviInclusion") );
		}
	}
	
	public String searchLocalVcg ( ResourceRequest request, ResourceResponse response ){
		return searchPerson(request, response, false);
	}
	
	public String searchPerson ( ResourceRequest request, ResourceResponse response, boolean restricted ){
		
		String fname = ParamUtil.get(request, CaretStrPool.FIRSTNAME, StringPool.BLANK);
		 String lname = ParamUtil.get(request, CaretStrPool.LASTNAME, StringPool.BLANK);
			 String female = getValue(request, "gender");
			 String ssn = getValue(request, "ssn");
			 String address = getValue(request, "address" );
			 String birthdate = getValue(request, "birthdate" );
			 String phone = getValue(request, "phone" );
			 String phone2 = getValue(request, "phone2" );
			 
			 _log.info ( "call Local search with :");

			 _log.info( "fname="+ fname + ", lname=" + lname  );
			 
//			 Boolean includeMulti = Boolean.valueOf( String.valueOf(request.getParameterMap().get("includeMulti") ) );

			 DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( PersnImpl.class, PortletClassLoaderUtil.getClassLoader() );
			 if ( ! fname.isEmpty() ){
				 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.FIRSTNAME).like(fname) );
			 }
			 
			 if ( ! lname.isEmpty() ){
				 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.LASTNAME).like(lname) );
			 }
			 
			 if ( restricted ){
				 Junction junction = RestrictionsFactoryUtil.disjunction();
				 junction.add( PropertyFactoryUtil.forName("externalId").isNotNull() );
				 junction.add( PropertyFactoryUtil.forName("persnUserId").gt( Long.valueOf(0) ) );
				 dynamicQuery.add( junction );
			 }
			 
			try {
				JSONObject vcg, json = JSONFactoryUtil.createJSONObject();
				JSONArray vcgs = JSONFactoryUtil.createJSONArray();

				boolean skipSearch = lname.isEmpty();
				List<Person> list = null;
				int size = 0;
				if ( !skipSearch ){
					
//					dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.PERSN_USER_ID).gt(Long.valueOf(0)) );
					List<Persn> listLocal = PersnLocalServiceUtil.dynamicQuery( dynamicQuery );
					if ( listLocal.isEmpty() && StringPool.TRUE.equals( PortletProps.get( "search.mvi.attended.enabled" ) ) ){
						list = CTSSHFacade.getInstance().searchAttended( getMviMap( request ), request );
					} else {
						list = new ArrayList<Person>();
						for ( Persn persn: listLocal ){
							list.add( new Person(persn) );
						}
					}
					
					size = list.size();
					_log.info("user size vcgs.. " + size );
					json.put("size", size );
				}
				
				if ( skipSearch || list.size() == 0 ){
					vcg = JSONFactoryUtil.createJSONObject();
					vcg.put(CaretStrPool.PRIMARY_KEY, 0 );
					ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
					String noPersonsFound = LanguageUtil.get(themeDisplay.getLocale(), "no-persons-found", "No Persons found" );
					vcg.put("fullName", noPersonsFound );
					vcgs.put(vcg);
				} else {
					for ( Person p : list ){
						
						vcg = JSONFactoryUtil.createJSONObject();
						
						vcg.put("fullName", p.getFullName() );
						vcg.put( CaretStrPool.PRIMARY_KEY, p.getPrimaryKey() );
						vcg.put(CaretStrPool.SSN, p.getSsn() );
						vcg.put(CaretStrPool.BIRTHDATE, p.getBirthDateStr() );
						vcg.put(CaretStrPool.LASTNAME, p.getLastName() );
						vcg.put(CaretStrPool.FIRSTNAME, p.getFirstName() );
						vcg.put("middleName", Toolbox.nullSafe( p.getMiddleName() ) );
						vcg.put("suffix", Toolbox.nullSafe((p.getSuffix() )) );
						vcg.put("phone", Toolbox.nullSafe( p.getPhone() ));
//						vcg.put("phone2", Toolbox.nullSafe(p.getPhone2() ));
						vcg.put("email", Toolbox.nullSafe( p.getEmail() ) );
						vcg.put(CaretStrPool.ADDRESS, Toolbox.nullSafe( p.getAddress() ) );
						vcg.put(CaretStrPool.CITY, Toolbox.nullSafe( p.getCity() ) );
						vcg.put(CaretStrPool.ZIP, Toolbox.nullSafe( p.getZip() ) );
						vcg.put(CaretStrPool.GENDER, Toolbox.nullSafe( p.getGender() ) );
						vcg.put(CaretStrPool.STATE, Toolbox.nullSafe(p.getState()) );
						vcg.put(CaretStrPool.GROUP_ID, p.getGroupId() );
						
						
						vcgs.put(vcg);
					}
				}
				
				json.put("vcgs", vcgs);

				return writeJson ( response, json );
				
			} catch (SystemException e) {
				e.printStackTrace();
			}
			return StringPool.BLANK;
	}
	
	private Map<String, String> getMviMap(ResourceRequest request) {
		
		String fname = ParamUtil.get(request, CaretStrPool.FIRSTNAME, StringPool.BLANK);
		 String lname = ParamUtil.get(request, CaretStrPool.LASTNAME, StringPool.BLANK);
		 
		 String ssn = getValue(request, CaretStrPool.SSN);
		 if ( !Toolbox.isEmpty(ssn) ){
			 ssn = ssn.replace(StringPool.DASH, StringPool.BLANK);
		 }
		 
		 String birthdate = getValue(request, CaretStrPool.BIRTHDATE );
		 if (  !Toolbox.isEmpty(birthdate) ){
			 birthdate = Toolbox.formatDateOrient( Toolbox.parseDate(birthdate) );
		 }
		
		 Map<String,String> map = new HashMap<String,String>();
		 
		 map.put(CTSSHConstants.FLD_MVI_LASTNAME, lname );
		 map.put(CTSSHConstants.FLD_MVI_FIRSTNAME, fname );
		 map.put(CTSSHConstants.FLD_MVI_DOB, birthdate );
		 map.put(CTSSHConstants.FLD_MVI_SSN, ssn );
		 map.put(CTSSHConstants.FLD_MVI_MIDDLENAME, getValue(request, "middleName" ) );
		 map.put(CTSSHConstants.FLD_MVI_SUFFIX, getValue(request, "suffix") );
		 map.put(CTSSHConstants.FLD_MVI_PATIENT_TELEPHONE, getValue(request, "phone" ) );
		 map.put(CTSSHConstants.FLD_MVI_STREETADDRESS1, getValue(request, CaretStrPool.ADDRESS ) );
		 map.put(CTSSHConstants.FLD_MVI_CITY, getValue(request, CaretStrPool.CITY) );
		 map.put(CTSSHConstants.FLD_MVI_POSTALCODE, getValue(request, CaretStrPool.ZIP) );
		 map.put(CTSSHConstants.FLD_MVI_STATE, getValue(request, CaretStrPool.STATE) );
		 map.put(CTSSHConstants.FLD_MVI_GENDER, getValue(request, CaretStrPool.GENDER ) );
		return map;
	}
//	public String loadPiiSearchList ( ResourceRequest request, ResourceResponse response ){
//		
//		Map<String,Integer> total = ResultMap.getResultTotalMap( request );
//		Map<String,List<?>> results = ResultMap.getResultListMap( request );
//		
//		results.put("caretPersons", Collections.singletonList( 
//				Toolbox.getMap( 10, "Sam2","Sam3","Sam4","Sam5","Sam6","Sam7","Sam8" ) ) );
//		total.put("caretPersons", 1);
//		
//		return "piiSearchList";
//	}
//	
//	public String loadPiiEntry ( ResourceRequest request, ResourceResponse response ){
//		
//		_log.info("inside loadPersons...");
//		
//		Person personPii = new Person(new PersnImpl());
//		
//		personPii.setFirstName("First");
//		personPii.setLastName("Last");
//		personPii.setSsn("111-22-3333");
//		
//		request.setAttribute("person", personPii);
//		
//		return "person";
//	}
	
	public String updateVcg ( ResourceRequest request, ResourceResponse response ) {
		
		long persnId = ParamUtil.getLong(request, "persnId");
		long vcgId = ParamUtil.getLong(request, "vcgId");
		
		
		try {
			_log.info( request.getParameterNames() );
			
			
			CaretParam.getFacilities(request);
		} catch (ApplicationWorkFlowException e) {
			e.printStackTrace();
		} catch (PortalException e) {
			e.printStackTrace();
		}
		
		
		return request.getParameter("page");
	}
	
	public String loadVcgEntry ( ResourceRequest request, ResourceResponse response ) {
		
		long persnId = ParamUtil.getLong(request, "persnId");
		long vcgId = ParamUtil.getLong(request, "vcgId");
		
		
		
		try {
			Person person = null;
			if (persnId > 0){
				person = new Person( PersnLocalServiceUtil.getPersn(persnId) );
			}else{
				person = new Person ( new PersnImpl() );
			}
			
			Map<String,String> disabled = new CaretMap<String,String>("disabled");
			Map<String,Object> caret = ResultMap.getCaretMap(request);
			Map<String,Object> form = ResultMap.getForm(request);
			//form.put("cssClass", new CaretMap<String, String>(CaretStrPool.REQUIRED_INPUT));
			
			request.setAttribute("person", person);
			
			Vcg vcg = VcgLocalServiceUtil.getVcg(vcgId);
			if ( vcg.getPrimaryId() == persnId ){
				form.put("isPrimary", true);
				if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_INSURANCE.name() ) ){
					disabled.put("insurance", StringPool.BLANK );
				}
			}

			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_NAME.name() ) ){
				disabled.put("lastName", StringPool.BLANK);
			}
			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_FNAME.name() ) ){
				disabled.put("firstName", StringPool.BLANK);
			}
			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_MNAME.name() ) ){
				disabled.put("middleName", StringPool.BLANK);
			}
			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_GENDER.name() ) ){
				disabled.put("gender", StringPool.BLANK);
			}
			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_BDAY.name() ) ){
				disabled.put("birthDate", StringPool.BLANK);
			}
			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_SSN.name() ) ){
				disabled.put("ssn", StringPool.BLANK);
			}
			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_ADDRESS.name() ) ){
				disabled.put("address", StringPool.BLANK);
			}
			
			if ( CAction.canDoCaret( request, CAction.CaretCan.UPDATE_ACTIVE_VCG_ICN.name() ) ){
				disabled.put("icn", StringPool.BLANK);
			}
			
			form.put("disabled", disabled);
			if ( vcg.getVeteranId() == persnId ){
				caret.put( CaretStrPool.VHA_SYSTEM, Toolbox.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
				request.setAttribute("includeFacility", true );
			}
			request.setAttribute( CaretStrPool.TRACKER, CaretParam.trackNdx( request ) );
			request.setAttribute(CaretStrPool.FORM, form);
			
			request.setAttribute(CaretStrPool.NDX, StringPool.BLANK);
			CaretViewController.getViewController().loadAddress ( caret, person, StringPool.BLANK );
			caret.put(CaretStrPool.STATES, RegionServiceUtil.getRegions( CountryConstants.DEFAULT_COUNTRY_ID ) );
			caret.put("genderTypes", PortletProps.get("persn.gender.types").split(StringPool.COMMA) ) ;
			
			_log.info("generalCaregiver is :"+vcg.getGeneralCaregiver());
			form.put("generalCaregiver", vcg.getGeneralCaregiver());
			
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		
		return request.getParameter("page");
	}
	
	public String loadList ( ResourceRequest request, ResourceResponse response ){
		
		
		String page = request.getParameter("page"); //[advancedSearch, orderByType, keywords, page, orderByCol, delta, action, cur, andOperator]
		if ( _log.isDebugEnabled() ){
			_log.info("inside loadList..." + page );
		}
		if ( page == null ){
			return StringPool.BLANK;
		}
		
		
		boolean fromParameter = ParamUtil.getBoolean(request, "fromParameter");
		
		if ( !page.isEmpty() ){
			int ndx = page.indexOf(StringPool.POUND);
			if ( ndx > -1 ){
				page = page.substring(ndx+1);
			}
		}
		DashboardConfig dashboardConfig = (DashboardConfig)request.getPortletSession().getAttribute(CaretStrPool.DASHBOARD_CONFIG);
		
		if ( dashboardConfig != null ){
			GenericReport report = dashboardConfig.getReport(page);
			if ( report != null ){
				
				int cur = ParamUtil.getInteger(request, "cur");
				int delta = ParamUtil.getInteger(request, "delta", SearchContainer.DEFAULT_DELTA);
				int start = ( cur == 0 )? 0 : delta * ( cur-1 );
				int end = ( cur == 0 )? delta : ( delta * cur );
				
				ResourceURL url = response.createResourceURL();
				url.setParameter("page", page);
				url.setParameter("action", "loadList");
				ResultMap.getResultUrlMap( request, url );
				
				report.run(request, fromParameter, start, end);
			}
		}

		return page;
	}
	
	
	
	public String getDocum(ResourceRequest request, ResourceResponse response) {
		return super.getDocum(request, response);
	}
	
	public String savePii ( ResourceRequest request, ResourceResponse response ){
		
		JSONObject json = JSONFactoryUtil.createJSONObject();
		long primaryKey = ParamUtil.getLong(request, "primaryKey");
		_log.info("inside savePii...primaryKey=" + primaryKey );
		json.put("savedPii", true);
		
		Person pers = null;
		if ( primaryKey > 0 ){
			try {
				pers = new Person ( PersnLocalServiceUtil.getPersn(primaryKey) );
				String oldSsn = pers.getSsn();
				String oldFirst = pers.getFirstName();
				String oldLast = pers.getLastName();
				
				pers = (Person) CaretParam.loadModel(request, pers, Toolbox.getCollection("lastName","firstName","middleName",
						"birthDate","gender","ssn","phone","phone2","email"), 
							CaretStrPool.PRIMARY_PERSN  + StringPool.UNDERLINE);

				boolean personPiiChanged = !pers.getFirstName().equals(oldFirst) || 
						!pers.getSsn().equals(oldSsn) || 
						!pers.getLastName().equals(oldLast);
				
				ServiceContext sc = CaretParam.setOnlineServiceContext(request);
				if ( personPiiChanged && 0 < CaretLocalServiceUtil.getReportCount( "primaryAppWork", primaryKey )	){
					CaretLocalServiceUtil.save ( Toolbox.createWorkItem( sc, 0, pers, WorkType.VENDOR_PII_UPDATE, 0, pers.getPersnId() ) );
				}
				
				//Load entity with primary key...
				
				String message = MessageFormat.format( LanguageUtil.get( Locale.getDefault(), CaretStrPool.UPDATED_PII),
						PortletProps.get(CaretStrPool.BUILD_VERSION),
						PortletProps.get(CaretStrPool.CARET_DATE) );
				
				
				Toolbox.createNote(sc.getCreateDate(), primaryKey, CaretParam.getUserRoleId(request), PortalUtil.getUserId(request), message);
			} catch (PortalException e1) {
				e1.printStackTrace();
			} catch (SystemException e1) {
				e1.printStackTrace();
			}
		}
		
		return writeJson(response, json);
	}
	
	public String addCallType ( ResourceRequest request, ResourceResponse response ){
		
		String callType = request.getParameter(CaretStrPool.CALL_TYPE);
		_log.info("CALL_TYPE=" + callType );
		 boolean isValid = true;
		 String reason = StringPool.BLANK;
		 JSONObject json = JSONFactoryUtil.createJSONObject();
		 if ( callType.trim().isEmpty() ){
			 isValid = false;
			 reason = "Call Type cannot be blank";
		 } else {
			 if ( callType.trim().length() > ModelConfig.CALL_TYPE_LENGTH ) {
				 isValid = false;
				 reason = "Call Type label cannot be greater than "+ ModelConfig.CALL_TYPE_LENGTH + " characters";
			 } else {
				 
				 callType = callType.trim().replaceAll("\\s+", StringPool.SPACE);
				 
				 ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
				 try {
					 String subgroupCallType = callType.toLowerCase().replace(StringPool.SPACE, StringPool.DASH);
					 String standardCallTypes = PortletProps.get("call.type");
					 int standardTypesSize = 0;
					 String[] standardTypes = standardCallTypes.split(StringPool.COMMA);
					 standardTypesSize = standardTypes.length;
					 for ( String standardType : standardTypes ){
						 if ( subgroupCallType.equals(standardType) || 
								 callType.equals( LanguageUtil.get(themeDisplay.getLocale(), standardType) ) ) {
							 isValid = false;
							 reason = "Call Type already defined or too close to one already defined";
							 break;
						 }
					 }
					 
					 if ( isValid ){
						 List<BoxGp> customTypes = BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.CUSTOM_CALL_TYPES);
						 for ( BoxGp boxGp: customTypes ){
							 String subGroup = boxGp.getBoxSubGroup();
							 String label = boxGp.getLabel();
							 if ( label.equals(callType) ||
									 subGroup.equals(subgroupCallType) ){
								 isValid = false;
								 reason = "Call Type already defined or too close to one already defined";
								 break;
							 }
						 }
						 if ( isValid ){
							 BoxGp callTypeBoxGp = new BoxGpImpl();
							 callTypeBoxGp.setBoxGroup(CaretStrPool.CUSTOM_CALL_TYPES);
							 callTypeBoxGp.setBoxSubGroup(subgroupCallType);
							 callTypeBoxGp.setLabel(callType);
							 callTypeBoxGp.setViewSequence(customTypes.size()+standardTypesSize);
							 try {
								 BoxGpLocalServiceUtil.addBoxGp(callTypeBoxGp);
								 json.put( CaretStrPool.BOX_GROUP_ID, callTypeBoxGp.getBoxGpId() );
							 } catch (SystemException e) {
								 ApplicationWorkFlowException.handleException(e);
								 isValid = false;
								 reason = "System Error";
							 }
						 }
					 }
					 
					 
				 } catch (ApplicationWorkFlowException e) {
					 ApplicationWorkFlowException.handleException(e);
				 }
			 }
		 }
		 
		json.put(CaretStrPool.FORM, isValid);
		json.put(CaretStrPool.CALL_TYPE, reason);
		return writeJson ( response, json );
	}
	
	public String createVendrPayment ( ResourceRequest request, ResourceResponse response ){
		_log.info("inside createVendrPayment... ");
		 String blsRate = ParamUtil.get(request, "blsRate", ""); 
		 
//		 long blsrateId = ParamUtil.getLong(request, "blsRate", 0); 
		 Date now = new Date();
		 _log.info("blsRate=" + blsRate );
		 
		 String tier = getValue(request, "tier");
		 _log.info("tier=" + tier );

		 String ten10Id = getValue(request, "ten10Id");
		 _log.info("ten10Id=" + ten10Id );
		 VcgAn ten = null;
		try {
			ten = VcgAnLocalServiceUtil.getVcgAn( Long.valueOf(ten10Id) );
		} catch (NumberFormatException e2) {
			e2.printStackTrace();
		} catch (PortalException e2) {
			e2.printStackTrace();
		} catch (SystemException e2) {
			e2.printStackTrace();
		}
		
		 String cgIdStr = getValue(request, "cgId");
		 _log.info("cgId=" + cgIdStr );
		 
		 String zip = ParamUtil.get(request, "zip", "");
		 _log.info("zip=" + zip );
		 
		 String startDate = getValue(request, "startDate");
		 _log.info("startDate=" + startDate );
		 
		 int hours = Integer.valueOf(tier);
		 
		 User user = null;
		try {
			user = UserLocalServiceUtil.getUser(Long.valueOf(cgIdStr));
		} catch (PortalException e1) {
			e1.printStackTrace();
		} catch (SystemException e1) {
			e1.printStackTrace();
		}
		 String fedTaxId = StringPool.BLANK;
		 if ( user != null ){
			 fedTaxId = Toolbox.getExpandoValue( user.getExpandoBridge(), CaretStrPool.METADATA, false );
		 }
		 _log.info("fedTaxId=" + fedTaxId );
		 
		 
		 if ( fedTaxId!= null && !fedTaxId.isEmpty() && ! blsRate.isEmpty() && blsRate.length() > 4 ){
			String cbsaarea = blsRate.substring(0,5) + '%';
			try {
				Vendr vendor = null; // VendrLocalServiceUtil.findByFedTaxId(fedTaxId, -1, -1);
				if ( vendor == null ){
					vendor = new VendrImpl();
					vendor.setFirstName(user.getFirstName());
					vendor.setLastName(user.getLastName());
					vendor.setFedTaxId(fedTaxId);
					Toolbox.setExpandoValue( vendor, CaretStrPool.METADATA, fedTaxId );
//					vendor.setVendorSsn(fedTaxId);
					vendor.setZip(zip);
					try {
						VendrLocalServiceUtil.addVendr(vendor);
					} catch (SystemException e) {
						e.printStackTrace();
					}
					VetVr vv = new VetVrImpl();
					vv.setCgId( user.getPrimaryKey() );
//					vv.setVeteranId( ten.getVeteranStatus() );
					vv.setVendrId( vendor.getVendrId() );
					try {
						VetVrLocalServiceUtil.addVetVr(vv);
					} catch (SystemException e) {
						e.printStackTrace();
					}
				}
				
				_log.info("vendor********************** " + vendor.getVendrId() );
				
				List<Map<String, Object>> list = CaretLocalServiceUtil.getReport( "getBlsRate", (Object)cbsaarea );
				if ( !list.isEmpty() ){
					String blsRateId = list.get(0).get("ndx0").toString();
					_log.info("blsRateId is " + blsRateId );
					String rateStr = list.get(0).get("ndx1").toString();
					_log.info("rate is " + rateStr );
					String areaName= list.get(0).get("ndx2").toString();
					_log.info("areaName is " + areaName );
					
					double rate = Double.valueOf(rateStr);
					double payment = hours * rate;
					
					StiPt stipend = new StiPtImpl();
					try {
						Date stipendStartDate = new Date();
						try{
							stipendStartDate= Toolbox.parseDate(startDate);
						} catch (Exception e){
							_log.error("parseException" + startDate);
						}
						stipend.setStipendStartDate(stipendStartDate);
						stipend.setBlsRateHourly(rateStr);
						stipend.setVendrId(vendor.getVendrId());
						tier = String.valueOf((Integer.valueOf(hours))/25);
						stipend.setTier(tier);
						stipend.setTierHours( String.valueOf(hours) );
						stipend.setStipendStatus(CaretStrPool.PAYMENT_PENDING);
						
						StiPtLocalServiceUtil.addStiPt(stipend);
						
					} catch (SystemException e) {
						e.printStackTrace();
					}
					NumberFormat nf = NumberFormat.getCurrencyInstance();
					
					JSONObject json = JSONFactoryUtil.createJSONObject();
					json.put("user", user.getFullName() );
					json.put("areaName", areaName);
					json.put("rate", nf.format(rate) );
					json.put("hours", hours );
					json.put("startDate", startDate );
					json.put("payment", nf.format(payment) );
					
					writeJson ( response, json );
					_log.info( "payment is ... " + payment );
				}
//				try {
//					VcgDemo vcg = VcgDemoLocalServiceUtil.fetchVcgDemo( ten.getVcgId() );
//					_log.info("vcg.getVcgDemoId= " + vcg.getVcgDemoId() );
//					vcg.setStatus("PAYMENT CREATED");
//					VcgDemoLocalServiceUtil.updateVcgDemo(vcg);
					
//				} catch (SystemException e) {
//					e.printStackTrace();
//				}
			} catch (ApplicationWorkFlowException e) {
				e.printStackTrace();
			}
		}
		 return StringPool.BLANK;
	}
	
	public void validateUSPSAddress ( ResourceRequest request, ResourceResponse response ){
	    super.validateUSPSAddress(request, response);
	}
	
	//@ProcessAction (name="calculateStipend")
	public String calculateStipend ( ResourceRequest request, ResourceResponse response  ){
		String zip = ParamUtil.getString(request, "zip", StringPool.BLANK);
		Long tierhours = ParamUtil.getLong(request, "tier");
		List<BlsRe> blsRates;
		JSONObject stipends, json = JSONFactoryUtil.createJSONObject();
		try {
			blsRates = BlsReLocalServiceUtil.findBlsByZip(zip);
			if(blsRates.isEmpty()) {
				json.put("error", "Zipcode not found please notify Supervisor");
			} else {
				BlsRe blsRe = blsRates.get(0);
				BlsAe blsAe = BlsAeLocalServiceUtil.fetchBlsAe(blsRe.getBlsAeId());
				Double rate = blsRe.getH75();
				//stipends = JSONFactoryUtil.createJSONObject();
				//stipends.put("stipend", rate*tierhours);
				double times4 = tierhours*4.35;
				double stipend = rate*times4;
				json.put("hours", tierhours);
				json.put("times4",  times4);
				json.put("wage", rate);
				json.put("stipend", Math.floor(stipend * 100) / 100);
				if (blsAe != null) {
					json.put("areaname", blsAe.getAreaName());
				} else {
					json.put("areaname", "");
					
				}
				json.put("county", blsRe.getCounty());
				json.put("location", blsRe.getCity()+ ", " +blsRe.getState());
				json.put("zipcode", blsRe.getZip());
			}
			return writeJson ( response, json );
			//request.setAttribute("stipend", rate);
		} catch (ApplicationWorkFlowException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return StringPool.BLANK;
		
	}
	
	public void saveAssessment ( ResourceRequest request, ResourceResponse response ) {
		_log.info("saveAssessment");
		
		long vcgId = ParamUtil.getLong(request, "vcgId", 0);
		String type = ParamUtil.getString(request, "type", "");
		long assessmentId = ParamUtil.getLong(request, "assessmentId");
		Date completionDate= ParamUtil.getDate(request, "completionDate", new SimpleDateFormat("MM/dd/yyyy"));
		String comment= ParamUtil.getString(request, "comment", "");
		long caregiverId = ParamUtil.getLong(request, "caregiverId");
		
		ServiceContext sc = CaretParam.setCaretServiceContext(request);
		JSONObject json = JSONFactoryUtil.createJSONObject();		
		
		try {
			if(assessmentId > 0)
			{
				Assmt assessment = AssmtLocalServiceUtil.getAssmt(assessmentId);
	
				if(!((Toolbox.formatDateCprs(assessment.getCompletionDate())).equals(Toolbox.formatDateCprs(completionDate)))
					|| !(assessment.getComment().equals(comment)))
				{
					assessment.setCompletionDate(completionDate);	
					assessment.setComment(comment);
					CaretLocalServiceUtil.save(assessment);
				}				
			}else{
				Assmt assessment = new AssmtImpl();
				
				assessment.setVcgId(vcgId);
				assessment.setCompletionDate(completionDate);
				assessment.setType(type);
				assessment.setComment(comment);
				assessment.setActive(true);
				assessment.setCaregiverId(caregiverId);
				assessment.setUserId(sc.getUserId());
	
				CaretLocalServiceUtil.save(assessment);
				assessmentId = assessment.getAssmtId();
					
				//if assessment type is training assessment - check if in home assessment has been completed or not - if not completed - create work item due after 10 days of training assessment completion date
				if(type.equals(CaretStrPool.PRIMARY_TRAINING)){
					boolean homeVisitCompleted = false;					
					List<Assmt> completedAssessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);

					for(Assmt oneAssmt:completedAssessmentList)
					{
						if(oneAssmt.getType().equals(CaretStrPool.PRIMARY_IN_HOME) && oneAssmt.getCaregiverId()==caregiverId && oneAssmt.isActive()){
							homeVisitCompleted = true;
						}
					}

					if(! homeVisitCompleted ){
						long veteranId = ParamUtil.getLong(request, "veteranId");
						CaretLocalServiceUtil.save( Toolbox.createHomeVisitWorkItem(sc, 0, assessment, WorkType.HOME_VISIT, veteranId, caregiverId, vcgId, completionDate ));					
					}
				}
	
				//if type of assessment is in-home visit - check if there is a open work item for that vcg and caregiver - if yes, update status of work item to complete
				if(type.equals(CaretStrPool.PRIMARY_IN_HOME)){
					WorIm workItem = WorImLocalServiceUtil.findByVcgId(vcgId, caregiverId, CaretStrPool.NEW);	
					if(null!=workItem){
						workItem.setStatus(CaretStrPool.COMPLETE);
						workItem.setCompletionBy( sc.getUserId() );
						workItem.setCompletionDate( sc.getCreateDate() );
						
						CaretLocalServiceUtil.save(workItem);
					}
				}											
			}
				
		}catch (ApplicationWorkFlowException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
		} catch (PortalException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SystemException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		json.put("assessmentId", assessmentId);	
		writeJson ( response, json);
	}


	
	private static Log _log = LogFactoryUtil.getLog( CaretResourceCommand.class );

	@Override
	public String getJspDir() {
		return CaretBaseViewController.INTERNAL_VIEW;
	}
	
}
