package gov.va.caret.portlet.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;

import java.lang.reflect.InvocationTargetException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.ProcessAction;

public abstract class ActionCommand {
	
	public static void handle ( ActionRequest request, ActionResponse response, ActionCommand actionCommand ){
		String action = ParamUtil.getString( request, "action", StringPool.BLANK );
		
		if ( !action.isEmpty() ) try {
			actionCommand.getClass().getDeclaredMethod( action, ActionRequest.class, ActionResponse.class )
																	.invoke( actionCommand, request, response );
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		}
	}
	
	@ProcessAction (name="goHome")
	public void goHome( ActionRequest actionRequest, ActionResponse actionResponse ) {
		if ( _log.isInfoEnabled() ){
			_log.info("goHome...");
		}
	}
		
	private static Log _log = LogFactoryUtil.getLog( ActionCommand.class );
	
}
