
package gov.va.caret.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.caret.controller.CaretBaseViewController;
import gov.va.caret.controller.OnlineViewController;
import gov.va.caret.portlet.action.OnlineActionCommand;
import gov.va.caret.portlet.resource.OnlineResourceCommand;
import gov.va.caret.security.CAction;

import java.io.IOException;

import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

/**
 * Portlet implementation class OnlinePortlet
 */
public class OnlinePortlet extends CaretBasePortlet {

	protected void include( String path, RenderRequest renderRequest, RenderResponse renderResponse)
			throws IOException, PortletException {
		if ( CAction.canDoOnline ( renderRequest, CAction.VIEW ) ){
			super.include(path,renderRequest, renderResponse);
		}else {
			_log.info("VIEW needed");
			super.include(CaretBaseViewController.INVALID_ACCESS_VIEW, renderRequest, renderResponse);
		}
	}
	
	public void init(){
		try {
			super.init();
		} catch (PortletException e) {
			e.printStackTrace();
		}
		this.actionCommand = new OnlineActionCommand();
		this.resourceCommand = new OnlineResourceCommand();
		this.viewController = OnlineViewController.get();
	}


	private static Log _log = LogFactoryUtil.getLog(OnlinePortlet.class);
}
