package gov.va.caret.model.support;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Crypto;
import gov.va.caret.model.Persn;
import gov.va.caret.model.PersnWrapper;
import gov.va.caret.model.impl.CryptoImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.service.CryptoLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;


//Notice - encryption currently commented out

public class Person extends PersnWrapper {
	
	private static final long serialVersionUID = -8375561258486068131L;
	public static final Person DEFAULT_PERSON = new Person( new PersnImpl() );

	private static final String SSN_FORMAT = "###-##-####";
	private static final String PHONE_FORMAT = "(###) ###-####";
	
	Crypto _crypto = null;
	String _nss = StringPool.BLANK;
	String facilityName = null;  
	
	public Person(Persn person) {
		super(person);
		loadCrypto();
	}
	
	private Crypto loadCrypto() {
		try {
			if ( getPersnId() > 0 ){
				if ( _crypto == null ){
					_crypto = CryptoLocalServiceUtil.getCrypto( getPersnId(), CaretStrPool.CRYPTO_NSS );
				}
				if ( _crypto == null ){
					_crypto = new CryptoImpl();
					_crypto.setType( CaretStrPool.CRYPTO_NSS );
					_crypto.setOwnerId( getPersnId() );
				} else {
					_nss = _crypto.getValue();
				}
			}
		} catch (ApplicationWorkFlowException e) {}
		return _crypto;
	}
	
	public void setSsn ( String metadata ){
		if ( SSN_FORMAT.equals(metadata) ){
			metadata = StringPool.BLANK;
		}
		_nss = metadata;
		if ( loadCrypto() != null ){
//			encrypt:
//			c.setValue( com.liferay.portal.kernel.util.Base64.fromURLSafe( metadata ) );
			_crypto.setValue(metadata);
		}
	}
	
	public String getSsn(){
		if ( loadCrypto() != null ){
//			decript:
//			return com.liferay.portal.kernel.util.Base64.toURLSafe( c.getValue() );
			return _crypto.getValue();
		}
		return _nss;
	}
	
	public String getFullName (){
		return new StringBuilder(getLastName()).append(", ").append(getFirstName()).toString(); 
	}
	
	public boolean isMedicareEnrolled (){
//TODO: use BoxGroups...
		return true; 
	}
	
	public void setPhone( String phone ){
		if ( PHONE_FORMAT.equals( phone ) ){
			phone = StringPool.BLANK;
		}
		super.setPhone(phone);
	}
	
	public void setPhone2( String phone ){
		if ( PHONE_FORMAT.equals( phone ) ){
			phone = StringPool.BLANK;
		}
		super.setPhone2(phone);
	}
	
	public String getFacilityName (){
		if ( facilityName == null ){
			if ( getGroupId() == 0 ){
				facilityName = StringPool.BLANK;
			} else {
				try {
					Organization org = OrganizationLocalServiceUtil.getOrganization( getGroupId() );
					facilityName = org.getName();
				} catch (PortalException e) {
				} catch (SystemException e) {
				}
			}
		}
		
		return facilityName; 
	}

	public String getIcn() {
		return Toolbox.nullSafe( getExternalId() );
	}
	
	public String getBirthDateStr() {
		return Toolbox.nullSafe( Toolbox.formatDateCprs( getBirthDate() ) );
	}
	
	public void setBirthDateStr( String dateStr ) {
		try {
			Date date = (Date)Toolbox.getDateFormatCprs().parseObject(dateStr);
			setBirthDate(date);
		} catch (ParseException e) {
			e.printStackTrace();
		}
	}
	
	public String getZip(){
		return Toolbox.formatZip( super.getZip() );
	}

	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		if ( getBirthDate() != null ) {
			modelAttributes.put(CaretStrPool.BIRTHDATE, Toolbox.getDateFormatCprs().format( getBirthDate() ) );
		}
		modelAttributes.put( CaretStrPool.SSN, loadCrypto() != null? _crypto.getValue() : _nss );
		return modelAttributes;
	}
	
	public void setModelAttributes( Map<String, Object> map ) {
		super.setModelAttributes(map);
		if ( map.containsKey( CaretStrPool.SSN ) ){
			setSsn( Toolbox.formatSsn( map.get(CaretStrPool.SSN).toString() ) );
		}
		Object birthDate = map.get( CaretStrPool.BIRTHDATE );
		if ( birthDate != null && birthDate instanceof String && !( (String) birthDate ).isEmpty() ){
			setBirthDate( Toolbox.parseDate( (String) birthDate ) ); 
		}
	}

	public void persist () throws SystemException{
		super.persist();
		if ( loadCrypto() != null ){
			_crypto.setValue( _nss );
			CryptoLocalServiceUtil.updateCrypto(_crypto);
		}
	}

	public void setMedicareEnrolled(boolean medicareEnrolled) {
		// TODO Auto-generated method stub
//		_log.info("");
	}

}
