package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.ZipFy;
import gov.va.caret.service.ZipFyLocalServiceUtil;

/**
 * The extended model base implementation for the ZipFy service. Represents a row in the &quot;CARET_FACILITY_ZIP&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ZipFyImpl}.
 * </p>
 *
 * @author caret
 * @see ZipFyImpl
 * @see gov.va.caret.model.ZipFy
 * @generated
 */
public abstract class ZipFyBaseImpl extends ZipFyModelImpl implements ZipFy {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a zip fy model instance should use the {@link ZipFy} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            ZipFyLocalServiceUtil.addZipFy(this);
        } else {
            ZipFyLocalServiceUtil.updateZipFy(this);
        }
    }
}
