package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.WorIm;
import gov.va.caret.service.WorImLocalServiceUtil;

/**
 * The extended model base implementation for the WorIm service. Represents a row in the &quot;CARET_WORK_ITEM&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WorImImpl}.
 * </p>
 *
 * @author caret
 * @see WorImImpl
 * @see gov.va.caret.model.WorIm
 * @generated
 */
public abstract class WorImBaseImpl extends WorImModelImpl implements WorIm {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a wor im model instance should use the {@link WorIm} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            WorImLocalServiceUtil.addWorIm(this);
        } else {
            WorImLocalServiceUtil.updateWorIm(this);
        }
    }
}
