package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.Waivr;
import gov.va.caret.model.WaivrModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the Waivr service. Represents a row in the &quot;CARET_WAIVER&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.WaivrModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WaivrImpl}.
 * </p>
 *
 * @author caret
 * @see WaivrImpl
 * @see gov.va.caret.model.Waivr
 * @see gov.va.caret.model.WaivrModel
 * @generated
 */
public class WaivrModelImpl extends BaseModelImpl<Waivr> implements WaivrModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a waivr model instance should use the {@link gov.va.caret.model.Waivr} interface instead.
     */
    public static final String TABLE_NAME = "CARET_WAIVER";
    public static final Object[][] TABLE_COLUMNS = {
            { "waivrId", Types.BIGINT },
            { "classPk", Types.BIGINT },
            { "adjudication", Types.VARCHAR },
            { "reason", Types.VARCHAR },
            { "note", Types.VARCHAR },
            { "creationDate", Types.TIMESTAMP },
            { "completionDate", Types.TIMESTAMP },
            { "userId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_WAIVER (waivrId LONG not null primary key,classPk LONG,adjudication VARCHAR(75) null,reason VARCHAR(75) null,note VARCHAR(75) null,creationDate DATE null,completionDate DATE null,userId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_WAIVER";
    public static final String ORDER_BY_JPQL = " ORDER BY waivr.creationDate ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_WAIVER.creationDate ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.Waivr"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.Waivr"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = false;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.Waivr"));
    private static ClassLoader _classLoader = Waivr.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { Waivr.class };
    private long _waivrId;
    private long _classPk;
    private String _adjudication;
    private String _reason;
    private String _note;
    private Date _creationDate;
    private Date _completionDate;
    private long _userId;
    private String _userUuid;
    private Waivr _escapedModel;

    public WaivrModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _waivrId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setWaivrId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _waivrId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return Waivr.class;
    }

    @Override
    public String getModelClassName() {
        return Waivr.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("waivrId", getWaivrId());
        attributes.put("classPk", getClassPk());
        attributes.put("adjudication", getAdjudication());
        attributes.put("reason", getReason());
        attributes.put("note", getNote());
        attributes.put("creationDate", getCreationDate());
        attributes.put("completionDate", getCompletionDate());
        attributes.put("userId", getUserId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long waivrId = (Long) attributes.get("waivrId");

        if (waivrId != null) {
            setWaivrId(waivrId);
        }

        Long classPk = (Long) attributes.get("classPk");

        if (classPk != null) {
            setClassPk(classPk);
        }

        String adjudication = (String) attributes.get("adjudication");

        if (adjudication != null) {
            setAdjudication(adjudication);
        }

        String reason = (String) attributes.get("reason");

        if (reason != null) {
            setReason(reason);
        }

        String note = (String) attributes.get("note");

        if (note != null) {
            setNote(note);
        }

        Date creationDate = (Date) attributes.get("creationDate");

        if (creationDate != null) {
            setCreationDate(creationDate);
        }

        Date completionDate = (Date) attributes.get("completionDate");

        if (completionDate != null) {
            setCompletionDate(completionDate);
        }

        Long userId = (Long) attributes.get("userId");

        if (userId != null) {
            setUserId(userId);
        }
    }

    @Override
    public long getWaivrId() {
        return _waivrId;
    }

    @Override
    public void setWaivrId(long waivrId) {
        _waivrId = waivrId;
    }

    @Override
    public long getClassPk() {
        return _classPk;
    }

    @Override
    public void setClassPk(long classPk) {
        _classPk = classPk;
    }

    @Override
    public String getAdjudication() {
        if (_adjudication == null) {
            return StringPool.BLANK;
        } else {
            return _adjudication;
        }
    }

    @Override
    public void setAdjudication(String adjudication) {
        _adjudication = adjudication;
    }

    @Override
    public String getReason() {
        if (_reason == null) {
            return StringPool.BLANK;
        } else {
            return _reason;
        }
    }

    @Override
    public void setReason(String reason) {
        _reason = reason;
    }

    @Override
    public String getNote() {
        if (_note == null) {
            return StringPool.BLANK;
        } else {
            return _note;
        }
    }

    @Override
    public void setNote(String note) {
        _note = note;
    }

    @Override
    public Date getCreationDate() {
        return _creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        _creationDate = creationDate;
    }

    @Override
    public Date getCompletionDate() {
        return _completionDate;
    }

    @Override
    public void setCompletionDate(Date completionDate) {
        _completionDate = completionDate;
    }

    @Override
    public long getUserId() {
        return _userId;
    }

    @Override
    public void setUserId(long userId) {
        _userId = userId;
    }

    @Override
    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
    }

    @Override
    public void setUserUuid(String userUuid) {
        _userUuid = userUuid;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            Waivr.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public Waivr toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (Waivr) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        WaivrImpl waivrImpl = new WaivrImpl();

        waivrImpl.setWaivrId(getWaivrId());
        waivrImpl.setClassPk(getClassPk());
        waivrImpl.setAdjudication(getAdjudication());
        waivrImpl.setReason(getReason());
        waivrImpl.setNote(getNote());
        waivrImpl.setCreationDate(getCreationDate());
        waivrImpl.setCompletionDate(getCompletionDate());
        waivrImpl.setUserId(getUserId());

        waivrImpl.resetOriginalValues();

        return waivrImpl;
    }

    @Override
    public int compareTo(Waivr waivr) {
        int value = 0;

        value = DateUtil.compareTo(getCreationDate(), waivr.getCreationDate());

        if (value != 0) {
            return value;
        }

        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof Waivr)) {
            return false;
        }

        Waivr waivr = (Waivr) obj;

        long primaryKey = waivr.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
    }

    @Override
    public CacheModel<Waivr> toCacheModel() {
        WaivrCacheModel waivrCacheModel = new WaivrCacheModel();

        waivrCacheModel.waivrId = getWaivrId();

        waivrCacheModel.classPk = getClassPk();

        waivrCacheModel.adjudication = getAdjudication();

        String adjudication = waivrCacheModel.adjudication;

        if ((adjudication != null) && (adjudication.length() == 0)) {
            waivrCacheModel.adjudication = null;
        }

        waivrCacheModel.reason = getReason();

        String reason = waivrCacheModel.reason;

        if ((reason != null) && (reason.length() == 0)) {
            waivrCacheModel.reason = null;
        }

        waivrCacheModel.note = getNote();

        String note = waivrCacheModel.note;

        if ((note != null) && (note.length() == 0)) {
            waivrCacheModel.note = null;
        }

        Date creationDate = getCreationDate();

        if (creationDate != null) {
            waivrCacheModel.creationDate = creationDate.getTime();
        } else {
            waivrCacheModel.creationDate = Long.MIN_VALUE;
        }

        Date completionDate = getCompletionDate();

        if (completionDate != null) {
            waivrCacheModel.completionDate = completionDate.getTime();
        } else {
            waivrCacheModel.completionDate = Long.MIN_VALUE;
        }

        waivrCacheModel.userId = getUserId();

        return waivrCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(17);

        sb.append("{waivrId=");
        sb.append(getWaivrId());
        sb.append(", classPk=");
        sb.append(getClassPk());
        sb.append(", adjudication=");
        sb.append(getAdjudication());
        sb.append(", reason=");
        sb.append(getReason());
        sb.append(", note=");
        sb.append(getNote());
        sb.append(", creationDate=");
        sb.append(getCreationDate());
        sb.append(", completionDate=");
        sb.append(getCompletionDate());
        sb.append(", userId=");
        sb.append(getUserId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(28);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.Waivr");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>waivrId</column-name><column-value><![CDATA[");
        sb.append(getWaivrId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>classPk</column-name><column-value><![CDATA[");
        sb.append(getClassPk());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>adjudication</column-name><column-value><![CDATA[");
        sb.append(getAdjudication());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>reason</column-name><column-value><![CDATA[");
        sb.append(getReason());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>note</column-name><column-value><![CDATA[");
        sb.append(getNote());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>creationDate</column-name><column-value><![CDATA[");
        sb.append(getCreationDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>completionDate</column-name><column-value><![CDATA[");
        sb.append(getCompletionDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(getUserId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
