package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Vendr;
import gov.va.caret.service.VendrLocalServiceUtil;

/**
 * The extended model base implementation for the Vendr service. Represents a row in the &quot;CARET_VENDOR&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link VendrImpl}.
 * </p>
 *
 * @author caret
 * @see VendrImpl
 * @see gov.va.caret.model.Vendr
 * @generated
 */
public abstract class VendrBaseImpl extends VendrModelImpl implements Vendr {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a vendr model instance should use the {@link Vendr} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            VendrLocalServiceUtil.addVendr(this);
        } else {
            VendrLocalServiceUtil.updateVendr(this);
        }
    }
}
