package gov.va.caret.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import gov.va.caret.model.Vcg;
import gov.va.caret.service.VcgLocalServiceUtil;

/**
 * The extended model base implementation for the Vcg service. Represents a row in the &quot;CareT_VCG&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link VcgImpl}.
 * </p>
 *
 * @author caret
 * @see VcgImpl
 * @see gov.va.caret.model.Vcg
 * @generated
 */
public abstract class VcgBaseImpl extends VcgModelImpl implements Vcg {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a vcg model instance should use the {@link Vcg} interface instead.
     */
    @Override
    public void persist() throws SystemException {
        if (this.isNew()) {
            VcgLocalServiceUtil.addVcg(this);
        } else {
            VcgLocalServiceUtil.updateVcg(this);
        }
    }
}
