package gov.va.caret.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

import gov.va.caret.model.StiPt;
import gov.va.caret.model.StiPtModel;

import java.io.Serializable;

import java.sql.Types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * The base model implementation for the StiPt service. Represents a row in the &quot;CARET_PAYMENT_CONFIG&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link gov.va.caret.model.StiPtModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link StiPtImpl}.
 * </p>
 *
 * @author caret
 * @see StiPtImpl
 * @see gov.va.caret.model.StiPt
 * @see gov.va.caret.model.StiPtModel
 * @generated
 */
public class StiPtModelImpl extends BaseModelImpl<StiPt> implements StiPtModel {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never modify or reference this class directly. All methods that expect a sti pt model instance should use the {@link gov.va.caret.model.StiPt} interface instead.
     */
    public static final String TABLE_NAME = "CARET_PAYMENT_CONFIG";
    public static final Object[][] TABLE_COLUMNS = {
            { "stiPtId", Types.BIGINT },
            { "stiRdId", Types.BIGINT },
            { "vendrId", Types.BIGINT },
            { "tier", Types.VARCHAR },
            { "tierHours", Types.VARCHAR },
            { "blsRateHourly", Types.VARCHAR },
            { "dailyRate", Types.VARCHAR },
            { "monthlyPayment", Types.VARCHAR },
            { "stipendStatus", Types.VARCHAR },
            { "stipendApprovedDate", Types.TIMESTAMP },
            { "stipendStartDate", Types.TIMESTAMP },
            { "groupId", Types.BIGINT }
        };
    public static final String TABLE_SQL_CREATE = "create table CARET_PAYMENT_CONFIG (stiPtId LONG not null primary key,stiRdId LONG,vendrId LONG,tier VARCHAR(75) null,tierHours VARCHAR(75) null,blsRateHourly VARCHAR(75) null,dailyRate VARCHAR(75) null,monthlyPayment VARCHAR(75) null,stipendStatus VARCHAR(75) null,stipendApprovedDate DATE null,stipendStartDate DATE null,groupId LONG)";
    public static final String TABLE_SQL_DROP = "drop table CARET_PAYMENT_CONFIG";
    public static final String ORDER_BY_JPQL = " ORDER BY stiPt.stiPtId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY CARET_PAYMENT_CONFIG.stiPtId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.entity.cache.enabled.gov.va.caret.model.StiPt"),
            true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.finder.cache.enabled.gov.va.caret.model.StiPt"),
            true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
                "value.object.column.bitmask.enabled.gov.va.caret.model.StiPt"),
            true);
    public static long STIRDID_COLUMN_BITMASK = 1L;
    public static long STIPENDSTARTDATE_COLUMN_BITMASK = 2L;
    public static long STIPENDSTATUS_COLUMN_BITMASK = 4L;
    public static long VENDRID_COLUMN_BITMASK = 8L;
    public static long STIPTID_COLUMN_BITMASK = 16L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
                "lock.expiration.time.gov.va.caret.model.StiPt"));
    private static ClassLoader _classLoader = StiPt.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[] { StiPt.class };
    private long _stiPtId;
    private long _stiRdId;
    private long _originalStiRdId;
    private boolean _setOriginalStiRdId;
    private long _vendrId;
    private long _originalVendrId;
    private boolean _setOriginalVendrId;
    private String _tier;
    private String _tierHours;
    private String _blsRateHourly;
    private String _dailyRate;
    private String _monthlyPayment;
    private String _stipendStatus;
    private String _originalStipendStatus;
    private Date _stipendApprovedDate;
    private Date _stipendStartDate;
    private Date _originalStipendStartDate;
    private long _groupId;
    private long _columnBitmask;
    private StiPt _escapedModel;

    public StiPtModelImpl() {
    }

    @Override
    public long getPrimaryKey() {
        return _stiPtId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        setStiPtId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return _stiPtId;
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        setPrimaryKey(((Long) primaryKeyObj).longValue());
    }

    @Override
    public Class<?> getModelClass() {
        return StiPt.class;
    }

    @Override
    public String getModelClassName() {
        return StiPt.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        Map<String, Object> attributes = new HashMap<String, Object>();

        attributes.put("stiPtId", getStiPtId());
        attributes.put("stiRdId", getStiRdId());
        attributes.put("vendrId", getVendrId());
        attributes.put("tier", getTier());
        attributes.put("tierHours", getTierHours());
        attributes.put("blsRateHourly", getBlsRateHourly());
        attributes.put("dailyRate", getDailyRate());
        attributes.put("monthlyPayment", getMonthlyPayment());
        attributes.put("stipendStatus", getStipendStatus());
        attributes.put("stipendApprovedDate", getStipendApprovedDate());
        attributes.put("stipendStartDate", getStipendStartDate());
        attributes.put("groupId", getGroupId());

        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Long stiPtId = (Long) attributes.get("stiPtId");

        if (stiPtId != null) {
            setStiPtId(stiPtId);
        }

        Long stiRdId = (Long) attributes.get("stiRdId");

        if (stiRdId != null) {
            setStiRdId(stiRdId);
        }

        Long vendrId = (Long) attributes.get("vendrId");

        if (vendrId != null) {
            setVendrId(vendrId);
        }

        String tier = (String) attributes.get("tier");

        if (tier != null) {
            setTier(tier);
        }

        String tierHours = (String) attributes.get("tierHours");

        if (tierHours != null) {
            setTierHours(tierHours);
        }

        String blsRateHourly = (String) attributes.get("blsRateHourly");

        if (blsRateHourly != null) {
            setBlsRateHourly(blsRateHourly);
        }

        String dailyRate = (String) attributes.get("dailyRate");

        if (dailyRate != null) {
            setDailyRate(dailyRate);
        }

        String monthlyPayment = (String) attributes.get("monthlyPayment");

        if (monthlyPayment != null) {
            setMonthlyPayment(monthlyPayment);
        }

        String stipendStatus = (String) attributes.get("stipendStatus");

        if (stipendStatus != null) {
            setStipendStatus(stipendStatus);
        }

        Date stipendApprovedDate = (Date) attributes.get("stipendApprovedDate");

        if (stipendApprovedDate != null) {
            setStipendApprovedDate(stipendApprovedDate);
        }

        Date stipendStartDate = (Date) attributes.get("stipendStartDate");

        if (stipendStartDate != null) {
            setStipendStartDate(stipendStartDate);
        }

        Long groupId = (Long) attributes.get("groupId");

        if (groupId != null) {
            setGroupId(groupId);
        }
    }

    @Override
    public long getStiPtId() {
        return _stiPtId;
    }

    @Override
    public void setStiPtId(long stiPtId) {
        _stiPtId = stiPtId;
    }

    @Override
    public long getStiRdId() {
        return _stiRdId;
    }

    @Override
    public void setStiRdId(long stiRdId) {
        _columnBitmask |= STIRDID_COLUMN_BITMASK;

        if (!_setOriginalStiRdId) {
            _setOriginalStiRdId = true;

            _originalStiRdId = _stiRdId;
        }

        _stiRdId = stiRdId;
    }

    public long getOriginalStiRdId() {
        return _originalStiRdId;
    }

    @Override
    public long getVendrId() {
        return _vendrId;
    }

    @Override
    public void setVendrId(long vendrId) {
        _columnBitmask |= VENDRID_COLUMN_BITMASK;

        if (!_setOriginalVendrId) {
            _setOriginalVendrId = true;

            _originalVendrId = _vendrId;
        }

        _vendrId = vendrId;
    }

    public long getOriginalVendrId() {
        return _originalVendrId;
    }

    @Override
    public String getTier() {
        if (_tier == null) {
            return StringPool.BLANK;
        } else {
            return _tier;
        }
    }

    @Override
    public void setTier(String tier) {
        _tier = tier;
    }

    @Override
    public String getTierHours() {
        if (_tierHours == null) {
            return StringPool.BLANK;
        } else {
            return _tierHours;
        }
    }

    @Override
    public void setTierHours(String tierHours) {
        _tierHours = tierHours;
    }

    @Override
    public String getBlsRateHourly() {
        if (_blsRateHourly == null) {
            return StringPool.BLANK;
        } else {
            return _blsRateHourly;
        }
    }

    @Override
    public void setBlsRateHourly(String blsRateHourly) {
        _blsRateHourly = blsRateHourly;
    }

    @Override
    public String getDailyRate() {
        if (_dailyRate == null) {
            return StringPool.BLANK;
        } else {
            return _dailyRate;
        }
    }

    @Override
    public void setDailyRate(String dailyRate) {
        _dailyRate = dailyRate;
    }

    @Override
    public String getMonthlyPayment() {
        if (_monthlyPayment == null) {
            return StringPool.BLANK;
        } else {
            return _monthlyPayment;
        }
    }

    @Override
    public void setMonthlyPayment(String monthlyPayment) {
        _monthlyPayment = monthlyPayment;
    }

    @Override
    public String getStipendStatus() {
        if (_stipendStatus == null) {
            return StringPool.BLANK;
        } else {
            return _stipendStatus;
        }
    }

    @Override
    public void setStipendStatus(String stipendStatus) {
        _columnBitmask |= STIPENDSTATUS_COLUMN_BITMASK;

        if (_originalStipendStatus == null) {
            _originalStipendStatus = _stipendStatus;
        }

        _stipendStatus = stipendStatus;
    }

    public String getOriginalStipendStatus() {
        return GetterUtil.getString(_originalStipendStatus);
    }

    @Override
    public Date getStipendApprovedDate() {
        return _stipendApprovedDate;
    }

    @Override
    public void setStipendApprovedDate(Date stipendApprovedDate) {
        _stipendApprovedDate = stipendApprovedDate;
    }

    @Override
    public Date getStipendStartDate() {
        return _stipendStartDate;
    }

    @Override
    public void setStipendStartDate(Date stipendStartDate) {
        _columnBitmask |= STIPENDSTARTDATE_COLUMN_BITMASK;

        if (_originalStipendStartDate == null) {
            _originalStipendStartDate = _stipendStartDate;
        }

        _stipendStartDate = stipendStartDate;
    }

    public Date getOriginalStipendStartDate() {
        return _originalStipendStartDate;
    }

    @Override
    public long getGroupId() {
        return _groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        _groupId = groupId;
    }

    public long getColumnBitmask() {
        return _columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(0,
            StiPt.class.getName(), getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = getExpandoBridge();

        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public StiPt toEscapedModel() {
        if (_escapedModel == null) {
            _escapedModel = (StiPt) ProxyUtil.newProxyInstance(_classLoader,
                    _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
        }

        return _escapedModel;
    }

    @Override
    public Object clone() {
        StiPtImpl stiPtImpl = new StiPtImpl();

        stiPtImpl.setStiPtId(getStiPtId());
        stiPtImpl.setStiRdId(getStiRdId());
        stiPtImpl.setVendrId(getVendrId());
        stiPtImpl.setTier(getTier());
        stiPtImpl.setTierHours(getTierHours());
        stiPtImpl.setBlsRateHourly(getBlsRateHourly());
        stiPtImpl.setDailyRate(getDailyRate());
        stiPtImpl.setMonthlyPayment(getMonthlyPayment());
        stiPtImpl.setStipendStatus(getStipendStatus());
        stiPtImpl.setStipendApprovedDate(getStipendApprovedDate());
        stiPtImpl.setStipendStartDate(getStipendStartDate());
        stiPtImpl.setGroupId(getGroupId());

        stiPtImpl.resetOriginalValues();

        return stiPtImpl;
    }

    @Override
    public int compareTo(StiPt stiPt) {
        long primaryKey = stiPt.getPrimaryKey();

        if (getPrimaryKey() < primaryKey) {
            return -1;
        } else if (getPrimaryKey() > primaryKey) {
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (!(obj instanceof StiPt)) {
            return false;
        }

        StiPt stiPt = (StiPt) obj;

        long primaryKey = stiPt.getPrimaryKey();

        if (getPrimaryKey() == primaryKey) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int) getPrimaryKey();
    }

    @Override
    public void resetOriginalValues() {
        StiPtModelImpl stiPtModelImpl = this;

        stiPtModelImpl._originalStiRdId = stiPtModelImpl._stiRdId;

        stiPtModelImpl._setOriginalStiRdId = false;

        stiPtModelImpl._originalVendrId = stiPtModelImpl._vendrId;

        stiPtModelImpl._setOriginalVendrId = false;

        stiPtModelImpl._originalStipendStatus = stiPtModelImpl._stipendStatus;

        stiPtModelImpl._originalStipendStartDate = stiPtModelImpl._stipendStartDate;

        stiPtModelImpl._columnBitmask = 0;
    }

    @Override
    public CacheModel<StiPt> toCacheModel() {
        StiPtCacheModel stiPtCacheModel = new StiPtCacheModel();

        stiPtCacheModel.stiPtId = getStiPtId();

        stiPtCacheModel.stiRdId = getStiRdId();

        stiPtCacheModel.vendrId = getVendrId();

        stiPtCacheModel.tier = getTier();

        String tier = stiPtCacheModel.tier;

        if ((tier != null) && (tier.length() == 0)) {
            stiPtCacheModel.tier = null;
        }

        stiPtCacheModel.tierHours = getTierHours();

        String tierHours = stiPtCacheModel.tierHours;

        if ((tierHours != null) && (tierHours.length() == 0)) {
            stiPtCacheModel.tierHours = null;
        }

        stiPtCacheModel.blsRateHourly = getBlsRateHourly();

        String blsRateHourly = stiPtCacheModel.blsRateHourly;

        if ((blsRateHourly != null) && (blsRateHourly.length() == 0)) {
            stiPtCacheModel.blsRateHourly = null;
        }

        stiPtCacheModel.dailyRate = getDailyRate();

        String dailyRate = stiPtCacheModel.dailyRate;

        if ((dailyRate != null) && (dailyRate.length() == 0)) {
            stiPtCacheModel.dailyRate = null;
        }

        stiPtCacheModel.monthlyPayment = getMonthlyPayment();

        String monthlyPayment = stiPtCacheModel.monthlyPayment;

        if ((monthlyPayment != null) && (monthlyPayment.length() == 0)) {
            stiPtCacheModel.monthlyPayment = null;
        }

        stiPtCacheModel.stipendStatus = getStipendStatus();

        String stipendStatus = stiPtCacheModel.stipendStatus;

        if ((stipendStatus != null) && (stipendStatus.length() == 0)) {
            stiPtCacheModel.stipendStatus = null;
        }

        Date stipendApprovedDate = getStipendApprovedDate();

        if (stipendApprovedDate != null) {
            stiPtCacheModel.stipendApprovedDate = stipendApprovedDate.getTime();
        } else {
            stiPtCacheModel.stipendApprovedDate = Long.MIN_VALUE;
        }

        Date stipendStartDate = getStipendStartDate();

        if (stipendStartDate != null) {
            stiPtCacheModel.stipendStartDate = stipendStartDate.getTime();
        } else {
            stiPtCacheModel.stipendStartDate = Long.MIN_VALUE;
        }

        stiPtCacheModel.groupId = getGroupId();

        return stiPtCacheModel;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(25);

        sb.append("{stiPtId=");
        sb.append(getStiPtId());
        sb.append(", stiRdId=");
        sb.append(getStiRdId());
        sb.append(", vendrId=");
        sb.append(getVendrId());
        sb.append(", tier=");
        sb.append(getTier());
        sb.append(", tierHours=");
        sb.append(getTierHours());
        sb.append(", blsRateHourly=");
        sb.append(getBlsRateHourly());
        sb.append(", dailyRate=");
        sb.append(getDailyRate());
        sb.append(", monthlyPayment=");
        sb.append(getMonthlyPayment());
        sb.append(", stipendStatus=");
        sb.append(getStipendStatus());
        sb.append(", stipendApprovedDate=");
        sb.append(getStipendApprovedDate());
        sb.append(", stipendStartDate=");
        sb.append(getStipendStartDate());
        sb.append(", groupId=");
        sb.append(getGroupId());
        sb.append("}");

        return sb.toString();
    }

    @Override
    public String toXmlString() {
        StringBundler sb = new StringBundler(40);

        sb.append("<model><model-name>");
        sb.append("gov.va.caret.model.StiPt");
        sb.append("</model-name>");

        sb.append(
            "<column><column-name>stiPtId</column-name><column-value><![CDATA[");
        sb.append(getStiPtId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>stiRdId</column-name><column-value><![CDATA[");
        sb.append(getStiRdId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>vendrId</column-name><column-value><![CDATA[");
        sb.append(getVendrId());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>tier</column-name><column-value><![CDATA[");
        sb.append(getTier());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>tierHours</column-name><column-value><![CDATA[");
        sb.append(getTierHours());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>blsRateHourly</column-name><column-value><![CDATA[");
        sb.append(getBlsRateHourly());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>dailyRate</column-name><column-value><![CDATA[");
        sb.append(getDailyRate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>monthlyPayment</column-name><column-value><![CDATA[");
        sb.append(getMonthlyPayment());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>stipendStatus</column-name><column-value><![CDATA[");
        sb.append(getStipendStatus());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>stipendApprovedDate</column-name><column-value><![CDATA[");
        sb.append(getStipendApprovedDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>stipendStartDate</column-name><column-value><![CDATA[");
        sb.append(getStipendStartDate());
        sb.append("]]></column-value></column>");
        sb.append(
            "<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(getGroupId());
        sb.append("]]></column-value></column>");

        sb.append("</model>");

        return sb.toString();
    }
}
